/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.RGBColorDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public abstract class ResourceManager {
    private List<Runnable> disposeExecs = null;

    public abstract Device getDevice();

    public abstract Object create(DeviceResourceDescriptor var1);

    public abstract void destroy(DeviceResourceDescriptor var1);

    public final Object get(DeviceResourceDescriptor descriptor) {
        Object result = this.find(descriptor);
        if (result == null) {
            result = this.create(descriptor);
        }
        return result;
    }

    public final Image createImage(ImageDescriptor descriptor) {
        Assert.isNotNull(descriptor);
        return (Image)this.create(descriptor);
    }

    public final Image createImageWithDefault(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return this.getDefaultImage();
        }
        try {
            return (Image)this.create(descriptor);
        }
        catch (DeviceResourceException | SWTException e) {
            Policy.getLog().log(new Status(2, "org.eclipse.jface", 0, "The image could not be loaded: " + descriptor, e));
            return this.getDefaultImage();
        }
    }

    protected abstract Image getDefaultImage();

    public final void destroyImage(ImageDescriptor descriptor) {
        this.destroy(descriptor);
    }

    public final Color createColor(ColorDescriptor descriptor) {
        return (Color)this.create(descriptor);
    }

    public final Color createColor(RGB descriptor) {
        return this.createColor(new RGBColorDescriptor(descriptor));
    }

    public final void destroyColor(RGB descriptor) {
        this.destroyColor(new RGBColorDescriptor(descriptor));
    }

    public final void destroyColor(ColorDescriptor descriptor) {
        this.destroy(descriptor);
    }

    public final Font createFont(FontDescriptor descriptor) {
        return (Font)this.create(descriptor);
    }

    public final void destroyFont(FontDescriptor descriptor) {
        this.destroy(descriptor);
    }

    public void dispose() {
        Runnable[] execs;
        if (this.disposeExecs == null) {
            return;
        }
        RuntimeException foundException = null;
        Runnable[] runnableArray = execs = this.disposeExecs.toArray(new Runnable[this.disposeExecs.size()]);
        int n = execs.length;
        int n2 = 0;
        while (n2 < n) {
            Runnable exec = runnableArray[n2];
            try {
                exec.run();
            }
            catch (RuntimeException e) {
                foundException = e;
            }
            ++n2;
        }
        if (foundException != null) {
            throw foundException;
        }
    }

    public abstract Object find(DeviceResourceDescriptor var1);

    public void disposeExec(Runnable r) {
        Assert.isNotNull(r);
        if (this.disposeExecs == null) {
            this.disposeExecs = new ArrayList<Runnable>();
        }
        this.disposeExecs.add(r);
    }

    public void cancelDisposeExec(Runnable r) {
        Assert.isNotNull(r);
        if (this.disposeExecs == null) {
            return;
        }
        this.disposeExecs.remove(r);
        if (this.disposeExecs.isEmpty()) {
            this.disposeExecs = null;
        }
    }
}

