/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.preference;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ComboFieldEditor
extends FieldEditor {
    private Combo fCombo;
    private String fValue;
    private String[][] fEntryNamesAndValues;

    public ComboFieldEditor(String name, String labelText, String[][] entryNamesAndValues, Composite parent) {
        this.init(name, labelText);
        Assert.isTrue(ComboFieldEditor.checkArray(entryNamesAndValues));
        this.fEntryNamesAndValues = entryNamesAndValues;
        this.createControl(parent);
    }

    private static boolean checkArray(String[][] table) {
        if (table == null) {
            return false;
        }
        String[][] stringArray = table;
        int n = table.length;
        int n2 = 0;
        while (n2 < n) {
            String[] array = stringArray[n2];
            if (array == null || array.length < 2) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        if (numColumns > 1) {
            Label control = this.getLabelControl();
            int left = numColumns;
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
                --left;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = left;
        } else {
            Label control = this.getLabelControl();
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = 1;
        }
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        int comboC = 1;
        if (numColumns > 1) {
            comboC = numColumns - 1;
        }
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = comboC;
        gd.horizontalAlignment = 4;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
    }

    @Override
    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    @Override
    protected void doLoadDefault() {
        String oldValue = this.fValue;
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
        this.valueChanged(oldValue, this.fValue);
    }

    @Override
    protected void doStore() {
        if (this.fValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.fValue);
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    private Combo getComboBoxControl(Composite parent) {
        if (this.fCombo == null) {
            this.fCombo = new Combo(parent, 8);
            this.fCombo.setFont(parent.getFont());
            int i = 0;
            while (i < this.fEntryNamesAndValues.length) {
                this.fCombo.add(this.fEntryNamesAndValues[i][0], i);
                ++i;
            }
            this.fCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(evt -> {
                String oldValue = this.fValue;
                String name = this.fCombo.getText();
                this.fValue = this.getValueForName(name);
                this.setPresentsDefaultValue(false);
                this.valueChanged(oldValue, this.fValue);
            }));
        }
        return this.fCombo;
    }

    private String getValueForName(String name) {
        String[][] stringArray = this.fEntryNamesAndValues;
        int n = this.fEntryNamesAndValues.length;
        int n2 = 0;
        while (n2 < n) {
            String[] entry = stringArray[n2];
            if (name.equals(entry[0])) {
                return entry[1];
            }
            ++n2;
        }
        return this.fEntryNamesAndValues[0][0];
    }

    private void updateComboForValue(String value) {
        this.fValue = value;
        String[][] stringArray = this.fEntryNamesAndValues;
        int n = this.fEntryNamesAndValues.length;
        int n2 = 0;
        while (n2 < n) {
            String[] fEntryNamesAndValue = stringArray[n2];
            if (value.equals(fEntryNamesAndValue[1])) {
                this.fCombo.setText(fEntryNamesAndValue[0]);
                return;
            }
            ++n2;
        }
        if (this.fEntryNamesAndValues.length > 0) {
            this.fValue = this.fEntryNamesAndValues[0][1];
            this.fCombo.setText(this.fEntryNamesAndValues[0][0]);
        }
    }

    protected void valueChanged(String oldValue, String newValue) {
        if (oldValue != null && !oldValue.equals(newValue) || newValue != null) {
            this.fireValueChanged("field_editor_value", oldValue, newValue);
        }
    }

    @Override
    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getComboBoxControl(parent).setEnabled(enabled);
    }
}

