/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ContentChangeNotifier;
import org.eclipse.compare.internal.core.patch.FilePatch2;
import org.eclipse.compare.internal.core.patch.HunkResult;
import org.eclipse.compare.internal.patch.HunkTypedElement;
import org.eclipse.compare.internal.patch.LineReader;
import org.eclipse.compare.internal.patch.Patcher;
import org.eclipse.compare.internal.patch.WorkspaceFileDiffResult;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class UnmatchedHunkTypedElement
extends HunkTypedElement
implements IContentChangeNotifier,
IEditableContent {
    private ContentChangeNotifier changeNotifier;

    public UnmatchedHunkTypedElement(HunkResult result) {
        super(result, false, true);
    }

    @Override
    public synchronized void addContentChangeListener(IContentChangeListener listener) {
        if (this.changeNotifier == null) {
            this.changeNotifier = new ContentChangeNotifier(this);
        }
        this.changeNotifier.addContentChangeListener(listener);
    }

    @Override
    public synchronized void removeContentChangeListener(IContentChangeListener listener) {
        if (this.changeNotifier != null) {
            this.changeNotifier.removeContentChangeListener(listener);
        }
    }

    @Override
    public boolean isEditable() {
        IFile file = ((WorkspaceFileDiffResult)this.getHunkResult().getDiffResult()).getTargetFile();
        return file != null && file.isAccessible();
    }

    @Override
    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        return null;
    }

    @Override
    public void setContent(byte[] newContent) {
        this.getPatcher().setManuallyMerged(this.getHunkResult().getHunk(), true);
        this.getPatcher().cacheContents(this.getDiff(), newContent);
        if (this.changeNotifier != null) {
            this.changeNotifier.fireContentChanged();
        }
    }

    private FilePatch2 getDiff() {
        return this.getHunkResult().getDiffResult().getDiff();
    }

    private Patcher getPatcher() {
        return Patcher.getPatcher(this.getConfiguration());
    }

    @Override
    public InputStream getContents() throws CoreException {
        if (this.getPatcher().hasCachedContents(this.getDiff())) {
            return new ByteArrayInputStream(this.getPatcher().getCachedContents(this.getDiff()));
        }
        List<String> lines = this.getHunkResult().getDiffResult().getAfterLines();
        String content = LineReader.createString(this.getHunkResult().getDiffResult().isPreserveLineDelimeters(), lines);
        byte[] bytes = null;
        if (this.getCharset() != null) {
            try {
                bytes = content.getBytes(this.getCharset());
            }
            catch (UnsupportedEncodingException e) {
                CompareUIPlugin.log(e);
            }
        }
        if (bytes == null) {
            bytes = content.getBytes();
        }
        return new ByteArrayInputStream(bytes);
    }

    private PatchConfiguration getConfiguration() {
        return this.getHunkResult().getDiffResult().getConfiguration();
    }
}

