/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ExceptionHandler;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.patch.InputPatchPage;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.PatchTargetPage;
import org.eclipse.compare.internal.patch.PreviewPatchPage2;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class PatchWizard
extends Wizard {
    private static final String DIALOG_SETTINGS_KEY = "PatchWizard";
    private boolean fHasNewDialogSettings;
    protected InputPatchPage fPatchWizardPage;
    protected PatchTargetPage fPatchTargetPage;
    protected PreviewPatchPage2 fPreviewPage2;
    private final WorkspacePatcher fPatcher;
    private CompareConfiguration fConfiguration;
    private IStorage patch;
    private boolean patchReadIn = false;

    public PatchWizard(IStorage patch, IResource target, CompareConfiguration configuration) {
        Assert.isNotNull(configuration);
        this.fConfiguration = configuration;
        this.setDefaultPageImageDescriptor(CompareUIPlugin.getImageDescriptor("wizban/applypatch_wizban.png"));
        this.setWindowTitle(PatchMessages.PatchWizard_title);
        this.initializeDialogSettings();
        this.fPatcher = new WorkspacePatcher(target);
        if (patch != null) {
            try {
                this.fPatcher.parse(patch);
                this.patch = patch;
                this.patchReadIn = true;
            }
            catch (IOException iOException) {
                MessageDialog.openError(null, PatchMessages.InputPatchPage_PatchErrorDialog_title, PatchMessages.InputPatchPage_ParseError_message);
            }
            catch (CoreException e) {
                ErrorDialog.openError(this.getShell(), PatchMessages.InputPatchPage_PatchErrorDialog_title, PatchMessages.InputPatchPage_PatchFileNotFound_message, e.getStatus());
            }
        }
    }

    private void initializeDialogSettings() {
        IDialogSettings workbenchSettings = CompareUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fHasNewDialogSettings = true;
        } else {
            this.fHasNewDialogSettings = false;
            this.setDialogSettings(section);
        }
    }

    protected WorkspacePatcher getPatcher() {
        return this.fPatcher;
    }

    protected IStorage getPatch() {
        return this.patch;
    }

    IResource getTarget() {
        return this.fPatcher.getTarget();
    }

    @Override
    public void addPages() {
        if (this.patch == null) {
            this.fPatchWizardPage = new InputPatchPage(this);
            this.addPage(this.fPatchWizardPage);
        }
        if (this.patch == null || !this.fPatcher.isWorkspacePatch() && !this.fPatcher.isGitPatch()) {
            this.fPatchTargetPage = new PatchTargetPage(this.fPatcher);
            this.addPage(this.fPatchTargetPage);
        } else if (this.fPatcher.isGitPatch()) {
            this.fPatcher.setTarget((IResource)ResourcesPlugin.getWorkspace().getRoot());
        }
        this.fPreviewPage2 = new PreviewPatchPage2(this.fPatcher, this.fConfiguration);
        this.addPage(this.fPreviewPage2);
    }

    @Override
    public boolean performFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage.getName().equals("PreviewPatchPage")) {
            PreviewPatchPage2 previewPage = (PreviewPatchPage2)currentPage;
            previewPage.ensureContentsSaved();
        }
        if (this.fPatchWizardPage != null) {
            if (!this.fPatchWizardPage.isPatchRead()) {
                this.fPatchWizardPage.readInPatch();
            }
            this.fPatcher.refresh();
            if (!this.fPatchWizardPage.checkPageComplete()) {
                return false;
            }
        } else {
            Assert.isNotNull(this.patch);
            Assert.isTrue(this.patchReadIn);
        }
        if (!currentPage.getName().equals("PreviewPatchPage") && this.fPatcher.hasRejects() && !MessageDialog.openConfirm(this.getShell(), PatchMessages.PatchWizard_0, PatchMessages.PatchWizard_1)) {
            return false;
        }
        try {
            MultiRule scheduleRule = null;
            if (this.fPatcher.isWorkspacePatch()) {
                ISchedulingRule[] projectRules = this.fPatcher.getTargetProjects();
                scheduleRule = new MultiRule(projectRules);
            } else {
                IResource resource = this.getTarget();
                if (resource.getType() == 1) {
                    resource = resource.getParent();
                }
                scheduleRule = ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule(resource);
            }
            WorkspaceModifyOperation op = new WorkspaceModifyOperation((ISchedulingRule)scheduleRule){

                protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        PatchWizard.this.fPatcher.applyAll(monitor, resoures -> Utilities.validateResources((IResource[])resoures, PatchWizard.this.getShell(), PatchMessages.PatchWizard_title));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, PatchMessages.PatchWizard_title, PatchMessages.PatchWizard_unexpectedException_message);
        }
        catch (InterruptedException interruptedException) {}
        if (this.fHasNewDialogSettings) {
            IDialogSettings workbenchSettings = CompareUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        if (this.fPatchWizardPage != null) {
            this.fPatchWizardPage.saveWidgetValues();
        }
        this.fPreviewPage2.saveWidgetValues();
        return true;
    }

    public void showPage(IWizardPage page) {
        this.getContainer().showPage(page);
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        if (!this.patchReadIn) {
            return this.fPatchWizardPage;
        }
        if (page instanceof PatchTargetPage && this.getTarget() != null) {
            return super.getNextPage(page);
        }
        if (page instanceof InputPatchPage && !this.fPatcher.isWorkspacePatch()) {
            return this.fPatchTargetPage;
        }
        return super.getNextPage(page);
    }

    protected void patchReadIn() {
        this.patchReadIn = true;
    }

    public CompareConfiguration getCompareConfiguration() {
        return this.fConfiguration;
    }

    @Override
    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage.getName().equals("PreviewPatchPage")) {
            return currentPage.isPageComplete();
        }
        return super.canFinish();
    }
}

