/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.core.patch.DiffProject;
import org.eclipse.compare.internal.core.patch.FileDiffResult;
import org.eclipse.compare.internal.core.patch.FilePatch2;
import org.eclipse.compare.internal.core.patch.HunkResult;
import org.eclipse.compare.internal.patch.DecoratorOverlayIcon;
import org.eclipse.compare.internal.patch.HunkDiffNode;
import org.eclipse.compare.internal.patch.PatchDiffNode;
import org.eclipse.compare.internal.patch.PatchFileDiffNode;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.PatchProjectDiffNode;
import org.eclipse.compare.internal.patch.UnmatchedHunkTypedElement;
import org.eclipse.compare.internal.patch.Utilities;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

public abstract class PatchCompareEditorInput
extends CompareEditorInput {
    private static final String IMAGE_CACHE_KEY = "IMAGE_CACHE";
    private final DiffNode root;
    private final WorkspacePatcher patcher;
    private TreeViewer viewer;
    private boolean fShowAll;
    private boolean showMatched = false;

    public static ImageDescriptor createOverlay(Image baseImage, ImageDescriptor overlayImage, int quadrant) {
        return new DecoratorOverlayIcon(baseImage, PatchCompareEditorInput.createArrayFrom(overlayImage, quadrant), new Point(Math.max(baseImage.getBounds().width, 16), Math.max(baseImage.getBounds().height, 16)));
    }

    private static ImageDescriptor[] createArrayFrom(ImageDescriptor overlayImage, int quadrant) {
        ImageDescriptor[] descs = new ImageDescriptor[5];
        descs[quadrant] = overlayImage;
        return descs;
    }

    public PatchCompareEditorInput(WorkspacePatcher patcher, CompareConfiguration configuration) {
        super(configuration);
        Assert.isNotNull(patcher);
        this.patcher = patcher;
        this.root = new DiffNode(0){

            @Override
            public boolean hasChildren() {
                return true;
            }
        };
        this.initializeImageCache();
    }

    private void initializeImageCache() {
        PatchCompareEditorInput.initializeImageCache(this.patcher.getConfiguration());
    }

    private static LocalResourceManager initializeImageCache(PatchConfiguration patchConfiguration) {
        LocalResourceManager imageCache = new LocalResourceManager(JFaceResources.getResources());
        patchConfiguration.setProperty(IMAGE_CACHE_KEY, imageCache);
        return imageCache;
    }

    @Override
    protected void handleDispose() {
        super.handleDispose();
        PatchCompareEditorInput.getImageCache(this.getPatcher().getConfiguration()).dispose();
    }

    public static LocalResourceManager getImageCache(PatchConfiguration patchConfiguration) {
        LocalResourceManager cache = (LocalResourceManager)patchConfiguration.getProperty(IMAGE_CACHE_KEY);
        if (cache == null) {
            return PatchCompareEditorInput.initializeImageCache(patchConfiguration);
        }
        return cache;
    }

    @Override
    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.initLabels();
        return this.root;
    }

    private void initLabels() {
        CompareConfiguration cc = this.getCompareConfiguration();
        cc.setLeftEditable(true);
        cc.setRightEditable(false);
        cc.setLeftLabel(this.getCompareConfiguration().getLeftLabel(this.root));
        cc.setLeftImage(this.getCompareConfiguration().getLeftImage(this.root));
        cc.setRightLabel(this.getCompareConfiguration().getRightLabel(this.root));
        cc.setRightImage(this.getCompareConfiguration().getRightImage(this.root));
    }

    protected void updateTree() {
        if (this.getViewer() != null && !this.getViewer().getControl().isDisposed()) {
            this.getViewer().refresh(true);
        }
    }

    protected void buildTree() {
        if (this.getRoot().hasChildren()) {
            this.resetRoot();
        }
        this.getViewer().setInput(this.getRoot());
        this.getPatcher().refresh();
        if (this.getPatcher().isWorkspacePatch()) {
            this.processProjects(this.getPatcher().getDiffProjects());
        } else {
            this.processDiffs(this.getPatcher().getDiffs());
        }
        this.getViewer().refresh();
    }

    private void processDiffs(FilePatch2[] diffs) {
        FilePatch2[] filePatch2Array = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            FilePatch2 diff = filePatch2Array[n2];
            this.processDiff(diff, this.getRoot());
            ++n2;
        }
    }

    private void processProjects(DiffProject[] diffProjects) {
        DiffProject[] diffProjectArray = diffProjects;
        int n = diffProjects.length;
        int n2 = 0;
        while (n2 < n) {
            FilePatch2[] diffs;
            DiffProject diffProject = diffProjectArray[n2];
            PatchProjectDiffNode projectNode = new PatchProjectDiffNode(this.getRoot(), diffProject, this.getPatcher().getConfiguration());
            FilePatch2[] filePatch2Array = diffs = diffProject.getFileDiffs();
            int n3 = diffs.length;
            int n4 = 0;
            while (n4 < n3) {
                FilePatch2 fileDiff = filePatch2Array[n4];
                this.processDiff(fileDiff, projectNode);
                ++n4;
            }
            ++n2;
        }
    }

    private void processDiff(FilePatch2 diff, DiffNode parent) {
        HunkResult[] hunkResults;
        FileDiffResult diffResult = this.getPatcher().getDiffResult(diff);
        PatchFileDiffNode node = PatchFileDiffNode.createDiffNode(parent, diffResult);
        HunkResult[] hunkResultArray = hunkResults = diffResult.getHunkResults();
        int n = hunkResults.length;
        int n2 = 0;
        while (n2 < n) {
            HunkResult hunkResult = hunkResultArray[n2];
            if (!hunkResult.isOK()) {
                HunkDiffNode hunkNode = HunkDiffNode.createDiffNode(node, hunkResult, true);
                ITypedElement left = hunkNode.getLeft();
                if (left instanceof UnmatchedHunkTypedElement) {
                    UnmatchedHunkTypedElement element = (UnmatchedHunkTypedElement)left;
                    element.addContentChangeListener(source -> {
                        if (this.getViewer() == null || this.getViewer().getControl().isDisposed()) {
                            return;
                        }
                        this.getViewer().refresh(true);
                    });
                }
            } else if (this.showMatched) {
                HunkDiffNode.createDiffNode(node, hunkResult, false, true, false);
            }
            ++n2;
        }
    }

    @Override
    public Viewer createDiffViewer(Composite parent) {
        this.viewer = new DiffTreeViewer(parent, this.getCompareConfiguration()){

            @Override
            protected void fillContextMenu(IMenuManager manager) {
                PatchCompareEditorInput.this.fillContextMenu(manager);
            }
        };
        this.viewer.setLabelProvider(new PatcherCompareEditorLabelProvider((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.getTree().setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)PatchMessages.PatcherCompareEditorInput_PatchContents);
        this.viewer.addOpenListener(event -> {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            Object obj = sel.getFirstElement();
            if (obj instanceof HunkDiffNode) {
                if (((HunkDiffNode)obj).getHunkResult().isOK()) {
                    this.getCompareConfiguration().setLeftLabel(PatchMessages.PatcherCompareEditorInput_LocalCopy);
                    this.getCompareConfiguration().setRightLabel(PatchMessages.PreviewPatchPage2_MatchedHunk);
                } else {
                    this.getCompareConfiguration().setLeftLabel(PatchMessages.PreviewPatchPage2_PatchedLocalFile);
                    this.getCompareConfiguration().setRightLabel(PatchMessages.PreviewPatchPage2_OrphanedHunk);
                }
            } else {
                this.getCompareConfiguration().setLeftLabel(PatchMessages.PatcherCompareEditorInput_LocalCopy);
                this.getCompareConfiguration().setRightLabel(PatchMessages.PatcherCompareEditorInput_AfterPatch);
            }
        });
        this.viewer.setFilters(this.getFilters());
        this.viewer.setInput(this.root);
        return this.viewer;
    }

    private ViewerFilter[] getFilters() {
        return new ViewerFilter[]{new ViewerFilter(){

            @Override
            public boolean select(Viewer v, Object parentElement, Object element) {
                if (element instanceof PatchDiffNode) {
                    PatchDiffNode node = (PatchDiffNode)element;
                    return node.isEnabled() || PatchCompareEditorInput.this.isShowAll();
                }
                return false;
            }
        }};
    }

    protected boolean isShowAll() {
        return this.fShowAll;
    }

    protected void setShowAll(boolean show) {
        this.fShowAll = show;
    }

    public boolean isShowMatched() {
        return this.showMatched;
    }

    protected void setShowMatched(boolean show) {
        this.showMatched = show;
    }

    public void contributeDiffViewerToolbarItems(Action[] actions, boolean workspacePatch) {
        ToolBarManager tbm = CompareViewerPane.getToolBarManager(this.viewer.getControl().getParent());
        if (tbm != null) {
            tbm.removeAll();
            tbm.add(new Separator("contributed"));
            Action[] actionArray = actions;
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                Action action = actionArray[n2];
                tbm.appendToGroup("contributed", action);
                ++n2;
            }
            tbm.update(true);
        }
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public DiffNode getRoot() {
        return this.root;
    }

    public void resetRoot() {
        IDiffElement[] children;
        IDiffElement[] iDiffElementArray = children = this.root.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffElement child = iDiffElementArray[n2];
            this.root.remove(child);
            ++n2;
        }
    }

    public WorkspacePatcher getPatcher() {
        return this.patcher;
    }

    public boolean confirmRebuild(String message) {
        if (this.getPatcher().hasCachedContents()) {
            if (this.promptToDiscardCachedChanges(message)) {
                this.getPatcher().clearCachedContents();
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean promptToDiscardCachedChanges(String message) {
        return MessageDialog.openConfirm(this.viewer.getControl().getShell(), PatchMessages.PatcherCompareEditorInput_0, message);
    }

    public boolean hasResultToApply() {
        boolean atLeastOneIsEnabled = false;
        if (this.getViewer() != null) {
            IDiffElement[] elements;
            IDiffElement[] iDiffElementArray = elements = this.getRoot().getChildren();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IDiffElement element = iDiffElementArray[n2];
                if (this.isEnabled(element)) {
                    atLeastOneIsEnabled = true;
                    break;
                }
                ++n2;
            }
        }
        return atLeastOneIsEnabled;
    }

    private boolean isEnabled(IDiffElement element) {
        if (element instanceof PatchDiffNode) {
            PatchDiffNode node = (PatchDiffNode)element;
            return node.isEnabled();
        }
        return false;
    }

    protected abstract void fillContextMenu(IMenuManager var1);

    @Override
    public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        if (org.eclipse.compare.internal.Utilities.isHunk(input)) {
            return null;
        }
        return super.findStructureViewer(oldViewer, input, parent);
    }

    class PatcherCompareEditorLabelProvider
    extends LabelProvider {
        private ILabelProvider wrappedProvider;

        public PatcherCompareEditorLabelProvider(ILabelProvider labelProvider) {
            this.wrappedProvider = labelProvider;
        }

        @Override
        public String getText(Object element) {
            String text = this.wrappedProvider.getText(element);
            if (element instanceof PatchDiffNode) {
                PatchProjectDiffNode projectNode;
                PatchDiffNode node = (PatchDiffNode)element;
                if (node instanceof PatchProjectDiffNode && !Utilities.getProject((projectNode = (PatchProjectDiffNode)node).getDiffProject()).exists()) {
                    text = NLS.bind((String)PatchMessages.Diff_2Args, (Object[])new String[]{text, PatchMessages.PreviewPatchLabelDecorator_ProjectDoesNotExist});
                }
                if (!node.isEnabled()) {
                    return NLS.bind((String)PatchMessages.Diff_2Args, (Object[])new String[]{text, PatchMessages.PatcherCompareEditorInput_NotIncluded});
                }
                if (node instanceof PatchFileDiffNode) {
                    PatchFileDiffNode fileNode = (PatchFileDiffNode)node;
                    if (PatchCompareEditorInput.this.getPatcher().hasCachedContents(fileNode.getDiffResult().getDiff())) {
                        text = NLS.bind((String)PatchMessages.Diff_2Args, (Object[])new String[]{text, PatchMessages.HunkMergePage_Merged});
                    }
                    if (!fileNode.fileExists()) {
                        text = NLS.bind((String)PatchMessages.Diff_2Args, (Object[])new String[]{text, PatchMessages.PatchCompareEditorInput_0});
                    }
                }
                if (node instanceof HunkDiffNode) {
                    HunkDiffNode hunkNode = (HunkDiffNode)node;
                    if (hunkNode.isManuallyMerged()) {
                        text = NLS.bind((String)PatchMessages.Diff_2Args, (Object[])new String[]{text, PatchMessages.HunkMergePage_Merged});
                    }
                    if (hunkNode.isFuzzUsed()) {
                        text = NLS.bind((String)PatchMessages.Diff_2Args, (Object[])new String[]{text, NLS.bind((String)(hunkNode.isAllContextIgnored() ? PatchMessages.PreviewPatchPage_AllContextIgnored : PatchMessages.PreviewPatchPage_FuzzUsed), (Object[])new String[]{String.valueOf(hunkNode.getHunkResult().getFuzz())})});
                    }
                }
                if (PatchCompareEditorInput.this.getPatcher().isRetargeted(node.getPatchElement())) {
                    return NLS.bind((String)PatchMessages.Diff_2Args, (Object[])new String[]{PatchCompareEditorInput.this.getPatcher().getOriginalPath(node.getPatchElement()).toString(), NLS.bind((String)PatchMessages.PreviewPatchPage_Target, (Object[])new String[]{node.getName()})});
                }
            }
            return text;
        }

        @Override
        public Image getImage(Object element) {
            PatchDiffNode node;
            Image image = this.wrappedProvider.getImage(element);
            if (element instanceof PatchDiffNode && !(node = (PatchDiffNode)element).isEnabled() && image != null) {
                LocalResourceManager imageCache = PatchCompareEditorInput.getImageCache(PatchCompareEditorInput.this.getPatcher().getConfiguration());
                return imageCache.createImage(PatchCompareEditorInput.createOverlay(image, CompareUIPlugin.getImageDescriptor("ovr16/removed_ov.png"), 0));
            }
            if (element instanceof HunkDiffNode && ((HunkDiffNode)(node = (HunkDiffNode)element)).isManuallyMerged()) {
                LocalResourceManager imageCache = PatchCompareEditorInput.getImageCache(PatchCompareEditorInput.this.getPatcher().getConfiguration());
                return imageCache.createImage(PatchCompareEditorInput.createOverlay(image, CompareUIPlugin.getImageDescriptor("ovr16/merged_ov.png"), 0));
            }
            return image;
        }
    }
}

