/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.internal.WorkQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class Worker
implements IRunnableWithProgress {
    private final WorkQueue work = new WorkQueue();
    private boolean isWorking;
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private WorkProgressMonitor currentMonitor;
    private IRunnableWithProgress currentTask;
    private final String taskName;

    public Worker(String taskName) {
        this.taskName = taskName;
    }

    @Override
    public void run(IProgressMonitor monitor) {
        this.errors.clear();
        SubMonitor progress = SubMonitor.convert(monitor, this.getTaskName(), 100);
        try {
            try {
                this.isWorking = true;
                while (!this.work.isEmpty()) {
                    try {
                        this.performNextTask(progress);
                        progress.checkCanceled();
                    }
                    catch (InterruptedException | OperationCanceledException exception) {
                        progress.checkCanceled();
                    }
                    catch (InvocationTargetException e) {
                        this.handleError(e.getTargetException());
                    }
                    progress.setWorkRemaining(100);
                }
                progress.done();
            }
            catch (OperationCanceledException operationCanceledException) {
                this.work.clear();
                this.isWorking = false;
                this.currentMonitor = null;
                this.currentTask = null;
            }
        }
        finally {
            this.isWorking = false;
            this.currentMonitor = null;
            this.currentTask = null;
        }
    }

    private WorkProgressMonitor subMonitorFor(SubMonitor pm, int ticks) {
        return new WorkProgressMonitor(pm.newChild(ticks));
    }

    private void handleError(Throwable targetException) {
        this.errors.add(targetException);
    }

    public Throwable[] getErrors() {
        return this.errors.toArray(new Throwable[this.errors.size()]);
    }

    protected String getTaskName() {
        return this.taskName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performNextTask(SubMonitor pm) throws InvocationTargetException, InterruptedException {
        Worker worker = this;
        synchronized (worker) {
            if (this.work.isEmpty()) {
                return;
            }
            this.currentTask = this.work.remove();
            this.currentMonitor = this.subMonitorFor(pm, 10);
        }
        this.currentTask.run(this.currentMonitor);
    }

    public synchronized void add(IRunnableWithProgress r) {
        if (this.currentTask != null && this.currentTask.equals(r)) {
            this.currentMonitor.cancelTask();
        }
        this.work.add(r);
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public boolean hasWork() {
        return this.isWorking() || !this.work.isEmpty();
    }

    private static class WorkProgressMonitor
    extends ProgressMonitorWrapper {
        private boolean localCancel;

        protected WorkProgressMonitor(IProgressMonitor monitor) {
            super(monitor);
        }

        public void cancelTask() {
            this.localCancel = true;
        }

        @Override
        public boolean isCanceled() {
            return this.localCancel || super.isCanceled();
        }
    }
}

