/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class OverlayPreferenceStore
implements IPreferenceStore {
    public static final TypeDescriptor BOOLEAN = new TypeDescriptor();
    public static final TypeDescriptor DOUBLE = new TypeDescriptor();
    public static final TypeDescriptor FLOAT = new TypeDescriptor();
    public static final TypeDescriptor INT = new TypeDescriptor();
    public static final TypeDescriptor LONG = new TypeDescriptor();
    public static final TypeDescriptor STRING = new TypeDescriptor();
    private IPreferenceStore fParent;
    private IPreferenceStore fStore;
    private OverlayKey[] fOverlayKeys;
    private PropertyListener fPropertyListener;

    public OverlayPreferenceStore(IPreferenceStore parent, OverlayKey[] overlayKeys) {
        this.fParent = parent;
        this.fOverlayKeys = overlayKeys;
        this.fStore = new PreferenceStore();
    }

    private OverlayKey findOverlayKey(String key) {
        OverlayKey[] overlayKeyArray = this.fOverlayKeys;
        int n = this.fOverlayKeys.length;
        int n2 = 0;
        while (n2 < n) {
            OverlayKey overlayKey = overlayKeyArray[n2];
            if (overlayKey.fKey.equals(key)) {
                return overlayKey;
            }
            ++n2;
        }
        return null;
    }

    private boolean covers(String key) {
        return this.findOverlayKey(key) != null;
    }

    private void propagateProperty(IPreferenceStore orgin, OverlayKey key, IPreferenceStore target) {
        if (orgin.isDefault(key.fKey)) {
            if (!target.isDefault(key.fKey)) {
                target.setToDefault(key.fKey);
            }
            return;
        }
        TypeDescriptor d = key.fDescriptor;
        if (BOOLEAN == d) {
            boolean originValue = orgin.getBoolean(key.fKey);
            boolean targetValue = target.getBoolean(key.fKey);
            if (targetValue != originValue) {
                target.setValue(key.fKey, originValue);
            }
        } else if (DOUBLE == d) {
            double originValue = orgin.getDouble(key.fKey);
            double targetValue = target.getDouble(key.fKey);
            if (targetValue != originValue) {
                target.setValue(key.fKey, originValue);
            }
        } else if (FLOAT == d) {
            float originValue = orgin.getFloat(key.fKey);
            float targetValue = target.getFloat(key.fKey);
            if (targetValue != originValue) {
                target.setValue(key.fKey, originValue);
            }
        } else if (INT == d) {
            int originValue = orgin.getInt(key.fKey);
            int targetValue = target.getInt(key.fKey);
            if (targetValue != originValue) {
                target.setValue(key.fKey, originValue);
            }
        } else if (LONG == d) {
            long originValue = orgin.getLong(key.fKey);
            long targetValue = target.getLong(key.fKey);
            if (targetValue != originValue) {
                target.setValue(key.fKey, originValue);
            }
        } else if (STRING == d) {
            String originValue = orgin.getString(key.fKey);
            String targetValue = target.getString(key.fKey);
            if (targetValue != null && originValue != null && !targetValue.equals(originValue)) {
                target.setValue(key.fKey, originValue);
            }
        }
    }

    public void propagate() {
        OverlayKey[] overlayKeyArray = this.fOverlayKeys;
        int n = this.fOverlayKeys.length;
        int n2 = 0;
        while (n2 < n) {
            OverlayKey overlayKey = overlayKeyArray[n2];
            this.propagateProperty(this.fStore, overlayKey, this.fParent);
            ++n2;
        }
    }

    private void loadProperty(IPreferenceStore orgin, OverlayKey key, IPreferenceStore target, boolean forceInitialization) {
        TypeDescriptor d = key.fDescriptor;
        if (BOOLEAN == d) {
            if (forceInitialization) {
                target.setValue(key.fKey, true);
            }
            target.setValue(key.fKey, orgin.getBoolean(key.fKey));
            target.setDefault(key.fKey, orgin.getDefaultBoolean(key.fKey));
        } else if (DOUBLE == d) {
            if (forceInitialization) {
                target.setValue(key.fKey, 1.0);
            }
            target.setValue(key.fKey, orgin.getDouble(key.fKey));
            target.setDefault(key.fKey, orgin.getDefaultDouble(key.fKey));
        } else if (FLOAT == d) {
            if (forceInitialization) {
                target.setValue(key.fKey, 1.0f);
            }
            target.setValue(key.fKey, orgin.getFloat(key.fKey));
            target.setDefault(key.fKey, orgin.getDefaultFloat(key.fKey));
        } else if (INT == d) {
            if (forceInitialization) {
                target.setValue(key.fKey, 1);
            }
            target.setValue(key.fKey, orgin.getInt(key.fKey));
            target.setDefault(key.fKey, orgin.getDefaultInt(key.fKey));
        } else if (LONG == d) {
            if (forceInitialization) {
                target.setValue(key.fKey, 1L);
            }
            target.setValue(key.fKey, orgin.getLong(key.fKey));
            target.setDefault(key.fKey, orgin.getDefaultLong(key.fKey));
        } else if (STRING == d) {
            if (forceInitialization) {
                target.setValue(key.fKey, "1");
            }
            target.setValue(key.fKey, orgin.getString(key.fKey));
            target.setDefault(key.fKey, orgin.getDefaultString(key.fKey));
        }
    }

    public void load() {
        OverlayKey[] overlayKeyArray = this.fOverlayKeys;
        int n = this.fOverlayKeys.length;
        int n2 = 0;
        while (n2 < n) {
            OverlayKey overlayKey = overlayKeyArray[n2];
            this.loadProperty(this.fParent, overlayKey, this.fStore, true);
            ++n2;
        }
    }

    public void loadDefaults() {
        OverlayKey[] overlayKeyArray = this.fOverlayKeys;
        int n = this.fOverlayKeys.length;
        int n2 = 0;
        while (n2 < n) {
            OverlayKey overlayKey = overlayKeyArray[n2];
            this.setToDefault(overlayKey.fKey);
            ++n2;
        }
    }

    public void start() {
        if (this.fPropertyListener == null) {
            this.fPropertyListener = new PropertyListener();
            this.fParent.addPropertyChangeListener(this.fPropertyListener);
        }
    }

    public void stop() {
        if (this.fPropertyListener != null) {
            this.fParent.removePropertyChangeListener(this.fPropertyListener);
            this.fPropertyListener = null;
        }
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fStore.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fStore.removePropertyChangeListener(listener);
    }

    @Override
    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        this.fStore.firePropertyChangeEvent(name, oldValue, newValue);
    }

    @Override
    public boolean contains(String name) {
        return this.fStore.contains(name);
    }

    @Override
    public boolean getBoolean(String name) {
        return this.fStore.getBoolean(name);
    }

    @Override
    public boolean getDefaultBoolean(String name) {
        return this.fStore.getDefaultBoolean(name);
    }

    @Override
    public double getDefaultDouble(String name) {
        return this.fStore.getDefaultDouble(name);
    }

    @Override
    public float getDefaultFloat(String name) {
        return this.fStore.getDefaultFloat(name);
    }

    @Override
    public int getDefaultInt(String name) {
        return this.fStore.getDefaultInt(name);
    }

    @Override
    public long getDefaultLong(String name) {
        return this.fStore.getDefaultLong(name);
    }

    @Override
    public String getDefaultString(String name) {
        return this.fStore.getDefaultString(name);
    }

    @Override
    public double getDouble(String name) {
        return this.fStore.getDouble(name);
    }

    @Override
    public float getFloat(String name) {
        return this.fStore.getFloat(name);
    }

    @Override
    public int getInt(String name) {
        return this.fStore.getInt(name);
    }

    @Override
    public long getLong(String name) {
        return this.fStore.getLong(name);
    }

    @Override
    public String getString(String name) {
        return this.fStore.getString(name);
    }

    @Override
    public boolean isDefault(String name) {
        return this.fStore.isDefault(name);
    }

    @Override
    public boolean needsSaving() {
        return this.fStore.needsSaving();
    }

    @Override
    public void putValue(String name, String value) {
        if (this.covers(name)) {
            this.fStore.putValue(name, value);
        }
    }

    @Override
    public void setDefault(String name, double value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    @Override
    public void setDefault(String name, float value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    @Override
    public void setDefault(String name, int value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    @Override
    public void setDefault(String name, long value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    @Override
    public void setDefault(String name, String value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    @Override
    public void setDefault(String name, boolean value) {
        if (this.covers(name)) {
            this.fStore.setDefault(name, value);
        }
    }

    @Override
    public void setToDefault(String name) {
        this.fStore.setToDefault(name);
    }

    @Override
    public void setValue(String name, double value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, float value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, int value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, long value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, String value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, boolean value) {
        if (this.covers(name)) {
            this.fStore.setValue(name, value);
        }
    }

    public static class OverlayKey {
        TypeDescriptor fDescriptor;
        String fKey;

        public OverlayKey(TypeDescriptor descriptor, String key) {
            this.fDescriptor = descriptor;
            this.fKey = key;
        }
    }

    private class PropertyListener
    implements IPropertyChangeListener {
        private PropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            OverlayKey key = OverlayPreferenceStore.this.findOverlayKey(event.getProperty());
            if (key != null) {
                OverlayPreferenceStore.this.propagateProperty(OverlayPreferenceStore.this.fParent, key, OverlayPreferenceStore.this.fStore);
            }
        }
    }

    public static final class TypeDescriptor {
        private TypeDescriptor() {
        }
    }
}

