/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.swt.widgets.Display;

public class ContentChangeNotifier
implements IContentChangeNotifier {
    private ListenerList<IContentChangeListener> fListenerList;
    private final IContentChangeNotifier element;

    public ContentChangeNotifier(IContentChangeNotifier element) {
        this.element = element;
    }

    @Override
    public void addContentChangeListener(IContentChangeListener listener) {
        if (this.fListenerList == null) {
            this.fListenerList = new ListenerList();
        }
        this.fListenerList.add(listener);
    }

    @Override
    public void removeContentChangeListener(IContentChangeListener listener) {
        if (this.fListenerList != null) {
            this.fListenerList.remove(listener);
            if (this.fListenerList.isEmpty()) {
                this.fListenerList = null;
            }
        }
    }

    public void fireContentChanged() {
        if (this.isEmpty()) {
            return;
        }
        Runnable runnable = () -> {
            for (final IContentChangeListener contentChangeListener : this.fListenerList) {
                SafeRunner.run(new ISafeRunnable(){

                    @Override
                    public void run() throws Exception {
                        contentChangeListener.contentChanged(ContentChangeNotifier.this.element);
                    }

                    @Override
                    public void handleException(Throwable exception) {
                    }
                });
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public boolean isEmpty() {
        return this.fListenerList == null || this.fListenerList.isEmpty();
    }
}

