/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareResourceFilter;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.compare.internal.OverlayPreferenceStore;
import org.eclipse.compare.internal.TabFolderLayout;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.core.ComparePlugin;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ComparePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREFIX = "org.eclipse.compare.";
    public static final String OPEN_STRUCTURE_COMPARE = "org.eclipse.compare.OpenStructureCompare";
    public static final String USE_OUTLINE_VIEW = "org.eclipse.compare.UseOutlineView";
    public static final String SYNCHRONIZE_SCROLLING = "org.eclipse.compare.SynchronizeScrolling";
    public static final String SHOW_PSEUDO_CONFLICTS = "org.eclipse.compare.ShowPseudoConflicts";
    public static final String INITIALLY_SHOW_ANCESTOR_PANE = "org.eclipse.compare.InitiallyShowAncestorPane";
    public static final String PREF_SAVE_ALL_EDITORS = "org.eclipse.compare.SaveAllEditors";
    public static final String IGNORE_WHITESPACE = "org.eclipse.compare.IgnoreWhitespace";
    public static final String USE_SINGLE_LINE = "org.eclipse.compare.UseSingleLine";
    public static final String HIGHLIGHT_TOKEN_CHANGES = "org.eclipse.compare.HighlightTokenChanges";
    public static final String CAPPING_DISABLED = "org.eclipse.compare.CappingDisable";
    public static final String PATH_FILTER = "org.eclipse.compare.PathFilter";
    public static final String ADDED_LINES_REGEX = "org.eclipse.compare.AddedLinesRegex";
    public static final String REMOVED_LINES_REGEX = "org.eclipse.compare.RemovedLinesRegex";
    public static final String SWAPPED = "org.eclipse.compare.Swapped";
    private IPropertyChangeListener fPreferenceChangeListener;
    private List<CompareConfiguration> fCompareConfigurations = new ArrayList<CompareConfiguration>();
    private OverlayPreferenceStore fOverlayStore;
    private Map<Button, String> fCheckBoxes = new HashMap<Button, String>();
    private Text fFilters;
    private Text addedLinesRegex;
    private Text removedLinesRegex;
    private SelectionListener fCheckBoxListener;
    public final OverlayPreferenceStore.OverlayKey[] fKeys = new OverlayPreferenceStore.OverlayKey[]{new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.OpenStructureCompare"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.UseOutlineView"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.SynchronizeScrolling"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.ShowPseudoConflicts"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.InitiallyShowAncestorPane"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.IgnoreWhitespace"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.SaveAllEditors"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "org.eclipse.compare.AddedLinesRegex"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "org.eclipse.compare.RemovedLinesRegex"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.UseSingleLine"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.HighlightTokenChanges"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.CappingDisable"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "org.eclipse.compare.PathFilter"), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, ICompareUIConstants.PREF_NAVIGATION_END_ACTION), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, ICompareUIConstants.PREF_NAVIGATION_END_ACTION_LOCAL), new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "org.eclipse.compare.Swapped")};
    private List<FieldEditor> editors = new ArrayList<FieldEditor>();
    private TabItem fTextCompareTab;
    private Button fDisableCappingCheckBox;

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(OPEN_STRUCTURE_COMPARE, true);
        store.setDefault(USE_OUTLINE_VIEW, false);
        store.setDefault(SYNCHRONIZE_SCROLLING, true);
        store.setDefault(SHOW_PSEUDO_CONFLICTS, false);
        store.setDefault(INITIALLY_SHOW_ANCESTOR_PANE, false);
        store.setDefault(IGNORE_WHITESPACE, false);
        store.setDefault(PREF_SAVE_ALL_EDITORS, false);
        store.setDefault(ADDED_LINES_REGEX, "");
        store.setDefault(REMOVED_LINES_REGEX, "");
        store.setDefault(USE_SINGLE_LINE, true);
        store.setDefault(HIGHLIGHT_TOKEN_CHANGES, true);
        store.setDefault(CAPPING_DISABLED, false);
        store.setDefault(PATH_FILTER, "");
        store.setDefault(ICompareUIConstants.PREF_NAVIGATION_END_ACTION, "prompt");
        store.setDefault(ICompareUIConstants.PREF_NAVIGATION_END_ACTION_LOCAL, "loop");
        store.setDefault(SWAPPED, false);
    }

    public ComparePreferencePage() {
        this.setPreferenceStore(CompareUIPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.fKeys);
        this.fPreferenceChangeListener = event -> {
            String key = event.getProperty();
            if (key.equals(INITIALLY_SHOW_ANCESTOR_PANE)) {
                boolean b = this.fOverlayStore.getBoolean(INITIALLY_SHOW_ANCESTOR_PANE);
                for (CompareConfiguration compareConfiguration : this.fCompareConfigurations) {
                    compareConfiguration.setProperty(INITIALLY_SHOW_ANCESTOR_PANE, b);
                }
            }
        };
        this.fOverlayStore.addPropertyChangeListener(this.fPreferenceChangeListener);
    }

    public void init(IWorkbench workbench) {
    }

    @Override
    public boolean performOk() {
        this.fOverlayStore.setValue(ADDED_LINES_REGEX, this.addedLinesRegex.getText());
        this.fOverlayStore.setValue(REMOVED_LINES_REGEX, this.removedLinesRegex.getText());
        this.editors.forEach(FieldEditor::store);
        this.fOverlayStore.propagate();
        ComparePlugin.getDefault().setCappingDisabled(this.getPreferenceStore().getBoolean(CAPPING_DISABLED));
        return true;
    }

    @Override
    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        super.performDefaults();
    }

    @Override
    public void dispose() {
        if (this.fOverlayStore != null) {
            if (this.fPreferenceChangeListener != null) {
                this.fOverlayStore.removePropertyChangeListener(this.fPreferenceChangeListener);
                this.fPreferenceChangeListener = null;
            }
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    public static boolean getSaveAllEditors() {
        IPreferenceStore store = CompareUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(PREF_SAVE_ALL_EDITORS);
    }

    public static void setSaveAllEditors(boolean value) {
        IPreferenceStore store = CompareUIPlugin.getDefault().getPreferenceStore();
        store.setValue(PREF_SAVE_ALL_EDITORS, value);
    }

    @Override
    protected Control createContents(Composite parent) {
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.compare.compare_preference_page_context");
        }
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText(Utilities.getString("ComparePreferencePage.generalTab.label"));
        item.setControl(this.createGeneralPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(Utilities.getString("ComparePreferencePage.textCompareTab.label"));
        item.setControl(this.createTextComparePage((Composite)folder));
        this.fTextCompareTab = item;
        this.initializeFields();
        Dialog.applyDialogFont((Control)folder);
        return folder;
    }

    private Control createGeneralPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.addCheckBox(composite, "ComparePreferencePage.structureCompare.label", OPEN_STRUCTURE_COMPARE, 0);
        this.addCheckBox(composite, "ComparePreferencePage.structureOutline.label", USE_OUTLINE_VIEW, 0);
        this.addCheckBox(composite, "ComparePreferencePage.ignoreWhitespace.label", IGNORE_WHITESPACE, 0);
        new Label(composite, 0);
        this.addCheckBox(composite, "ComparePreferencePage.saveBeforePatching.label", PREF_SAVE_ALL_EDITORS, 0);
        new Label(composite, 0);
        Label l = new Label(composite, 64);
        l.setText(Utilities.getString("ComparePreferencePage.regex.description"));
        Composite c2 = new Composite(composite, 0);
        c2.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        c2.setLayout((Layout)layout);
        l = new Label(c2, 0);
        l.setText(Utilities.getString("ComparePreferencePage.regexAdded.label"));
        this.addedLinesRegex = new Text(c2, 2048);
        this.addedLinesRegex.setLayoutData((Object)new GridData(768));
        this.addedLinesRegex.setText(this.fOverlayStore.getString(ADDED_LINES_REGEX));
        l = new Label(c2, 0);
        l.setText(Utilities.getString("ComparePreferencePage.regexRemoved.label"));
        this.removedLinesRegex = new Text(c2, 2048);
        this.removedLinesRegex.setLayoutData((Object)new GridData(768));
        this.removedLinesRegex.setText(this.fOverlayStore.getString(REMOVED_LINES_REGEX));
        new Label(composite, 0);
        l = new Label(composite, 64);
        l.setText(Utilities.getString("ComparePreferencePage.filter.description"));
        Composite c3 = new Composite(composite, 0);
        c3.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        c3.setLayout((Layout)layout);
        l = new Label(c3, 0);
        l.setText(Utilities.getString("ComparePreferencePage.filter.label"));
        this.fFilters = new Text(c3, 2048);
        this.fFilters.setLayoutData((Object)new GridData(768));
        this.fFilters.setText(this.fOverlayStore.getString(PATH_FILTER));
        this.fFilters.addModifyListener(e -> {
            String filters = this.fFilters.getText();
            String message = CompareResourceFilter.validateResourceFilters(filters);
            this.setValid(message == null);
            this.setMessage(null);
            this.setErrorMessage(message);
            this.fOverlayStore.setValue(PATH_FILTER, filters);
        });
        return composite;
    }

    private Control createTextComparePage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.addCheckBox(composite, "ComparePreferencePage.synchronizeScrolling.label", SYNCHRONIZE_SCROLLING, 0);
        this.addCheckBox(composite, "ComparePreferencePage.initiallyShowAncestorPane.label", INITIALLY_SHOW_ANCESTOR_PANE, 0);
        this.addCheckBox(composite, "ComparePreferencePage.showPseudoConflicts.label", SHOW_PSEUDO_CONFLICTS, 0);
        this.addCheckBox(composite, "ComparePreferencePage.useSingleLine.label", USE_SINGLE_LINE, 0);
        this.addCheckBox(composite, "ComparePreferencePage.highlightTokenChanges.label", HIGHLIGHT_TOKEN_CHANGES, 0);
        this.fDisableCappingCheckBox = this.addCheckBox(composite, "ComparePreferencePage.disableCapping.label", CAPPING_DISABLED, 0);
        this.addCheckBox(composite, "ComparePreferencePage.swapped.label", SWAPPED, 0);
        Composite radioGroup = new Composite(composite, 0);
        radioGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        RadioGroupFieldEditor editor = new RadioGroupFieldEditor(ICompareUIConstants.PREF_NAVIGATION_END_ACTION, CompareMessages.ComparePreferencePage_0, 1, new String[][]{{CompareMessages.ComparePreferencePage_1, "prompt"}, {CompareMessages.ComparePreferencePage_2, "loop"}, {CompareMessages.ComparePreferencePage_3, "next"}, {CompareMessages.ComparePreferencePage_4, "doNothing"}}, radioGroup, true);
        editor.setPreferenceStore(this.fOverlayStore);
        editor.fillIntoGrid(radioGroup, 1);
        this.editors.add(editor);
        PreferenceLinkArea area = new PreferenceLinkArea(composite, 0, "org.eclipse.ui.preferencePages.ColorsAndFonts", Utilities.getString("ComparePreferencePage.colorAndFontLink"), (IWorkbenchPreferenceContainer)this.getContainer(), (Object)"selectCategory:org.eclipse.compare.contentmergeviewer.TextMergeViewer");
        GridData data = new GridData(4, 0x1000000, false, false);
        area.getControl().setLayoutData((Object)data);
        Label separator = new Label(composite, 258);
        separator.setVisible(false);
        Label previewLabel = new Label(composite, 0);
        previewLabel.setText(Utilities.getString("ComparePreferencePage.preview-2way.label"));
        Control previewer = this.create2WayPreviewer(composite);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        gd.heightHint = this.convertHeightInCharsToPixels(12);
        previewer.setLayoutData((Object)gd);
        previewLabel = new Label(composite, 0);
        previewLabel.setText(Utilities.getString("ComparePreferencePage.preview.label"));
        previewer = this.create3WayPreviewer(composite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        gd.heightHint = this.convertHeightInCharsToPixels(9);
        previewer.setLayoutData((Object)gd);
        return composite;
    }

    private Control create3WayPreviewer(Composite parent) {
        CompareConfiguration compareConfiguration = new CompareConfiguration(this.fOverlayStore);
        compareConfiguration.setAncestorLabel(Utilities.getString("ComparePreferencePage.ancestor.label"));
        compareConfiguration.setLeftLabel(Utilities.getString("ComparePreferencePage.left.label"));
        compareConfiguration.setLeftEditable(false);
        compareConfiguration.setRightLabel(Utilities.getString("ComparePreferencePage.right.label"));
        compareConfiguration.setRightEditable(false);
        TextMergeViewer previewViewer = new TextMergeViewer(parent, 2048, compareConfiguration);
        previewViewer.setInput(new DiffNode(12, new FakeInput("ComparePreferencePage.previewAncestor"), new FakeInput("ComparePreferencePage.previewLeft"), new FakeInput("ComparePreferencePage.previewRight")));
        Control c = previewViewer.getControl();
        c.addDisposeListener(e -> {
            if (compareConfiguration != null) {
                compareConfiguration.dispose();
            }
        });
        this.fCompareConfigurations.add(compareConfiguration);
        return c;
    }

    private Control create2WayPreviewer(Composite parent) {
        CompareConfiguration compareConfiguration = new CompareConfiguration(this.fOverlayStore);
        compareConfiguration.setLeftLabel(Utilities.getString("ComparePreferencePage.workingCopy.label"));
        compareConfiguration.setRightLabel(Utilities.getString("ComparePreferencePage.baseline.label"));
        compareConfiguration.setRightEditable(false);
        TextMergeViewer previewViewer = new TextMergeViewer(parent, 2048, compareConfiguration);
        previewViewer.setInput(new DiffNode(new FakeInput("ComparePreferencePage.workingCopy"), new FakeInput("ComparePreferencePage.baseline")));
        Control c = previewViewer.getControl();
        c.addDisposeListener(e -> {
            if (compareConfiguration != null) {
                compareConfiguration.dispose();
            }
        });
        this.fCompareConfigurations.add(compareConfiguration);
        return c;
    }

    private void initializeFields() {
        for (Button b : this.fCheckBoxes.keySet()) {
            String key = this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
        if (this.fFilters != null) {
            this.fFilters.setText(this.fOverlayStore.getString(PATH_FILTER));
        }
        if (this.addedLinesRegex != null) {
            this.addedLinesRegex.setText(this.fOverlayStore.getString(ADDED_LINES_REGEX));
        }
        if (this.removedLinesRegex != null) {
            this.removedLinesRegex.setText(this.fOverlayStore.getString(REMOVED_LINES_REGEX));
        }
        this.editors.forEach(FieldEditor::load);
    }

    private Button addCheckBox(Composite parent, String labelKey, String key, int indentation) {
        String label = Utilities.getString(labelKey);
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(768);
        gd.horizontalIndent = indentation;
        checkBox.setLayoutData((Object)gd);
        if (this.fCheckBoxListener == null) {
            this.fCheckBoxListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.widget;
                    ComparePreferencePage.this.fOverlayStore.setValue((String)ComparePreferencePage.this.fCheckBoxes.get(button), button.getSelection());
                }
            };
        }
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    @Override
    public void applyData(Object data) {
        if (CAPPING_DISABLED.equals(data)) {
            this.fTextCompareTab.getParent().setSelection(this.fTextCompareTab);
            this.fDisableCappingCheckBox.setFocus();
        }
    }

    private static class FakeInput
    implements ITypedElement,
    IEncodedStreamContentAccessor {
        static final String UTF_16 = "UTF-16";
        String fContent;

        FakeInput(String name) {
            this.fContent = this.loadPreviewContentFromFile(name);
        }

        @Override
        public Image getImage() {
            return null;
        }

        @Override
        public String getName() {
            return "no name";
        }

        @Override
        public String getType() {
            return "no type";
        }

        @Override
        public InputStream getContents() {
            return new ByteArrayInputStream(Utilities.getBytes(this.fContent, UTF_16));
        }

        @Override
        public String getCharset() {
            return UTF_16;
        }

        private String loadPreviewContentFromFile(String key) {
            String preview = Utilities.getString(key);
            String separator = System.getProperty("line.separator");
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < preview.length()) {
                char c = preview.charAt(i);
                if (c == '\n') {
                    buffer.append(separator);
                } else {
                    buffer.append(c);
                }
                ++i;
            }
            return buffer.toString();
        }
    }
}

