/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Widget;

public class CompareEditorSelectionProvider
implements IPostSelectionProvider {
    private TextViewer[] fViewers;
    private TextViewer fViewerInFocus;
    private ListenerList<ISelectionChangedListener> fSelectionChangedListeners = new ListenerList();
    private ListenerList<ISelectionChangedListener> fPostSelectionChangedListeners = new ListenerList();

    public void setViewers(TextViewer[] viewers, TextViewer viewerInFocus) {
        Assert.isNotNull(viewers);
        this.fViewers = viewers;
        InternalListener listener = new InternalListener();
        this.fViewerInFocus = viewerInFocus;
        TextViewer[] textViewerArray = this.fViewers;
        int n = this.fViewers.length;
        int n2 = 0;
        while (n2 < n) {
            TextViewer viewer = textViewerArray[n2];
            viewer.addSelectionChangedListener((ISelectionChangedListener)listener);
            viewer.addPostSelectionChangedListener((ISelectionChangedListener)new InternalPostSelectionListener());
            StyledText textWidget = viewer.getTextWidget();
            textWidget.addFocusListener((FocusListener)listener);
            ++n2;
        }
    }

    private void doFocusChanged(Widget control) {
        TextViewer[] textViewerArray = this.fViewers;
        int n = this.fViewers.length;
        int n2 = 0;
        while (n2 < n) {
            TextViewer viewer = textViewerArray[n2];
            if (viewer.getTextWidget() == control) {
                this.propagateFocusChanged(viewer);
                return;
            }
            ++n2;
        }
    }

    final void doPostSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider provider = event.getSelectionProvider();
        if (provider == this.fViewerInFocus) {
            this.firePostSelectionChanged();
        }
    }

    final void doSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider provider = event.getSelectionProvider();
        if (provider == this.fViewerInFocus) {
            this.fireSelectionChanged();
        }
    }

    final void propagateFocusChanged(TextViewer viewer) {
        if (viewer != this.fViewerInFocus) {
            this.fViewerInFocus = viewer;
            this.fireSelectionChanged();
            this.firePostSelectionChanged();
        }
    }

    private void fireSelectionChanged() {
        if (this.fSelectionChangedListeners != null) {
            SelectionChangedEvent event = new SelectionChangedEvent(this, this.getSelection());
            for (ISelectionChangedListener listener : this.fSelectionChangedListeners) {
                listener.selectionChanged(event);
            }
        }
    }

    private void firePostSelectionChanged() {
        if (this.fPostSelectionChangedListeners != null) {
            SelectionChangedEvent event = new SelectionChangedEvent(this, this.getSelection());
            for (ISelectionChangedListener listener : this.fPostSelectionChangedListeners) {
                listener.selectionChanged(event);
            }
        }
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.add(listener);
    }

    @Override
    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.remove(listener);
    }

    @Override
    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionChangedListeners.add(listener);
    }

    @Override
    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionChangedListeners.remove(listener);
    }

    @Override
    public ISelection getSelection() {
        if (this.fViewerInFocus != null) {
            return this.fViewerInFocus.getSelection();
        }
        return TextSelection.emptySelection();
    }

    @Override
    public void setSelection(ISelection selection) {
        this.setSelection(selection, true);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (this.fViewerInFocus != null) {
            if (reveal && !CompareEditorSelectionProvider.isSelectionInsideVisibleRegion(this.fViewerInFocus, selection)) {
                this.resetVisibleRegion();
            }
            this.fViewerInFocus.setSelection(selection, reveal);
        }
    }

    private void resetVisibleRegion() {
        if (this.fViewers == null) {
            return;
        }
        TextViewer[] textViewerArray = this.fViewers;
        int n = this.fViewers.length;
        int n2 = 0;
        while (n2 < n) {
            TextViewer viewer = textViewerArray[n2];
            viewer.setVisibleRegion(0, viewer.getDocument().getLength());
            ++n2;
        }
    }

    private static boolean isSelectionInsideVisibleRegion(TextViewer textViewer, ISelection selection) {
        if (!(selection instanceof ITextSelection)) {
            return false;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        IRegion visibleRegion = textViewer.getVisibleRegion();
        return textSelection.getOffset() >= visibleRegion.getOffset() && textSelection.getOffset() + textSelection.getLength() <= visibleRegion.getOffset() + visibleRegion.getLength();
    }

    private class InternalListener
    implements ISelectionChangedListener,
    FocusListener {
        private InternalListener() {
        }

        @Override
        public void selectionChanged(SelectionChangedEvent event) {
            CompareEditorSelectionProvider.this.doSelectionChanged(event);
        }

        public void focusGained(FocusEvent e) {
            CompareEditorSelectionProvider.this.doFocusChanged(e.widget);
        }

        public void focusLost(FocusEvent e) {
        }
    }

    private class InternalPostSelectionListener
    implements ISelectionChangedListener {
        private InternalPostSelectionListener() {
        }

        @Override
        public void selectionChanged(SelectionChangedEvent event) {
            CompareEditorSelectionProvider.this.doPostSelectionChanged(event);
        }
    }
}

