/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.AbstractViewer;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class BinaryCompareViewer
extends AbstractViewer {
    private static final String BUNDLE_NAME = "org.eclipse.compare.internal.BinaryCompareViewerResources";
    private static final int EOF = -1;
    private ICompareInput fInput;
    private ResourceBundle fBundle;
    private Composite fComposite;
    private Label fMessage;
    private CompareConfiguration compareConfiguration;

    public BinaryCompareViewer(Composite parent, CompareConfiguration cc) {
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.compare.binary_compare_view_context");
        }
        this.fBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        this.fComposite = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        this.fComposite.setLayout((Layout)rowLayout);
        this.fMessage = new Label(this.fComposite, 64);
        this.fComposite.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)Utilities.getString(this.fBundle, "title"));
        CompareConfiguration compareConfiguration = this.compareConfiguration = cc != null ? cc : new CompareConfiguration();
        if (this.compareConfiguration.getContainer() instanceof CompareEditorInput) {
            Label compareAsTextLabel = new Label(this.fComposite, 64);
            compareAsTextLabel.setText(Utilities.getString(this.fBundle, "compareAsText"));
        }
    }

    @Override
    public Control getControl() {
        return this.fComposite;
    }

    @Override
    public void setInput(Object input) {
        if (this.fComposite != null && input instanceof ICompareInput) {
            String message;
            block18: {
                this.fInput = (ICompareInput)input;
                InputStream left = null;
                InputStream right = null;
                message = null;
                try {
                    try {
                        left = this.getStream(this.fInput.getLeft());
                        right = this.getStream(this.fInput.getRight());
                        if (left != null && right != null) {
                            int pos = 0;
                            while (true) {
                                int r;
                                int l;
                                if ((l = left.read()) != (r = right.read())) {
                                    String format = Utilities.getString(this.fBundle, "diffMessageFormat");
                                    message = MessageFormat.format(format, Integer.toString(pos));
                                } else if (l != -1) {
                                    ++pos;
                                    continue;
                                }
                                break;
                            }
                        } else if (left == null && right == null) {
                            message = Utilities.getString(this.fBundle, "deleteConflictMessage");
                        } else if (left == null) {
                            message = Utilities.getString(this.fBundle, this.compareConfiguration.isMirrored() ? "addedMessage" : "deletedMessage");
                        } else if (right == null) {
                            message = Utilities.getString(this.fBundle, this.compareConfiguration.isMirrored() ? "deletedMessage" : "addedMessage");
                        }
                    }
                    catch (IOException | CoreException ex) {
                        message = Utilities.getString(this.fBundle, "errorMessage");
                        CompareUIPlugin.log(ex);
                        Utilities.close(left);
                        Utilities.close(right);
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    Utilities.close(left);
                    Utilities.close(right);
                    throw throwable;
                }
                Utilities.close(left);
                Utilities.close(right);
            }
            if (message != null) {
                this.fMessage.setText(message);
            }
            this.fComposite.layout();
        }
    }

    @Override
    public Object getInput() {
        return this.fInput;
    }

    private InputStream getStream(ITypedElement input) throws CoreException {
        if (input instanceof IStreamContentAccessor) {
            return ((IStreamContentAccessor)((Object)input)).getContents();
        }
        return null;
    }
}

