/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.INavigatable;
import org.eclipse.core.runtime.Adapters;

public abstract class CompareNavigator
implements ICompareNavigator {
    @Override
    public boolean selectChange(boolean next) {
        INavigatable[] navigators = this.getNavigatables();
        Object downStreamInput = null;
        int i = navigators.length - 1;
        while (i >= 0) {
            INavigatable navigatable = navigators[i];
            if (navigatable.getInput() != downStreamInput) {
                if (navigatable.selectChange(next ? 1 : 2)) {
                    downStreamInput = navigatable.getInput();
                } else {
                    if (i + 1 < navigators.length && navigators[i + 1] != null && navigators[i + 1].getInput() != downStreamInput) {
                        navigators[i + 1].selectChange(next ? 3 : 4);
                    }
                    return false;
                }
            }
            --i;
        }
        return true;
    }

    protected abstract INavigatable[] getNavigatables();

    protected final INavigatable getNavigator(Object object) {
        if (object == null) {
            return null;
        }
        return Adapters.adapt(object, INavigatable.class);
    }

    public boolean hasChange(boolean next) {
        INavigatable[] navigators = this.getNavigatables();
        Object downStreamInput = null;
        int i = navigators.length;
        while (--i >= 0) {
            INavigatable navigatable = navigators[i];
            if (navigatable.getInput() == downStreamInput) continue;
            if (navigatable.hasChange(next ? 1 : 2)) {
                return true;
            }
            downStreamInput = navigatable.getInput();
        }
        return false;
    }
}

