/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.web.util.RequirejsConfigContributor;
import net.sf.jasperreports.web.util.RequirejsTemplateConfigContext;
import net.sf.jasperreports.web.util.VelocityUtil;
import net.sf.jasperreports.web.util.WebRequestContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequirejsTemplateConfigContributor
implements RequirejsConfigContributor {
    private static final Log log = LogFactory.getLog(RequirejsTemplateConfigContributor.class);
    private String templateName;
    private Map<String, String> paths = new HashMap<String, String>();
    private Map<String, String> resourcePaths = new HashMap<String, String>();

    @Override
    public void contribute(WebRequestContext context, ObjectNode config) {
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        RequirejsTemplateConfigContext templateContext = new RequirejsTemplateConfigContext(context, this.paths, this.resourcePaths);
        templateMap.put("context", templateContext);
        String configString = VelocityUtil.processTemplate(this.templateName, templateMap);
        if (log.isTraceEnabled()) {
            log.trace("template " + this.templateName + " config:\n" + configString);
        }
        ObjectNode templateConfig = this.parseTemplateConfig(configString);
        this.mergeObject(config, templateConfig);
    }

    protected ObjectNode parseTemplateConfig(String configString) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            ObjectNode templateConfig = objectMapper.readValue((Reader)new StringReader(configString), ObjectNode.class);
            return templateConfig;
        }
        catch (JsonParseException e) {
            throw new JRRuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new JRRuntimeException(e);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected void mergeObject(ObjectNode dest, ObjectNode source) {
        Iterator<Map.Entry<String, JsonNode>> it = source.fields();
        while (it.hasNext()) {
            Map.Entry<String, JsonNode> fieldEntry = it.next();
            String field = fieldEntry.getKey();
            JsonNode sourceValue = fieldEntry.getValue();
            JsonNode destValue = dest.get(field);
            if (sourceValue instanceof ObjectNode && destValue instanceof ObjectNode) {
                this.mergeObject((ObjectNode)destValue, (ObjectNode)sourceValue);
                continue;
            }
            dest.set(field, sourceValue);
        }
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void addPath(String key, String path) {
        this.paths.put(key, path);
    }

    public void addResourcePath(String key, String resource) {
        this.resourcePaths.put(key, resource);
    }
}

