/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import net.sf.jasperreports.data.cache.ColumnDataCacheHandler;
import net.sf.jasperreports.data.cache.DataCacheHandler;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.fill.AsynchronousFillHandle;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.web.actions.Action;
import net.sf.jasperreports.web.commands.CommandStack;
import net.sf.jasperreports.web.servlets.AsyncJasperPrintAccessor;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import net.sf.jasperreports.web.servlets.SimpleJasperPrintAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Controller {
    private static final Log log = LogFactory.getLog(Controller.class);
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_NOT_FOUND = "web.servlets.controller.report.not.found";
    private JasperReportsContext jasperReportsContext;

    public Controller(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public void runReport(ReportContext reportContext, Action action) throws JRException {
        String reportUri = (String)reportContext.getParameterValue("jr_report_uri");
        int initialStackSize = 0;
        CommandStack commandStack = (CommandStack)reportContext.getParameterValue("net.sf.jasperreports.command.stack");
        if (commandStack != null) {
            initialStackSize = commandStack.getExecutionStackSize();
        }
        this.setDataCache(reportContext);
        JasperReport jasperReport = null;
        if (reportUri != null && reportUri.trim().length() > 0) {
            reportUri = reportUri.trim();
            if (action != null) {
                action.run();
                if (log.isDebugEnabled()) {
                    log.debug("action requires refill: " + action.requiresRefill());
                }
                if (!action.requiresRefill()) {
                    return;
                }
            }
            jasperReport = RepositoryUtil.getInstance(this.jasperReportsContext).getReport(reportContext, reportUri);
        }
        if (jasperReport == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_REPORT_NOT_FOUND, new Object[]{reportUri});
        }
        Boolean async = (Boolean)reportContext.getParameterValue("jr_async");
        if (async == null) {
            async = Boolean.FALSE;
        }
        reportContext.setParameterValue("jr_async", async);
        try {
            this.runReport(reportContext, jasperReport, async);
        }
        catch (JRException e) {
            this.undoAction(reportContext, initialStackSize);
            throw e;
        }
        catch (JRRuntimeException e) {
            this.undoAction(reportContext, initialStackSize);
            throw e;
        }
    }

    private void undoAction(ReportContext reportContext, int initialStackSize) {
        CommandStack commandStack = (CommandStack)reportContext.getParameterValue("net.sf.jasperreports.command.stack");
        if (commandStack != null) {
            for (int i = 0; i < commandStack.getExecutionStackSize() - initialStackSize; ++i) {
                commandStack.undo();
            }
        }
    }

    protected void setDataCache(ReportContext reportContext) {
        DataCacheHandler dataCacheHandler = (DataCacheHandler)reportContext.getParameterValue("net.sf.jasperreports.data.cache.handler");
        if (dataCacheHandler != null && !dataCacheHandler.isSnapshotPopulated()) {
            if (log.isDebugEnabled()) {
                log.debug("Data cache handler not final " + dataCacheHandler);
            }
            dataCacheHandler = null;
        }
        if (dataCacheHandler == null) {
            dataCacheHandler = new ColumnDataCacheHandler();
            if (log.isDebugEnabled()) {
                log.debug("Created data cache handler " + dataCacheHandler);
            }
            reportContext.setParameterValue("net.sf.jasperreports.data.cache.handler", dataCacheHandler);
        }
    }

    protected void runReport(ReportContext reportContext, JasperReport jasperReport, boolean async) throws JRException {
        JasperPrintAccessor accessor;
        if (async) {
            AsynchronousFillHandle fillHandle = AsynchronousFillHandle.createHandle(this.jasperReportsContext, jasperReport, reportContext.getParameterValues());
            AsyncJasperPrintAccessor asyncAccessor = new AsyncJasperPrintAccessor(fillHandle);
            fillHandle.startFill();
            accessor = asyncAccessor;
        } else {
            JasperPrint jasperPrint = JasperFillManager.getInstance(this.jasperReportsContext).fill(jasperReport, reportContext.getParameterValues());
            accessor = new SimpleJasperPrintAccessor(jasperPrint);
        }
        reportContext.setParameterValue("net.sf.jasperreports.web.jasper_print.accessor", accessor);
    }
}

