/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.JsonOperatorEnum;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonUtil {
    private static final Log log = LogFactory.getLog(JsonUtil.class);
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_OPERATOR = "util.json.unknown.operator";

    public static boolean evaluateJsonExpression(JsonNode contextNode, String attributeExpression) throws JRException {
        if (attributeExpression == null) {
            return true;
        }
        String attribute = null;
        JsonOperatorEnum operator2 = null;
        String value = null;
        boolean result = false;
        for (JsonOperatorEnum joe : JsonOperatorEnum.values()) {
            int indexOfOperator = attributeExpression.indexOf(joe.getValue());
            if (indexOfOperator == -1) continue;
            operator2 = joe;
            attribute = attributeExpression.substring(0, indexOfOperator).trim();
            value = attributeExpression.substring(indexOfOperator + joe.getValue().length()).trim();
            break;
        }
        if (operator2 == null) {
            StringBuilder possibleOperations = new StringBuilder();
            for (JsonOperatorEnum op : JsonOperatorEnum.values()) {
                possibleOperations.append(op.getValue()).append(",");
            }
            throw new JRException(EXCEPTION_MESSAGE_KEY_UNKNOWN_OPERATOR, new Object[]{attributeExpression, possibleOperations});
        }
        if (attribute != null && operator2 != null && value != null) {
            if (!contextNode.path(attribute).isValueNode()) {
                result = false;
            } else {
                String contextValue = contextNode.path(attribute).asText();
                switch (operator2) {
                    case LT: {
                        try {
                            result = Double.parseDouble(contextValue) < Double.parseDouble(value);
                        }
                        catch (NumberFormatException nfe) {
                            result = false;
                        }
                        break;
                    }
                    case LE: {
                        try {
                            result = Double.parseDouble(contextValue) <= Double.parseDouble(value);
                        }
                        catch (NumberFormatException nfe) {
                            result = false;
                        }
                        break;
                    }
                    case GT: {
                        try {
                            result = Double.parseDouble(contextValue) > Double.parseDouble(value);
                        }
                        catch (NumberFormatException nfe) {
                            result = false;
                        }
                        break;
                    }
                    case GE: {
                        try {
                            result = Double.parseDouble(contextValue) >= Double.parseDouble(value);
                        }
                        catch (NumberFormatException nfe) {
                            result = false;
                        }
                        break;
                    }
                    case EQ: {
                        result = contextValue.equals(value);
                        break;
                    }
                    case NE: {
                        result = !contextValue.equals(value);
                    }
                }
            }
        }
        return result;
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        return mapper;
    }

    public static JsonNode parseJson(File file) throws JRException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            JsonNode jsonNode = JsonUtil.parseJson(fileInputStream);
            return jsonNode;
        }
        catch (FileNotFoundException e) {
            throw new JRException(e);
        }
        finally {
            block10: {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        if (!log.isWarnEnabled()) break block10;
                        log.warn("Failed to close input stream for file " + file, e);
                    }
                }
            }
        }
    }

    public static JsonNode parseJson(JasperReportsContext jasperReportsContext, String location) throws JRException {
        return JsonUtil.parseJson(SimpleRepositoryContext.of(jasperReportsContext), location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonNode parseJson(RepositoryContext repositoryContext, String location) throws JRException {
        RepositoryUtil repository = RepositoryUtil.getInstance(repositoryContext);
        InputStream stream = repository.getInputStreamFromLocation(location);
        try {
            JsonNode jsonNode = JsonUtil.parseJson(stream);
            return jsonNode;
        }
        finally {
            block8: {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        if (!log.isWarnEnabled()) break block8;
                        log.warn("Failed to close input stream for location " + location, e);
                    }
                }
            }
        }
    }

    public static JsonNode parseJson(InputStream jsonStream) throws JRException {
        JsonNode jsonTree;
        ObjectMapper mapper = JsonUtil.createObjectMapper();
        try {
            jsonTree = mapper.readTree(jsonStream);
        }
        catch (JsonProcessingException e) {
            throw new JRException(e);
        }
        catch (IOException e) {
            throw new JRException(e);
        }
        return jsonTree;
    }
}

