/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.json.expression.member.evaluation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.json.JRJsonNode;
import net.sf.jasperreports.engine.json.JsonNodeContainer;
import net.sf.jasperreports.engine.json.expression.EvaluationContext;
import net.sf.jasperreports.engine.json.expression.member.ArraySliceExpression;
import net.sf.jasperreports.engine.json.expression.member.MemberExpression;
import net.sf.jasperreports.engine.json.expression.member.evaluation.AbstractMemberExpressionEvaluator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArraySliceExpressionEvaluator
extends AbstractMemberExpressionEvaluator {
    private static final Log log = LogFactory.getLog(ArraySliceExpressionEvaluator.class);
    private ArraySliceExpression expression;

    public ArraySliceExpressionEvaluator(EvaluationContext evaluationContext, ArraySliceExpression expression) {
        super(evaluationContext);
        this.expression = expression;
    }

    @Override
    public JsonNodeContainer evaluate(JsonNodeContainer contextNode) {
        if (log.isDebugEnabled()) {
            log.debug("---> evaluating expression [" + this.expression + "] on a node with (size: " + contextNode.getSize() + ", cSize: " + contextNode.getContainerSize() + ")");
        }
        JsonNodeContainer result = new JsonNodeContainer();
        switch (this.expression.getDirection()) {
            case DOWN: {
                Integer start = this.getSliceStart(contextNode.getContainerSize());
                if (start >= contextNode.getContainerSize()) {
                    return null;
                }
                Integer end = this.getSliceEnd(contextNode.getContainerSize());
                if (end < 0) {
                    return null;
                }
                if (log.isDebugEnabled()) {
                    log.debug("start: " + start + ", end: " + end);
                }
                List<JRJsonNode> containerNodes = contextNode.getContainerNodes();
                for (int i = start.intValue(); i < end; ++i) {
                    JRJsonNode nodeAtIndex = containerNodes.get(i);
                    if (!this.applyFilter(nodeAtIndex)) continue;
                    result.add(nodeAtIndex);
                }
                break;
            }
            case ANYWHERE_DOWN: {
                for (JRJsonNode node : contextNode.getContainerNodes()) {
                    result.addNodes(this.goAnywhereDown(node));
                }
                break;
            }
        }
        if (result.getSize() > 0) {
            return result;
        }
        return null;
    }

    private Integer getSliceStart(int containerSize) {
        Integer start = this.expression.getStart();
        if (start == null) {
            start = 0;
        } else if (start < 0 && (start = Integer.valueOf(containerSize + start)) < 0) {
            start = 0;
        }
        return start;
    }

    private Integer getSliceEnd(int containerSize) {
        Integer end = this.expression.getEnd();
        if (end == null) {
            end = containerSize;
        } else if (end < 0) {
            end = containerSize + end;
        } else if (end > containerSize) {
            end = containerSize;
        }
        return end;
    }

    private List<JRJsonNode> goAnywhereDown(JRJsonNode jrJsonNode) {
        ArrayList<JRJsonNode> result = new ArrayList<JRJsonNode>();
        ArrayDeque<JRJsonNode> stack = new ArrayDeque<JRJsonNode>();
        if (log.isDebugEnabled()) {
            log.debug("initial stack population with: " + jrJsonNode.getDataNode());
        }
        stack.push(jrJsonNode);
        while (!stack.isEmpty()) {
            Integer end;
            JRJsonNode stackNode = (JRJsonNode)stack.pop();
            JsonNode stackDataNode = stackNode.getDataNode();
            this.addChildrenToStack(stackNode, stack);
            if (!stackDataNode.isArray()) continue;
            if (log.isDebugEnabled()) {
                log.debug("processing stack element: " + stackDataNode);
            }
            ArrayNode newNode = this.getEvaluationContext().getObjectMapper().createArrayNode();
            Integer start = this.getSliceStart(stackDataNode.size());
            if (start >= stackDataNode.size() || (end = this.getSliceEnd(stackDataNode.size())) < 0) continue;
            for (int i = start.intValue(); i < end; ++i) {
                JRJsonNode nodeAtIndex = stackNode.createChild(stackDataNode.get(i));
                if (!this.applyFilter(nodeAtIndex)) continue;
                newNode.add(nodeAtIndex.getDataNode());
            }
            if (newNode.size() <= 0) continue;
            result.add(stackNode.createChild(newNode));
        }
        return result;
    }

    @Override
    public MemberExpression getMemberExpression() {
        return this.expression;
    }
}

