/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.json.expression.filter.evaluation;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import net.sf.jasperreports.engine.json.JRJsonNode;
import net.sf.jasperreports.engine.json.JsonNodeContainer;
import net.sf.jasperreports.engine.json.expression.EvaluationContext;
import net.sf.jasperreports.engine.json.expression.filter.BasicFilterExpression;
import net.sf.jasperreports.engine.json.expression.filter.FilterExpression;
import net.sf.jasperreports.engine.json.expression.filter.ValueDescriptor;
import net.sf.jasperreports.engine.json.expression.filter.evaluation.FilterExpressionEvaluator;
import net.sf.jasperreports.engine.json.expression.member.MemberExpression;
import net.sf.jasperreports.engine.type.JsonOperatorEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicFilterExpressionEvaluator
implements FilterExpressionEvaluator {
    private static final Log log = LogFactory.getLog(BasicFilterExpressionEvaluator.class);
    private EvaluationContext evaluationContext;
    private BasicFilterExpression expression;

    public BasicFilterExpressionEvaluator(EvaluationContext evaluationContext, BasicFilterExpression expression) {
        this.evaluationContext = evaluationContext;
        this.expression = expression;
    }

    @Override
    public boolean evaluate(JRJsonNode jsonNode) {
        JsonNodeContainer memberEval = new JsonNodeContainer(jsonNode);
        boolean result = false;
        if (log.isDebugEnabled()) {
            log.debug("filtering (" + this.expression + ") to: " + jsonNode);
        }
        for (MemberExpression me : this.expression.getMemberExpressionList()) {
            memberEval = me.evaluate(memberEval, this.evaluationContext.getMemberExpressionEvaluatorVisitorForFilter());
            if (memberEval == null) {
                if (log.isDebugEnabled()) {
                    log.debug("result is null");
                }
                return false;
            }
            if (memberEval.getSize() != 1 || !memberEval.getFirst().getDataNode().isMissingNode()) continue;
            if (!log.isDebugEnabled()) break;
            log.debug("hit missing node");
            break;
        }
        if (log.isDebugEnabled()) {
            log.debug("done filter members' eval => node with (size: " + memberEval.getSize() + ", cSize: " + memberEval.getContainerSize() + ")");
        }
        if (this.expression.isNullFunction()) {
            if (log.isDebugEnabled()) {
                log.debug("expression isNullFunction");
            }
            if (memberEval.getSize() == 1 && (memberEval.getFirst().getDataNode().isNull() || memberEval.getFirst().getDataNode().isMissingNode())) {
                result = true;
            }
        } else if (this.expression.isNotNullFunction()) {
            if (log.isDebugEnabled()) {
                log.debug("expression isNotNullFunction");
            }
            if (memberEval.getSize() > 1 || memberEval.getSize() == 1 && !memberEval.getFirst().getDataNode().isNull() && !memberEval.getFirst().getDataNode().isMissingNode()) {
                result = true;
            }
        } else if (this.expression.isArrayFunction()) {
            if (log.isDebugEnabled()) {
                log.debug("expression isArrayFunction");
            }
            if (memberEval.getSize() > 1 || memberEval.getSize() == 1 && memberEval.getFirst().getDataNode().isArray()) {
                return true;
            }
        } else if (this.expression.isObjectFunction()) {
            if (log.isDebugEnabled()) {
                log.debug("expression isObjectFunction");
            }
            if (memberEval.getSize() == 1 && memberEval.getFirst().getDataNode().isObject()) {
                return true;
            }
        } else if (this.expression.isValueFunction()) {
            if (log.isDebugEnabled()) {
                log.debug("expression isValueFunction");
            }
            if (memberEval.getSize() == 1 && memberEval.getFirst().getDataNode().isValueNode()) {
                return true;
            }
        } else if (this.expression.isSizeFunction()) {
            if (log.isDebugEnabled()) {
                log.debug("expression isSizeFunction");
            }
            if (memberEval.getSize() > 1 || memberEval.getSize() == 1 && memberEval.getFirst().getDataNode().isArray()) {
                result = this.applySizeOperator(memberEval.getContainerSize());
            }
        } else if (memberEval.getSize() == 1 && (memberEval.getFirst().getDataNode().isValueNode() || memberEval.getFirst().getDataNode().isMissingNode())) {
            result = this.applyOperator(memberEval.getFirst().getDataNode());
        }
        if (log.isDebugEnabled()) {
            log.debug("filter result is: " + result);
        }
        return result;
    }

    protected boolean applySizeOperator(int size) {
        if (this.expression.getValueDescriptor().getType() == FilterExpression.VALUE_TYPE.INTEGER) {
            int operand = Integer.parseInt(this.expression.getValueDescriptor().getValue());
            switch (this.expression.getOperator()) {
                case EQ: {
                    return size == operand;
                }
                case NE: {
                    return size != operand;
                }
                case GT: {
                    return size > operand;
                }
                case GE: {
                    return size >= operand;
                }
                case LT: {
                    return size < operand;
                }
                case LE: {
                    return size <= operand;
                }
            }
        }
        return false;
    }

    protected boolean applyOperator(JsonNode valueNode) {
        ValueDescriptor valueDescriptor = this.expression.getValueDescriptor();
        JsonOperatorEnum operator2 = this.expression.getOperator();
        FilterExpression.VALUE_TYPE type = valueDescriptor.getType();
        if (FilterExpression.VALUE_TYPE.NULL.equals((Object)type)) {
            switch (operator2) {
                case EQ: {
                    return valueNode.isNull() || valueNode.isMissingNode();
                }
                case NE: {
                    return !valueNode.isNull() && !valueNode.isMissingNode();
                }
            }
        } else if (valueNode.isNumber() && (FilterExpression.VALUE_TYPE.INTEGER.equals((Object)type) || FilterExpression.VALUE_TYPE.DOUBLE.equals((Object)type))) {
            BigDecimal opRight = new BigDecimal(valueDescriptor.getValue());
            BigDecimal opLeft = valueNode.isBigDecimal() ? valueNode.decimalValue() : new BigDecimal(valueNode.asText());
            switch (operator2) {
                case EQ: {
                    return opLeft.compareTo(opRight) == 0;
                }
                case NE: {
                    return opLeft.compareTo(opRight) != 0;
                }
                case GT: {
                    return opLeft.compareTo(opRight) > 0;
                }
                case GE: {
                    return opLeft.compareTo(opRight) >= 0;
                }
                case LT: {
                    return opLeft.compareTo(opRight) < 0;
                }
                case LE: {
                    return opLeft.compareTo(opRight) <= 0;
                }
            }
        } else if (valueNode.isTextual() && FilterExpression.VALUE_TYPE.STRING.equals((Object)type)) {
            switch (operator2) {
                case EQ: {
                    return valueNode.textValue().equals(valueDescriptor.getValue());
                }
                case NE: {
                    return !valueNode.textValue().equals(valueDescriptor.getValue());
                }
                case CONTAINS: {
                    return valueNode.textValue().contains(valueDescriptor.getValue());
                }
            }
        } else if (valueNode.isBoolean() && FilterExpression.VALUE_TYPE.BOOLEAN.equals((Object)type)) {
            switch (operator2) {
                case EQ: {
                    return valueNode.booleanValue() == Boolean.parseBoolean(valueDescriptor.getValue());
                }
                case NE: {
                    return valueNode.booleanValue() != Boolean.parseBoolean(valueDescriptor.getValue());
                }
            }
        }
        return false;
    }
}

