/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfICCBased;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.color.ICC_Profile;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintAnchor;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.AbstractPdfTextRenderer;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementPdfHandler;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JRPdfExporterContext;
import net.sf.jasperreports.engine.export.JRPdfExporterTagHelper;
import net.sf.jasperreports.engine.export.PdfGlyphRenderer;
import net.sf.jasperreports.engine.export.PdfTextRenderer;
import net.sf.jasperreports.engine.export.PdfXmpCreator;
import net.sf.jasperreports.engine.export.SimplePdfTextRenderer;
import net.sf.jasperreports.engine.fonts.AwtFontAttribute;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.util.BreakIteratorSplitCharacter;
import net.sf.jasperreports.engine.util.ImageUtil;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRPdfaIccProfileNotFoundException;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.NullOutputStream;
import net.sf.jasperreports.export.ExportInterruptedException;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.OutputStreamExporterOutput;
import net.sf.jasperreports.export.PdfExporterConfiguration;
import net.sf.jasperreports.export.PdfReportConfiguration;
import net.sf.jasperreports.export.parameters.ParametersOutputStreamExporterOutput;
import net.sf.jasperreports.export.type.PdfPermissionsEnum;
import net.sf.jasperreports.export.type.PdfPrintScalingEnum;
import net.sf.jasperreports.export.type.PdfVersionEnum;
import net.sf.jasperreports.export.type.PdfaConformanceEnum;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.renderers.WrappingImageDataToGraphics2DRenderer;
import net.sf.jasperreports.renderers.WrappingSvgDataToGraphics2DRenderer;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRPdfExporter
extends JRAbstractExporter<PdfReportConfiguration, PdfExporterConfiguration, OutputStreamExporterOutput, JRPdfExporterContext> {
    private static final Log log = LogFactory.getLog(JRPdfExporter.class);
    public static final String PDF_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.pdf.";
    public static final String EXCEPTION_MESSAGE_KEY_DOCUMENT_ERROR = "export.pdf.document.error";
    public static final String EXCEPTION_MESSAGE_KEY_FONT_LOADING_ERROR = "export.pdf.font.loading.error";
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_GENERATION_ERROR = "export.pdf.report.generation.error";
    public static final String PROPERTY_IGNORE_HYPERLINK = "net.sf.jasperreports.export.pdf.ignore.hyperlink";
    public static final String PDF_FONT_FILES_PREFIX = "net.sf.jasperreports.export.pdf.font.";
    public static final String PDF_FONT_DIRS_PREFIX = "net.sf.jasperreports.export.pdf.fontdir.";
    public static final String PDF_EXPORTER_KEY = "net.sf.jasperreports.pdf";
    private static final String EMPTY_BOOKMARK_TITLE = "";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static boolean fontsRegistered;
    protected Document document;
    protected PdfContentByte pdfContentByte;
    protected PdfWriter pdfWriter;
    protected Document imageTesterDocument;
    protected PdfContentByte imageTesterPdfContentByte;
    protected JRPdfExporterTagHelper tagHelper = new JRPdfExporterTagHelper(this);
    protected int reportIndex;
    protected PrintPageFormat pageFormat;
    protected int crtDocumentPageNumber;
    protected int permissions;
    protected RenderersCache renderersCache;
    protected Map<String, Image> loadedImagesMap;
    protected Image pxImage;
    private BookmarkStack bookmarkStack;
    private SplitCharacter splitCharacter;
    private int crtOddPageOffsetX;
    private int crtOddPageOffsetY;
    private int crtEvenPageOffsetX;
    private int crtEvenPageOffsetY;
    private boolean awtIgnoreMissingFont;
    private Set<Character.UnicodeBlock> glyphRendererBlocks;
    private boolean glyphRendererAddActualText;
    private PdfVersionEnum minimalVersion;
    private Map<FontKey, Boolean> glyphRendererFonts;

    public JRPdfExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRPdfExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
        this.glyphRendererFonts = new HashMap<FontKey, Boolean>();
    }

    @Override
    protected Class<PdfExporterConfiguration> getConfigurationInterface() {
        return PdfExporterConfiguration.class;
    }

    @Override
    protected Class<PdfReportConfiguration> getItemConfigurationInterface() {
        return PdfReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersOutputStreamExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    protected Image getPxImage() {
        if (this.pxImage == null) {
            try {
                this.pxImage = Image.getInstance(JRLoader.loadBytesFromResource("net/sf/jasperreports/engine/images/pixel.GIF"));
            }
            catch (Exception e) {
                throw new JRRuntimeException(e);
            }
        }
        return this.pxImage;
    }

    @Override
    public void exportReport() throws JRException {
        JRPdfExporter.registerFonts();
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        OutputStream outputStream = ((OutputStreamExporterOutput)this.getExporterOutput()).getOutputStream();
        try {
            this.exportReportToStream(outputStream);
        }
        finally {
            ((OutputStreamExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
        PdfExporterConfiguration configuration = (PdfExporterConfiguration)this.getCurrentConfiguration();
        Boolean isTagged = configuration.isTagged();
        if (isTagged != null) {
            this.tagHelper.setTagged(isTagged);
        }
        this.tagHelper.setLanguage(configuration.getTagLanguage());
        this.permissions = JRPdfExporter.getIntegerPermissions(configuration.getAllowedPermissions()) & ~JRPdfExporter.getIntegerPermissions(configuration.getDeniedPermissions());
        this.crtDocumentPageNumber = 0;
        this.awtIgnoreMissingFont = this.getPropertiesUtil().getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font");
        this.glyphRendererAddActualText = this.propertiesUtil.getBooleanProperty("net.sf.jasperreports.export.pdf.glyph.renderer.add.actual.text", false);
        if (this.glyphRendererAddActualText && !this.tagHelper.isTagged && PdfGlyphRenderer.supported()) {
            this.minimalVersion = PdfVersionEnum.VERSION_1_5;
        }
    }

    @Override
    protected void initReport() {
        super.initReport();
        PdfReportConfiguration configuration = (PdfReportConfiguration)this.getCurrentItemConfiguration();
        if (configuration.isForceLineBreakPolicy().booleanValue()) {
            this.splitCharacter = new BreakIteratorSplitCharacter();
        }
        this.crtOddPageOffsetX = configuration.getOddPageOffsetX();
        this.crtOddPageOffsetY = configuration.getOddPageOffsetY();
        this.crtEvenPageOffsetX = configuration.getEvenPageOffsetX();
        this.crtEvenPageOffsetY = configuration.getEvenPageOffsetY();
        this.initGlyphRenderer();
        this.renderersCache = new RenderersCache(this.getJasperReportsContext());
        this.loadedImagesMap = new HashMap<String, Image>();
    }

    protected void initGlyphRenderer() {
        this.glyphRendererBlocks = new HashSet<Character.UnicodeBlock>();
        List<JRPropertiesUtil.PropertySuffix> props = this.propertiesUtil.getAllProperties(this.getCurrentJasperPrint(), "net.sf.jasperreports.export.pdf.glyph.renderer.blocks.");
        for (JRPropertiesUtil.PropertySuffix prop : props) {
            String blocks = prop.getValue();
            for (String blockToken : blocks.split(",")) {
                Character.UnicodeBlock block = this.resolveUnicodeBlock(blockToken);
                if (block == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("glyph renderer block " + block);
                }
                this.glyphRendererBlocks.add(block);
            }
        }
    }

    protected Character.UnicodeBlock resolveUnicodeBlock(String name) {
        if (name.trim().isEmpty()) {
            return null;
        }
        try {
            return Character.UnicodeBlock.forName(name.trim());
        }
        catch (IllegalArgumentException e) {
            log.warn("Could not resolve \"" + name + "\" to a Unicode block");
            return null;
        }
    }

    protected void exportReportToStream(OutputStream os) throws JRException {
        PdfExporterConfiguration configuration = (PdfExporterConfiguration)this.getCurrentConfiguration();
        this.pageFormat = this.jasperPrint.getPageFormat(0);
        this.document = new Document(new Rectangle(this.pageFormat.getPageWidth().intValue(), this.pageFormat.getPageHeight().intValue()));
        this.imageTesterDocument = new Document(new Rectangle(10.0f, 10.0f));
        boolean closeDocuments = true;
        try {
            String pdfJavaScript;
            String creator;
            String keywords;
            String subject;
            String author;
            String title;
            PdfPrintScalingEnum printScaling;
            this.pdfWriter = PdfWriter.getInstance(this.document, os);
            this.pdfWriter.setCloseStream(false);
            this.tagHelper.setPdfWriter(this.pdfWriter);
            PdfVersionEnum pdfVersion = configuration.getPdfVersion();
            if (pdfVersion != null) {
                this.pdfWriter.setPdfVersion(pdfVersion.getName().charAt(0));
            }
            if (this.minimalVersion != null) {
                this.pdfWriter.setAtLeastPdfVersion(this.minimalVersion.getName().charAt(0));
            }
            if (configuration.isCompressed().booleanValue()) {
                this.pdfWriter.setFullCompression();
            }
            if (configuration.isEncrypted().booleanValue()) {
                int perms = configuration.isOverrideHints() == null || configuration.isOverrideHints().booleanValue() ? (configuration.getPermissions() != null ? configuration.getPermissions() : this.permissions) : (this.permissions != 0 ? this.permissions : (configuration.getPermissions() != null ? configuration.getPermissions() : 0));
                this.pdfWriter.setEncryption(PdfWriter.getISOBytes(configuration.getUserPassword()), PdfWriter.getISOBytes(configuration.getOwnerPassword()), perms, configuration.is128BitKey() != false ? 1 : 0);
            }
            if (PdfPrintScalingEnum.DEFAULT == (printScaling = configuration.getPrintScaling())) {
                this.pdfWriter.addViewerPreference(PdfName.PRINTSCALING, PdfName.APPDEFAULT);
            } else if (PdfPrintScalingEnum.NONE == printScaling) {
                this.pdfWriter.addViewerPreference(PdfName.PRINTSCALING, PdfName.NONE);
            }
            boolean justifiedLetterSpacing = this.propertiesUtil.getBooleanProperty(this.jasperPrint, "net.sf.jasperreports.export.pdf.justified.letter.spacing", false);
            if (!justifiedLetterSpacing) {
                this.pdfWriter.setSpaceCharRatio(1.0E7f);
            }
            if ((title = configuration.getMetadataTitle()) != null) {
                this.document.addTitle(title);
                if (configuration.isDisplayMetadataTitle().booleanValue()) {
                    this.pdfWriter.addViewerPreference(PdfName.DISPLAYDOCTITLE, new PdfBoolean(true));
                }
            }
            if ((author = configuration.getMetadataAuthor()) != null) {
                this.document.addAuthor(author);
            }
            if ((subject = configuration.getMetadataSubject()) != null) {
                this.document.addSubject(subject);
            }
            if ((keywords = configuration.getMetadataKeywords()) != null) {
                this.document.addKeywords(keywords);
            }
            if ((creator = configuration.getMetadataCreator()) == null) {
                creator = "JasperReports Library version " + Package.getPackage("net.sf.jasperreports.engine").getImplementationVersion();
            }
            this.document.addCreator(creator);
            this.pdfWriter.setTabs(PdfName.S);
            String language = configuration.getTagLanguage();
            if (language != null) {
                this.pdfWriter.getExtraCatalog().put(PdfName.LANG, new PdfString(language));
            }
            PdfaConformanceEnum pdfaConformance = configuration.getPdfaConformance();
            boolean gotPdfa = false;
            if (PdfaConformanceEnum.PDFA_1A == pdfaConformance) {
                this.pdfWriter.setPDFXConformance(3);
                gotPdfa = true;
            } else if (PdfaConformanceEnum.PDFA_1B == pdfaConformance) {
                this.pdfWriter.setPDFXConformance(4);
                gotPdfa = true;
            }
            if (gotPdfa) {
                if (PdfXmpCreator.supported()) {
                    byte[] metadata = PdfXmpCreator.createXmpMetadata(this.pdfWriter);
                    this.pdfWriter.setXmpMetadata(metadata);
                } else {
                    if ((title != null || subject != null || keywords != null) && log.isWarnEnabled()) {
                        log.warn("XMP metadata might be non conforming, include the Adobe XMP library to correct");
                    }
                    this.pdfWriter.createXmpMetadata();
                }
            } else {
                this.pdfWriter.setRgbTransparencyBlending(true);
            }
            this.document.open();
            if (gotPdfa) {
                String iccProfilePath = configuration.getIccProfilePath();
                if (iccProfilePath != null) {
                    PdfDictionary pdfDictionary = new PdfDictionary(PdfName.OUTPUTINTENT);
                    pdfDictionary.put(PdfName.OUTPUTCONDITIONIDENTIFIER, new PdfString("sRGB IEC61966-2.1"));
                    pdfDictionary.put(PdfName.INFO, new PdfString("sRGB IEC61966-2.1"));
                    pdfDictionary.put(PdfName.S, PdfName.GTS_PDFA1);
                    InputStream iccIs = RepositoryUtil.getInstance(this.jasperReportsContext).getInputStreamFromLocation(iccProfilePath);
                    PdfICCBased pdfICCBased = new PdfICCBased(ICC_Profile.getInstance(iccIs));
                    pdfICCBased.remove(PdfName.ALTERNATE);
                    pdfDictionary.put(PdfName.DESTOUTPUTPROFILE, this.pdfWriter.addToBody(pdfICCBased).getIndirectReference());
                    this.pdfWriter.getExtraCatalog().put(PdfName.OUTPUTINTENTS, new PdfArray(pdfDictionary));
                } else {
                    throw new JRPdfaIccProfileNotFoundException();
                }
            }
            if ((pdfJavaScript = configuration.getPdfJavaScript()) != null) {
                this.pdfWriter.addJavaScript(pdfJavaScript);
            }
            this.pdfContentByte = this.pdfWriter.getDirectContent();
            this.tagHelper.init(this.pdfContentByte);
            PdfWriter imageTesterPdfWriter = PdfWriter.getInstance(this.imageTesterDocument, new NullOutputStream());
            this.imageTesterDocument.open();
            this.imageTesterDocument.newPage();
            this.imageTesterPdfContentByte = imageTesterPdfWriter.getDirectContent();
            this.imageTesterPdfContentByte.setLiteral("\n");
            List<ExporterInputItem> items = this.exporterInput.getItems();
            this.initBookmarks(items);
            boolean isCreatingBatchModeBookmarks = configuration.isCreatingBatchModeBookmarks();
            this.reportIndex = 0;
            while (this.reportIndex < items.size()) {
                ExporterInputItem item = items.get(this.reportIndex);
                this.setCurrentExporterInputItem(item);
                this.pageFormat = this.jasperPrint.getPageFormat(0);
                this.setPageSize(null);
                List<JRPrintPage> pages = this.jasperPrint.getPages();
                if (pages != null && pages.size() > 0) {
                    if (items.size() > 1) {
                        this.document.newPage();
                        if (isCreatingBatchModeBookmarks) {
                            this.addBookmark(0, this.jasperPrint.getName(), 0, 0);
                        }
                    }
                    PdfReportConfiguration lcItemConfiguration = (PdfReportConfiguration)this.getCurrentItemConfiguration();
                    boolean sizePageToContent = lcItemConfiguration.isSizePageToContent();
                    PrintPageFormat oldPageFormat = null;
                    JRAbstractExporter.PageRange pageRange = this.getPageRange();
                    int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                    int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                    for (int pageIndex = startPageIndex; pageIndex <= endPageIndex; ++pageIndex) {
                        if (Thread.interrupted()) {
                            throw new ExportInterruptedException();
                        }
                        JRPrintPage page = pages.get(pageIndex);
                        this.pageFormat = this.jasperPrint.getPageFormat(pageIndex);
                        if (sizePageToContent || oldPageFormat != this.pageFormat) {
                            this.setPageSize(sizePageToContent ? page : null);
                        }
                        this.document.newPage();
                        this.pdfContentByte = this.pdfWriter.getDirectContent();
                        this.pdfContentByte.setLineCap(2);
                        this.writePageAnchor(pageIndex);
                        ++this.crtDocumentPageNumber;
                        this.exportPage(page);
                        oldPageFormat = this.pageFormat;
                    }
                } else {
                    this.document.newPage();
                    this.pdfContentByte = this.pdfWriter.getDirectContent();
                    this.pdfContentByte.setLiteral("\n");
                }
                ++this.reportIndex;
            }
            closeDocuments = false;
            this.document.close();
            this.imageTesterDocument.close();
        }
        catch (DocumentException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DOCUMENT_ERROR, new Object[]{this.jasperPrint.getName()}, e);
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_REPORT_GENERATION_ERROR, new Object[]{this.jasperPrint.getName()}, e);
        }
        finally {
            if (closeDocuments) {
                try {
                    this.document.close();
                }
                catch (Exception exception) {}
                try {
                    this.imageTesterDocument.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void writePageAnchor(int pageIndex) throws DocumentException {
        HashMap<AttributedCharacterIterator.Attribute, Object> attributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        this.fontUtil.getAttributesWithoutAwtFont(attributes, new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider()));
        com.lowagie.text.Font pdfFont = this.getFont(attributes, this.getLocale(), false);
        Chunk chunk = new Chunk(" ", pdfFont);
        chunk.setLocalDestination(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (pageIndex + 1));
        this.tagHelper.startPageAnchor();
        ColumnText colText = new ColumnText(this.pdfContentByte);
        colText.setSimpleColumn(new Phrase(chunk), 0.0f, this.pageFormat.getPageHeight().intValue(), 1.0f, 1.0f, 0.0f, 0);
        colText.go();
        this.tagHelper.endPageAnchor();
    }

    protected void setPageSize(JRPrintPage page) throws JRException, DocumentException, IOException {
        Rectangle pageSize;
        int pageWidth = 0;
        int pageHeight = 0;
        if (page != null) {
            List<JRPrintElement> elements = page.getElements();
            for (JRPrintElement element : elements) {
                int elementRight = element.getX() + element.getWidth();
                int elementBottom = element.getY() + element.getHeight();
                pageWidth = pageWidth < elementRight ? elementRight : pageWidth;
                pageHeight = pageHeight < elementBottom ? elementBottom : pageHeight;
            }
            pageWidth += this.pageFormat.getRightMargin().intValue();
            pageHeight += this.pageFormat.getBottomMargin().intValue();
        }
        pageWidth = pageWidth < this.pageFormat.getPageWidth() ? this.pageFormat.getPageWidth() : pageWidth;
        pageHeight = pageHeight < this.pageFormat.getPageHeight() ? this.pageFormat.getPageHeight() : pageHeight;
        switch (this.pageFormat.getOrientation()) {
            case LANDSCAPE: {
                pageSize = new Rectangle(pageHeight, pageWidth).rotate();
                break;
            }
            default: {
                pageSize = new Rectangle(pageWidth, pageHeight);
            }
        }
        this.document.setPageSize(pageSize);
    }

    protected void exportPage(JRPrintPage page) throws JRException, DocumentException, IOException {
        this.tagHelper.startPage();
        List<JRPrintElement> elements = page.getElements();
        this.exportElements(elements);
        this.tagHelper.endPage();
        JRExportProgressMonitor progressMonitor = ((PdfReportConfiguration)this.getCurrentItemConfiguration()).getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection<JRPrintElement> elements) throws DocumentException, IOException, JRException {
        if (elements != null && elements.size() > 0) {
            for (JRPrintElement element : elements) {
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                this.tagHelper.startElement(element);
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                } else if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                } else if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                } else if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                } else if (element instanceof JRPrintText) {
                    this.exportText((JRPrintText)element);
                } else if (element instanceof JRPrintFrame) {
                    this.exportFrame((JRPrintFrame)element);
                } else if (element instanceof JRGenericPrintElement) {
                    this.exportGenericElement((JRGenericPrintElement)element);
                }
                this.tagHelper.endElement(element);
            }
        }
    }

    protected void exportLine(JRPrintLine line) {
        int lcOffsetX = this.getOffsetX();
        int lcOffsetY = this.getOffsetY();
        float lineWidth = line.getLinePen().getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            JRPdfExporter.preparePen(this.pdfContentByte, line.getLinePen(), 0);
            if (line.getWidth() == 1) {
                if (line.getHeight() != 1) {
                    if (line.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                        this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX) + 0.5f - lineWidth / 3.0f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY);
                        this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX) + 0.5f - lineWidth / 3.0f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight());
                        this.pdfContentByte.stroke();
                        this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX) + 0.5f + lineWidth / 3.0f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY);
                        this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX) + 0.5f + lineWidth / 3.0f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight());
                    } else {
                        this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX) + 0.5f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY);
                        this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX) + 0.5f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight());
                    }
                }
            } else if (line.getHeight() == 1) {
                if (line.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                    this.pdfContentByte.moveTo(line.getX() + lcOffsetX, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f + lineWidth / 3.0f);
                    this.pdfContentByte.lineTo(line.getX() + lcOffsetX + line.getWidth(), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f + lineWidth / 3.0f);
                    this.pdfContentByte.stroke();
                    this.pdfContentByte.moveTo(line.getX() + lcOffsetX, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f - lineWidth / 3.0f);
                    this.pdfContentByte.lineTo(line.getX() + lcOffsetX + line.getWidth(), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f - lineWidth / 3.0f);
                } else {
                    this.pdfContentByte.moveTo(line.getX() + lcOffsetX, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f);
                    this.pdfContentByte.lineTo(line.getX() + lcOffsetX + line.getWidth(), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f);
                }
            } else if (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN) {
                if (line.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                    double xtrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getWidth(), 2.0) / Math.pow(line.getHeight(), 2.0)));
                    double ytrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getHeight(), 2.0) / Math.pow(line.getWidth(), 2.0)));
                    this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX) + (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) + (float)ytrans);
                    this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX + line.getWidth()) + (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()) + (float)ytrans);
                    this.pdfContentByte.stroke();
                    this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX) - (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - (float)ytrans);
                    this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX + line.getWidth()) - (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()) - (float)ytrans);
                } else {
                    this.pdfContentByte.moveTo(line.getX() + lcOffsetX, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY);
                    this.pdfContentByte.lineTo(line.getX() + lcOffsetX + line.getWidth(), this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight());
                }
            } else if (line.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                double xtrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getWidth(), 2.0) / Math.pow(line.getHeight(), 2.0)));
                double ytrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getHeight(), 2.0) / Math.pow(line.getWidth(), 2.0)));
                this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX) + (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()) - (float)ytrans);
                this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX + line.getWidth()) + (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - (float)ytrans);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX) - (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()) + (float)ytrans);
                this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX + line.getWidth()) - (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) + (float)ytrans);
            } else {
                this.pdfContentByte.moveTo(line.getX() + lcOffsetX, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight());
                this.pdfContentByte.lineTo(line.getX() + lcOffsetX + line.getWidth(), this.pageFormat.getPageHeight() - line.getY() - lcOffsetY);
            }
            this.pdfContentByte.stroke();
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.setLineCap(2);
        }
    }

    protected void exportRectangle(JRPrintRectangle rectangle) {
        this.pdfContentByte.setRGBColorFill(rectangle.getBackcolor().getRed(), rectangle.getBackcolor().getGreen(), rectangle.getBackcolor().getBlue());
        JRPdfExporter.preparePen(this.pdfContentByte, rectangle.getLinePen(), 2);
        float lineWidth = rectangle.getLinePen().getLineWidth().floatValue();
        int lcOffsetX = this.getOffsetX();
        int lcOffsetY = this.getOffsetY();
        if (rectangle.getModeValue() == ModeEnum.OPAQUE) {
            this.pdfContentByte.roundRectangle(rectangle.getX() + lcOffsetX, this.pageFormat.getPageHeight() - rectangle.getY() - lcOffsetY - rectangle.getHeight(), rectangle.getWidth(), rectangle.getHeight(), rectangle.getRadius());
            this.pdfContentByte.fill();
        }
        if (lineWidth > 0.0f) {
            if (rectangle.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                this.pdfContentByte.roundRectangle((float)(rectangle.getX() + lcOffsetX) - lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - rectangle.getY() - lcOffsetY - rectangle.getHeight()) - lineWidth / 3.0f, (float)rectangle.getWidth() + 2.0f * lineWidth / 3.0f, (float)rectangle.getHeight() + 2.0f * lineWidth / 3.0f, rectangle.getRadius());
                this.pdfContentByte.stroke();
                this.pdfContentByte.roundRectangle((float)(rectangle.getX() + lcOffsetX) + lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - rectangle.getY() - lcOffsetY - rectangle.getHeight()) + lineWidth / 3.0f, (float)rectangle.getWidth() - 2.0f * lineWidth / 3.0f, (float)rectangle.getHeight() - 2.0f * lineWidth / 3.0f, rectangle.getRadius());
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.roundRectangle(rectangle.getX() + lcOffsetX, this.pageFormat.getPageHeight() - rectangle.getY() - lcOffsetY - rectangle.getHeight(), rectangle.getWidth(), rectangle.getHeight(), rectangle.getRadius());
                this.pdfContentByte.stroke();
            }
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    protected void exportEllipse(JRPrintEllipse ellipse) {
        this.pdfContentByte.setRGBColorFill(ellipse.getBackcolor().getRed(), ellipse.getBackcolor().getGreen(), ellipse.getBackcolor().getBlue());
        JRPdfExporter.preparePen(this.pdfContentByte, ellipse.getLinePen(), 2);
        float lineWidth = ellipse.getLinePen().getLineWidth().floatValue();
        int lcOffsetX = this.getOffsetX();
        int lcOffsetY = this.getOffsetY();
        if (ellipse.getModeValue() == ModeEnum.OPAQUE) {
            this.pdfContentByte.ellipse(ellipse.getX() + lcOffsetX, this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY - ellipse.getHeight(), ellipse.getX() + lcOffsetX + ellipse.getWidth(), this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY);
            this.pdfContentByte.fill();
        }
        if (lineWidth > 0.0f) {
            if (ellipse.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                this.pdfContentByte.ellipse((float)(ellipse.getX() + lcOffsetX) - lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY - ellipse.getHeight()) - lineWidth / 3.0f, (float)(ellipse.getX() + lcOffsetX + ellipse.getWidth()) + lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY) + lineWidth / 3.0f);
                this.pdfContentByte.stroke();
                this.pdfContentByte.ellipse((float)(ellipse.getX() + lcOffsetX) + lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY - ellipse.getHeight()) + lineWidth / 3.0f, (float)(ellipse.getX() + lcOffsetX + ellipse.getWidth()) - lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY) - lineWidth / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.ellipse(ellipse.getX() + lcOffsetX, this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY - ellipse.getHeight(), ellipse.getX() + lcOffsetX + ellipse.getWidth(), this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY);
                this.pdfContentByte.stroke();
            }
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    public void exportImage(JRPrintImage printImage) throws DocumentException, IOException, JRException {
        if (printImage.getModeValue() == ModeEnum.OPAQUE) {
            this.pdfContentByte.setRGBColorFill(printImage.getBackcolor().getRed(), printImage.getBackcolor().getGreen(), printImage.getBackcolor().getBlue());
            this.pdfContentByte.rectangle(printImage.getX() + this.getOffsetX(), this.pageFormat.getPageHeight() - printImage.getY() - this.getOffsetY(), printImage.getWidth(), -printImage.getHeight());
            this.pdfContentByte.fill();
        }
        InternalImageProcessor imageProcessor = new InternalImageProcessor(printImage);
        Renderable renderer = printImage.getRenderer();
        if (renderer != null && imageProcessor.availableImageWidth > 0 && imageProcessor.availableImageHeight > 0) {
            InternalImageProcessorResult imageProcessorResult;
            block8: {
                imageProcessorResult = null;
                try {
                    imageProcessorResult = imageProcessor.process(renderer);
                }
                catch (Exception e) {
                    Renderable onErrorRenderer = this.getRendererUtil().handleImageError(e, printImage.getOnErrorTypeValue());
                    if (onErrorRenderer == null) break block8;
                    imageProcessorResult = imageProcessor.process(onErrorRenderer);
                }
            }
            if (imageProcessorResult != null) {
                this.setAnchor(imageProcessorResult.chunk, printImage, printImage);
                this.setHyperlinkInfo(imageProcessorResult.chunk, printImage);
                this.tagHelper.startImage(printImage);
                ColumnText colText = new ColumnText(this.pdfContentByte);
                int upperY = this.pageFormat.getPageHeight() - printImage.getY() - imageProcessor.topPadding - this.getOffsetY() - imageProcessorResult.yoffset;
                int lowerX = printImage.getX() + imageProcessor.leftPadding + this.getOffsetX() + imageProcessorResult.xoffset;
                colText.setSimpleColumn(new Phrase(imageProcessorResult.chunk), lowerX, (float)upperY - imageProcessorResult.scaledHeight, (float)lowerX + imageProcessorResult.scaledWidth, upperY, imageProcessorResult.scaledHeight, 0);
                colText.go();
                this.tagHelper.endImage();
            }
        }
        if (printImage.getLineBox().getTopPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getLeftPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getBottomPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getRightPen().getLineWidth().floatValue() <= 0.0f) {
            if (printImage.getLinePen().getLineWidth().floatValue() > 0.0f) {
                this.exportPen(printImage.getLinePen(), printImage);
            }
        } else {
            this.exportBox(printImage.getLineBox(), printImage);
        }
    }

    protected void setHyperlinkInfo(Chunk chunk, JRPrintHyperlink link) {
        if (link != null) {
            Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink(PROPERTY_IGNORE_HYPERLINK, link);
            if (ignoreHyperlink == null) {
                ignoreHyperlink = ((PdfReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreHyperlink();
            }
            if (!ignoreHyperlink.booleanValue()) {
                block0 : switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() == null) break;
                        switch (link.getHyperlinkTargetValue()) {
                            case BLANK: {
                                chunk.setAction(PdfAction.javaScript("if (app.viewerVersion < 7){this.getURL(\"" + link.getHyperlinkReference() + "\");}else {app.launchURL(\"" + link.getHyperlinkReference() + "\", true);};", this.pdfWriter));
                                break block0;
                            }
                        }
                        chunk.setAnchor(link.getHyperlinkReference());
                        break;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() == null) break;
                        chunk.setLocalGoto(link.getHyperlinkAnchor());
                        break;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() == null) break;
                        chunk.setLocalGoto(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + link.getHyperlinkPage().toString());
                        break;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() == null || link.getHyperlinkAnchor() == null) break;
                        chunk.setRemoteGoto(link.getHyperlinkReference(), link.getHyperlinkAnchor());
                        break;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() == null || link.getHyperlinkPage() == null) break;
                        chunk.setRemoteGoto(link.getHyperlinkReference(), link.getHyperlinkPage());
                        break;
                    }
                    case CUSTOM: {
                        String hyperlink;
                        JRHyperlinkProducerFactory hyperlinkProducerFactory = ((PdfReportConfiguration)this.getCurrentItemConfiguration()).getHyperlinkProducerFactory();
                        if (hyperlinkProducerFactory == null || (hyperlink = hyperlinkProducerFactory.produceHyperlink(link)) == null) break;
                        switch (link.getHyperlinkTargetValue()) {
                            case BLANK: {
                                chunk.setAction(PdfAction.javaScript("if (app.viewerVersion < 7){this.getURL(\"" + hyperlink + "\");}else {app.launchURL(\"" + hyperlink + "\", true);};", this.pdfWriter));
                                break block0;
                            }
                        }
                        chunk.setAnchor(hyperlink);
                    }
                }
            }
        }
    }

    @Override
    protected Locale getTextLocale(JRPrintText text) {
        return super.getTextLocale(text);
    }

    protected Phrase getPhrase(AttributedString as, String text, JRPrintText textElement) {
        Phrase phrase = new Phrase();
        int runLimit = 0;
        AttributedCharacterIterator iterator = as.getIterator();
        Locale locale = this.getTextLocale(textElement);
        boolean firstChunk = true;
        while (runLimit < text.length() && (runLimit = iterator.getRunLimit()) <= text.length()) {
            JRPrintHyperlink hyperlink;
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            Chunk chunk = this.getChunk(attributes, text.substring(iterator.getIndex(), runLimit), locale);
            if (firstChunk) {
                this.setAnchor(chunk, textElement, textElement);
            }
            if ((hyperlink = textElement).getHyperlinkTypeValue() == HyperlinkTypeEnum.NONE) {
                hyperlink = (JRPrintHyperlink)attributes.get(JRTextAttribute.HYPERLINK);
            }
            this.setHyperlinkInfo(chunk, hyperlink);
            phrase.add(chunk);
            iterator.setIndex(runLimit);
            firstChunk = false;
        }
        return phrase;
    }

    protected Chunk getChunk(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale) {
        Object script;
        Color backcolor;
        com.lowagie.text.Font font = this.getFont(attributes, locale, false);
        Chunk chunk = new Chunk(text, font);
        if (this.hasUnderline(attributes)) {
            chunk.setUnderline(null, 0.0f, 0.055555556f, 0.0f, -0.083333336f, 0);
        }
        if (this.hasStrikethrough(attributes)) {
            chunk.setUnderline(null, 0.0f, 0.055555556f, 0.0f, 0.33333334f, 0);
        }
        if ((backcolor = (Color)attributes.get(TextAttribute.BACKGROUND)) != null) {
            chunk.setBackground(backcolor);
        }
        if ((script = attributes.get(TextAttribute.SUPERSCRIPT)) != null) {
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(script)) {
                chunk.setTextRise(font.getCalculatedLeading(1.0f) / 2.0f);
            } else if (TextAttribute.SUPERSCRIPT_SUB.equals(script)) {
                chunk.setTextRise(-font.getCalculatedLeading(1.0f) / 2.0f);
            }
        }
        if (this.splitCharacter != null) {
            chunk.setSplitCharacter(this.splitCharacter);
        }
        return chunk;
    }

    protected boolean hasUnderline(Map<AttributedCharacterIterator.Attribute, Object> textAttributes) {
        Integer underline = (Integer)textAttributes.get(TextAttribute.UNDERLINE);
        return TextAttribute.UNDERLINE_ON.equals(underline);
    }

    protected boolean hasStrikethrough(Map<AttributedCharacterIterator.Attribute, Object> textAttributes) {
        Boolean strike = (Boolean)textAttributes.get(TextAttribute.STRIKETHROUGH);
        return TextAttribute.STRIKETHROUGH_ON.equals(strike);
    }

    protected com.lowagie.text.Font getFont(Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale, boolean setFontLines) {
        JRBaseFont jrFont = new JRBaseFont(attributes);
        Exception initialException = null;
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        float fontSizeScale = 1.0f;
        Integer scriptStyle = (Integer)attributes.get(TextAttribute.SUPERSCRIPT);
        if (scriptStyle != null && (TextAttribute.SUPERSCRIPT_SUB.equals(scriptStyle) || TextAttribute.SUPERSCRIPT_SUPER.equals(scriptStyle))) {
            fontSizeScale = 0.6666667f;
        }
        com.lowagie.text.Font font = null;
        String pdfFontName = null;
        String pdfEncoding = null;
        boolean isPdfEmbedded = false;
        boolean isPdfSimulatedBold = false;
        boolean isPdfSimulatedItalic = false;
        FontInfo fontInfo = (FontInfo)attributes.get(JRTextAttribute.FONT_INFO);
        if (fontInfo == null) {
            fontInfo = this.fontUtil.getFontInfo(jrFont.getFontName(), locale);
        }
        if (fontInfo == null) {
            pdfFontName = jrFont.getPdfFontName();
            pdfEncoding = jrFont.getPdfEncoding();
            isPdfEmbedded = jrFont.isPdfEmbedded();
        } else {
            FontFamily family = fontInfo.getFontFamily();
            int pdfFontStyle = 0;
            FontFace fontFace = fontInfo.getFontFace();
            if (fontFace != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = fontInfo.getStyle();
            }
            if (pdfFontName == null && jrFont.isBold() && jrFont.isItalic() && (fontFace = family.getBoldItalicFace()) != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = 3;
            }
            if (pdfFontName == null && jrFont.isBold() && (fontFace = family.getBoldFace()) != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = 1;
            }
            if (pdfFontName == null && jrFont.isItalic() && (fontFace = family.getItalicFace()) != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = 2;
            }
            if (pdfFontName == null && (fontFace = family.getNormalFace()) != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = 0;
            }
            if (pdfFontName == null) {
                pdfFontName = jrFont.getPdfFontName();
            }
            pdfEncoding = family.getPdfEncoding() == null ? jrFont.getPdfEncoding() : family.getPdfEncoding();
            isPdfEmbedded = family.isPdfEmbedded() == null ? jrFont.isPdfEmbedded() : family.isPdfEmbedded().booleanValue();
            isPdfSimulatedBold = jrFont.isBold() && (pdfFontStyle & 1) == 0;
            isPdfSimulatedItalic = jrFont.isItalic() && (pdfFontStyle & 2) == 0;
        }
        int pdfFontStyle = (isPdfSimulatedBold ? 1 : 0) | (isPdfSimulatedItalic ? 2 : 0);
        if (setFontLines) {
            pdfFontStyle |= (jrFont.isUnderline() ? 4 : 0) | (jrFont.isStrikeThrough() ? 8 : 0);
        }
        try {
            font = FontFactory.getFont(pdfFontName, pdfEncoding, isPdfEmbedded, jrFont.getFontsize() * fontSizeScale, pdfFontStyle, forecolor);
            if (font != null && font.getBaseFont() == null && font.getFamily() == -1) {
                font = null;
            }
        }
        catch (Exception e) {
            initialException = e;
        }
        if (font == null) {
            byte[] bytes = null;
            try {
                bytes = this.getRepository().getBytesFromLocation(pdfFontName);
            }
            catch (JRException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_FONT_LOADING_ERROR, new Object[]{pdfFontName, pdfEncoding, isPdfEmbedded}, initialException);
            }
            BaseFont baseFont = null;
            try {
                baseFont = BaseFont.createFont(pdfFontName, pdfEncoding, isPdfEmbedded, true, bytes, null);
            }
            catch (DocumentException e) {
                throw new JRRuntimeException(e);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
            font = new com.lowagie.text.Font(baseFont, jrFont.getFontsize() * fontSizeScale, pdfFontStyle, forecolor);
        }
        return font;
    }

    public void exportText(JRPrintText text) throws DocumentException {
        JRStyledText styledText = this.styledTextUtil.getProcessedStyledText(text, this.noBackcolorSelector, null);
        if (styledText == null) {
            return;
        }
        AbstractPdfTextRenderer textRenderer = this.getTextRenderer(text, styledText);
        textRenderer.initialize(this, this.pdfContentByte, text, styledText, this.getOffsetX(), this.getOffsetY());
        double angle = 0.0;
        switch (text.getRotationValue()) {
            case LEFT: {
                angle = 1.5707963267948966;
                break;
            }
            case RIGHT: {
                angle = -1.5707963267948966;
                break;
            }
            case UPSIDE_DOWN: {
                angle = Math.PI;
                break;
            }
        }
        AffineTransform atrans = new AffineTransform();
        atrans.rotate(angle, textRenderer.getX(), this.pageFormat.getPageHeight() - textRenderer.getY());
        this.pdfContentByte.transform(atrans);
        if (text.getModeValue() == ModeEnum.OPAQUE) {
            Color backcolor = text.getBackcolor();
            this.pdfContentByte.setRGBColorFill(backcolor.getRed(), backcolor.getGreen(), backcolor.getBlue());
            this.pdfContentByte.rectangle(textRenderer.getX(), this.pageFormat.getPageHeight() - textRenderer.getY(), textRenderer.getWidth(), -textRenderer.getHeight());
            this.pdfContentByte.fill();
        }
        if (this.glyphRendererAddActualText && textRenderer instanceof PdfGlyphRenderer) {
            this.tagHelper.startText(styledText.getText(), text.getLinkType() != null);
        } else {
            this.tagHelper.startText(text.getLinkType() != null);
        }
        if (styledText.length() > 0) {
            textRenderer.render();
        }
        this.tagHelper.endText();
        atrans = new AffineTransform();
        atrans.rotate(-angle, textRenderer.getX(), this.pageFormat.getPageHeight() - textRenderer.getY());
        this.pdfContentByte.transform(atrans);
        this.exportBox(text.getLineBox(), text);
    }

    protected AbstractPdfTextRenderer getTextRenderer(JRPrintText text, JRStyledText styledText) {
        AbstractPdfTextRenderer textRenderer = this.toUseGlyphRenderer(text) && PdfGlyphRenderer.supported() && this.canUseGlyphRendering(text, styledText) ? new PdfGlyphRenderer(this.jasperReportsContext, this.awtIgnoreMissingFont, this.glyphRendererAddActualText && !this.tagHelper.isTagged) : (text.getLeadingOffset() == 0.0f ? new PdfTextRenderer(this.jasperReportsContext, this.awtIgnoreMissingFont) : new SimplePdfTextRenderer(this.jasperReportsContext, this.awtIgnoreMissingFont));
        return textRenderer;
    }

    protected boolean canUseGlyphRendering(JRPrintText text, JRStyledText styledText) {
        Locale locale = this.getTextLocale(text);
        AttributedCharacterIterator attributesIterator = styledText.getAttributedString().getIterator();
        int index = 0;
        while (index < styledText.length()) {
            FontKey fontKey = this.extractFontKey(attributesIterator.getAttributes(), locale);
            if (!fontKey.fontAttribute.hasAttribute()) {
                return false;
            }
            Boolean canUse = this.glyphRendererFonts.get(fontKey);
            if (canUse == null) {
                canUse = this.canUseGlyphRendering(fontKey);
                this.glyphRendererFonts.put(fontKey, canUse);
            }
            if (!canUse.booleanValue()) {
                return false;
            }
            index = attributesIterator.getRunLimit();
            attributesIterator.setIndex(index);
        }
        return true;
    }

    protected FontKey extractFontKey(Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale) {
        AwtFontAttribute fontAttribute = AwtFontAttribute.fromAttributes(attributes);
        Number posture = (Number)attributes.get(TextAttribute.POSTURE);
        boolean italic = TextAttribute.POSTURE_OBLIQUE.equals(posture);
        Number weight = (Number)attributes.get(TextAttribute.WEIGHT);
        boolean bold = TextAttribute.WEIGHT_BOLD.equals(weight);
        return new FontKey(fontAttribute, italic, bold, locale);
    }

    protected boolean canUseGlyphRendering(FontKey fontKey) {
        com.lowagie.text.Font pdfFont;
        BaseFont baseFont;
        HashMap<AttributedCharacterIterator.Attribute, Object> fontAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        fontKey.fontAttribute.putAttributes(fontAttributes);
        fontAttributes.put(TextAttribute.SIZE, Float.valueOf(10.0f));
        int style = 0;
        if (fontKey.italic) {
            style |= 2;
            fontAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (fontKey.bold) {
            style |= 1;
            fontAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if ((baseFont = (pdfFont = this.getFont(fontAttributes, fontKey.locale, false)).getBaseFont()).getFontType() != 3 || baseFont.isFontSpecific()) {
            if (log.isDebugEnabled()) {
                log.debug("pdf font for " + fontKey + " has type " + baseFont.getFontType() + ", symbol " + baseFont.isFontSpecific() + ", cannot use glyph rendering");
            }
            return false;
        }
        Font awtFont = this.fontUtil.getAwtFontFromBundles(fontKey.fontAttribute, style, 10.0f, fontKey.locale, this.awtIgnoreMissingFont);
        if (awtFont == null) {
            awtFont = new Font(fontAttributes);
        }
        String awtFontName = awtFont.getFontName();
        if (log.isDebugEnabled()) {
            log.debug(fontKey + " resolved to awt font " + awtFontName);
        }
        String[][] pdfFontNames = baseFont.getFullFontName();
        boolean nameMatch = false;
        for (String[] nameArray : pdfFontNames) {
            if (nameArray.length < 4) continue;
            if (log.isDebugEnabled()) {
                log.debug(fontKey + " resolved to pdf font " + nameArray[3]);
            }
            if (!awtFontName.equals(nameArray[3])) continue;
            nameMatch = true;
            break;
        }
        return nameMatch;
    }

    protected boolean toUseGlyphRenderer(JRPrintText text) {
        String value = this.styledTextUtil.getTruncatedText(text);
        if (value == null) {
            return false;
        }
        if (this.glyphRendererBlocks.isEmpty()) {
            return false;
        }
        int charCount = value.length();
        char[] chars = new char[charCount];
        value.getChars(0, charCount, chars, 0);
        for (char c : chars) {
            Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
            if (!this.glyphRendererBlocks.contains(block)) continue;
            if (log.isTraceEnabled()) {
                log.trace("found character in block " + block + ", using the glyph renderer");
            }
            return true;
        }
        return false;
    }

    protected void exportBox(JRLineBox box, JRPrintElement element) {
        this.exportTopPen(box.getTopPen(), box.getLeftPen(), box.getRightPen(), element);
        this.exportLeftPen(box.getTopPen(), box.getLeftPen(), box.getBottomPen(), element);
        this.exportBottomPen(box.getLeftPen(), box.getBottomPen(), box.getRightPen(), element);
        this.exportRightPen(box.getTopPen(), box.getBottomPen(), box.getRightPen(), element);
        this.pdfContentByte.setLineDash(0.0f);
        this.pdfContentByte.setLineCap(2);
    }

    protected void exportPen(JRPen pen, JRPrintElement element) {
        this.exportTopPen(pen, pen, pen, element);
        this.exportLeftPen(pen, pen, pen, element);
        this.exportBottomPen(pen, pen, pen, element);
        this.exportRightPen(pen, pen, pen, element);
        this.pdfContentByte.setLineDash(0.0f);
        this.pdfContentByte.setLineCap(2);
    }

    protected void exportTopPen(JRPen topPen, JRPen leftPen, JRPen rightPen, JRPrintElement element) {
        if (topPen.getLineWidth().floatValue() > 0.0f) {
            float leftOffset = leftPen.getLineWidth().floatValue() / 2.0f;
            float rightOffset = rightPen.getLineWidth().floatValue() / 2.0f;
            int lcOffsetX = this.getOffsetX();
            int lcOffsetY = this.getOffsetY();
            JRPdfExporter.preparePen(this.pdfContentByte, topPen, 0);
            if (topPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float topOffset = topPen.getLineWidth().floatValue();
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX) - leftOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset / 3.0f);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX) + leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) - topOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()) - rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) - topOffset / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX) - leftOffset, this.pageFormat.getPageHeight() - element.getY() - lcOffsetY);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset, this.pageFormat.getPageHeight() - element.getY() - lcOffsetY);
                this.pdfContentByte.stroke();
            }
        }
    }

    protected void exportLeftPen(JRPen topPen, JRPen leftPen, JRPen bottomPen, JRPrintElement element) {
        if (leftPen.getLineWidth().floatValue() > 0.0f) {
            float topOffset = topPen.getLineWidth().floatValue() / 2.0f;
            float bottomOffset = bottomPen.getLineWidth().floatValue() / 2.0f;
            int lcOffsetX = this.getOffsetX();
            int lcOffsetY = this.getOffsetY();
            JRPdfExporter.preparePen(this.pdfContentByte, leftPen, 0);
            if (leftPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float leftOffset = leftPen.getLineWidth().floatValue();
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX) - leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX) - leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX) + leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) - topOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX) + leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) + bottomOffset / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.moveTo(element.getX() + lcOffsetX, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset);
                this.pdfContentByte.lineTo(element.getX() + lcOffsetX, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset);
                this.pdfContentByte.stroke();
            }
        }
    }

    protected void exportBottomPen(JRPen leftPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element) {
        if (bottomPen.getLineWidth().floatValue() > 0.0f) {
            float leftOffset = leftPen.getLineWidth().floatValue() / 2.0f;
            float rightOffset = rightPen.getLineWidth().floatValue() / 2.0f;
            int lcOffsetX = this.getOffsetX();
            int lcOffsetY = this.getOffsetY();
            JRPdfExporter.preparePen(this.pdfContentByte, bottomPen, 0);
            if (bottomPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float bottomOffset = bottomPen.getLineWidth().floatValue();
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX) - leftOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset / 3.0f);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX) + leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) + bottomOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()) - rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) + bottomOffset / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX) - leftOffset, this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight());
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset, this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight());
                this.pdfContentByte.stroke();
            }
        }
    }

    protected void exportRightPen(JRPen topPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element) {
        if (rightPen.getLineWidth().floatValue() > 0.0f) {
            float topOffset = topPen.getLineWidth().floatValue() / 2.0f;
            float bottomOffset = bottomPen.getLineWidth().floatValue() / 2.0f;
            int lcOffsetX = this.getOffsetX();
            int lcOffsetY = this.getOffsetY();
            JRPdfExporter.preparePen(this.pdfContentByte, rightPen, 0);
            if (rightPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float rightOffset = rightPen.getLineWidth().floatValue();
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX + element.getWidth()) - rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) - topOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()) - rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) + bottomOffset / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.moveTo(element.getX() + lcOffsetX + element.getWidth(), (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset);
                this.pdfContentByte.lineTo(element.getX() + lcOffsetX + element.getWidth(), (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset);
                this.pdfContentByte.stroke();
            }
        }
    }

    private static void preparePen(PdfContentByte pdfContentByte, JRPen pen, int lineCap) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth <= 0.0f) {
            return;
        }
        pdfContentByte.setLineWidth(lineWidth);
        pdfContentByte.setLineCap(lineCap);
        Color color = pen.getLineColor();
        pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
        switch (pen.getLineStyleValue()) {
            case DOUBLE: {
                pdfContentByte.setLineWidth(lineWidth / 3.0f);
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            case DOTTED: {
                switch (lineCap) {
                    case 0: {
                        pdfContentByte.setLineDash(lineWidth, lineWidth, 0.0f);
                        break;
                    }
                    case 2: {
                        pdfContentByte.setLineDash(0.0f, 2.0f * lineWidth, 0.0f);
                    }
                }
                break;
            }
            case DASHED: {
                switch (lineCap) {
                    case 0: {
                        pdfContentByte.setLineDash(5.0f * lineWidth, 3.0f * lineWidth, 0.0f);
                        break;
                    }
                    case 2: {
                        pdfContentByte.setLineDash(4.0f * lineWidth, 4.0f * lineWidth, 0.0f);
                    }
                }
                break;
            }
            default: {
                pdfContentByte.setLineDash(0.0f);
            }
        }
    }

    protected static synchronized void registerFonts() {
        if (!fontsRegistered) {
            List<JRPropertiesUtil.PropertySuffix> fontDirs;
            List<JRPropertiesUtil.PropertySuffix> fontFiles = JRPropertiesUtil.getInstance(DefaultJasperReportsContext.getInstance()).getProperties(PDF_FONT_FILES_PREFIX);
            if (!fontFiles.isEmpty()) {
                for (JRPropertiesUtil.PropertySuffix font : fontFiles) {
                    String file = font.getValue();
                    if (file.toLowerCase().endsWith(".ttc")) {
                        FontFactory.register(file);
                        continue;
                    }
                    String alias = font.getSuffix();
                    FontFactory.register(file, alias);
                }
            }
            if (!(fontDirs = JRPropertiesUtil.getInstance(DefaultJasperReportsContext.getInstance()).getProperties(PDF_FONT_DIRS_PREFIX)).isEmpty()) {
                for (JRPropertiesUtil.PropertySuffix dir : fontDirs) {
                    FontFactory.registerDirectory(dir.getValue());
                }
            }
            fontsRegistered = true;
        }
    }

    protected void initBookmarks(List<ExporterInputItem> items) {
        this.bookmarkStack = new BookmarkStack();
        int rootLevel = items.size() > 1 && ((PdfExporterConfiguration)this.getCurrentConfiguration()).isCreatingBatchModeBookmarks() != false ? -1 : 0;
        Bookmark bookmark = new Bookmark(this.pdfContentByte.getRootOutline(), rootLevel);
        this.bookmarkStack.push(bookmark);
    }

    protected void addBookmark(int level, String title, int x, int y) {
        Bookmark parent = this.bookmarkStack.peek();
        while (parent.level >= level) {
            this.bookmarkStack.pop();
            parent = this.bookmarkStack.peek();
        }
        if (!((PdfReportConfiguration)this.getCurrentItemConfiguration()).isCollapseMissingBookmarkLevels().booleanValue()) {
            for (int i = parent.level + 1; i < level; ++i) {
                Bookmark emptyBookmark = new Bookmark(parent, parent.pdfOutline.getPdfDestination(), EMPTY_BOOKMARK_TITLE);
                this.bookmarkStack.push(emptyBookmark);
                parent = emptyBookmark;
            }
        }
        int height = OrientationEnum.PORTRAIT.equals(this.pageFormat.getOrientation()) ? this.pageFormat.getPageHeight() - y : y;
        Bookmark bookmark = new Bookmark(parent, x, height, title);
        this.bookmarkStack.push(bookmark);
    }

    protected void setAnchor(Chunk chunk, JRPrintAnchor anchor, JRPrintElement element) {
        String anchorName = anchor.getAnchorName();
        if (anchorName != null) {
            chunk.setLocalDestination(anchorName);
            if (anchor.getBookmarkLevel() != 0) {
                int x = OrientationEnum.PORTRAIT.equals(this.pageFormat.getOrientation()) ? this.getOffsetX() + element.getX() : this.getOffsetY() + element.getY();
                int y = OrientationEnum.PORTRAIT.equals(this.pageFormat.getOrientation()) ? this.getOffsetY() + element.getY() : this.getOffsetX() + element.getX();
                this.addBookmark(anchor.getBookmarkLevel(), anchor.getAnchorName(), x, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportFrame(JRPrintFrame frame) throws DocumentException, IOException, JRException {
        if (frame.getModeValue() == ModeEnum.OPAQUE) {
            int x = frame.getX() + this.getOffsetX();
            int y = frame.getY() + this.getOffsetY();
            Color backcolor = frame.getBackcolor();
            this.pdfContentByte.setRGBColorFill(backcolor.getRed(), backcolor.getGreen(), backcolor.getBlue());
            this.pdfContentByte.rectangle(x, this.pageFormat.getPageHeight() - y, frame.getWidth(), -frame.getHeight());
            this.pdfContentByte.fill();
        }
        this.setFrameElementsOffset(frame, false);
        try {
            this.exportElements(frame.getElements());
        }
        finally {
            this.restoreElementOffsets();
        }
        this.exportBox(frame.getLineBox(), frame);
    }

    protected PrintPageFormat getCurrentPageFormat() {
        return this.pageFormat;
    }

    @Override
    protected int getOffsetX() {
        return super.getOffsetX() + (this.insideFrame() ? 0 : (this.crtDocumentPageNumber % 2 == 0 ? this.crtEvenPageOffsetX : this.crtOddPageOffsetX));
    }

    @Override
    protected int getOffsetY() {
        return super.getOffsetY() + (this.insideFrame() ? 0 : (this.crtDocumentPageNumber % 2 == 0 ? this.crtEvenPageOffsetY : this.crtOddPageOffsetY));
    }

    protected void exportGenericElement(JRGenericPrintElement element) {
        GenericElementPdfHandler handler = (GenericElementPdfHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), PDF_EXPORTER_KEY);
        if (handler != null) {
            handler.exportElement((JRPdfExporterContext)this.exporterContext, element);
        } else if (log.isDebugEnabled()) {
            log.debug("No PDF generic element handler for " + element.getGenericType());
        }
    }

    @Override
    public String getExporterKey() {
        return PDF_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return PDF_EXPORTER_PROPERTIES_PREFIX;
    }

    public static int getIntegerPermissions(String permissions) {
        int permission = 0;
        if (permissions != null && permissions.length() > 0) {
            String[] perms;
            for (String perm : perms = permissions.split("\\|")) {
                if (PdfPermissionsEnum.ALL.equals(PdfPermissionsEnum.getByName(perm))) {
                    permission = PdfExporterConfiguration.ALL_PERMISSIONS;
                    break;
                }
                if (perm == null || perm.length() <= 0) continue;
                permission |= PdfPermissionsEnum.getByName(perm).getPdfPermission().intValue();
            }
        }
        return permission;
    }

    protected static class FontKey {
        AwtFontAttribute fontAttribute;
        boolean italic;
        boolean bold;
        Locale locale;

        public FontKey(AwtFontAttribute fontAttribute, boolean italic, boolean bold, Locale locale) {
            this.fontAttribute = fontAttribute;
            this.italic = italic;
            this.bold = bold;
            this.locale = locale;
        }

        public int hashCode() {
            int hash = 43;
            hash = hash * 29 + this.fontAttribute.hashCode();
            hash = hash * 29 + (this.italic ? 1231 : 1237);
            hash = hash * 29 + (this.bold ? 1231 : 1237);
            hash = hash * 29 + (this.locale == null ? 0 : this.locale.hashCode());
            return hash;
        }

        public boolean equals(Object obj) {
            FontKey key = (FontKey)obj;
            return this.fontAttribute.equals(key.fontAttribute) && this.italic == key.italic && this.bold == key.bold && (this.locale == null ? key.locale == null : key.locale != null && this.locale.equals(key.locale));
        }

        public String toString() {
            return "{font: " + this.fontAttribute + ", italic: " + this.italic + ", bold: " + this.bold + "}";
        }
    }

    class LocalFontMapper
    implements FontMapper {
        @Override
        public BaseFont awtToPdf(Font font) {
            HashMap<AttributedCharacterIterator.Attribute, Object> atts = new HashMap<AttributedCharacterIterator.Attribute, Object>();
            atts.putAll(font.getAttributes());
            return JRPdfExporter.this.getFont(atts, null, false).getBaseFont();
        }

        @Override
        public Font pdfToAwt(BaseFont font, int size) {
            return null;
        }
    }

    protected static class BookmarkStack {
        LinkedList<Bookmark> stack = new LinkedList();

        BookmarkStack() {
        }

        void push(Bookmark bookmark) {
            this.stack.add(bookmark);
        }

        Bookmark pop() {
            return this.stack.removeLast();
        }

        Bookmark peek() {
            return this.stack.getLast();
        }
    }

    protected static class Bookmark {
        final PdfOutline pdfOutline;
        final int level;

        Bookmark(Bookmark parent, int x, int top, String title) {
            this(parent, new PdfDestination(0, x, top, 0.0f), title);
        }

        Bookmark(Bookmark parent, PdfDestination destination, String title) {
            this.pdfOutline = new PdfOutline(parent.pdfOutline, destination, title, false);
            this.level = parent.level + 1;
        }

        Bookmark(PdfOutline pdfOutline, int level) {
            this.pdfOutline = pdfOutline;
            this.level = level;
        }
    }

    private class InternalImageProcessorResult {
        private final Chunk chunk;
        private final float scaledWidth;
        private final float scaledHeight;
        private final int xoffset;
        private final int yoffset;

        private InternalImageProcessorResult(Chunk chunk, float scaledWidth, float scaledHeight, int xoffset, int yoffset) {
            this.chunk = chunk;
            this.scaledWidth = scaledWidth;
            this.scaledHeight = scaledHeight;
            this.xoffset = xoffset;
            this.yoffset = yoffset;
        }
    }

    private class InternalImageProcessor {
        private final JRPrintImage printImage;
        private final RenderersCache imageRenderersCache;
        private final int topPadding;
        private final int leftPadding;
        private final int bottomPadding;
        private final int rightPadding;
        private final int availableImageWidth;
        private final int availableImageHeight;

        private InternalImageProcessor(JRPrintImage printImage) {
            this.printImage = printImage;
            this.imageRenderersCache = printImage.isUsingCache() ? JRPdfExporter.this.renderersCache : new RenderersCache(JRPdfExporter.this.getJasperReportsContext());
            this.topPadding = printImage.getLineBox().getTopPadding();
            this.leftPadding = printImage.getLineBox().getLeftPadding();
            this.bottomPadding = printImage.getLineBox().getBottomPadding();
            this.rightPadding = printImage.getLineBox().getRightPadding();
            int tmpAvailableImageWidth = printImage.getWidth() - this.leftPadding - this.rightPadding;
            this.availableImageWidth = tmpAvailableImageWidth < 0 ? 0 : tmpAvailableImageWidth;
            int tmpAvailableImageHeight = printImage.getHeight() - this.topPadding - this.bottomPadding;
            this.availableImageHeight = tmpAvailableImageHeight < 0 ? 0 : tmpAvailableImageHeight;
        }

        private InternalImageProcessorResult process(Renderable renderer) throws JRException, IOException, BadElementException {
            InternalImageProcessorResult imageProcessorResult = null;
            if (renderer instanceof ResourceRenderer) {
                renderer = this.imageRenderersCache.getLoadedRenderer((ResourceRenderer)renderer);
            }
            if (renderer instanceof Graphics2DRenderable) {
                imageProcessorResult = this.processGraphics2D((Graphics2DRenderable)((Object)renderer));
            } else if (renderer instanceof DataRenderable) {
                boolean isSvgData = JRPdfExporter.this.getRendererUtil().isSvgData((DataRenderable)((Object)renderer));
                if (isSvgData) {
                    imageProcessorResult = this.processGraphics2D(new WrappingSvgDataToGraphics2DRenderer((DataRenderable)((Object)renderer)));
                } else {
                    switch (this.printImage.getScaleImageValue()) {
                        case CLIP: {
                            imageProcessorResult = this.processImageClip(new WrappingImageDataToGraphics2DRenderer((DataRenderable)((Object)renderer)));
                            break;
                        }
                        case FILL_FRAME: {
                            imageProcessorResult = this.processImageFillFrame(renderer.getId(), (DataRenderable)((Object)renderer));
                            break;
                        }
                        default: {
                            imageProcessorResult = this.processImageRetainShape(renderer.getId(), (DataRenderable)((Object)renderer));
                        }
                    }
                }
            } else {
                throw new JRException("engine.renderable.must.implement.interface", new Object[]{renderer.getClass().getName(), DataRenderable.class.getName() + " or " + Graphics2DRenderable.class.getName()});
            }
            return imageProcessorResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InternalImageProcessorResult processImageClip(Graphics2DRenderable renderer) throws JRException, IOException, BadElementException {
            Dimension2D dimension;
            int normalWidth = this.availableImageWidth;
            int normalHeight = this.availableImageHeight;
            Dimension2D dimension2D = dimension = renderer instanceof DimensionRenderable ? ((DimensionRenderable)((Object)renderer)).getDimension(JRPdfExporter.this.jasperReportsContext) : null;
            if (dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            int xoffset = (int)(ImageUtil.getXAlignFactor(this.printImage) * (float)(this.availableImageWidth - normalWidth));
            int yoffset = (int)(ImageUtil.getYAlignFactor(this.printImage) * (float)(this.availableImageHeight - normalHeight));
            int minWidth = Math.min(normalWidth, this.availableImageWidth);
            int minHeight = Math.min(normalHeight, this.availableImageHeight);
            BufferedImage bi = new BufferedImage(minWidth, minHeight, 2);
            Graphics2D g = bi.createGraphics();
            try {
                if (this.printImage.getModeValue() == ModeEnum.OPAQUE) {
                    g.setColor(this.printImage.getBackcolor());
                    g.fillRect(0, 0, minWidth, minHeight);
                }
                renderer.render(JRPdfExporter.this.jasperReportsContext, g, new java.awt.Rectangle(xoffset > 0 ? 0 : xoffset, yoffset > 0 ? 0 : yoffset, normalWidth, normalHeight));
            }
            finally {
                g.dispose();
            }
            xoffset = xoffset < 0 ? 0 : xoffset;
            yoffset = yoffset < 0 ? 0 : yoffset;
            Image image = Image.getInstance(bi, null);
            return new InternalImageProcessorResult(new Chunk(image, 0.0f, 0.0f), image.getScaledWidth(), image.getScaledHeight(), xoffset, yoffset);
        }

        private InternalImageProcessorResult processImageFillFrame(String rendererId, DataRenderable renderer) throws JRException {
            Image image = null;
            if (this.printImage.isUsingCache() && JRPdfExporter.this.loadedImagesMap.containsKey(rendererId)) {
                image = JRPdfExporter.this.loadedImagesMap.get(rendererId);
            } else {
                try {
                    image = Image.getInstance(renderer.getData(JRPdfExporter.this.jasperReportsContext));
                    JRPdfExporter.this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                }
                catch (Exception e) {
                    throw new JRException(e);
                }
                if (this.printImage.isUsingCache()) {
                    JRPdfExporter.this.loadedImagesMap.put(rendererId, image);
                }
            }
            image.scaleAbsolute(this.availableImageWidth, this.availableImageHeight);
            return new InternalImageProcessorResult(new Chunk(image, 0.0f, 0.0f), image.getScaledWidth(), image.getScaledHeight(), 0, 0);
        }

        private InternalImageProcessorResult processImageRetainShape(String rendererId, DataRenderable renderer) throws JRException {
            Image image = null;
            if (this.printImage.isUsingCache() && JRPdfExporter.this.loadedImagesMap.containsKey(rendererId)) {
                image = JRPdfExporter.this.loadedImagesMap.get(rendererId);
            } else {
                try {
                    image = Image.getInstance(renderer.getData(JRPdfExporter.this.jasperReportsContext));
                    JRPdfExporter.this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                }
                catch (Exception e) {
                    throw new JRException(e);
                }
                if (this.printImage.isUsingCache()) {
                    JRPdfExporter.this.loadedImagesMap.put(rendererId, image);
                }
            }
            image.scaleToFit(this.availableImageWidth, this.availableImageHeight);
            int xoffset = (int)(ImageUtil.getXAlignFactor(this.printImage) * ((float)this.availableImageWidth - image.getPlainWidth()));
            int yoffset = (int)(ImageUtil.getYAlignFactor(this.printImage) * ((float)this.availableImageHeight - image.getPlainHeight()));
            xoffset = xoffset < 0 ? 0 : xoffset;
            yoffset = yoffset < 0 ? 0 : yoffset;
            return new InternalImageProcessorResult(new Chunk(image, 0.0f, 0.0f), image.getScaledWidth(), image.getScaledHeight(), xoffset, yoffset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InternalImageProcessorResult processGraphics2D(Graphics2DRenderable renderer) throws JRException, IOException {
            Dimension2D dimension;
            int xoffset = 0;
            int yoffset = 0;
            double normalWidth = this.availableImageWidth;
            double normalHeight = this.availableImageHeight;
            double displayWidth = this.availableImageWidth;
            double displayHeight = this.availableImageHeight;
            double ratioX = 1.0;
            double ratioY = 1.0;
            Rectangle2D.Double clip = null;
            Dimension2D dimension2D = dimension = renderer instanceof DimensionRenderable ? ((DimensionRenderable)((Object)renderer)).getDimension(JRPdfExporter.this.jasperReportsContext) : null;
            if (dimension != null) {
                normalWidth = dimension.getWidth();
                normalHeight = dimension.getHeight();
                displayWidth = normalWidth;
                displayHeight = normalHeight;
                switch (this.printImage.getScaleImageValue()) {
                    case CLIP: {
                        xoffset = (int)((double)ImageUtil.getXAlignFactor(this.printImage) * ((double)this.availableImageWidth - normalWidth));
                        yoffset = (int)((double)ImageUtil.getYAlignFactor(this.printImage) * ((double)this.availableImageHeight - normalHeight));
                        clip = new Rectangle2D.Double(-xoffset, -yoffset, this.availableImageWidth, this.availableImageHeight);
                        break;
                    }
                    case FILL_FRAME: {
                        ratioX = (double)this.availableImageWidth / normalWidth;
                        ratioY = (double)this.availableImageHeight / normalHeight;
                        normalWidth *= ratioX;
                        normalHeight *= ratioY;
                        xoffset = 0;
                        yoffset = 0;
                        break;
                    }
                    default: {
                        ratioX = (double)this.availableImageWidth / normalWidth;
                        ratioY = (double)this.availableImageHeight / normalHeight;
                        ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                        xoffset = (int)((double)ImageUtil.getXAlignFactor(this.printImage) * ((double)this.availableImageWidth - (normalWidth *= ratioX)));
                        yoffset = (int)((double)ImageUtil.getYAlignFactor(this.printImage) * ((double)this.availableImageHeight - (normalHeight *= ratioY)));
                    }
                }
            }
            PdfTemplate template = JRPdfExporter.this.pdfContentByte.createTemplate((float)displayWidth, (float)displayHeight);
            Graphics2D g = ((PdfReportConfiguration)JRPdfExporter.this.getCurrentItemConfiguration()).isForceSvgShapes() != false ? template.createGraphicsShapes((float)displayWidth, (float)displayHeight) : template.createGraphics(this.availableImageWidth, this.availableImageHeight, new LocalFontMapper());
            try {
                if (clip != null) {
                    g.setClip(clip);
                }
                if (this.printImage.getModeValue() == ModeEnum.OPAQUE) {
                    g.setColor(this.printImage.getBackcolor());
                    g.fillRect(0, 0, (int)displayWidth, (int)displayHeight);
                }
                renderer.render(JRPdfExporter.this.jasperReportsContext, g, new Rectangle2D.Double(0.0, 0.0, displayWidth, displayHeight));
            }
            finally {
                g.dispose();
            }
            JRPdfExporter.this.pdfContentByte.saveState();
            JRPdfExporter.this.pdfContentByte.addTemplate(template, (float)ratioX, 0.0f, 0.0f, (float)ratioY, this.printImage.getX() + this.leftPadding + JRPdfExporter.this.getOffsetX() + xoffset, JRPdfExporter.this.pageFormat.getPageHeight() - this.printImage.getY() - this.topPadding - JRPdfExporter.this.getOffsetY() - (int)normalHeight - yoffset);
            JRPdfExporter.this.pdfContentByte.restoreState();
            Image image = JRPdfExporter.this.getPxImage();
            image.scaleAbsolute(this.availableImageWidth, this.availableImageHeight);
            InternalImageProcessorResult result = new InternalImageProcessorResult(new Chunk(image, 0.0f, 0.0f), this.availableImageWidth, this.availableImageHeight, xoffset, yoffset);
            JRPdfExporter.this.pdfWriter.releaseTemplate(template);
            return result;
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRPdfExporterContext {
        protected ExporterContext() {
        }

        @Override
        public PdfWriter getPdfWriter() {
            return JRPdfExporter.this.pdfWriter;
        }
    }
}

