/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import net.sf.jasperreports.data.cache.ArrayStore;
import net.sf.jasperreports.data.cache.BufferColumnStore;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.DoubleArrayStore;
import net.sf.jasperreports.data.cache.EmptyColumnValues;
import net.sf.jasperreports.data.cache.FloatArrayValues;
import net.sf.jasperreports.data.cache.RunLengthColumnValues;
import net.sf.jasperreports.data.cache.RunLengthStore;
import net.sf.jasperreports.data.cache.SingleObjectValue;
import net.sf.jasperreports.data.cache.ValueLength;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FloatArrayStore
implements BufferColumnStore,
ArrayStore {
    private static final Log log = LogFactory.getLog(DoubleArrayStore.class);
    private final float[] values;
    private int count;
    private RunLengthStore runLengthStore;

    public FloatArrayStore(int size) {
        this.values = new float[size];
        this.runLengthStore = new RunLengthStore(this);
        this.reset();
    }

    private void reset() {
        this.count = 0;
        this.runLengthStore.reset();
    }

    @Override
    public Class<?> getBaseValuesType() {
        return Float.class;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public boolean valuesEqual(int idx1, int idx2) {
        return this.values[idx1] == this.values[idx2];
    }

    @Override
    public void copyValue(int destIdx, int sourceIdx) {
        this.values[destIdx] = this.values[sourceIdx];
    }

    @Override
    public void updateCount(int count) {
        this.count = count;
    }

    @Override
    public void addValue(Object object) {
        float value;
        if (!(object instanceof Float)) {
            throw new IllegalArgumentException();
        }
        this.values[this.count] = value = ((Float)object).floatValue();
        ++this.count;
        this.runLengthStore.valueAdded();
    }

    @Override
    public boolean full() {
        return this.count >= this.values.length;
    }

    @Override
    public void resetValues() {
        this.reset();
    }

    @Override
    public ColumnValues createValues() {
        if (this.count == 0) {
            if (log.isDebugEnabled()) {
                log.debug(this + ": empty values");
            }
            return EmptyColumnValues.instance();
        }
        if (this.count == 1) {
            if (log.isDebugEnabled()) {
                log.debug(this + ": single values");
            }
            return new SingleObjectValue(Float.valueOf(this.values[0]));
        }
        int originalCount = this.count;
        ColumnValues runLengthValues = this.runLengthStore.applyRunLengths(ValueLength.FLOAT);
        if (log.isDebugEnabled()) {
            log.debug(this + ": creating values of size " + this.count);
        }
        float[] floatValues = new float[this.count];
        System.arraycopy(this.values, 0, floatValues, 0, this.count);
        FloatArrayValues colValues = new FloatArrayValues(floatValues);
        ColumnValues finalValues = runLengthValues == null ? colValues : new RunLengthColumnValues(originalCount, colValues, runLengthValues);
        return finalValues;
    }

    public String toString() {
        return "FloatArrayStore@" + this.hashCode();
    }
}

