/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.jasperreports.data.cache.BigDecimalValues;
import net.sf.jasperreports.data.cache.BigIntegerStore;
import net.sf.jasperreports.data.cache.BufferColumnStore;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.LongArrayStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BigDecimalStore
implements BufferColumnStore {
    private static final Log log = LogFactory.getLog(BigDecimalStore.class);
    private final BigIntegerStore valueStore;
    private final LongArrayStore scaleStore;

    public BigDecimalStore(int size) {
        this.valueStore = new BigIntegerStore(size);
        this.scaleStore = new LongArrayStore(size);
        if (log.isDebugEnabled()) {
            log.debug(this + ": created value store " + this.valueStore);
            log.debug(this + ": created scale store " + this.scaleStore);
        }
    }

    @Override
    public Class<?> getBaseValuesType() {
        return BigDecimal.class;
    }

    @Override
    public void addValue(Object object) {
        if (!(object instanceof BigDecimal)) {
            throw new IllegalArgumentException();
        }
        BigDecimal value = (BigDecimal)object;
        BigInteger unscaledValue = value.unscaledValue();
        int scale = value.scale();
        this.valueStore.addValue(unscaledValue);
        this.scaleStore.addValue(scale);
    }

    @Override
    public boolean full() {
        return this.valueStore.full() || this.scaleStore.full();
    }

    @Override
    public void resetValues() {
        this.valueStore.resetValues();
        this.scaleStore.resetValues();
    }

    @Override
    public ColumnValues createValues() {
        ColumnValues unscaledValues = this.valueStore.createValues();
        ColumnValues scaleValues = this.scaleStore.createValues();
        return new BigDecimalValues(unscaledValues, scaleValues);
    }

    public String toString() {
        return "BigDecimalStore@" + this.hashCode();
    }
}

