/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data;

import java.io.InputStream;
import java.util.Map;
import net.sf.jasperreports.data.DataFileConnection;
import net.sf.jasperreports.data.DataFileService;
import net.sf.jasperreports.data.DataFileStreamConnection;
import net.sf.jasperreports.data.RepositoryDataLocation;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryDataLocationService
implements DataFileService {
    private static final Log log = LogFactory.getLog(RepositoryDataLocationService.class);
    private final RepositoryUtil repository;
    private final RepositoryDataLocation dataLocation;

    public RepositoryDataLocationService(ParameterContributorContext context, RepositoryDataLocation dataLocation) {
        this.repository = RepositoryUtil.getInstance(context.getRepositoryContext());
        this.dataLocation = dataLocation;
    }

    @Override
    public DataFileConnection getDataFileConnection(Map<String, Object> parameters) throws JRException {
        String location = this.dataLocation.getLocation();
        if (log.isDebugEnabled()) {
            log.debug("loading from the repository " + location);
        }
        InputStream dataStream = this.repository.getInputStreamFromLocation(location);
        return new DataFileStreamConnection(dataStream);
    }
}

