/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.sf.jasperreports.components.sort.FieldFilter;
import net.sf.jasperreports.components.sort.FilterTypeBooleanOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypeDateOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypeNumericOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypeTextOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypesEnum;
import net.sf.jasperreports.components.sort.SortElementUtils;
import net.sf.jasperreports.components.sort.actions.FilterAction;
import net.sf.jasperreports.components.sort.actions.SortAction;
import net.sf.jasperreports.components.sort.actions.SortData;
import net.sf.jasperreports.engine.CompositeDatasetFilter;
import net.sf.jasperreports.engine.DatasetFilter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.GenericElementJsonHandler;
import net.sf.jasperreports.engine.export.JsonExporterContext;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.util.MessageProvider;
import net.sf.jasperreports.engine.util.MessageUtil;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.web.commands.CommandTarget;
import net.sf.jasperreports.web.util.JacksonUtil;
import net.sf.jasperreports.web.util.VelocityUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;

public class SortElementJsonHandler
implements GenericElementJsonHandler {
    private static final Log log = LogFactory.getLog(SortElementJsonHandler.class);
    private static final String SORT_ELEMENT_HTML_TEMPLATE = "net/sf/jasperreports/components/sort/resources/SortElementJsonTemplate.vm";
    private static final String PARAM_GENERATED_TEMPLATE = "net.sf.jasperreports.sort";
    private static final String SORT_DATASET = "exporter_first_attempt";

    @Override
    public String getJsonFragment(JsonExporterContext context, JRGenericPrintElement element) {
        String htmlFragment = null;
        ReportContext reportContext = context.getExporterRef().getReportContext();
        if (reportContext != null) {
            SortData sortData;
            String sortField;
            String sortColumnName = (String)element.getParameterValue("sortColumnName");
            String sortColumnType = (String)element.getParameterValue("sortColumnType");
            String sortDatasetName = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.jr.dsr");
            boolean templateAlreadyLoaded = false;
            FilterTypesEnum filterType = FilterTypesEnum.getByName(element.getPropertiesMap().getProperty("net.sf.jasperreports.export.jr.fltrTp"));
            if (filterType == null) {
                return null;
            }
            String filterPattern = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.jr.fltrPtrn");
            Locale locale = (Locale)reportContext.getParameterValue("REPORT_LOCALE");
            JasperReportsContext jrContext = context.getJasperReportsContext();
            if (log.isDebugEnabled()) {
                log.debug("report locale: " + locale);
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            VelocityContext contextMap = new VelocityContext();
            Boolean isClearCache = (Boolean)reportContext.getParameterValue("net.sf.jasperreports.engine.export.clear.json.cache");
            if (!(reportContext.getParameterValue(PARAM_GENERATED_TEMPLATE) == null || isClearCache != null && isClearCache.booleanValue())) {
                templateAlreadyLoaded = true;
            } else {
                reportContext.setParameterValue(PARAM_GENERATED_TEMPLATE, true);
            }
            contextMap.put("templateAlreadyLoaded", (Object)templateAlreadyLoaded);
            if (!sortDatasetName.equals(context.getValue(SORT_DATASET))) {
                context.setValue(SORT_DATASET, sortDatasetName);
                contextMap.put("numericOperators", (Object)JacksonUtil.getInstance(jrContext).getJsonString(this.getTranslatedOperators(jrContext, FilterTypeNumericOperatorsEnum.class.getName(), FilterTypeNumericOperatorsEnum.values(), locale)));
                contextMap.put("dateOperators", (Object)JacksonUtil.getInstance(jrContext).getJsonString(this.getTranslatedOperators(jrContext, FilterTypeDateOperatorsEnum.class.getName(), FilterTypeDateOperatorsEnum.values(), locale)));
                contextMap.put("timeOperators", (Object)JacksonUtil.getInstance(jrContext).getJsonString(this.getTranslatedOperators(jrContext, FilterTypeDateOperatorsEnum.class.getName(), FilterTypeDateOperatorsEnum.values(), locale)));
                contextMap.put("textOperators", (Object)JacksonUtil.getInstance(jrContext).getJsonString(this.getTranslatedOperators(jrContext, FilterTypeTextOperatorsEnum.class.getName(), FilterTypeTextOperatorsEnum.values(), locale)));
                contextMap.put("booleanOperators", (Object)JacksonUtil.getInstance(jrContext).getJsonString(this.getTranslatedOperators(jrContext, FilterTypeBooleanOperatorsEnum.class.getName(), FilterTypeBooleanOperatorsEnum.values(), locale)));
                contextMap.put("exporterFirstAttempt", (Object)true);
            }
            if ((sortField = this.getCurrentSortField(context.getJasperReportsContext(), reportContext, element.getUUID().toString(), sortDatasetName, sortColumnName, sortColumnType)) == null) {
                sortData = new SortData(element.getUUID().toString(), sortColumnName, sortColumnType, "Asc");
            } else {
                String[] sortActionData = SortElementUtils.extractColumnInfo(sortField);
                boolean isAscending = "Asc".equals(sortActionData[2]);
                String sortOrder = !isAscending ? "None" : "Dsc";
                sortData = new SortData(element.getUUID().toString(), sortColumnName, sortColumnType, sortOrder);
            }
            String filterValueStart = "";
            String filterValueEnd = "";
            String filterTypeOperator = "";
            List<FieldFilter> fieldFilters = this.getExistingFiltersForField(context.getJasperReportsContext(), reportContext, element.getUUID().toString(), sortColumnName);
            if (fieldFilters.size() > 0) {
                FieldFilter ff = fieldFilters.get(0);
                if (ff.getFilterValueStart() != null) {
                    filterValueStart = ff.getFilterValueStart();
                }
                if (ff.getFilterValueEnd() != null) {
                    filterValueEnd = ff.getFilterValueEnd();
                }
                filterTypeOperator = ff.getFilterTypeOperator();
            }
            contextMap.put("id", (Object)element.hashCode());
            contextMap.put("uuid", (Object)element.getUUID().toString());
            contextMap.put("isFilterable", (Object)(filterType != null ? 1 : 0));
            contextMap.put("datasetUuid", (Object)element.getUUID().toString());
            contextMap.put("actionData", (Object)this.getActionData(context, sortData));
            contextMap.put("isField", (Object)SortFieldTypeEnum.FIELD.equals(SortFieldTypeEnum.getByName(sortColumnType)));
            contextMap.put("fieldName", (Object)sortColumnName);
            contextMap.put("fieldValueStart", (Object)filterValueStart);
            contextMap.put("fieldValueEnd", (Object)filterValueEnd);
            contextMap.put("filterType", (Object)filterType.getName());
            contextMap.put("filterTypeOperator", (Object)filterTypeOperator);
            contextMap.put("filterPattern", (Object)(filterPattern != null ? filterPattern : ""));
            htmlFragment = VelocityUtil.processTemplate(SORT_ELEMENT_HTML_TEMPLATE, contextMap);
        }
        return htmlFragment;
    }

    private String getCurrentSortField(JasperReportsContext jasperReportsContext, ReportContext reportContext, String uuid, String sortDatasetName, String sortColumnName, String sortColumnType) {
        JasperDesignCache cache = JasperDesignCache.getInstance(jasperReportsContext, reportContext);
        SortAction action = new SortAction();
        action.init(jasperReportsContext, reportContext);
        CommandTarget target = action.getCommandTarget(UUID.fromString(uuid));
        if (target != null) {
            JasperDesign jasperDesign = cache.getJasperDesign(target.getUri());
            JRDesignDataset dataset = (JRDesignDataset)jasperDesign.getMainDataset();
            List<JRSortField> existingFields = dataset.getSortFieldsList();
            String sortField = null;
            if (existingFields != null && existingFields.size() > 0) {
                for (JRSortField field : existingFields) {
                    if (!field.getName().equals(sortColumnName) || !field.getType().getName().equals(sortColumnType)) continue;
                    sortField = sortColumnName + ":" + sortColumnType + ":";
                    switch (field.getOrderValue()) {
                        case ASCENDING: {
                            sortField = sortField + "Asc";
                            break;
                        }
                        case DESCENDING: {
                            sortField = sortField + "Dsc";
                        }
                    }
                    break;
                }
            }
            return sortField;
        }
        return null;
    }

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }

    private List<LinkedHashMap<String, String>> getTranslatedOperators(JasperReportsContext jasperReportsContext, String bundleName, NamedEnum[] operators, Locale locale) {
        ArrayList<LinkedHashMap<String, String>> result = new ArrayList<LinkedHashMap<String, String>>();
        MessageProvider messageProvider = MessageUtil.getInstance(jasperReportsContext).getMessageProvider(bundleName);
        for (NamedEnum operator2 : operators) {
            LinkedHashMap<String, String> keys = new LinkedHashMap<String, String>();
            String key = bundleName + "." + ((Enum)((Object)operator2)).name();
            keys.put("key", ((Enum)((Object)operator2)).name());
            keys.put("val", messageProvider.getMessage(key, null, locale));
            result.add(keys);
        }
        return result;
    }

    public static void getFieldFilters(DatasetFilter existingFilter, List<FieldFilter> fieldFilters, String fieldName) {
        if (existingFilter instanceof FieldFilter) {
            if (fieldName == null || fieldName != null && ((FieldFilter)existingFilter).getField().equals(fieldName)) {
                fieldFilters.add((FieldFilter)existingFilter);
            }
        } else if (existingFilter instanceof CompositeDatasetFilter) {
            for (DatasetFilter datasetFilter : ((CompositeDatasetFilter)existingFilter).getFilters()) {
                SortElementJsonHandler.getFieldFilters(datasetFilter, fieldFilters, fieldName);
            }
        }
    }

    private String getActionData(JsonExporterContext context, SortData sortData) {
        return "{\"actionName\":\"sortica\",\"sortData\":" + JacksonUtil.getInstance(context.getJasperReportsContext()).getJsonString(sortData) + "}";
    }

    private List<FieldFilter> getExistingFiltersForField(JasperReportsContext jasperReportsContext, ReportContext reportContext, String uuid, String filterFieldName) {
        JasperDesignCache cache = JasperDesignCache.getInstance(jasperReportsContext, reportContext);
        FilterAction action = new FilterAction();
        action.init(jasperReportsContext, reportContext);
        CommandTarget target = action.getCommandTarget(UUID.fromString(uuid));
        ArrayList<FieldFilter> result = new ArrayList<FieldFilter>();
        if (target != null) {
            List<FieldFilter> existingFilters;
            JasperDesign jasperDesign = cache.getJasperDesign(target.getUri());
            JRDesignDataset dataset = (JRDesignDataset)jasperDesign.getMainDataset();
            String serializedFilters = "[]";
            JRPropertiesMap propertiesMap = dataset.getPropertiesMap();
            if (propertiesMap.getProperty("net.sf.jasperreports.filters") != null) {
                serializedFilters = propertiesMap.getProperty("net.sf.jasperreports.filters");
            }
            if ((existingFilters = JacksonUtil.getInstance(jasperReportsContext).loadList(serializedFilters, FieldFilter.class)).size() > 0) {
                for (DatasetFilter datasetFilter : existingFilters) {
                    if (!((FieldFilter)datasetFilter).getField().equals(filterFieldName)) continue;
                    result.add((FieldFilter)datasetFilter);
                    break;
                }
            }
        }
        return result;
    }
}

