/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.viewer;

import eelk.koguja.model.BusinessObject;
import eelk.koguja.preference.IPreferenceStore;
import eelk.koguja.preference.Preferences;
import eelk.koguja.viewer.AbstractSorter;
import eelk.koguja.viewer.DomAbstractStrucuredViewer;
import eelk.koguja.viewer.DomCellModifier;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DomTableViewer<D extends BusinessObject>
extends DomAbstractStrucuredViewer<D>
implements ControlListener,
SelectionListener {
    private Table table;
    private TableViewer tableViewer;
    private boolean[] colResized;
    private boolean isPackingColumns;
    private DomCellModifier<D> cellModifier;
    private String colWidthPref = null;

    public DomTableViewer(Table table) {
        this.createViewer(table);
    }

    public DomTableViewer(Table table, ITableLabelProvider labelProvider) {
        super(labelProvider);
        this.createViewer(table);
    }

    public DomTableViewer(Table table, ITableLabelProvider labelProvider, AbstractSorter sorter) {
        super(labelProvider, sorter);
        this.createViewer(table);
    }

    protected void createViewer(Table table) {
        this.table = table;
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider(this.contentProvider);
        this.tableViewer.setLabelProvider(this.labelProvider);
        this.cellModifier = new DomCellModifier(this.tableViewer);
        this.tableViewer.setCellModifier(this.cellModifier);
        this.tableViewer.setInput(this);
        this.isPackingColumns = false;
        TableColumn[] tc = this.table.getColumns();
        String[] cp = new String[tc.length];
        CellEditor[] ce = new CellEditor[tc.length];
        this.colResized = new boolean[tc.length];
        for (int i = 0; i < tc.length; ++i) {
            tc[i].addControlListener((ControlListener)this);
            tc[i].addSelectionListener((SelectionListener)this);
            cp[i] = tc[i].getText();
            ce[i] = null;
            this.colResized[i] = false;
        }
        this.tableViewer.setColumnProperties(cp);
        this.tableViewer.setCellEditors(ce);
    }

    public DomCellModifier<D> getCellModifier() {
        return this.cellModifier;
    }

    protected void setCellModifier(DomCellModifier<D> value) {
        this.cellModifier = value;
    }

    @Override
    public void setSource(List<D> source) {
        super.setSource(source);
        this.cellModifier.clearModified();
        this.packColumns();
    }

    public void packColumns() {
        this.isPackingColumns = true;
        TableColumn[] tc = this.table.getColumns();
        for (int i = 0; i < tc.length; ++i) {
            if (this.colResized[i]) continue;
            tc[i].pack();
        }
        this.isPackingColumns = false;
    }

    protected void setColumnWidth(int column, int width) {
        if (column >= this.colResized.length) {
            throw new IllegalArgumentException("Column index out of bounds: " + column);
        }
        this.table.getColumn(column).setWidth(width);
        this.colResized[column] = true;
    }

    protected void restoreColumnWidths() {
        if (this.colWidthPref == null) {
            return;
        }
        IPreferenceStore store = Preferences.getStore();
        if (store == null) {
            return;
        }
        int cols = this.table.getColumnCount();
        for (int i = 0; i < cols; ++i) {
            int w;
            String pref = MessageFormat.format(this.colWidthPref, i);
            if (!store.contains(pref) || (w = store.getInt(pref)) <= 0) continue;
            this.setColumnWidth(i, w);
        }
    }

    protected void storeColumnWidth(int col, int width) {
        if (this.colWidthPref == null) {
            return;
        }
        IPreferenceStore store = Preferences.getStore();
        if (store == null) {
            return;
        }
        String pref = MessageFormat.format(this.colWidthPref, col);
        store.setValue(pref, width);
    }

    public void setColWidthPref(String p) {
        this.colWidthPref = p;
        this.restoreColumnWidths();
    }

    @Override
    public StructuredViewer getViewer() {
        return this.tableViewer;
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        TableColumn[] tc = this.table.getColumns();
        for (int i = 0; i < tc.length; ++i) {
            if (tc[i] != e.getSource()) continue;
            if (!this.isPackingColumns) {
                this.colResized[i] = true;
                this.storeColumnWidth(i, tc[i].getWidth());
            }
            return;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        TableColumn[] tc = this.table.getColumns();
        for (int i = 0; i < tc.length; ++i) {
            if (tc[i] != e.getSource()) continue;
            this.sort(i);
            return;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected Table getTable() {
        return this.table;
    }

    protected void setTable(Table value) {
        this.table = value;
    }

    protected boolean isPackingColumns() {
        return this.isPackingColumns;
    }

    protected void setPackingColumns(boolean isPackingColumns) {
        this.isPackingColumns = isPackingColumns;
    }

    protected boolean[] getColResized() {
        return this.colResized;
    }

    protected void setColResized(boolean[] colResized) {
        this.colResized = colResized;
    }
}

