/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.viewer;

import eelk.koguja.model.BusinessObject;
import eelk.koguja.viewer.DomCellModifier;
import eelk.koguja.viewer.DomTableViewer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DomCheckBoxTableViewer<D extends BusinessObject>
extends DomTableViewer<D> {
    private CheckboxTableViewer tableViewer;

    public DomCheckBoxTableViewer(Table table) {
        super(table);
    }

    public DomCheckBoxTableViewer(Table table, ITableLabelProvider labelProvider) {
        super(table, labelProvider);
    }

    @Override
    protected void createViewer(Table table) {
        this.setTable(table);
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setContentProvider(this.contentProvider);
        this.tableViewer.setLabelProvider(this.labelProvider);
        this.setCellModifier(new DomCellModifier(this.tableViewer));
        this.tableViewer.setCellModifier(this.getCellModifier());
        this.tableViewer.setInput(this);
        this.setPackingColumns(false);
        TableColumn[] tc = this.getTable().getColumns();
        this.setColResized(new boolean[tc.length]);
        for (int i = 0; i < tc.length; ++i) {
            tc[i].addControlListener((ControlListener)this);
            tc[i].addSelectionListener((SelectionListener)this);
            this.getColResized()[i] = false;
        }
    }

    @Override
    public StructuredViewer getViewer() {
        return this.tableViewer;
    }

    public List<D> getCheckedObjects() {
        ArrayList<BusinessObject> result = new ArrayList<BusinessObject>();
        for (Object o : this.tableViewer.getCheckedElements()) {
            result.add((BusinessObject)o);
        }
        return result;
    }

    public void setCheckedObjects(List<D> objects) {
        this.tableViewer.setAllChecked(false);
        for (BusinessObject d : objects) {
            this.tableViewer.setChecked(d, true);
        }
    }
}

