/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.viewer;

import eelk.koguja.model.BusinessObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Item;

public class DomCellModifier<D extends BusinessObject>
implements ICellModifier {
    private final StructuredViewer vwrStructured;
    private final List<D> modifiedObjects;

    public DomCellModifier(StructuredViewer vwrStructured) {
        this.vwrStructured = vwrStructured;
        this.modifiedObjects = new ArrayList<D>();
    }

    public List<D> getModifiedObjects() {
        return this.modifiedObjects;
    }

    public void clearModified() {
        this.modifiedObjects.clear();
    }

    @Override
    public boolean canModify(Object businessObject, String property) {
        return true;
    }

    @Override
    public Object getValue(Object businessObject, String property) {
        if (businessObject == null) {
            return null;
        }
        return ((BusinessObject)businessObject).getProperty(property);
    }

    @Override
    public void modify(Object tableItem, String property, Object value) {
        if (tableItem == null) {
            return;
        }
        BusinessObject businessObject = (BusinessObject)((Item)tableItem).getData();
        if (businessObject == null) {
            return;
        }
        businessObject.setProperty(property, value);
        if (!this.modifiedObjects.contains(businessObject)) {
            this.modifiedObjects.add(businessObject);
        }
        if (this.vwrStructured != null) {
            this.vwrStructured.update(businessObject, new String[]{property});
            this.vwrStructured.refresh();
        }
    }
}

