/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.viewer;

import eelk.koguja.model.BusinessObject;
import eelk.koguja.viewer.AbstractSorter;
import eelk.koguja.viewer.DomLabelProvider;
import eelk.koguja.viewer.DomListContentProvider;
import eelk.koguja.viewer.LabelSorter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;

public abstract class DomAbstractStrucuredViewer<D extends BusinessObject> {
    protected final DomListContentProvider<D> contentProvider = new DomListContentProvider();
    protected final IBaseLabelProvider labelProvider;
    protected final AbstractSorter sorter;
    private List<D> source;

    public DomAbstractStrucuredViewer() {
        this(new DomLabelProvider());
    }

    public DomAbstractStrucuredViewer(IBaseLabelProvider labelProvider) {
        this(labelProvider, new LabelSorter(labelProvider));
    }

    public DomAbstractStrucuredViewer(IBaseLabelProvider labelProvider, AbstractSorter sorter) {
        this.labelProvider = labelProvider;
        this.sorter = sorter;
    }

    public List<D> getSource() {
        return this.source;
    }

    public void setSource(List<D> source) {
        this.contentProvider.setSource(source);
        this.getViewer().refresh();
        this.source = source;
    }

    public void sort(int column) {
        this.sorter.setColumn(column);
        this.getViewer().setSorter(null);
        this.getViewer().setSorter(this.sorter);
    }

    public int getSelectedObjectID() {
        D selObject = this.getSelectedObject();
        if (selObject == null) {
            return -1;
        }
        return ((BusinessObject)selObject).getId();
    }

    public D getSelectedObject() {
        List<D> lst = this.getSelectedObjects();
        if (lst.isEmpty()) {
            return null;
        }
        return (D)((BusinessObject)lst.get(0));
    }

    public void setSelectedObject(Integer objectId) {
        BusinessObject bo = null;
        StructuredSelection selection = null;
        if (objectId != null) {
            List<D> list = this.contentProvider.getSource();
            bo = BusinessObject.find(list, objectId);
        }
        selection = bo == null ? StructuredSelection.EMPTY : new StructuredSelection(bo);
        this.getViewer().setSelection(selection);
    }

    public List<D> getSelectedObjects() {
        IStructuredSelection s = (IStructuredSelection)this.getViewer().getSelection();
        List list = s.toList();
        ArrayList<BusinessObject> result = new ArrayList<BusinessObject>();
        for (Object o : list) {
            result.add((BusinessObject)o);
        }
        return result;
    }

    public abstract StructuredViewer getViewer();
}

