/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.model.DomEventState;
import eelk.koguja.search.WeddingResult;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.VMain;
import eelk.koguja.view.VResult;
import eelk.koguja.viewer.AbstractSorter;
import java.util.Date;
import org.eclipse.swt.widgets.Composite;

public class VWeddingResult
extends VResult {
    public VWeddingResult(Composite parent) {
        this(parent, 0);
    }

    public VWeddingResult(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected String[] getColumns() {
        return new String[]{Resources.getString("VEventResult.colDocNr"), Resources.getString("VEventResult.colState"), Resources.getString("VEventResult.colEventDateTime"), Resources.getString("VWeddingResult.colBrideName"), Resources.getString("VWeddingResult.colBrideFirstName"), Resources.getString("VWeddingResult.colGroomName"), Resources.getString("VWeddingResult.colGroomFirstName")};
    }

    @Override
    public String getColumnLabel(Object o, int column) {
        String res = "";
        if (o == null) {
            return res;
        }
        WeddingResult result = (WeddingResult)o;
        switch (column) {
            case 0: {
                res = result.docNr;
                break;
            }
            case 1: {
                res = DomEventState.nameOf(3, result.state);
                break;
            }
            case 2: {
                String date = Util.dateToStr(result.date);
                String timeStart = Util.timeToStr(result.start);
                String timeEnd = Util.timeToStr(result.end);
                if (Util.c(date) == null) {
                    res = "";
                    break;
                }
                if (Util.c(timeStart) == null && Util.c(timeEnd) == null) {
                    res = date;
                    break;
                }
                res = date + " " + timeStart + " - " + timeEnd;
                break;
            }
            case 3: {
                res = result.brideLastName;
                break;
            }
            case 4: {
                res = result.brideFirstName;
                break;
            }
            case 5: {
                res = result.groomLastName;
                break;
            }
            case 6: {
                res = result.groomFirstName;
            }
        }
        return res;
    }

    @Override
    protected AbstractSorter getSorter() {
        return new AbstractSorter(){

            @Override
            public Comparable getSortValue(Object o, int column) {
                if (o == null) {
                    return null;
                }
                WeddingResult weddingResult = (WeddingResult)o;
                switch (column) {
                    case 0: {
                        return weddingResult.docNr;
                    }
                    case 1: {
                        return DomEventState.nameOf(3, weddingResult.state);
                    }
                    case 2: {
                        Date date = null;
                        if (weddingResult.date != null) {
                            date = weddingResult.start != null ? new Date(weddingResult.date.getTime() + weddingResult.start.getTime()) : (weddingResult.end != null ? new Date(weddingResult.date.getTime() + weddingResult.end.getTime()) : new Date(weddingResult.date.getTime()));
                        } else if (weddingResult.start != null) {
                            date = new Date(weddingResult.start.getTime());
                        } else if (weddingResult.end != null) {
                            date = new Date(weddingResult.end.getTime());
                        }
                        return date;
                    }
                    case 3: {
                        return weddingResult.brideLastName;
                    }
                    case 4: {
                        return weddingResult.brideFirstName;
                    }
                    case 5: {
                        return weddingResult.groomLastName;
                    }
                    case 6: {
                        return weddingResult.groomFirstName;
                    }
                }
                return null;
            }
        };
    }

    @Override
    public VMain.SearchMode getMode() {
        return VMain.SearchMode.WEDDING;
    }
}

