/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.dao.MWedding;
import eelk.koguja.gui.DiffText;
import eelk.koguja.model.DomWedding;
import eelk.koguja.model.DomWeddingHistory;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.VEventPreview;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VWeddingPreview
extends VEventPreview<DomWedding, DomWeddingHistory> {
    private String brideCongregation;
    private String groomCongregation;
    private Text txtBrideSurename;
    private Text txtBrideGivenName;
    private Text txtBrideDateOfBirth;
    private Text txtBrideCongregation;
    private Text txtGroomSurename;
    private Text txtGroomGivenName;
    private Text txtGroomDateOfBirth;
    private Text txtGroomCongregation;
    private DiffText diffBrideLastName;
    private DiffText diffBrideFirstName;
    private DiffText diffBrideDateOfBirth;
    private DiffText diffGroomLastName;
    private DiffText diffGroomFirstName;
    private DiffText diffGroomDateOfBirth;

    public VWeddingPreview(Composite parent) {
        super(parent, 0);
    }

    public VWeddingPreview(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected Composite getSpecificPane(Composite parent, int style) {
        Composite specificPane = new Composite(parent, style);
        FillLayout ltFill = new FillLayout(256);
        ltFill.spacing = 5;
        specificPane.setLayout((Layout)ltFill);
        Group grpBride = new Group(specificPane, 0);
        grpBride.setText(Resources.getString("VWeddingPreview.grpBride"));
        grpBride.setLayout((Layout)new GridLayout(2, false));
        Group grpGroom = new Group(specificPane, 0);
        grpGroom.setText(Resources.getString("VWeddingPreview.grpGroom"));
        grpGroom.setLayout((Layout)new GridLayout(2, false));
        Label lblBrideSurename = new Label((Composite)grpBride, 0);
        lblBrideSurename.setText(Resources.getString("VWeddingPreview.lblSurename"));
        lblBrideSurename.setLayoutData((Object)new GridData(128));
        this.txtBrideSurename = new Text((Composite)grpBride, 2052);
        this.txtBrideSurename.setLayoutData((Object)new GridData(768));
        this.txtBrideSurename.setEditable(false);
        Label lblBrideGivenName = new Label((Composite)grpBride, 0);
        lblBrideGivenName.setText(Resources.getString("VWeddingPreview.lblGivenName"));
        lblBrideGivenName.setLayoutData((Object)new GridData(128));
        this.txtBrideGivenName = new Text((Composite)grpBride, 2052);
        this.txtBrideGivenName.setLayoutData((Object)new GridData(768));
        this.txtBrideGivenName.setEditable(false);
        Label lblBrideDateOfBirth = new Label((Composite)grpBride, 0);
        lblBrideDateOfBirth.setText(Resources.getString("VWeddingPreview.lblDateOfBirth"));
        lblBrideDateOfBirth.setLayoutData((Object)new GridData(128));
        this.txtBrideDateOfBirth = new Text((Composite)grpBride, 2052);
        this.txtBrideDateOfBirth.setLayoutData((Object)new GridData(768));
        this.txtBrideDateOfBirth.setEditable(false);
        Label lblBrideCongregation = new Label((Composite)grpBride, 0);
        lblBrideCongregation.setText(Resources.getString("VWeddingPreview.lblCongregation"));
        lblBrideCongregation.setLayoutData((Object)new GridData(128));
        this.txtBrideCongregation = new Text((Composite)grpBride, 2052);
        this.txtBrideCongregation.setLayoutData((Object)new GridData(768));
        this.txtBrideCongregation.setEditable(false);
        Label lblGroomSurename = new Label((Composite)grpGroom, 0);
        lblGroomSurename.setText(Resources.getString("VWeddingPreview.lblSurename"));
        lblGroomSurename.setLayoutData((Object)new GridData(128));
        this.txtGroomSurename = new Text((Composite)grpGroom, 2052);
        this.txtGroomSurename.setLayoutData((Object)new GridData(768));
        this.txtGroomSurename.setEditable(false);
        Label lblGroomGivenName = new Label((Composite)grpGroom, 0);
        lblGroomGivenName.setText(Resources.getString("VWeddingPreview.lblGivenName"));
        lblGroomGivenName.setLayoutData((Object)new GridData(128));
        this.txtGroomGivenName = new Text((Composite)grpGroom, 2052);
        this.txtGroomGivenName.setLayoutData((Object)new GridData(768));
        this.txtGroomGivenName.setEditable(false);
        Label lblGroomDateOfBirth = new Label((Composite)grpGroom, 0);
        lblGroomDateOfBirth.setText(Resources.getString("VWeddingPreview.lblDateOfBirth"));
        lblGroomDateOfBirth.setLayoutData((Object)new GridData(128));
        this.txtGroomDateOfBirth = new Text((Composite)grpGroom, 2052);
        this.txtGroomDateOfBirth.setLayoutData((Object)new GridData(768));
        this.txtGroomDateOfBirth.setEditable(false);
        Label lblGroomCongregation = new Label((Composite)grpGroom, 0);
        lblGroomCongregation.setText(Resources.getString("VWeddingPreview.lblCongregation"));
        lblGroomCongregation.setLayoutData((Object)new GridData(128));
        this.txtGroomCongregation = new Text((Composite)grpGroom, 2052);
        this.txtGroomCongregation.setLayoutData((Object)new GridData(768));
        this.txtGroomCongregation.setEditable(false);
        return specificPane;
    }

    @Override
    protected void initControls() {
        super.initControls();
        this.diffBrideLastName = new DiffText(this.txtBrideSurename);
        this.diffBrideFirstName = new DiffText(this.txtBrideGivenName);
        this.diffBrideDateOfBirth = new DiffText(this.txtBrideDateOfBirth);
        this.diffGroomLastName = new DiffText(this.txtGroomSurename);
        this.diffGroomFirstName = new DiffText(this.txtGroomGivenName);
        this.diffGroomDateOfBirth = new DiffText(this.txtGroomDateOfBirth);
    }

    @Override
    protected void setSelectedObject(Integer objectId) throws SQLException, ObjectNotFound {
        this.selectedObject = MWedding.instance().get(objectId);
    }

    @Override
    protected List<DomWeddingHistory> getHistoryList() throws SQLException, ObjectNotFound {
        List<DomWeddingHistory> list = MWedding.instance().getWeddingHistory(this.getObjectID());
        list.add(0, new DomWeddingHistory((DomWedding)this.selectedObject));
        return list;
    }

    @Override
    public void loadHistory() {
        if (this.historyID == null) {
            return;
        }
        super.loadHistory();
        String newBLastName = Util.d(((DomWeddingHistory)this.historicalObject).getBrideLastName());
        String newBFirstName = Util.d(((DomWeddingHistory)this.historicalObject).getBrideFirstName());
        String newBDateOfBirth = Util.dateToStr(((DomWeddingHistory)this.historicalObject).getBrideBirthdate());
        String newGLastName = Util.d(((DomWeddingHistory)this.historicalObject).getGroomLastName());
        String newGFirstName = Util.d(((DomWeddingHistory)this.historicalObject).getGroomFirstName());
        String newGDateOfBirth = Util.dateToStr(((DomWeddingHistory)this.historicalObject).getGroomBirthdate());
        this.txtBrideSurename.setText(newBLastName);
        this.txtBrideGivenName.setText(newBFirstName);
        this.txtBrideDateOfBirth.setText(newBDateOfBirth);
        this.txtGroomSurename.setText(newGLastName);
        this.txtGroomGivenName.setText(newGFirstName);
        this.txtGroomDateOfBirth.setText(newGDateOfBirth);
    }

    @Override
    public void refresh() {
        super.refresh();
        DomWedding wedding = (DomWedding)this.selectedObject;
        String brideLastName = Util.d(wedding.getBrideLastName());
        String groomLastName = Util.d(wedding.getGroomLastName());
        this.setTitle(brideLastName + " - " + groomLastName);
        this.txtBrideSurename.setText(Util.d(wedding.getBrideLastName()));
        this.txtBrideGivenName.setText(Util.d(wedding.getBrideFirstName()));
        this.txtBrideCongregation.setText(Util.d(this.brideCongregation));
        this.txtBrideDateOfBirth.setText(Util.dateToStr(wedding.getBrideBirthdate()));
        this.txtGroomSurename.setText(Util.d(wedding.getGroomLastName()));
        this.txtGroomGivenName.setText(Util.d(wedding.getGroomFirstName()));
        this.txtGroomCongregation.setText(Util.d(this.groomCongregation));
        this.txtGroomDateOfBirth.setText(Util.dateToStr(wedding.getGroomBirthdate()));
        this.diffBrideLastName.setBaseText(wedding.getBrideLastName());
        this.diffBrideFirstName.setBaseText(wedding.getBrideFirstName());
        this.diffBrideDateOfBirth.setBaseText(Util.dateToStr(wedding.getBrideBirthdate()));
        this.diffGroomLastName.setBaseText(wedding.getGroomLastName());
        this.diffGroomFirstName.setBaseText(wedding.getGroomFirstName());
        this.diffGroomDateOfBirth.setBaseText(Util.dateToStr(wedding.getGroomBirthdate()));
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        super.load(p);
        if (this.selectedObject == null) {
            return;
        }
        Integer brideCongId = null;
        Integer groomCongId = null;
        if (((DomWedding)this.selectedObject).getBrideId() != null) {
            brideCongId = MPersonSwt.instance().getCongregation(((DomWedding)this.selectedObject).getBrideId());
        }
        if (((DomWedding)this.selectedObject).getGroomId() != null) {
            groomCongId = MPersonSwt.instance().getCongregation(((DomWedding)this.selectedObject).getGroomId());
        }
        this.brideCongregation = brideCongId == null ? "" : MCongregation.instance().get(brideCongId).getName();
        this.groomCongregation = groomCongId == null ? "" : MCongregation.instance().get(groomCongId).getName();
    }

    @Override
    protected int getEventType() {
        return 3;
    }
}

