/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.dao.MWedding;
import eelk.koguja.gui.DatePickerCombo;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomParticipant;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.DomWedding;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.ISave;
import eelk.koguja.view.VEdit;
import eelk.koguja.view.VEventCommon;
import eelk.koguja.view.VPersonData;
import eelk.koguja.viewer.DomComboViewer;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VWeddingEdit
extends VEdit
implements SelectionListener {
    private DomWedding wedding;
    private Integer tmp_brideMaritalStatus;
    private Integer tmp_groomMaritalStatus;
    private boolean askCommentOnSave = true;
    private List<DomCongregation> congregations;
    private DomComboViewer<DomCongregation> vwrNewCong;
    private VEventCommon vwEventCommon;
    private Composite cmpWedding;
    private VPersonData vwGroom;
    private VPersonData vwBride;
    private Button chkRegistered;
    private DatePickerCombo dpcRegDate;
    private Text txtRegPlace;
    private Text txtCertNo;
    private Button chkConvetionVer;

    public VWeddingEdit(Composite parent) {
        this(parent, 0);
    }

    public VWeddingEdit(Composite parent, int style) {
        super(parent, style);
    }

    public DomWedding getWedding() {
        return this.wedding;
    }

    public void setGroomId(Integer id) {
        this.vwGroom.setObjectID(id);
    }

    public void setBrideId(Integer id) {
        this.vwBride.setObjectID(id);
    }

    public boolean askCommentOnSave() {
        return this.askCommentOnSave;
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        p.beginTask(Resources.getMsgString("Load.Loading"), 9);
        this.setMode(this.getObjectID() == null ? ISave.SaveMode.SaveAdd : ISave.SaveMode.SaveUpdate);
        if (this.getObjectID() != null) {
            this.setMode(ISave.SaveMode.SaveUpdate);
            this.vwEventCommon.setMode(ISave.SaveMode.SaveUpdate);
            this.wedding = MWedding.instance().get(this.getObjectID());
            DomPerson groom = null;
            DomPerson bride = null;
            if (this.wedding.getGroomId() != null) {
                groom = MPersonSwt.instance().getFromAll(this.wedding.getGroomId());
            }
            if (this.wedding.getBrideId() != null) {
                bride = MPersonSwt.instance().getFromAll(this.wedding.getBrideId());
            }
            this.tmp_brideMaritalStatus = this.wedding.getBrideMaritalStatus();
            this.tmp_groomMaritalStatus = this.wedding.getGroomMaritalStatus();
            this.vwEventCommon.setEvent(this.getWedding());
            this.vwBride.setPerson(bride);
            this.vwGroom.setPerson(groom);
            this.vwEventCommon.setParticipants(MWedding.instance().getParticipants(this.getObjectID()));
        } else {
            this.setMode(ISave.SaveMode.SaveAdd);
            this.vwEventCommon.setMode(ISave.SaveMode.SaveAdd);
            this.vwEventCommon.setParticipants(new ArrayList<DomParticipant>());
            this.wedding = new DomWedding();
            this.wedding.setDocNr(MWedding.getNextDocNr(Session.congregation().getId()));
            this.vwEventCommon.setEvent(this.wedding);
        }
        p.worked(1);
        this.vwEventCommon.load(p);
        this.vwGroom.load(p);
        p.worked(1);
        this.vwBride.load(p);
        p.worked(1);
        this.congregations = MCongregation.listCongregations();
        p.worked(1);
        this.askCommentOnSave = false;
        p.done();
    }

    @Override
    public void refresh() {
        this.vwEventCommon.refresh();
        this.vwBride.refresh();
        this.vwGroom.refresh();
        this.vwrNewCong.setSource(this.congregations);
        if (this.getWedding() == null) {
            return;
        }
        if (this.getWedding().getNewCongregationId() != null) {
            this.vwrNewCong.setSelectedObject(this.getWedding().getNewCongregationId());
        }
        if (this.getWedding().isMarriageRegistered() != null) {
            this.chkRegistered.setSelection(Util.d(this.getWedding().isMarriageRegistered()));
        }
        if (this.getWedding().getMarriageRegDate() != null) {
            this.dpcRegDate.setDate(this.getWedding().getMarriageRegDate());
        }
        if (this.getWedding().getMarriageRegPlace() != null) {
            this.txtRegPlace.setText(Util.d(this.getWedding().getMarriageRegPlace()));
        }
        if (this.getWedding().getMarriageCertNo() != null) {
            this.txtCertNo.setText(Util.d(this.getWedding().getMarriageCertNo()));
        }
        if (this.getWedding().isMarriageConvetionVerified() != null) {
            this.chkConvetionVer.setSelection(Util.d(this.getWedding().isMarriageConvetionVerified()));
        }
        this.chkConvetionVer.setEnabled(!this.chkRegistered.getSelection());
        if (this.vwBride != null && this.getWedding().getState() != null) {
            this.vwBride.setMaritalStatusEnabled(this.getWedding().getState() != 2);
        }
        if (this.vwGroom != null && this.getWedding().getState() != null) {
            this.vwGroom.setMaritalStatusEnabled(this.getWedding().getState() != 2);
        }
        this.updateMarriageRegistered();
    }

    @Override
    public boolean save(IProgressMonitor p) throws SQLException {
        p.beginTask(Resources.getMsgString("Save.Saving"), 5);
        if (this.getWedding().getState() != 2) {
            MPersonSwt.instance().setMaritalStatus(this.vwGroom.getPerson().getId(), this.getWedding().getState());
            p.worked(1);
            MPersonSwt.instance().setMaritalStatus(this.vwBride.getPerson().getId(), this.getWedding().getState());
            p.worked(1);
        }
        if (this.getMode().equals((Object)ISave.SaveMode.SaveAdd)) {
            this.setObjectID(MWedding.instance().create(this.getWedding()));
            if (this.getWedding().getGroomId() != null) {
                // empty if block
            }
        } else if (this.getMode().equals((Object)ISave.SaveMode.SaveUpdate)) {
            MWedding.instance().modify(this.getWedding());
        }
        p.worked(1);
        MWedding.instance().setParticipants(this.getObjectID(), this.vwEventCommon.getParticipants());
        p.worked(1);
        if (this.getWedding().getState().equals(2) && this.getWedding().getNewCongregationId() != null) {
            int congId = this.getWedding().getNewCongregationId();
            MPersonSwt.instance().setCongregation(this.vwGroom.getObjectID(), congId);
            MPersonSwt.instance().setCongregation(this.vwBride.getObjectID(), congId);
        }
        p.worked(1);
        p.done();
        if (this.getObjectID() >= 0) {
            this.setMode(ISave.SaveMode.SaveUpdate);
        }
        return this.getObjectID() >= 0;
    }

    @Override
    public boolean collect() {
        if (this.getWedding() == null) {
            this.wedding = new DomWedding();
            this.vwEventCommon.setEvent(this.getWedding());
        }
        if (!this.vwEventCommon.collect()) {
            return false;
        }
        if (!this.collectGroomData()) {
            return false;
        }
        if (!this.collectBrideData()) {
            return false;
        }
        if (!this.collectWeddingData()) {
            return false;
        }
        this.askCommentOnSave |= this.vwEventCommon.askCommentOnSave();
        if (this.getMode() == ISave.SaveMode.SaveAdd) {
            this.askCommentOnSave = false;
        }
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.chkRegistered == e.getSource()) {
            this.updateMarriageRegistered();
        } else if (e.getSource() instanceof Button) {
            // empty if block
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private boolean collectBrideData() {
        if (!this.vwBride.collect()) {
            return false;
        }
        boolean isBrideMissing = false;
        if (this.vwBride.getObjectID() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VWeddingEdit.Bride", new Object[0]);
            this.vwBride.setFocus();
            isBrideMissing = true;
        }
        if (!isBrideMissing && this.vwBride.getPerson().getSex() != null && this.vwBride.getPerson().getSex() != 1 && !GuiUtil.confirmationDialog(this.getShell(), "Msg.Wedding.BrideSex")) {
            this.vwBride.setFocus();
            return false;
        }
        this.askCommentOnSave |= Util.compare(this.wedding.getBrideId(), this.vwBride.getObjectID()) != 0;
        if (!isBrideMissing) {
            this.getWedding().setBrideId(this.vwBride.getObjectID());
            DomPerson person = this.vwBride.getPerson();
            this.wedding.setBrideFirstName(person.getFirstName());
            this.wedding.setBrideLastName(person.getLastName());
            this.wedding.setBrideCode(person.getCode());
            this.wedding.setBrideBirthdate(person.getBirthDate());
            if (this.wedding.getState() != 2 || this.getMode() == ISave.SaveMode.SaveAdd) {
                this.wedding.setBrideMaritalStatus(person.getMaritalStatus());
            } else {
                this.wedding.setBrideMaritalStatus(this.tmp_brideMaritalStatus);
            }
        }
        return true;
    }

    private boolean collectGroomData() {
        if (!this.vwGroom.collect()) {
            return false;
        }
        boolean isGroomMissing = false;
        if (this.vwGroom.getObjectID() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VWeddingEdit.Groom", new Object[0]);
            this.vwGroom.setFocus();
            isGroomMissing = true;
        }
        if (!isGroomMissing && this.vwGroom.getPerson().getSex() != null && this.vwGroom.getPerson().getSex() != 0 && !GuiUtil.confirmationDialog(this.getShell(), "Msg.Wedding.GroomSex")) {
            this.vwGroom.setFocus();
            return false;
        }
        this.askCommentOnSave |= Util.compare(this.wedding.getGroomId(), this.vwGroom.getObjectID()) != 0;
        if (!isGroomMissing) {
            this.getWedding().setGroomId(this.vwGroom.getObjectID());
            DomPerson person = this.vwGroom.getPerson();
            this.wedding.setGroomFirstName(person.getFirstName());
            this.wedding.setGroomLastName(person.getLastName());
            this.wedding.setGroomCode(person.getCode());
            this.wedding.setGroomBirthdate(person.getBirthDate());
            if (this.wedding.getState() != 2 || this.getMode() == ISave.SaveMode.SaveAdd) {
                this.wedding.setGroomMaritalStatus(person.getMaritalStatus());
            } else {
                this.wedding.setBrideMaritalStatus(this.tmp_groomMaritalStatus);
            }
        }
        return true;
    }

    private boolean collectWeddingData() {
        Integer id = this.vwrNewCong.getSelectedObject() == null ? null : Integer.valueOf(this.vwrNewCong.getSelectedObjectID());
        this.askCommentOnSave |= Util.compare(this.getWedding().getNewCongregationId(), id) != 0;
        this.getWedding().setNewCongregationId(id);
        this.getWedding().setMarriageRegistered(this.chkRegistered.getSelection());
        Date date = this.dpcRegDate.getSqlDate();
        this.askCommentOnSave |= Util.compare(this.getWedding().getMarriageRegDate(), date) != 0;
        this.getWedding().setMarriageRegDate(date);
        if (this.getWedding().isMarriageRegistered().booleanValue() && this.getWedding().getMarriageRegDate() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VWeddingEdit.RegDate", new Object[0]);
            this.dpcRegDate.setFocus();
            return false;
        }
        String s = Util.c(this.txtRegPlace.getText());
        this.askCommentOnSave |= Util.compare(this.getWedding().getMarriageRegPlace(), s) != 0;
        this.getWedding().setMarriageRegPlace(s);
        if (this.getWedding().isMarriageRegistered().booleanValue() && this.getWedding().getMarriageRegPlace() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VWeddingEdit.RegPlace", new Object[0]);
            this.txtRegPlace.setFocus();
            return false;
        }
        s = Util.c(this.txtCertNo.getText());
        this.askCommentOnSave |= Util.compare(this.getWedding().getMarriageCertNo(), s) != 0;
        this.getWedding().setMarriageCertNo(Util.c(this.txtCertNo.getText()));
        if (this.getWedding().isMarriageRegistered().booleanValue() && this.getWedding().getMarriageCertNo() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VWeddingEdit.CertNo", new Object[0]);
            this.txtCertNo.setFocus();
            return false;
        }
        this.askCommentOnSave |= Util.compare(this.getWedding().isMarriageConvetionVerified(), this.chkConvetionVer.getSelection()) != 0;
        this.getWedding().setMarriageConvetionVerified(this.chkConvetionVer.getSelection());
        return true;
    }

    private void updateMarriageRegistered() {
        this.chkConvetionVer.setEnabled(!this.chkRegistered.getSelection());
        this.dpcRegDate.setEnabled(this.chkRegistered.getSelection());
        this.txtRegPlace.setEnabled(this.chkRegistered.getSelection());
        this.txtCertNo.setEnabled(this.chkRegistered.getSelection());
        if (!this.chkRegistered.getSelection()) {
            this.dpcRegDate.setDate(null);
            this.txtRegPlace.setText("");
            this.txtCertNo.setText("");
        }
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(2, true));
        this.cmpWedding = new Composite((Composite)this, 0);
        this.cmpWedding.setLayoutData((Object)new GridData(1808));
        this.cmpWedding.setLayout((Layout)new GridLayout(1, true));
        this.initGroomControls();
        this.initBrideControls();
        this.initMarriageControls();
        this.vwEventCommon = new VEventCommon(this);
        this.vwEventCommon.setLayoutData(new GridData(1808));
        this.vwEventCommon.setEventType(3);
        this.vwEventCommon.addStateSelectionListener(this);
    }

    private void initGroomControls() {
        Group grpGroom = new Group(this.cmpWedding, 0);
        grpGroom.setText(Resources.getString("VWeddingEdit.grpGroom"));
        grpGroom.setLayoutData((Object)new GridData(768));
        grpGroom.setLayout((Layout)new FillLayout());
        GuiUtil.displayAsMandatory((Control)grpGroom);
        this.vwGroom = new VPersonData((Composite)grpGroom, 0);
    }

    private void initBrideControls() {
        Group grpBride = new Group(this.cmpWedding, 0);
        grpBride.setText(Resources.getString("VWeddingEdit.grpBride"));
        grpBride.setLayoutData((Object)new GridData(768));
        grpBride.setLayout((Layout)new FillLayout());
        GuiUtil.displayAsMandatory((Control)grpBride);
        this.vwBride = new VPersonData((Composite)grpBride, 0);
    }

    private void initMarriageControls() {
        Group grpMarriage = new Group(this.cmpWedding, 0);
        grpMarriage.setText(Resources.getString("VWeddingEdit.grpMarriage"));
        grpMarriage.setLayoutData((Object)new GridData(1808));
        grpMarriage.setLayout((Layout)new GridLayout(2, false));
        Label lblNewCong = new Label((Composite)grpMarriage, 0);
        lblNewCong.setText(Resources.getString("VWeddingEdit.lblNewCong"));
        lblNewCong.setLayoutData((Object)new GridData(128));
        Combo cmbNewCong = new Combo((Composite)grpMarriage, 2056);
        cmbNewCong.setLayoutData((Object)new GridData(768));
        this.vwrNewCong = new DomComboViewer(cmbNewCong);
        new Label((Composite)grpMarriage, 0);
        this.chkRegistered = new Button((Composite)grpMarriage, 32);
        this.chkRegistered.setText(Resources.getString("VWeddingEdit.chkRegistered"));
        this.chkRegistered.setLayoutData((Object)new GridData(768));
        this.chkRegistered.addSelectionListener((SelectionListener)this);
        GuiUtil.displayAsMandatory((Control)this.chkRegistered);
        Label lblRegDate = new Label((Composite)grpMarriage, 0);
        lblRegDate.setText(Resources.getString("VWeddingEdit.lblRegDate"));
        lblRegDate.setLayoutData((Object)new GridData(128));
        this.dpcRegDate = new DatePickerCombo((Composite)grpMarriage, 2048);
        this.dpcRegDate.setLayoutData(new GridData(768));
        Label lblRegPlace = new Label((Composite)grpMarriage, 0);
        lblRegPlace.setText(Resources.getString("VWeddingEdit.lblRegPlace"));
        lblRegPlace.setLayoutData((Object)new GridData(128));
        this.txtRegPlace = new Text((Composite)grpMarriage, 2048);
        this.txtRegPlace.setLayoutData((Object)new GridData(768));
        this.txtRegPlace.setTextLimit(240);
        Label lblCertNo = new Label((Composite)grpMarriage, 0);
        lblCertNo.setText(Resources.getString("VWeddingEdit.lblCertNo"));
        lblCertNo.setLayoutData((Object)new GridData(128));
        this.txtCertNo = new Text((Composite)grpMarriage, 2048);
        this.txtCertNo.setLayoutData((Object)new GridData(768));
        this.txtCertNo.setTextLimit(240);
        new Label((Composite)grpMarriage, 0);
        this.chkConvetionVer = new Button((Composite)grpMarriage, 32);
        this.chkConvetionVer.setText(Resources.getString("VWeddingEdit.chkConvetionVer"));
        this.chkConvetionVer.setLayoutData((Object)new GridData(768));
        GuiUtil.displayAsMandatory((Control)this.chkConvetionVer);
    }
}

