/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.dao.MUserSwt;
import eelk.koguja.gui.TableEx;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomUser;
import eelk.koguja.model.DomUserCongregation;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.DbUtil;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.IDbUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.util.Util;
import eelk.koguja.view.VAddModDel;
import eelk.koguja.view.VPersonData;
import eelk.koguja.view.View;
import eelk.koguja.viewer.DomComboViewer;
import eelk.koguja.viewer.DomLabelProvider;
import eelk.koguja.viewer.DomTableViewer;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class VUsers
extends View
implements ISelectionChangedListener,
SelectionListener {
    private static final Logger logger = Logger.getLogger(VUsers.class);
    protected DomLabelProvider labelProvider;
    private boolean userCreationFailed = false;
    private DomTableViewer<DomUser> vwrUsers;
    private List<DomUser> users;
    private DomComboViewer<DomCongregation> vwrOwnerCongregations;
    private List<DomCongregation> ownerCongregations;
    private List<DomUserCongregation> congregationAccesses;
    private List<DomUserCongregation> ModifiedCongregationAccesses;
    private DomTableViewer<DomUserCongregation> vwrCongAccess;
    private Text txtUsername;
    private Button btnNormalUser;
    private Button btnSuperUser;
    private Combo cmbOwner;
    private Text txtPassword;
    private Text txtPasswordRepeat;
    private VPersonData vwRelatedPerson;
    private VAddModDel cmpButtons;

    public VUsers(Composite parent) {
        super(parent);
    }

    public VUsers(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initControls() {
        TableEx tblUsers = new TableEx(this, 67584);
        tblUsers.setHeaderVisible(true);
        tblUsers.setLinesVisible(true);
        TableColumn colUsername = new TableColumn(tblUsers.getTable(), 0x1000000);
        colUsername.setText(Resources.getString("VUsers.colUsername"));
        colUsername.pack();
        this.vwrUsers = new DomTableViewer(tblUsers.getTable());
        this.vwrUsers.getViewer().addSelectionChangedListener(this);
        Group grpUser = new Group((Composite)this, 0);
        grpUser.setText(Resources.getString("VUsers.grpUser"));
        grpUser.setLayout((Layout)new GridLayout(2, false));
        Label lblUsername = new Label((Composite)grpUser, 0);
        lblUsername.setText(Resources.getString("VUsers.lblUsername"));
        lblUsername.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblUsername);
        this.txtUsername = new Text((Composite)grpUser, 2048);
        this.txtUsername.setLayoutData((Object)new GridData(768));
        Label lblLevel = new Label((Composite)grpUser, 0);
        lblLevel.setText(Resources.getString("VUsers.lblLevel"));
        lblLevel.setLayoutData((Object)new GridData(132));
        GuiUtil.displayAsMandatory((Control)lblLevel);
        Group grpLevel = new Group((Composite)grpUser, 0);
        grpLevel.setLayout((Layout)new FillLayout(512));
        grpLevel.setLayoutData((Object)new GridData(1808));
        this.btnNormalUser = new Button((Composite)grpLevel, 16);
        this.btnNormalUser.setText(Resources.getString("VUsers.btnNormalUser"));
        this.btnSuperUser = new Button((Composite)grpLevel, 16);
        this.btnSuperUser.setText(Resources.getString("VUsers.btnSuperUser"));
        Label lblOwner = new Label((Composite)grpUser, 0);
        lblOwner.setText(Resources.getString("VUsers.lblOwner"));
        lblOwner.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblOwner);
        this.cmbOwner = new Combo((Composite)grpUser, 2056);
        this.cmbOwner.setLayoutData((Object)new GridData(768));
        this.vwrOwnerCongregations = new DomComboViewer(this.cmbOwner);
        Label lblPassword = new Label((Composite)grpUser, 0);
        lblPassword.setText(Resources.getString("VUsers.lblPassword"));
        lblPassword.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblPassword);
        this.txtPassword = new Text((Composite)grpUser, 0x400800);
        this.txtPassword.setLayoutData((Object)new GridData(0x400300));
        Label lblPasswordRepeat = new Label((Composite)grpUser, 0);
        lblPasswordRepeat.setText(Resources.getString("VUsers.lblPasswordRepeat"));
        lblPasswordRepeat.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblPasswordRepeat);
        this.txtPasswordRepeat = new Text((Composite)grpUser, 0x400800);
        this.txtPasswordRepeat.setLayoutData((Object)new GridData(768));
        Group grpRelatedPerson = new Group((Composite)this, 0);
        grpRelatedPerson.setText(Resources.getString("VUsers.grpRelatedPerson"));
        grpRelatedPerson.setLayoutData((Object)new GridData(768));
        grpRelatedPerson.setLayout((Layout)new FillLayout());
        GuiUtil.displayAsMandatory((Control)grpRelatedPerson);
        this.vwRelatedPerson = new VPersonData((Composite)grpRelatedPerson, true, false, true, false, 0);
        Group grpAccess = new Group((Composite)this, 65536);
        grpAccess.setText(Resources.getString("VUsers.grpAccess"));
        grpAccess.setLayout((Layout)new GridLayout(1, false));
        int style = 101124;
        TableEx tblAccess = new TableEx((Composite)grpAccess, style);
        tblAccess.setHeaderVisible(true);
        tblAccess.setLinesVisible(true);
        tblAccess.setLayoutData(new GridData(1808));
        TableColumn colCongregation = new TableColumn(tblAccess.getTable(), 0x1000000);
        colCongregation.setText(Resources.getString("VUsers.colCongregation"));
        colCongregation.pack();
        TableColumn colRead = new TableColumn(tblAccess.getTable(), 0x1000000);
        colRead.setText(Resources.getString("VUsers.colRead"));
        colRead.pack();
        TableColumn colWrite = new TableColumn(tblAccess.getTable(), 0x1000000);
        colWrite.setText(Resources.getString("VUsers.colWrite"));
        colWrite.pack();
        TableColumn colAdmin = new TableColumn(tblAccess.getTable(), 0x1000000);
        colAdmin.setText(Resources.getString("VUsers.colAdmin"));
        colAdmin.pack();
        this.labelProvider = new DomLabelProvider<DomUserCongregation>(){

            @Override
            public String getColumnText(Object o, int column) {
                if (o == null) {
                    return "";
                }
                String res = "";
                DomUserCongregation u = (DomUserCongregation)o;
                switch (column) {
                    case 0: {
                        res = u.getCongregationName();
                        break;
                    }
                    case 1: {
                        res = Util.blnToStr(u.isReadAccess());
                        break;
                    }
                    case 2: {
                        res = Util.blnToStr(u.isWriteAccess());
                        break;
                    }
                    case 3: {
                        res = Util.blnToStr(u.isAdminAccess());
                    }
                }
                return res;
            }
        };
        this.vwrCongAccess = new DomTableViewer(tblAccess.getTable(), this.labelProvider);
        CellEditor[] cellEditors = new CellEditor[]{null, new CheckboxCellEditor((Composite)tblAccess.getTable()), new CheckboxCellEditor((Composite)tblAccess.getTable()), new CheckboxCellEditor((Composite)tblAccess.getTable())};
        String[] colNames = new String[]{"congregation_name", "read_access", "write_access", "admin_access"};
        TableViewer v = (TableViewer)this.vwrCongAccess.getViewer();
        v.setColumnProperties(colNames);
        v.setCellEditors(cellEditors);
        if (this.getLayout() == null) {
            this.setLayout((Layout)new FormLayout());
        }
        FormData formData = null;
        formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.left = new FormAttachment(0, 10);
        formData.right = new FormAttachment(20, 0);
        formData.bottom = new FormAttachment(80, 0);
        tblUsers.setLayoutData(formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.left = new FormAttachment((Control)tblUsers, 10);
        formData.right = new FormAttachment(60, 0);
        formData.bottom = new FormAttachment(0, 210);
        grpUser.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 10);
        formData.left = new FormAttachment((Control)grpUser, 10);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(0, 210);
        grpRelatedPerson.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)grpUser, 10);
        formData.left = new FormAttachment((Control)tblUsers, 10);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(80, 0);
        grpAccess.setLayoutData((Object)formData);
        this.btnNormalUser.setSelection(true);
        if (!DbUtil.isSuperuser(this.getShell(), false)) {
            this.btnNormalUser.setEnabled(false);
            this.btnSuperUser.setEnabled(false);
        }
    }

    public void setButtonsPanel(VAddModDel cmp) {
        this.cmpButtons = cmp;
        this.cmpButtons.setParent(this);
        FormData formData = new FormData();
        formData.right = new FormAttachment(100, -10);
        formData.bottom = new FormAttachment(100, -10);
        this.cmpButtons.setLayoutData(formData);
        this.cmpButtons.getBtnAdd().addSelectionListener((SelectionListener)this);
        this.cmpButtons.getBtnModify().addSelectionListener((SelectionListener)this);
        this.cmpButtons.getBtnDelete().addSelectionListener((SelectionListener)this);
        this.cmpButtons.getBtnClear().addSelectionListener((SelectionListener)this);
        this.checkButtons();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.cmpButtons.getBtnAdd())) {
            this.createUser();
        } else if (e.getSource().equals(this.cmpButtons.getBtnModify())) {
            this.modifyUser((DomUser)this.vwrUsers.getSelectedObject());
        } else if (e.getSource().equals(this.cmpButtons.getBtnDelete())) {
            this.deleteUser((DomUser)this.vwrUsers.getSelectedObject());
        } else if (e.getSource().equals(this.cmpButtons.getBtnClear())) {
            this.clearFields();
        }
    }

    @Override
    public void selectionChanged(SelectionChangedEvent e) {
        if (e.getSelection().isEmpty()) {
            this.setUserAttributes(false);
        } else {
            this.setUserAttributes(true);
        }
    }

    private void clearFields() {
        this.vwrUsers.setSelectedObject(null);
        this.vwrOwnerCongregations.setSelectedObject(null);
        this.vwRelatedPerson.emptyPerson();
    }

    private boolean isPasswordCorrectForCreate() {
        if (Util.c(this.txtPassword.getText()) == null) {
            this.txtPassword.setFocus();
            GuiUtil.informationDialog(this.getShell(), "Err.VUsers.Password", new Object[0]);
            return false;
        }
        if (Util.c(this.txtPasswordRepeat.getText()) == null) {
            this.txtPasswordRepeat.setFocus();
            GuiUtil.informationDialog(this.getShell(), "Err.VUsers.PasswordRepeat", new Object[0]);
            return false;
        }
        if (Util.compare(Util.c(this.txtPassword.getText()), Util.c(this.txtPasswordRepeat.getText())) != 0) {
            this.txtPassword.setText("");
            this.txtPasswordRepeat.setText("");
            this.txtPassword.setFocus();
            GuiUtil.informationDialog(this.getShell(), "Err.VUsers.PasswordError", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean isPasswordCorrectForModify() {
        if (Util.c(this.txtPassword.getText()) == null && Util.c(this.txtPasswordRepeat.getText()) == null) {
            return true;
        }
        return this.isPasswordCorrectForCreate();
    }

    private void checkButtons() {
        if (this.vwrUsers.getSelectedObject() == null) {
            this.cmpButtons.getBtnDelete().setEnabled(false);
            this.cmpButtons.getBtnModify().setEnabled(false);
        } else {
            this.cmpButtons.getBtnDelete().setEnabled(true);
            this.cmpButtons.getBtnModify().setEnabled(true);
        }
    }

    private boolean isFieldsReadyForModify() {
        if (this.vwrOwnerCongregations.getSelectedObject() == null) {
            this.cmbOwner.setCapture(true);
            GuiUtil.informationDialog(this.getShell(), "Err.VUsers.Owner", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean isFieldsReadyForCreate() {
        if (Util.c(this.txtUsername.getText()) == null) {
            this.txtUsername.setFocus();
            GuiUtil.informationDialog(this.getShell(), "Err.VUsers.Username", new Object[0]);
            return false;
        }
        try {
            if (!Util.c(this.txtUsername.getText()).equals(URLEncoder.encode(Util.c(this.txtUsername.getText()), "UTF-8"))) {
                this.txtUsername.setFocus();
                GuiUtil.informationDialog(this.getShell(), "Err.VUsers.Username.Format", new Object[0]);
                return false;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.isFieldsReadyForModify();
    }

    private int createUser() {
        if (!(this.isFieldsReadyForCreate() && this.isPasswordCorrectForCreate() && this.vwRelatedPerson.isPersonOk())) {
            return -1;
        }
        final DomUser domUser = new DomUser();
        domUser.setUsername(Util.d(this.txtUsername.getText()));
        domUser.setPassword(Util.d(this.txtPassword.getText()));
        if (this.btnSuperUser.getSelection()) {
            domUser.setAccessLevel(1);
        } else {
            domUser.setAccessLevel(0);
        }
        domUser.setPersonId(this.vwRelatedPerson.getPerson().getId());
        domUser.setCongregationId(this.vwrOwnerCongregations.getSelectedObjectID());
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("CreatingObject"), -1);
                try {
                    MUserSwt.instance().create(domUser);
                    Session.connection().commit();
                    VUsers.this.load(p);
                    p.done();
                    VUsers.this.userCreationFailed = false;
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Create"), new Object[0]);
                    VUsers.this.userCreationFailed = true;
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        if (!this.users.isEmpty() && !this.userCreationFailed) {
            this.vwrUsers.setSelectedObject(this.users.get(this.users.size() - 1).getId());
        } else if (this.userCreationFailed) {
            this.txtPassword.setText("");
            this.txtPasswordRepeat.setText("");
        }
        this.checkButtons();
        return 0;
    }

    private int modifyUser(DomUser user) {
        if (!(this.isFieldsReadyForModify() && this.isPasswordCorrectForModify() && this.vwRelatedPerson.isPersonOk())) {
            return -1;
        }
        if (!this.txtUsername.getText().equals(user.getUsername())) {
            GuiUtil.informationDialog(this.getShell(), "Msg.Inf.CanNotChangeUsername", new Object[0]);
        }
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmUserMod", user.getUsername())) {
            this.loadUserData(this.getSelectedUser());
            this.setUserAttributes(true);
            return -1;
        }
        this.collect();
        final DomUser domUser = user.clone();
        if (this.btnSuperUser.getSelection()) {
            domUser.setAccessLevel(1);
        } else {
            domUser.setAccessLevel(0);
        }
        domUser.setPersonId(this.vwRelatedPerson.getPerson().getId());
        domUser.setCongregationId(this.vwrOwnerCongregations.getSelectedObjectID());
        domUser.setPassword(Util.c(this.txtPassword.getText()));
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("CreatingObject"), -1);
                try {
                    MUserSwt.instance().modify(domUser);
                    int result = MUserSwt.setUserCong(VUsers.this.ModifiedCongregationAccesses, p);
                    if (result == -1) {
                        throw new SQLException();
                    }
                    Session.connection().commit();
                    VUsers.this.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Modify"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        this.vwrUsers.setSelectedObject(user.getId());
        this.checkButtons();
        return 0;
    }

    private void deleteUser(DomUser user) {
        if (Session.current().getUsername().equals(user.getUsername())) {
            GuiUtil.informationDialog(this.getShell(), "Msg.Inf.CanNotDelYourself", user.getUsername());
            return;
        }
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmUserDel", user.getUsername())) {
            return;
        }
        final int id = user.getId();
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("DeletingObject"), -1);
                try {
                    MUserSwt.instance().delete(id);
                    Session.connection().commit();
                    VUsers.this.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Modify"), new Object[0]);
                }
                catch (ObjectNotFound e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Modify"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        this.checkButtons();
    }

    protected void loadUserData(DomUser selectedUser) {
        if (selectedUser == null) {
            this.congregationAccesses = new ArrayList<DomUserCongregation>();
        } else {
            final int selectedUserId = selectedUser.getId();
            final Integer selectedUserPersonId = selectedUser.getPersonId();
            IRunnableWithProgress r = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor p) {
                    p.beginTask(Resources.getMsgString("LoadingCongregations"), -1);
                    try {
                        VUsers.this.congregationAccesses = MUserSwt.listUserCongregations(selectedUserId);
                        if (selectedUserPersonId != null && MPersonSwt.instance().exists(selectedUserPersonId)) {
                            VUsers.this.vwRelatedPerson.setObjectID(selectedUserPersonId);
                        } else {
                            VUsers.this.vwRelatedPerson.setObjectID(null);
                        }
                        VUsers.this.vwRelatedPerson.load(p);
                    }
                    catch (SQLException e) {
                        p.done();
                        SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                    }
                    catch (ObjectNotFound e) {
                        p.done();
                        SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                    }
                }
            };
            Operation.run(this.getShell(), true, r);
        }
        this.refreshUserData();
        this.vwRelatedPerson.refresh();
    }

    public void load(IProgressMonitor p) throws SQLException {
        this.users = MUserSwt.listMyUsers();
        this.ownerCongregations = MCongregation.listMyCongregations(IDbUtil.Permission.Admin);
    }

    public void refresh() {
        this.vwrUsers.setSource(this.users);
        this.vwrOwnerCongregations.setSource(this.ownerCongregations);
    }

    public void refreshUserData() {
        this.vwrCongAccess.setSource(this.congregationAccesses);
    }

    private void setUserAttributes(boolean fill) {
        if (fill) {
            this.txtUsername.setText(this.getSelectedUser().getUsername());
            this.btnNormalUser.setSelection(this.getSelectedUser().getAccessLevel() == 0);
            this.btnSuperUser.setSelection(this.getSelectedUser().getAccessLevel() == 1);
            this.vwrOwnerCongregations.setSelectedObject(this.getSelectedUser().getCongregationId());
            this.loadUserData(this.getSelectedUser());
        } else {
            this.txtUsername.setText("");
            this.btnNormalUser.setSelection(true);
            this.btnSuperUser.setSelection(false);
            this.congregationAccesses = new ArrayList<DomUserCongregation>();
            this.refreshUserData();
        }
        this.txtPassword.setText("");
        this.txtPasswordRepeat.setText("");
        this.checkButtons();
    }

    private DomUser getSelectedUser() {
        return (DomUser)this.vwrUsers.getSelectedObject();
    }

    public boolean collect() {
        this.ModifiedCongregationAccesses = this.vwrCongAccess.getCellModifier().getModifiedObjects();
        return true;
    }
}

