/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.dao.MUserSwt;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VAbstractSelectPerson;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VSelectOfficiant
extends VAbstractSelectPerson {
    public static final Logger logger = Logger.getLogger(VSelectOfficiant.class);
    private List<DomPerson> officiants;
    private String firstName = null;
    private String lastName = null;
    private boolean searchAll = false;
    private Text txtLastName;
    private Text txtFirstName;
    private Button chkAllPersons;
    private Button btnSearch;
    private Button btnClear;

    public VSelectOfficiant(Composite parent) {
        super(parent);
    }

    public VSelectOfficiant(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        p.beginTask(Resources.getMsgString("Load.Loading"), -1);
        this.officiants = this.searchAll ? MPersonSwt.listPublicPersons(this.firstName, this.lastName, null, null, true) : MUserSwt.congregationUsers(Session.congregation().getId(), this.firstName, this.lastName);
        p.done();
    }

    @Override
    public void refresh() {
        this.setPersons(this.officiants);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
        if (this.btnSearch == e.getSource()) {
            this.search();
        } else if (this.btnClear == e.getSource()) {
            this.clearSearchControls();
        }
    }

    @Override
    protected void initControls() {
        Composite cmpConditions = new Composite((Composite)this, 0);
        cmpConditions.setLayoutData((Object)new GridData(768));
        cmpConditions.setLayout((Layout)new GridLayout(3, false));
        Label lblLastName = new Label(cmpConditions, 0);
        lblLastName.setText(Resources.getString("VSelectOfficiant.lblLastName"));
        lblLastName.setLayoutData((Object)new GridData(128));
        this.txtLastName = new Text(cmpConditions, 2048);
        this.txtLastName.setLayoutData((Object)new GridData(768));
        this.btnSearch = new Button(cmpConditions, 8);
        this.btnSearch.setText(Resources.getGenString("Search"));
        this.btnSearch.setLayoutData((Object)new GridData(256));
        this.btnSearch.addSelectionListener((SelectionListener)this);
        Label lblFirstName = new Label(cmpConditions, 0);
        lblFirstName.setText(Resources.getString("VSelectOfficiant.lblFirstName"));
        lblFirstName.setLayoutData((Object)new GridData(128));
        this.txtFirstName = new Text(cmpConditions, 2048);
        this.txtFirstName.setLayoutData((Object)new GridData(768));
        this.btnClear = new Button(cmpConditions, 8);
        this.btnClear.setText(Resources.getGenString("Clear"));
        this.btnClear.setLayoutData((Object)new GridData(256));
        this.btnClear.addSelectionListener((SelectionListener)this);
        new Label(cmpConditions, 0);
        this.chkAllPersons = new Button(cmpConditions, 32);
        this.chkAllPersons.setText(Resources.getString("VSelectOfficiant.chkAllPersons"));
        this.chkAllPersons.setLayoutData((Object)new GridData(256));
        super.initControls();
    }

    private void search() {
        this.firstName = this.txtFirstName.getText();
        this.lastName = this.txtLastName.getText();
        this.searchAll = this.chkAllPersons.getSelection();
        Operation.run(this.getShell(), true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    VSelectOfficiant.this.load(p);
                    p.done();
                }
                catch (SQLException ex) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Search"), new Object[0]);
                }
                catch (ObjectNotFound ex) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("ObjectNotFound"), new Object[0]);
                }
            }
        });
        this.refresh();
    }

    private void clearSearchControls() {
        this.txtFirstName.setText("");
        this.txtLastName.setText("");
    }
}

