/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.dao.MBaptism;
import eelk.koguja.dao.MConfirmation;
import eelk.koguja.dao.MDonation;
import eelk.koguja.dao.MFuneral;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.dao.MWedding;
import eelk.koguja.dlg.DlgMain;
import eelk.koguja.gui.ArrowButton;
import eelk.koguja.gui.StackLayout;
import eelk.koguja.preference.IPreferenceStore;
import eelk.koguja.preference.Preferences;
import eelk.koguja.search.BaptismExpression;
import eelk.koguja.search.BaptismResult;
import eelk.koguja.search.ConfirmationExpression;
import eelk.koguja.search.ConfirmationResult;
import eelk.koguja.search.DonationExpression;
import eelk.koguja.search.DonationResult;
import eelk.koguja.search.EventExpression;
import eelk.koguja.search.Expression;
import eelk.koguja.search.FuneralExpression;
import eelk.koguja.search.FuneralResult;
import eelk.koguja.search.IndividualEventExpression;
import eelk.koguja.search.PersonExpression;
import eelk.koguja.search.PersonResult;
import eelk.koguja.search.Result;
import eelk.koguja.search.WeddingExpression;
import eelk.koguja.search.WeddingResult;
import eelk.koguja.seq.SeqSearch;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.VAdvancedSearch;
import eelk.koguja.view.VBaptismSearchAdvanced;
import eelk.koguja.view.VBaptismSearchSimple;
import eelk.koguja.view.VConfirmationSearchAdvanced;
import eelk.koguja.view.VConfirmationSearchSimple;
import eelk.koguja.view.VDonationSearchAdvanced;
import eelk.koguja.view.VDonationSearchSimple;
import eelk.koguja.view.VFuneralSearchAdvanced;
import eelk.koguja.view.VFuneralSearchSimple;
import eelk.koguja.view.VMain;
import eelk.koguja.view.VPersonSearchAdvanced;
import eelk.koguja.view.VPersonSearchSimple;
import eelk.koguja.view.VResult;
import eelk.koguja.view.VSearch;
import eelk.koguja.view.VSimpleSearch;
import eelk.koguja.view.VWeddingSearchAdvanced;
import eelk.koguja.view.VWeddingSearchSimple;
import eelk.koguja.view.View;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class VSearchComposite
extends View
implements SelectionListener,
KeyListener {
    private static final Logger logger = Logger.getLogger(VSearchComposite.class);
    public VPersonSearchAdvanced vPersonSearchAdvanced;
    public VPersonSearchSimple vPersonSearchSimple;
    public VBaptismSearchAdvanced vBaptismSearchAdvanced;
    public VBaptismSearchSimple vBaptismSearchSimple;
    public VConfirmationSearchAdvanced vConfirmationSearchAdvanced;
    public VConfirmationSearchSimple vConfirmationSearchSimple;
    public VWeddingSearchAdvanced vWeddingSearchAdvanced;
    public VWeddingSearchSimple vWeddingSearchSimple;
    public VFuneralSearchAdvanced vFuneralSearchAdvanced;
    public VFuneralSearchSimple vFuneralSearchSimple;
    public VDonationSearchAdvanced vDonationSearchAdvanced;
    public VDonationSearchSimple vDonationSearchSimple;
    private boolean isSimple;
    private VMain.SearchMode mode;
    private ScrolledComposite cmpAllScr;
    private Composite cmpAll;
    private Composite cmpModeButtons;
    private Button btnShowSimple;
    private Button btnShowAdv;
    private Composite cmpSearch;
    private Composite cmpSrchButtons;
    private Composite cmpSmplSearchButtons;
    private ArrowButton btnSmplSearch;
    private Button btnClearSmpl;
    private Composite cmpAdvSearchButtons;
    private ArrowButton btnTypicals;
    private ArrowButton btnHistory;
    private ArrowButton btnAdvSearch;
    private Button btnClearAdv;
    private StackLayout laySearch;
    private StackLayout layButtons;
    private List<VSimpleSearch<? extends Expression>> lstSimpleSearch;
    private List<VAdvancedSearch<? extends Expression>> lstAdvancedSearch;

    public VSearchComposite(Composite parent) {
        this(parent, 0);
    }

    public VSearchComposite(Composite parent, int style) {
        super(parent, style);
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public void setSimple(boolean simple) {
        if (simple == this.isSimple()) {
            return;
        }
        this.isSimple = simple;
        this.copySearchData();
        this.refreshButtons();
        this.refreshSearchPane();
        this.refreshHistoryMenu();
        this.refreshStandardMenu();
    }

    public VMain.SearchMode getMode() {
        return this.mode;
    }

    public void setMode(VMain.SearchMode mode) {
        if (this.getMode() != null && this.getMode().getMode() == mode.getMode()) {
            return;
        }
        this.mode = mode;
        this.refreshSearchPane();
        this.refreshHistoryMenu();
        this.refreshStandardMenu();
    }

    public VSearch<? extends Expression> getCurrent() {
        return this.get(this.getMode(), this.isSimple());
    }

    public VSearch<PersonExpression> getPerson() {
        return this.isSimple() ? this.vPersonSearchSimple : this.vPersonSearchAdvanced;
    }

    public VSearch<BaptismExpression> getBaptism() {
        return this.isSimple() ? this.vBaptismSearchSimple : this.vBaptismSearchAdvanced;
    }

    public VSearch<ConfirmationExpression> getConfirmation() {
        return this.isSimple() ? this.vConfirmationSearchSimple : this.vConfirmationSearchAdvanced;
    }

    public VSearch<WeddingExpression> getWedding() {
        return this.isSimple() ? this.vWeddingSearchSimple : this.vWeddingSearchAdvanced;
    }

    public VSearch<FuneralExpression> getFuneral() {
        return this.isSimple() ? this.vFuneralSearchSimple : this.vFuneralSearchAdvanced;
    }

    public VSearch<DonationExpression> getDonation() {
        return this.isSimple() ? this.vDonationSearchSimple : this.vDonationSearchAdvanced;
    }

    public VSearch<? extends Expression> get(VMain.SearchMode m, boolean simple) {
        if (m == null) {
            return null;
        }
        return simple ? (VSearch)this.lstSimpleSearch.get(m.getMode()) : (VSearch)this.lstAdvancedSearch.get(m.getMode());
    }

    private void doSearch(VResult.ResultMode resultMode) {
        SeqSearch<EventExpression, Result> seqSearch = null;
        VResult vResult = DlgMain.instance().getVMain().getResultComposite().getCurrent();
        if (this.getMode() == VMain.SearchMode.PERSON) {
            seqSearch = new SeqSearch<PersonExpression, PersonResult>(this.getPerson(), vResult, MPersonSwt.instance(), resultMode, "Found.Persons");
        } else if (this.getMode() == VMain.SearchMode.BAPTISM) {
            seqSearch = new SeqSearch<BaptismExpression, BaptismResult>(this.getBaptism(), vResult, MBaptism.instance(), resultMode, "Found.Baptisms");
        } else if (this.getMode() == VMain.SearchMode.CONFIRMATION) {
            seqSearch = new SeqSearch<ConfirmationExpression, ConfirmationResult>(this.getConfirmation(), vResult, MConfirmation.instance(), resultMode, "Found.Confirmations");
        } else if (this.getMode() == VMain.SearchMode.WEDDING) {
            seqSearch = new SeqSearch<WeddingExpression, WeddingResult>(this.getWedding(), vResult, MWedding.instance(), resultMode, "Found.Weddings");
        } else if (this.getMode() == VMain.SearchMode.FUNERAL) {
            seqSearch = new SeqSearch<FuneralExpression, FuneralResult>(this.getFuneral(), vResult, MFuneral.instance(), resultMode, "Found.Funerals");
        } else if (this.getMode() == VMain.SearchMode.DONATION) {
            seqSearch = new SeqSearch<DonationExpression, DonationResult>(this.getDonation(), vResult, MDonation.instance(), resultMode, "Found.Donations");
        }
        if (seqSearch != null) {
            Sequence.execSequence(seqSearch);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            if (this.btnShowAdv == e.getSource()) {
                this.setSimple(false);
            } else if (this.btnShowSimple == e.getSource()) {
                this.setSimple(true);
            } else if (this.btnSmplSearch == e.getSource()) {
                this.doSearch(this.btnSmplSearch.getSelectedIndex());
            } else if (this.btnAdvSearch == e.getSource()) {
                this.doSearch(this.btnAdvSearch.getSelectedIndex());
            } else if (this.btnHistory == e.getSource()) {
                if (this.btnHistory.getSelectedIndex() < 0) {
                    this.loadHistory(0);
                } else {
                    this.loadHistory(this.btnHistory.getSelectedIndex());
                }
            } else if (this.btnClearSmpl == e.getSource() || this.btnClearAdv == e.getSource()) {
                this.getCurrent().clearFields();
            } else if (this.btnTypicals == e.getSource()) {
                if (this.btnTypicals.getSelectedIndex() < 0) {
                    this.loadStandard(0);
                } else {
                    this.loadStandard(this.btnTypicals.getSelectedIndex());
                }
            }
        }
        catch (Throwable ex) {
            logger.error(ex);
        }
    }

    private void doSearch(int index) {
        switch (index) {
            case -1: 
            case 0: {
                this.doSearch(VResult.ResultMode.ClearExisting);
                break;
            }
            case 1: {
                this.doSearch(VResult.ResultMode.KeepExisting);
                break;
            }
            case 2: {
                this.doSearch(VResult.ResultMode.IntersectExisting);
                break;
            }
            case 3: {
                this.doSearch(VResult.ResultMode.Subtract);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void loadHistory(int selectedIndex) {
        VSearch<? extends Expression> vw = this.getCurrent();
        vw.loadHistoryItem(selectedIndex);
    }

    private void loadStandard(int selectedIndex) {
        VSearch<? extends Expression> vw = this.getCurrent();
        vw.loadStandardItem(selectedIndex);
    }

    public void refreshHistoryMenu() {
        this.btnHistory.removeAllPopupitems();
        for (Expression expression : this.getCurrent().getHistory()) {
            this.btnHistory.addPopupItem(expression.toString());
        }
    }

    public void refreshStandardMenu() {
        this.btnTypicals.removeAllPopupitems();
        for (Expression expression : this.getCurrent().getStandard()) {
            this.btnTypicals.addPopupItem(expression.toString());
        }
    }

    protected void refreshSearchPane() {
        VSearch<? extends Expression> c = this.get(this.getMode(), this.isSimple());
        c.updateControls();
        this.laySearch.topControl = c;
        this.layButtons.topControl = this.isSimple() ? this.cmpSmplSearchButtons : this.cmpAdvSearchButtons;
        Point p = this.cmpAll.computeSize(-1, -1);
        this.cmpSearch.layout();
        this.cmpSrchButtons.layout();
        this.cmpAll.layout();
        this.cmpAllScr.setMinSize(p);
        Event e = new Event();
        e.data = p.y;
        this.notifyListeners(11, e);
    }

    protected void refreshButtons() {
        boolean simple = this.isSimple();
        this.btnShowAdv.setVisible(simple);
        this.btnShowSimple.setVisible(!simple);
    }

    public void storeSearchPrefs() {
        IPreferenceStore store = Preferences.getStore();
        if (store == null) {
            return;
        }
        for (VSearch vSearch : this.lstAdvancedSearch) {
            List historyList = vSearch.getHistory();
            if (historyList.isEmpty()) continue;
            int n = Math.min(historyList.size(), vSearch.P_S_HISTORY_ITEMS_COUNT);
            for (int i = 0; i < n; ++i) {
                String pref = MessageFormat.format(vSearch.P_SEARCH_PREF + vSearch.getMode().getName() + ".{0}", i);
                Expression e = (Expression)historyList.get(i);
                store.setValue(pref, e.encode());
            }
        }
    }

    public void loadSearchPrefs() {
        IPreferenceStore store = Preferences.getStore();
        if (store == null) {
            return;
        }
        for (VSearch vSearch : this.lstAdvancedSearch) {
            for (int i = 0; i < vSearch.P_S_HISTORY_ITEMS_COUNT; ++i) {
                String name = MessageFormat.format(vSearch.P_SEARCH_PREF + vSearch.getMode().getName() + ".{0}", i);
                if (!store.contains(name)) continue;
                String value = store.getString(name);
                vSearch.addEncodedHistoryItem(value);
            }
        }
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new FillLayout());
        this.cmpAllScr = new ScrolledComposite((Composite)this, 768);
        this.cmpAllScr.setExpandHorizontal(true);
        this.cmpAllScr.setExpandVertical(true);
        this.cmpAll = new Composite((Composite)this.cmpAllScr, 0);
        this.cmpAll.setLayout((Layout)new GridLayout(3, false));
        this.cmpAllScr.setContent((Control)this.cmpAll);
        this.cmpModeButtons = new Composite(this.cmpAll, 0);
        this.cmpModeButtons.setLayout((Layout)new FormLayout());
        GridData gridData = new GridData(2);
        this.cmpModeButtons.setLayoutData((Object)gridData);
        this.cmpSearch = new Composite(this.cmpAll, 0);
        gridData = new GridData(770);
        this.cmpSearch.setLayoutData((Object)gridData);
        this.laySearch = new StackLayout(false);
        this.cmpSearch.setLayout((Layout)this.laySearch);
        this.layButtons = new StackLayout(false);
        this.cmpSrchButtons = new Composite(this.cmpAll, 0);
        this.cmpSrchButtons.setLayout((Layout)this.layButtons);
        gridData = new GridData(2);
        this.cmpSrchButtons.setLayoutData((Object)gridData);
        this.initButtons();
        this.initSimpleSearch();
        this.initAdvSearch();
        this.isSimple = true;
    }

    private void initButtons() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        this.btnShowSimple = new Button(this.cmpModeButtons, 132);
        this.btnShowSimple.setLayoutData((Object)formData);
        this.btnShowSimple.setVisible(false);
        this.btnShowSimple.addSelectionListener((SelectionListener)this);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        this.btnShowAdv = new Button(this.cmpModeButtons, 1028);
        this.btnShowAdv.setLayoutData((Object)formData);
        this.btnShowAdv.setVisible(true);
        this.btnShowAdv.addSelectionListener((SelectionListener)this);
        int gridStyle = 1810;
        this.cmpSmplSearchButtons = new Composite(this.cmpSrchButtons, 0);
        this.cmpSmplSearchButtons.setLayout((Layout)new GridLayout(2, true));
        this.cmpAdvSearchButtons = new Composite(this.cmpSrchButtons, 0);
        this.cmpAdvSearchButtons.setLayout((Layout)new GridLayout(1, false));
        this.btnSmplSearch = new ArrowButton(this.cmpSmplSearchButtons, 8);
        this.btnSmplSearch.setText(Resources.getGenString("Search"));
        GridData gridData = new GridData(gridStyle);
        this.btnSmplSearch.setLayoutData(gridData);
        this.btnSmplSearch.addSelectionListener(this);
        this.btnSmplSearch.addPopupItem(Resources.getString("VSearchComposite.SearchClearExisting"));
        this.btnSmplSearch.addPopupItem(Resources.getString("VSearchComposite.SearchKeepExisting"));
        this.btnSmplSearch.addPopupItem(Resources.getString("VSearchComposite.SearchIntersectExisting"));
        this.btnSmplSearch.addPopupItem(Resources.getString("VSearchComposite.Subtract"));
        this.btnClearSmpl = new Button(this.cmpSmplSearchButtons, 8);
        this.btnClearSmpl.setText(Resources.getGenString("Clear"));
        gridData = new GridData(gridStyle);
        this.btnSmplSearch.setLayoutData(gridData);
        this.btnClearSmpl.addSelectionListener((SelectionListener)this);
        this.btnAdvSearch = new ArrowButton(this.cmpAdvSearchButtons, 8);
        this.btnAdvSearch.setText(Resources.getGenString("Search"));
        gridData = new GridData(gridStyle);
        this.btnAdvSearch.setLayoutData(gridData);
        this.btnAdvSearch.addSelectionListener(this);
        this.btnAdvSearch.addPopupItem(Resources.getString("VSearchComposite.SearchClearExisting"));
        this.btnAdvSearch.addPopupItem(Resources.getString("VSearchComposite.SearchKeepExisting"));
        this.btnAdvSearch.addPopupItem(Resources.getString("VSearchComposite.SearchIntersectExisting"));
        this.btnAdvSearch.addPopupItem(Resources.getString("VSearchComposite.Subtract"));
        this.btnClearAdv = new Button(this.cmpAdvSearchButtons, 8);
        this.btnClearAdv.setText(Resources.getGenString("Clear"));
        gridData = new GridData(gridStyle);
        this.btnAdvSearch.setLayoutData(gridData);
        this.btnClearAdv.addSelectionListener((SelectionListener)this);
        this.btnTypicals = new ArrowButton(this.cmpAdvSearchButtons, 0);
        this.btnTypicals.setText(Resources.getString("VSearchComposite.btnTypicals"));
        gridData = new GridData(gridStyle);
        this.btnTypicals.setLayoutData(gridData);
        this.btnTypicals.setVisible(false);
        this.btnTypicals.addSelectionListener(this);
        this.btnHistory = new ArrowButton(this.cmpAdvSearchButtons, 8);
        this.btnHistory.setText(Resources.getString("VSearchComposite.btnHistory"));
        gridData = new GridData(gridStyle);
        this.btnHistory.setLayoutData(gridData);
        this.btnHistory.setVisible(false);
        this.btnHistory.addSelectionListener(this);
    }

    private void initSimpleSearch() {
        this.vPersonSearchSimple = new VPersonSearchSimple(this.cmpSearch);
        this.vPersonSearchSimple.registerSubmitOnEnter(this);
        this.vBaptismSearchSimple = new VBaptismSearchSimple(this.cmpSearch);
        this.vBaptismSearchSimple.registerSubmitOnEnter(this);
        this.vConfirmationSearchSimple = new VConfirmationSearchSimple(this.cmpSearch);
        this.vConfirmationSearchSimple.registerSubmitOnEnter(this);
        this.vWeddingSearchSimple = new VWeddingSearchSimple(this.cmpSearch);
        this.vFuneralSearchSimple = new VFuneralSearchSimple(this.cmpSearch);
        this.vFuneralSearchSimple.registerSubmitOnEnter(this);
        this.vDonationSearchSimple = new VDonationSearchSimple(this.cmpSearch);
        this.vDonationSearchSimple.registerSubmitOnEnter(this);
        this.lstSimpleSearch = new ArrayList<VSimpleSearch<? extends Expression>>();
        Util.fill(this.lstSimpleSearch, 6);
        this.lstSimpleSearch.set(VMain.SearchMode.PERSON.getMode(), this.vPersonSearchSimple);
        this.lstSimpleSearch.set(VMain.SearchMode.BAPTISM.getMode(), this.vBaptismSearchSimple);
        this.lstSimpleSearch.set(VMain.SearchMode.CONFIRMATION.getMode(), this.vConfirmationSearchSimple);
        this.lstSimpleSearch.set(VMain.SearchMode.WEDDING.getMode(), this.vWeddingSearchSimple);
        this.lstSimpleSearch.set(VMain.SearchMode.FUNERAL.getMode(), this.vFuneralSearchSimple);
        this.lstSimpleSearch.set(VMain.SearchMode.DONATION.getMode(), this.vDonationSearchSimple);
    }

    private void initAdvSearch() {
        this.vPersonSearchAdvanced = new VPersonSearchAdvanced(this.cmpSearch);
        this.vBaptismSearchAdvanced = new VBaptismSearchAdvanced(this.cmpSearch);
        this.vConfirmationSearchAdvanced = new VConfirmationSearchAdvanced(this.cmpSearch);
        this.vWeddingSearchAdvanced = new VWeddingSearchAdvanced(this.cmpSearch);
        this.vFuneralSearchAdvanced = new VFuneralSearchAdvanced(this.cmpSearch);
        this.vDonationSearchAdvanced = new VDonationSearchAdvanced(this.cmpSearch);
        this.lstAdvancedSearch = new ArrayList<VAdvancedSearch<? extends Expression>>(6);
        Util.fill(this.lstAdvancedSearch, 6);
        this.lstAdvancedSearch.set(VMain.SearchMode.PERSON.getMode(), this.vPersonSearchAdvanced);
        this.lstAdvancedSearch.set(VMain.SearchMode.BAPTISM.getMode(), this.vBaptismSearchAdvanced);
        this.lstAdvancedSearch.set(VMain.SearchMode.CONFIRMATION.getMode(), this.vConfirmationSearchAdvanced);
        this.lstAdvancedSearch.set(VMain.SearchMode.WEDDING.getMode(), this.vWeddingSearchAdvanced);
        this.lstAdvancedSearch.set(VMain.SearchMode.FUNERAL.getMode(), this.vFuneralSearchAdvanced);
        this.lstAdvancedSearch.set(VMain.SearchMode.DONATION.getMode(), this.vDonationSearchAdvanced);
    }

    private void copySearchData() {
        Expression expNew = this.get(this.getMode(), this.isSimple()).getExp();
        Expression expOld = this.get(this.getMode(), !this.isSimple()).getExp();
        if (expOld instanceof IndividualEventExpression) {
            IndividualEventExpression eold = (IndividualEventExpression)expOld;
            IndividualEventExpression enew = (IndividualEventExpression)expNew;
            enew.firstName = eold.firstName;
            enew.lastName = eold.lastName;
            this.get(this.getMode(), this.isSimple()).loadExp(expNew);
        } else if (expOld instanceof WeddingExpression) {
            WeddingExpression eold = (WeddingExpression)expOld;
            WeddingExpression enew = (WeddingExpression)expNew;
            enew.brideLastName = eold.brideLastName;
            enew.groomLastName = eold.groomLastName;
            this.get(this.getMode(), this.isSimple()).loadExp(expNew);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 13) {
            this.doSearch(this.isSimple() ? this.btnSmplSearch.getSelectedIndex() : this.btnAdvSearch.getSelectedIndex());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

