/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MRole;
import eelk.koguja.model.DomRole;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VAttributes;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class VRoleAdmin
extends VAttributes<DomRole>
implements SelectionListener {
    private static final Logger logger = Logger.getLogger(VRoleAdmin.class);
    private List<DomRole> roles;

    public VRoleAdmin(Composite parent) {
        super(parent);
    }

    public VRoleAdmin(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initControls() {
    }

    @Override
    protected void initControlsHere() {
        super.initControlsHere();
        this.setTableHeaderText(Resources.getString("VRoleAdmin.colName"));
        this.setNameLabelText(Resources.getString("VRoleAdmin.lblName"));
        this.getVwrAttributes().packColumns();
        this.setTitle(Resources.getString("VRoleAdmin.Title"));
        this.getBtnAdd().addSelectionListener((SelectionListener)this);
        this.getBtnModify().addSelectionListener((SelectionListener)this);
        this.getBtnDelete().addSelectionListener((SelectionListener)this);
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.getBtnAdd())) {
            this.createRole();
        } else if (e.getSource().equals(this.getBtnModify())) {
            this.modifyRole((DomRole)this.getSelectedObject(), this.getAttributeText());
        } else if (e.getSource().equals(this.getBtnDelete())) {
            this.deleteRole((DomRole)this.getSelectedObject());
        }
    }

    private int createRole() {
        String newRoleName = this.getAttributeText();
        final DomRole domRole = new DomRole();
        domRole.setName(newRoleName);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("CreatingObject"), -1);
                try {
                    MRole.instance().create(domRole);
                    Session.connection().commit();
                    VRoleAdmin.this.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Create"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        return 0;
    }

    private int modifyRole(DomRole domRole, String newName) {
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmRoleMod", domRole.getName(), newName)) {
            return -1;
        }
        final DomRole role = domRole.clone();
        role.setName(newName);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("Save.Saving"), -1);
                try {
                    MRole.instance().modify(role);
                    Session.connection().commit();
                    VRoleAdmin.this.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        return 0;
    }

    private int deleteRole(DomRole domRole) {
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmRoleDel", domRole.getName())) {
            return -1;
        }
        final DomRole role = domRole;
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("DeletingObject"), -1);
                try {
                    MRole.instance().delete(role.getId());
                    Session.connection().commit();
                    VRoleAdmin.this.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Delete") + "." + Resources.getErrString("ObjectNotFound"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        this.getVwrAttributes().setSelectedObject(domRole.getId());
        return 0;
    }

    public void load(IProgressMonitor p) throws SQLException {
        this.roles = MRole.listRoles();
    }

    public void refresh() {
        this.setSource(this.roles);
    }
}

