/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.events.BusinessObjectEventFactory;
import eelk.koguja.events.IBusinessObjectListener;
import eelk.koguja.model.BusinessObject;
import eelk.koguja.model.DomAddress;
import eelk.koguja.model.DomBaptism;
import eelk.koguja.model.DomConfirmation;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomDonation;
import eelk.koguja.model.DomDonationType;
import eelk.koguja.model.DomFuneral;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.DomWedding;
import eelk.koguja.search.BaptismResult;
import eelk.koguja.search.ConfirmationResult;
import eelk.koguja.search.DonationResult;
import eelk.koguja.search.FuneralResult;
import eelk.koguja.search.PersonResult;
import eelk.koguja.search.Result;
import eelk.koguja.search.WeddingResult;
import eelk.koguja.view.VBaptismResult;
import eelk.koguja.view.VConfirmationResult;
import eelk.koguja.view.VDonationResult;
import eelk.koguja.view.VFuneralResult;
import eelk.koguja.view.VMain;
import eelk.koguja.view.VPersonResult;
import eelk.koguja.view.VResult;
import eelk.koguja.view.VWeddingResult;
import eelk.koguja.view.View;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class VResultComposite
extends View
implements IBusinessObjectListener {
    private VMain.SearchMode mode;
    private Composite cmpResult;
    private List<VResult> lstResult;

    public VResultComposite(Composite parent) {
        this(parent, 0);
    }

    public VResultComposite(Composite parent, int style) {
        super(parent, style);
    }

    public VMain.SearchMode getMode() {
        return this.mode;
    }

    public void setMode(VMain.SearchMode mode) {
        if (this.getMode() != null && mode.getMode() == this.getMode().getMode()) {
            return;
        }
        if (this.getMode() != null) {
            this.lstResult.get(this.getMode().getMode()).setVisible(false);
        }
        this.lstResult.get(mode.getMode()).setVisible(true);
        this.mode = mode;
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new FillLayout());
        ScrolledComposite cmpAll = new ScrolledComposite((Composite)this, 768);
        cmpAll.setExpandHorizontal(true);
        cmpAll.setExpandVertical(true);
        this.cmpResult = new Composite((Composite)cmpAll, 0);
        this.cmpResult.setLayout((Layout)new FormLayout());
        cmpAll.setContent((Control)this.cmpResult);
        this.initResultViews();
        cmpAll.setMinSize(this.cmpResult.computeSize(-1, -1));
        BusinessObjectEventFactory.addListener(this);
    }

    private void initResultViews() {
        this.lstResult = new ArrayList<VResult>();
        this.lstResult.add(new VBaptismResult(this.cmpResult));
        this.lstResult.add(new VConfirmationResult(this.cmpResult));
        this.lstResult.add(new VDonationResult(this.cmpResult));
        this.lstResult.add(new VFuneralResult(this.cmpResult));
        this.lstResult.add(new VPersonResult(this.cmpResult));
        this.lstResult.add(new VWeddingResult(this.cmpResult));
        for (VResult vw : this.lstResult) {
            vw.setVisible(false);
            vw.setLayoutData(this.createResultFormData());
        }
    }

    private FormData createResultFormData() {
        FormData result = new FormData();
        result.left = new FormAttachment(0, 0);
        result.top = new FormAttachment(0, 0);
        result.right = new FormAttachment(100, 0);
        result.bottom = new FormAttachment(100, 0);
        return result;
    }

    public void addResult(VMain.SearchMode mode, Result value) {
        this.lstResult.get(mode.getMode()).addResult(value);
    }

    public VResult getCurrent() {
        if (this.getMode() == null) {
            return null;
        }
        return this.lstResult.get(this.getMode().getMode());
    }

    public VResult getResult(VMain.SearchMode m) {
        return this.lstResult.get(m.getMode());
    }

    public List<VResult> getLstResult() {
        return this.lstResult;
    }

    public void clearAllResults() {
        if (this.lstResult == null) {
            return;
        }
        for (VResult r : this.lstResult) {
            r.clearResults();
        }
    }

    @Override
    public void businessObjectCreated(BusinessObject object, Object ... data) {
        if (object instanceof DomPerson) {
            PersonResult result = new PersonResult((DomPerson)object, (DomAddress)data[0]);
            this.getResult(VMain.SearchMode.PERSON).addResult(result);
        } else if (object instanceof DomBaptism) {
            BaptismResult result = new BaptismResult((DomBaptism)object);
            this.getResult(VMain.SearchMode.BAPTISM).addResult(result);
        } else if (object instanceof DomConfirmation) {
            ConfirmationResult result = new ConfirmationResult((DomConfirmation)object);
            this.getResult(VMain.SearchMode.CONFIRMATION).addResult(result);
        } else if (object instanceof DomWedding) {
            WeddingResult result = new WeddingResult((DomWedding)object);
            this.getResult(VMain.SearchMode.WEDDING).addResult(result);
        } else if (object instanceof DomFuneral) {
            FuneralResult result = new FuneralResult((DomFuneral)object);
            this.getResult(VMain.SearchMode.FUNERAL).addResult(result);
        } else if (object instanceof DomDonation) {
            DonationResult result = new DonationResult((DomDonation)object, (DomDonationType)data[0], (DomCongregation)data[1]);
            this.getResult(VMain.SearchMode.DONATION).addResult(result);
        }
    }

    @Override
    public void businessObjectModified(BusinessObject object) {
    }

    @Override
    public void businessObjectDeleted(BusinessObject object) {
    }
}

