/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.gui.TableEx;
import eelk.koguja.search.Result;
import eelk.koguja.view.VMain;
import eelk.koguja.view.View;
import eelk.koguja.viewer.AbstractSorter;
import eelk.koguja.viewer.DomLabelProvider;
import eelk.koguja.viewer.DomTableViewer;
import eelk.koguja.viewer.LabelSorter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public abstract class VResult
extends View {
    ITableLabelProvider labelProvider = null;
    private List<Result> results = new ArrayList<Result>();
    private TableEx tblResult;
    private DomTableViewer<Result> vwrResult;

    public VResult(Composite parent) {
        this(parent, 0);
    }

    public VResult(Composite parent, int style) {
        super(parent, style);
    }

    public void setResults(List<? extends Result> results, ResultMode modifier) {
        if (results == null) {
            return;
        }
        if (this.results == null) {
            this.results = new ArrayList<Result>();
            this.results.addAll(results);
            return;
        }
        if (modifier == ResultMode.ClearExisting) {
            this.results.clear();
            this.results.addAll(results);
        } else if (modifier == ResultMode.KeepExisting) {
            while (!results.isEmpty()) {
                Result rs = results.remove(0);
                if (this.results.contains(rs)) continue;
                this.results.add(rs);
            }
        } else if (modifier == ResultMode.IntersectExisting) {
            Iterator<Result> i = this.results.iterator();
            while (i.hasNext()) {
                if (results.contains(i.next())) continue;
                i.remove();
            }
        } else if (modifier == ResultMode.Subtract) {
            for (Result result : results) {
                this.results.remove(result);
            }
        }
        this.vwrResult.setSource(this.results);
    }

    public void clearResults() {
        ArrayList r = new ArrayList();
        this.setResults(r, ResultMode.ClearExisting);
    }

    public List<Result> getSelectedResults() {
        return this.vwrResult.getSelectedObjects();
    }

    public List<Result> getResults() {
        return this.results;
    }

    public void removeSelectedResults() {
        this.vwrResult.getSource().removeAll(this.getSelectedResults());
        this.vwrResult.getViewer().refresh();
    }

    public void removeResults(List<Result> r) {
        this.vwrResult.getSource().removeAll(r);
        this.vwrResult.getViewer().refresh();
    }

    public void addResult(Result value) {
        this.results.add(value);
        this.vwrResult.setSource(this.results);
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new FillLayout());
        this.tblResult = new TableEx(this, 65538);
        this.tblResult.setHeaderVisible(true);
        this.tblResult.setLinesVisible(true);
        String[] cols = this.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            TableColumn col = new TableColumn(this.tblResult.getTable(), 0x1000000);
            col.setText(cols[i]);
            col.pack();
        }
        this.labelProvider = this.getLabelProvider();
        this.vwrResult = new DomTableViewer(this.tblResult.getTable(), this.labelProvider, this.getSorter());
        this.tblResult.getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent arg0) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    VResult.this.removeSelectedResults();
                }
            }
        });
    }

    protected abstract String[] getColumns();

    protected abstract String getColumnLabel(Object var1, int var2);

    protected AbstractSorter getSorter() {
        return new LabelSorter(this.labelProvider);
    }

    private ITableLabelProvider getLabelProvider() {
        return new DomLabelProvider(){

            @Override
            public String getColumnText(Object o, int column) {
                return VResult.this.getColumnLabel(o, column);
            }
        };
    }

    public Table getTblResult() {
        return this.tblResult.getTable();
    }

    public abstract VMain.SearchMode getMode();

    public static enum ResultMode {
        ClearExisting,
        KeepExisting,
        IntersectExisting,
        Subtract;

    }
}

