/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.dao.MRelationship;
import eelk.koguja.dao.MRelationshipType;
import eelk.koguja.events.BusinessObjectManagedEvent;
import eelk.koguja.events.IBusinessObjectManagedListener;
import eelk.koguja.gui.TableEx;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.DomPersonAddress;
import eelk.koguja.model.DomRelationship;
import eelk.koguja.model.DomRelationshipType;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.ImageFactory;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.util.Util;
import eelk.koguja.view.VEdit;
import eelk.koguja.view.VPersonData;
import eelk.koguja.viewer.DomComboViewer;
import eelk.koguja.viewer.DomLabelProvider;
import eelk.koguja.viewer.DomTableViewer;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class VRelationship
extends VEdit
implements SelectionListener,
IBusinessObjectManagedListener<DomPerson> {
    private static final Logger logger = Logger.getLogger(VRelationship.class);
    private static final String INDETERMINABLE_RELATIONSHIP_DESCRIPTION = "...";
    private boolean skipSetFocus = false;
    private int updAddrPersonIndex;
    private Integer parentRelId;
    private Integer spouseRelId;
    private DomRelationship relationship;
    private List<DomRelationshipType> relTypes;
    private List<DomPersonAddress> person1Addresses;
    private List<DomPersonAddress> person2Addresses;
    private List<DomPersonAddress> personsAddresses;
    private DomComboViewer<DomRelationshipType> vwrRelTypes;
    private DomTableViewer<DomPersonAddress> vwrPersonsAddresses;
    private Group grpPerson1;
    private VPersonData vwPerson1;
    private Composite cmpRelationship;
    private Button rdbParent;
    private Button rdbChild;
    private Button rdbSpouse;
    private Button rdbOther;
    private Combo cmbOther;
    private Button btnSwitchPersons;
    private Group grpPerson2;
    private VPersonData vwPerson2;
    private Label lblRelationship;
    private Group grpAddresses;
    private TableEx tblAddresses;
    private Group grpComment;
    private Text txtComment;

    public VRelationship(Composite parent) {
        super(parent);
    }

    public VRelationship(Composite parent, int style) {
        super(parent, style);
    }

    public Integer getPerson1Id() {
        return this.vwPerson1.getObjectID();
    }

    public void setPerson1Id(Integer value) {
        this.vwPerson1.setObjectID(value);
    }

    public Integer getPerson2Id() {
        return this.vwPerson2.getObjectID();
    }

    public void setPerson2Id(Integer value) {
        this.vwPerson2.setObjectID(value);
    }

    public void endRelationship() {
        this.rdbChild.setSelection(false);
        this.rdbParent.setSelection(false);
        this.rdbSpouse.setSelection(false);
        this.rdbOther.setSelection(false);
        this.relationship = new DomRelationship();
        this.relationship.setPerson1Id(this.vwPerson1.getObjectID());
        this.relationship.setPerson2Id(this.vwPerson2.getObjectID());
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        p.beginTask(Resources.getMsgString("Load.Loading"), 6);
        if (this.getPerson1Id() != null && this.getPerson2Id() != null) {
            this.relationship = MRelationship.instance().get(this.getPerson1Id(), this.getPerson2Id());
            if (this.relationship != null && Util.compare(this.getPerson1Id(), this.relationship.getPerson1Id()) != 0) {
                Integer oid = this.vwPerson1.getObjectID();
                this.vwPerson1.setObjectID(this.vwPerson2.getObjectID());
                this.vwPerson2.setObjectID(oid);
            }
        } else {
            this.relationship = null;
        }
        p.worked(1);
        this.vwPerson1.load(p);
        p.worked(1);
        this.vwPerson2.load(p);
        p.worked(1);
        this.loadAddresses(true, true);
        p.worked(1);
        this.relTypes = MRelationshipType.listRelationshipTypes();
        p.worked(1);
        for (int i = this.relTypes.size() - 1; i >= 0; --i) {
            if (this.relTypes.get(i).getBaseType() == 0) {
                this.parentRelId = this.relTypes.get(i).getId();
                this.relTypes.remove(i);
                if (this.parentRelId == null || this.spouseRelId == null) continue;
                break;
            }
            if (this.relTypes.get(i).getBaseType() != 1) continue;
            this.spouseRelId = this.relTypes.get(i).getId();
            this.relTypes.remove(i);
            if (this.parentRelId != null && this.spouseRelId != null) break;
        }
        p.worked(1);
        p.done();
    }

    private void loadAddresses(boolean person1, boolean person2) throws SQLException {
        if (person1) {
            this.person1Addresses = this.vwPerson1.getObjectID() != null ? MPersonSwt.getPersonAddresses(this.vwPerson1.getObjectID()) : new ArrayList<DomPersonAddress>();
        }
        if (person2) {
            this.person2Addresses = this.vwPerson2.getObjectID() != null ? MPersonSwt.getPersonAddresses(this.vwPerson2.getObjectID()) : new ArrayList<DomPersonAddress>();
        }
        if (person1 || person2) {
            this.personsAddresses = new ArrayList<DomPersonAddress>();
            this.personsAddresses.addAll(this.person1Addresses);
            for (DomPersonAddress a : this.person2Addresses) {
                boolean contains = false;
                for (DomPersonAddress b : this.person1Addresses) {
                    if (!b.getAddress().equals(a.getAddress())) continue;
                    b.setId(a.getId());
                    contains = true;
                    break;
                }
                if (contains) continue;
                this.personsAddresses.add(a);
            }
        }
    }

    @Override
    public void refresh() {
        this.rdbParent.setSelection(false);
        this.rdbChild.setSelection(false);
        this.rdbSpouse.setSelection(false);
        this.rdbOther.setSelection(false);
        this.vwrRelTypes.setSelectedObject(null);
        this.vwrRelTypes.setSource(this.relTypes);
        this.vwrPersonsAddresses.setSource(this.personsAddresses);
        this.vwPerson1.refresh();
        this.vwPerson2.refresh();
        if (this.relationship == null) {
            return;
        }
        int type = this.relationship.getTypeId();
        if (type == this.parentRelId) {
            DomPerson p1 = this.vwPerson1.getPerson();
            DomPerson p2 = this.vwPerson2.getPerson();
            if (p1.getBirthDate().before(p2.getBirthDate())) {
                this.rdbParent.setSelection(true);
            } else {
                this.rdbChild.setSelection(true);
            }
        } else if (type == this.spouseRelId) {
            this.rdbSpouse.setSelection(true);
        } else {
            this.rdbOther.setSelection(true);
            this.vwrRelTypes.setSelectedObject(this.relationship.getTypeId());
        }
        this.txtComment.setText(Util.d(this.relationship.getComment()));
        this.generateRelDescription();
        this.cmbOther.setEnabled(this.rdbOther.getSelection());
    }

    @Override
    public boolean save(IProgressMonitor p) throws SQLException {
        p.beginTask(Resources.getMsgString("Save.Saving"), 3);
        Integer p1 = this.relationship.getPerson1Id();
        Integer p2 = this.relationship.getPerson2Id();
        if (p1 != null && p2 != null) {
            if (this.relationship.getTypeId() != null) {
                MRelationship.instance().set(this.relationship);
                p.worked(1);
                MPersonSwt.setPersonAddresses(p1, this.person1Addresses);
                p.worked(1);
                MPersonSwt.setPersonAddresses(p2, this.person2Addresses);
                p.worked(1);
            } else if (MRelationship.instance().get(p1, p2) != null) {
                MRelationship.instance().end(p1, p2);
                p.worked(3);
            } else {
                p.worked(3);
            }
        } else {
            p.worked(3);
        }
        p.done();
        return true;
    }

    @Override
    public boolean collect() {
        if (this.relationship == null) {
            this.relationship = new DomRelationship();
        }
        if (!this.skipSetFocus && !this.vwPerson1.collect()) {
            return false;
        }
        if (this.vwPerson1.getObjectID() == null) {
            if (!this.skipSetFocus) {
                GuiUtil.informationDialog(this.getShell(), "Err.VRelationship.Person1", new Object[0]);
                this.vwPerson1.setFocus();
            }
            return false;
        }
        this.relationship.setPerson1Id(this.vwPerson1.getObjectID());
        if (!this.skipSetFocus && !this.vwPerson2.collect()) {
            return false;
        }
        if (this.vwPerson2.getObjectID() == null) {
            if (!this.skipSetFocus) {
                GuiUtil.informationDialog(this.getShell(), "Err.VRelationship.Person2", new Object[0]);
                this.vwPerson2.setFocus();
            }
            return false;
        }
        this.relationship.setPerson2Id(this.vwPerson2.getObjectID());
        DomPerson person1 = this.vwPerson1.getPerson();
        DomPerson person2 = this.vwPerson2.getPerson();
        if (person1.equals(person2) && !this.skipSetFocus) {
            GuiUtil.informationDialog(this.getShell(), "Err.VRelationship.SamePerson", new Object[0]);
            this.vwPerson2.setFocus();
            return false;
        }
        if (this.rdbParent.getSelection()) {
            this.relationship.setTypeId(this.parentRelId);
            if (!person1.getBirthDate().before(person2.getBirthDate()) && !this.skipSetFocus) {
                GuiUtil.informationDialog(this.getShell(), "Err.VRelationship.CannotBeParent", person1, person2);
                this.rdbParent.setFocus();
                this.rdbParent.setSelection(false);
                return false;
            }
        } else if (this.rdbChild.getSelection()) {
            this.relationship.setTypeId(this.parentRelId);
            if (!person1.getBirthDate().after(person2.getBirthDate()) && !this.skipSetFocus) {
                GuiUtil.informationDialog(this.getShell(), "Err.VRelationship.CannotBeChild", person1, person2);
                this.rdbParent.setFocus();
                this.rdbParent.setSelection(false);
                return false;
            }
        } else if (this.rdbSpouse.getSelection()) {
            this.relationship.setTypeId(this.spouseRelId == null ? -1 : this.spouseRelId);
        } else if (this.rdbOther.getSelection()) {
            if (this.vwrRelTypes.getSelectedObject() == null) {
                if (!this.skipSetFocus) {
                    GuiUtil.informationDialog(this.getShell(), "Err.VRelationship.Relationship", new Object[0]);
                    this.cmbOther.setFocus();
                }
                return false;
            }
            this.relationship.setTypeId(this.vwrRelTypes.getSelectedObjectID());
        } else {
            if (!this.skipSetFocus) {
                GuiUtil.informationDialog(this.getShell(), "Err.VRelationship.Relationship", new Object[0]);
                this.rdbParent.setFocus();
                this.rdbParent.setSelection(false);
                return false;
            }
            return false;
        }
        this.relationship.setComment(Util.c(this.txtComment.getText()));
        return true;
    }

    private void updateAddresses(int personIndex) {
        this.updAddrPersonIndex = personIndex;
        Operation.run(this.getShell(), true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                p.beginTask(Resources.getMsgString("Load.Loading"), -1);
                try {
                    VRelationship.this.loadAddresses(VRelationship.this.updAddrPersonIndex == 1, VRelationship.this.updAddrPersonIndex == 2);
                    p.done();
                }
                catch (SQLException ex) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        });
        this.vwrPersonsAddresses.setSource(this.personsAddresses);
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (this.rdbParent == source || this.rdbChild == source || this.rdbSpouse == source || this.rdbOther == source || this.cmbOther == source) {
            this.generateRelDescription();
        }
        if (this.btnSwitchPersons == e.getSource()) {
            this.switchPersons();
        }
        this.cmbOther.setEnabled(this.rdbOther.getSelection());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    public void businessObjectManaged(BusinessObjectManagedEvent<DomPerson> e) {
        if (this.vwPerson1 == e.getSource()) {
            this.generateRelDescription();
            this.updateAddresses(1);
        }
        if (this.vwPerson2 == e.getSource()) {
            this.generateRelDescription();
            this.updateAddresses(2);
        }
    }

    @Override
    protected void initControls() {
        this.grpPerson1 = new Group((Composite)this, 0);
        this.grpPerson1.setText(Resources.getString("VRelationship.grpPerson1"));
        this.grpPerson1.setLayout((Layout)new FillLayout());
        GuiUtil.displayAsMandatory((Control)this.grpPerson1);
        this.vwPerson1 = new VPersonData((Composite)this.grpPerson1);
        this.vwPerson1.addBusinessObjectListener(this);
        this.cmpRelationship = new Composite((Composite)this, 0);
        this.cmpRelationship.setLayout((Layout)new GridLayout(1, false));
        Group grpRelationship = new Group(this.cmpRelationship, 0);
        grpRelationship.setText(Resources.getString("VRelationship.grpRelationship"));
        grpRelationship.setLayoutData((Object)new GridData(1808));
        grpRelationship.setLayout((Layout)new GridLayout(1, false));
        GuiUtil.displayAsMandatory((Control)grpRelationship);
        this.rdbParent = new Button((Composite)grpRelationship, 16);
        this.rdbParent.setText(Resources.getString("VRelationship.btnParent"));
        this.rdbParent.setLayoutData((Object)new GridData(32));
        this.rdbParent.addSelectionListener((SelectionListener)this);
        this.rdbChild = new Button((Composite)grpRelationship, 16);
        this.rdbChild.setText(Resources.getString("VRelationship.btnChild"));
        this.rdbChild.setLayoutData((Object)new GridData(32));
        this.rdbChild.addSelectionListener((SelectionListener)this);
        this.rdbSpouse = new Button((Composite)grpRelationship, 16);
        this.rdbSpouse.setText(Resources.getString("VRelationship.btnSpouse"));
        this.rdbSpouse.setLayoutData((Object)new GridData(32));
        this.rdbSpouse.addSelectionListener((SelectionListener)this);
        this.rdbOther = new Button((Composite)grpRelationship, 16);
        this.rdbOther.setText(Resources.getString("VRelationship.btnOther"));
        this.rdbOther.setLayoutData((Object)new GridData(32));
        this.rdbOther.addSelectionListener((SelectionListener)this);
        this.cmbOther = new Combo((Composite)grpRelationship, 2056);
        this.cmbOther.setLayoutData((Object)new GridData(768));
        this.cmbOther.addSelectionListener((SelectionListener)this);
        this.cmbOther.setEnabled(false);
        this.vwrRelTypes = new DomComboViewer(this.cmbOther);
        this.btnSwitchPersons = new Button(this.cmpRelationship, 8);
        this.btnSwitchPersons.setText(Resources.getString("VRelationship.btnSwitchPersons"));
        this.btnSwitchPersons.setLayoutData((Object)new GridData(64));
        this.btnSwitchPersons.addSelectionListener((SelectionListener)this);
        this.grpPerson2 = new Group((Composite)this, 0);
        this.grpPerson2.setText(Resources.getString("VRelationship.grpPerson2"));
        this.grpPerson2.setLayout((Layout)new FillLayout());
        GuiUtil.displayAsMandatory((Control)this.grpPerson2);
        this.vwPerson2 = new VPersonData((Composite)this.grpPerson2);
        this.vwPerson2.addBusinessObjectListener(this);
        this.lblRelationship = new Label((Composite)this, 2048);
        this.lblRelationship.setText(INDETERMINABLE_RELATIONSHIP_DESCRIPTION);
        this.grpAddresses = new Group((Composite)this, 0);
        this.grpAddresses.setText(Resources.getString("VRelationship.grpAddresses"));
        this.grpAddresses.setLayout((Layout)new GridLayout(2, false));
        this.tblAddresses = new TableEx((Composite)this.grpAddresses, 68356);
        this.tblAddresses.setHeaderVisible(true);
        this.tblAddresses.setLinesVisible(true);
        this.tblAddresses.setLayoutData(new GridData(1808));
        TableColumn colAddress = new TableColumn(this.tblAddresses.getTable(), 0x1000000);
        colAddress.setText(Resources.getString("VRelationship.colAddress"));
        colAddress.pack();
        TableColumn colPerson1 = new TableColumn(this.tblAddresses.getTable(), 0x1000000);
        colPerson1.setText(Resources.getString("VRelationship.colPerson1"));
        colPerson1.pack();
        TableColumn colPerson2 = new TableColumn(this.tblAddresses.getTable(), 0x1000000);
        colPerson2.setText(Resources.getString("VRelationship.colPerson2"));
        colPerson2.pack();
        this.tblAddresses.setColMaxWidths(100, 40, 40);
        this.tblAddresses.setFixedSizeColumns(false, true, true);
        this.vwrPersonsAddresses = new DomTableViewer(this.tblAddresses.getTable(), this.createAddressesLabelProvider());
        CellEditor[] addressesCellEditors = new CellEditor[]{null, new CheckboxCellEditor((Composite)this.tblAddresses.getTable()){

            @Override
            protected Object doGetValue() {
                return VRelationship.this.person1Addresses.contains(VRelationship.this.vwrPersonsAddresses.getSelectedObject());
            }

            @Override
            protected void doSetValue(Object value) {
                if (((Boolean)this.doGetValue()).booleanValue()) {
                    VRelationship.this.person1Addresses.remove(VRelationship.this.vwrPersonsAddresses.getSelectedObject());
                } else {
                    VRelationship.this.person1Addresses.add((DomPersonAddress)VRelationship.this.vwrPersonsAddresses.getSelectedObject());
                }
                VRelationship.this.tblAddresses.redraw();
            }
        }, new CheckboxCellEditor((Composite)this.tblAddresses.getTable()){

            @Override
            protected Object doGetValue() {
                return VRelationship.this.person2Addresses.contains(VRelationship.this.vwrPersonsAddresses.getSelectedObject());
            }

            @Override
            protected void doSetValue(Object value) {
                if (((Boolean)this.doGetValue()).booleanValue()) {
                    VRelationship.this.person2Addresses.remove(VRelationship.this.vwrPersonsAddresses.getSelectedObject());
                } else {
                    VRelationship.this.person2Addresses.add((DomPersonAddress)VRelationship.this.vwrPersonsAddresses.getSelectedObject());
                }
                VRelationship.this.tblAddresses.redraw();
            }
        }};
        TableViewer vwr = (TableViewer)this.vwrPersonsAddresses.getViewer();
        vwr.setColumnProperties(new String[]{"address_id", "belongs_to_1", "belongs_to_2"});
        vwr.setCellEditors(addressesCellEditors);
        this.grpComment = new Group((Composite)this, 0);
        this.grpComment.setText(Resources.getString("VRelationship.grpComment"));
        this.grpComment.setLayout((Layout)new GridLayout(2, false));
        this.txtComment = new Text((Composite)this.grpComment, 2048);
        this.txtComment.setLayoutData((Object)new GridData(1808));
        this.txtComment.setTextLimit(240);
        this.setupLayout();
    }

    private DomLabelProvider<DomPersonAddress> createAddressesLabelProvider() {
        return new DomLabelProvider<DomPersonAddress>(){

            @Override
            public Image getColumnImage(Object element, int columnIndex) {
                if (element == null || columnIndex == 0) {
                    return null;
                }
                DomPersonAddress a = (DomPersonAddress)element;
                if (columnIndex == 1) {
                    return VRelationship.this.person1Addresses.contains(a) ? ImageFactory.getImage(ImageFactory.ImageCollection.CHECK) : null;
                }
                if (columnIndex == 2) {
                    return VRelationship.this.person2Addresses.contains(a) ? ImageFactory.getImage(ImageFactory.ImageCollection.CHECK) : null;
                }
                return null;
            }

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0 && element != null) {
                    return ((DomPersonAddress)element).getAddress().toString();
                }
                return "";
            }
        };
    }

    private void setupLayout() {
        if (this.getLayout() == null) {
            this.setLayout((Layout)new FormLayout());
        }
        FormData formData = null;
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 10);
        formData.right = new FormAttachment(40, 0);
        formData.bottom = new FormAttachment(50, 0);
        this.grpPerson1.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment((Control)this.grpPerson1, 10);
        formData.right = new FormAttachment(60, 0);
        formData.bottom = new FormAttachment(50, 0);
        this.cmpRelationship.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment((Control)this.cmpRelationship, 10);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(50, 0);
        this.grpPerson2.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.grpPerson1, 10);
        formData.left = new FormAttachment(0, 10);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(60, 0);
        this.lblRelationship.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.lblRelationship, 10);
        formData.left = new FormAttachment(0, 10);
        formData.right = new FormAttachment(50, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.grpAddresses.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)this.lblRelationship, 10);
        formData.left = new FormAttachment((Control)this.grpAddresses, 10);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.grpComment.setLayoutData((Object)formData);
    }

    private void generateRelDescription() {
        this.skipSetFocus = true;
        if (!this.collect() || this.rdbOther.getSelection() && this.vwrRelTypes.getSelectedObject() == null) {
            this.lblRelationship.setText(INDETERMINABLE_RELATIONSHIP_DESCRIPTION);
            this.skipSetFocus = false;
            return;
        }
        this.skipSetFocus = false;
        StringBuilder sb = new StringBuilder("Isik ");
        sb.append(this.vwPerson1.getPerson().getFirstName());
        sb.append(" ");
        sb.append(this.vwPerson1.getPerson().getLastName());
        sb.append(" on isiku ");
        sb.append(this.vwPerson2.getPerson().getFirstName());
        sb.append(" ");
        sb.append(this.vwPerson2.getPerson().getLastName());
        sb.append(" ");
        if (this.rdbParent.getSelection()) {
            sb.append(this.rdbParent.getText().toLowerCase());
        } else if (this.rdbChild.getSelection()) {
            sb.append(this.rdbChild.getText().toLowerCase());
        } else if (this.rdbSpouse.getSelection()) {
            sb.append(this.rdbSpouse.getText().toLowerCase());
        } else if (this.rdbOther.getSelection()) {
            sb.append(this.cmbOther.getText().toLowerCase());
        }
        this.lblRelationship.setText(sb.toString());
    }

    private void switchPersons() {
        DomPerson person = this.vwPerson1.getPerson();
        this.vwPerson1.setPerson(this.vwPerson2.getPerson());
        this.vwPerson2.setPerson(person);
        if (this.rdbChild.getSelection()) {
            this.rdbChild.setSelection(false);
            this.rdbParent.setSelection(true);
        } else if (this.rdbParent.getSelection()) {
            this.rdbChild.setSelection(true);
            this.rdbParent.setSelection(false);
        } else if (!this.rdbSpouse.getSelection()) {
            Operation.run(this.getShell(), true, new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                    try {
                        p.beginTask(Resources.getMsgString("Load.Loading"), -1);
                        VRelationship.this.relationship = MRelationship.instance().get(VRelationship.this.getPerson1Id(), VRelationship.this.getPerson2Id());
                        p.done();
                    }
                    catch (SQLException ex) {
                        p.done();
                        Session.rollback();
                        SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                    }
                }
            });
            this.refresh();
        }
        List<DomPersonAddress> t = this.person1Addresses;
        this.person1Addresses = this.person2Addresses;
        this.person2Addresses = t;
        this.vwrPersonsAddresses.setSource(this.personsAddresses);
        this.generateRelDescription();
    }
}

