/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.model.DomPerson;
import eelk.koguja.util.Resources;
import eelk.koguja.view.View;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class VQuestionOption
extends View
implements SelectionListener {
    public static final int DEFAULT_ANSWERS_COUNT = 2;
    private int selectedAnswer = -1;
    private StyledText txtQuestion;
    private final List<Button> rdbAnswers = new ArrayList<Button>();

    public VQuestionOption(Composite parent) {
        this(parent, 0, 2);
    }

    public VQuestionOption(Composite parent, int questions) {
        this(parent, 0, 2);
    }

    public VQuestionOption(Composite parent, int style, int answers) {
        super(parent, style);
        this.setAnswers(answers);
    }

    public int getSelectedAnswer() {
        return this.selectedAnswer;
    }

    public int getAnswers() {
        return this.rdbAnswers.size();
    }

    public void setAnswers(int answers) {
        this.rdbAnswers.clear();
        for (int i = 0; i < answers; ++i) {
            Button btn = new Button((Composite)this, 16);
            this.rdbAnswers.add(btn);
            btn.addSelectionListener((SelectionListener)this);
        }
    }

    public void setAnswer(int nr, String text) {
        this.rdbAnswers.get(nr).setText(text);
    }

    public void setQuestion(String resourceKey) {
        String template = Resources.getString(resourceKey);
        this.txtQuestion.setText(template);
    }

    public void setQuestion(String resourceKey, Object[] obj) {
        String template = Resources.getString(resourceKey);
        this.txtQuestion.setText(String.format(template, obj));
    }

    public void setAnswerEnabled(int index, boolean value) {
        this.rdbAnswers.get(index).setEnabled(value);
    }

    public void setQuestion(String resourceKey, String address, List<DomPerson> lstPersons) {
        String template = Resources.getString(resourceKey);
        StringBuilder persons = new StringBuilder();
        if (lstPersons != null) {
            for (DomPerson person : lstPersons) {
                persons.append(person.toString()).append(", ");
            }
            persons = new StringBuilder(persons.substring(0, persons.length() - 2));
        }
        this.txtQuestion.setText(String.format(template, address, persons.toString()));
        int start = template.indexOf(37);
        int length = address.length();
        if (start >= 0 && length >= 0) {
            this.txtQuestion.setStyleRange(new StyleRange(start, length, this.txtQuestion.getForeground(), this.txtQuestion.getBackground(), 1));
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        for (int i = this.rdbAnswers.size() - 1; i >= 0; --i) {
            if (this.rdbAnswers.get(i) != o) continue;
            this.selectedAnswer = i;
            break;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.txtQuestion = new StyledText((Composite)this, 0);
        this.txtQuestion.setBackground(this.getBackground());
        this.txtQuestion.setEnabled(false);
        this.txtQuestion.setLayoutData((Object)new GridData(512));
        this.txtQuestion.setWordWrap(true);
    }
}

