/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.events.BusinessObjectEventFactory;
import eelk.koguja.events.IBusinessObjectListener;
import eelk.koguja.gui.ArrowButton;
import eelk.koguja.model.BusinessObject;
import eelk.koguja.model.DomBaptism;
import eelk.koguja.model.DomConfirmation;
import eelk.koguja.model.DomDonation;
import eelk.koguja.model.DomFuneral;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.DomShortEvent;
import eelk.koguja.model.DomWedding;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.seq.SeqModify;
import eelk.koguja.seq.SeqModifyBaptism;
import eelk.koguja.seq.SeqModifyConfirmation;
import eelk.koguja.seq.SeqModifyDonation;
import eelk.koguja.seq.SeqModifyFuneral;
import eelk.koguja.seq.SeqModifyPerson;
import eelk.koguja.seq.SeqModifyWedding;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.DbUtil;
import eelk.koguja.util.IDbUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VBaptismPreview;
import eelk.koguja.view.VConfirmationPreview;
import eelk.koguja.view.VDonationPreview;
import eelk.koguja.view.VFuneralPreview;
import eelk.koguja.view.VPersonPreview;
import eelk.koguja.view.VPreview;
import eelk.koguja.view.VWeddingPreview;
import eelk.koguja.view.View;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class VPreviewComposite
extends View
implements SelectionListener,
MouseListener,
IBusinessObjectListener {
    private static final Logger logger = Logger.getLogger(VPreviewComposite.class);
    private TabFolder tbfPreview;
    private Button btnClose;
    private Button btnEdit;
    private ArrowButton btnHistory;
    private Button btnRefresh;

    public VPreviewComposite(Composite parent) {
        this(parent, 0);
    }

    public VPreviewComposite(Composite parent, int style) {
        super(parent, style);
    }

    public void addPerson(int personID) {
        for (TabItem tbi : this.tbfPreview.getItems()) {
            VPreview vw = (VPreview)((ScrolledComposite)tbi.getControl()).getContent();
            if (!(vw instanceof VPersonPreview) || vw.getObjectID() != personID) continue;
            this.tbfPreview.setSelection(new TabItem[]{tbi});
            this.setButtonMenu(vw);
            return;
        }
        if (!DbUtil.checkUserPerson(IDbUtil.Permission.Read, personID, this.getShell())) {
            return;
        }
        TabItem tbi = new TabItem(this.tbfPreview, 0);
        ScrolledComposite cmp = new ScrolledComposite((Composite)this.tbfPreview, 768);
        VPersonPreview vw = new VPersonPreview((Composite)cmp);
        vw.getTxtFather().addMouseListener((MouseListener)this);
        vw.getTxtMother().addMouseListener((MouseListener)this);
        vw.getTxtSpouse().addMouseListener((MouseListener)this);
        vw.getTblEvents().addMouseListener((MouseListener)this);
        vw.getTblChildren().addMouseListener((MouseListener)this);
        vw.getTblRelatives().addMouseListener((MouseListener)this);
        this.addObject(personID, tbi, cmp, vw);
    }

    public void addBaptism(int baptismID) {
        for (TabItem tbi : this.tbfPreview.getItems()) {
            VPreview vw = (VPreview)((ScrolledComposite)tbi.getControl()).getContent();
            if (!(vw instanceof VBaptismPreview) || vw.getObjectID() != baptismID) continue;
            this.tbfPreview.setSelection(new TabItem[]{tbi});
            this.setButtonMenu(vw);
            return;
        }
        if (!DbUtil.checkUserBaptism(IDbUtil.Permission.Read, baptismID, this.getShell())) {
            return;
        }
        TabItem tbi = new TabItem(this.tbfPreview, 0);
        ScrolledComposite cmp = new ScrolledComposite((Composite)this.tbfPreview, 768);
        VBaptismPreview vw = new VBaptismPreview((Composite)cmp);
        this.addObject(baptismID, tbi, cmp, vw);
    }

    public void addConfirmation(int confirmationID) {
        for (TabItem tbi : this.tbfPreview.getItems()) {
            VPreview vw = (VPreview)((ScrolledComposite)tbi.getControl()).getContent();
            if (!(vw instanceof VConfirmationPreview) || vw.getObjectID() != confirmationID) continue;
            this.tbfPreview.setSelection(new TabItem[]{tbi});
            this.setButtonMenu(vw);
            return;
        }
        if (!DbUtil.checkUserConfirmation(IDbUtil.Permission.Read, confirmationID, this.getShell())) {
            return;
        }
        TabItem tbi = new TabItem(this.tbfPreview, 0);
        ScrolledComposite cmp = new ScrolledComposite((Composite)this.tbfPreview, 768);
        VConfirmationPreview vw = new VConfirmationPreview((Composite)cmp);
        this.addObject(confirmationID, tbi, cmp, vw);
    }

    public void addWedding(int weddingID) {
        for (TabItem tbi : this.tbfPreview.getItems()) {
            VPreview vw = (VPreview)((ScrolledComposite)tbi.getControl()).getContent();
            if (!(vw instanceof VWeddingPreview) || vw.getObjectID() != weddingID) continue;
            this.tbfPreview.setSelection(new TabItem[]{tbi});
            this.setButtonMenu(vw);
            return;
        }
        if (!DbUtil.checkUserWedding(IDbUtil.Permission.Read, weddingID, this.getShell())) {
            return;
        }
        TabItem tbi = new TabItem(this.tbfPreview, 0);
        ScrolledComposite cmp = new ScrolledComposite((Composite)this.tbfPreview, 768);
        VWeddingPreview vw = new VWeddingPreview((Composite)cmp);
        this.addObject(weddingID, tbi, cmp, vw);
    }

    public void addFuneral(int funeralID) {
        for (TabItem tbi : this.tbfPreview.getItems()) {
            VPreview vw = (VPreview)((ScrolledComposite)tbi.getControl()).getContent();
            if (!(vw instanceof VFuneralPreview) || vw.getObjectID() != funeralID) continue;
            this.tbfPreview.setSelection(new TabItem[]{tbi});
            this.setButtonMenu(vw);
            return;
        }
        if (!DbUtil.checkUserFuneral(IDbUtil.Permission.Read, funeralID, this.getShell())) {
            return;
        }
        TabItem tbi = new TabItem(this.tbfPreview, 0);
        ScrolledComposite cmp = new ScrolledComposite((Composite)this.tbfPreview, 768);
        VFuneralPreview vw = new VFuneralPreview((Composite)cmp);
        this.addObject(funeralID, tbi, cmp, vw);
    }

    public void addDonation(int donationID) {
        for (TabItem tbi : this.tbfPreview.getItems()) {
            VPreview vw = (VPreview)((ScrolledComposite)tbi.getControl()).getContent();
            if (!(vw instanceof VDonationPreview) || vw.getObjectID() != donationID) continue;
            this.tbfPreview.setSelection(new TabItem[]{tbi});
            this.setButtonMenu(vw);
            return;
        }
        if (!DbUtil.checkUserDonation(IDbUtil.Permission.Read, donationID, this.getShell())) {
            return;
        }
        TabItem tbi = new TabItem(this.tbfPreview, 0);
        ScrolledComposite cmp = new ScrolledComposite((Composite)this.tbfPreview, 768);
        VDonationPreview vw = new VDonationPreview((Composite)cmp);
        this.addObject(donationID, tbi, cmp, vw);
    }

    public boolean closeTab() {
        return this.closeTab(this.tbfPreview.getSelectionIndex());
    }

    public boolean closeAllTabs() {
        boolean closed = false;
        while (this.closeTab(0)) {
            closed = true;
        }
        return closed;
    }

    public boolean closeTab(int i) {
        if (i < 0 || i >= this.tbfPreview.getItemCount()) {
            return false;
        }
        this.tbfPreview.getItem(i).dispose();
        boolean hasMoreTabs = this.tbfPreview.getSelectionIndex() >= 0;
        this.btnClose.setEnabled(hasMoreTabs);
        this.btnHistory.setEnabled(hasMoreTabs);
        this.btnEdit.setEnabled(hasMoreTabs);
        this.btnRefresh.setEnabled(hasMoreTabs);
        if (!hasMoreTabs) {
            this.btnHistory.removeAllPopupitems();
        }
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.btnClose.equals(e.getSource())) {
            this.closeTab();
        } else if (this.tbfPreview.equals(e.getSource()) && this.tbfPreview.getItemCount() > 0) {
            int i = this.tbfPreview.getSelectionIndex();
            ScrolledComposite c = (ScrolledComposite)this.tbfPreview.getItem(i).getControl();
            if (c == null) {
                return;
            }
            VPreview vw = (VPreview)c.getContent();
            this.setButtonMenu(vw);
        } else if (((Object)((Object)this.btnHistory)).equals(e.getSource()) && this.btnHistory.getSelectedIndex() > -2) {
            this.loadHistory();
        } else if (this.btnEdit.equals(e.getSource())) {
            this.openModifyWindow();
        } else if (this.btnRefresh == e.getSource()) {
            this.refreshActiveTab();
        }
    }

    private void openModifyWindow() {
        SeqModify seq = null;
        int i = this.tbfPreview.getSelectionIndex();
        ScrolledComposite c = (ScrolledComposite)this.tbfPreview.getItem(i).getControl();
        if (c == null) {
            return;
        }
        VPreview vw = (VPreview)c.getContent();
        if (vw instanceof VPersonPreview) {
            seq = new SeqModifyPerson(this.getShell());
        } else if (vw instanceof VBaptismPreview) {
            seq = new SeqModifyBaptism(this.getShell());
        } else if (vw instanceof VConfirmationPreview) {
            seq = new SeqModifyConfirmation(this.getShell());
        } else if (vw instanceof VFuneralPreview) {
            seq = new SeqModifyFuneral(this.getShell());
        } else if (vw instanceof VWeddingPreview) {
            seq = new SeqModifyWedding(this.getShell());
        } else if (vw instanceof VDonationPreview) {
            seq = new SeqModifyDonation(this.getShell());
        }
        seq.setObjectId(vw.getObjectID());
        Sequence.execSequence(seq);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void loadHistory() {
        int indexInList = this.btnHistory.getSelectedIndex() == -1 ? 0 : this.btnHistory.getSelectedIndex();
        VPreview vw = (VPreview)((ScrolledComposite)this.tbfPreview.getItem(this.tbfPreview.getSelectionIndex()).getControl()).getContent();
        vw.setHistoryID(indexInList);
        vw.loadHistory();
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        Composite cmpButtons = new Composite((Composite)this, 0);
        cmpButtons.setLayoutData((Object)formData);
        cmpButtons.setLayout((Layout)new GridLayout(4, true));
        this.btnClose = new Button(cmpButtons, 8);
        this.btnClose.setText(Resources.getString("VPreviewComposite.btnClose"));
        this.btnClose.setLayoutData((Object)new GridData(256));
        this.btnClose.addSelectionListener((SelectionListener)this);
        this.btnClose.setEnabled(false);
        this.btnEdit = new Button(cmpButtons, 8);
        this.btnEdit.setText(Resources.getString("VPreviewComposite.btnEdit"));
        this.btnEdit.setLayoutData((Object)new GridData(256));
        this.btnEdit.setEnabled(false);
        this.btnEdit.addSelectionListener((SelectionListener)this);
        this.btnHistory = new ArrowButton(cmpButtons, 0);
        this.btnHistory.setText(Resources.getString("VPreviewComposite.btnHistory"));
        this.btnHistory.setLayoutData(new GridData(256));
        this.btnHistory.setEnabled(false);
        this.btnHistory.addSelectionListener(this);
        this.btnRefresh = new Button(cmpButtons, 0);
        this.btnRefresh.setText(Resources.getString("VPreviewComposite.btnRefresh"));
        this.btnRefresh.setLayoutData((Object)new GridData(256));
        this.btnRefresh.setEnabled(false);
        this.btnRefresh.addSelectionListener((SelectionListener)this);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment((Control)cmpButtons);
        this.tbfPreview = new TabFolder((Composite)this, 0);
        this.tbfPreview.addSelectionListener((SelectionListener)this);
        this.tbfPreview.setLayoutData((Object)formData);
        BusinessObjectEventFactory.addListener(this);
    }

    public void setButtonMenu(VPreview currentPreview) {
        List<String> selectedObjectHistory = currentPreview.getHistory();
        this.btnHistory.removeAllPopupitems();
        for (String s : selectedObjectHistory) {
            this.btnHistory.addPopupItem(s);
        }
    }

    private void loadData(VPreview vw) {
        final VPreview vPreview = vw;
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("Load.Loading"), -1);
                try {
                    vPreview.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        vPreview.refresh();
        this.setButtonMenu(vPreview);
    }

    private void addObject(int objectID, TabItem tbi, ScrolledComposite cmp, VPreview vw) {
        tbi.setControl((Control)cmp);
        cmp.setExpandHorizontal(true);
        cmp.setExpandVertical(true);
        cmp.setContent((Control)vw);
        cmp.setMinSize(vw.computeSize(-1, -1));
        vw.setObjectID(objectID);
        this.loadData(vw);
        tbi.setText(vw.getTitle());
        this.tbfPreview.setSelection(new TabItem[]{tbi});
        this.btnClose.setEnabled(true);
        this.btnHistory.setEnabled(true);
        this.btnEdit.setEnabled(true);
        this.btnRefresh.setEnabled(true);
    }

    @Override
    public void businessObjectCreated(BusinessObject object, Object ... data) {
    }

    @Override
    public void businessObjectModified(BusinessObject object) {
        for (TabItem tbi : this.tbfPreview.getItems()) {
            VPreview vw = (VPreview)((ScrolledComposite)tbi.getControl()).getContent();
            if (vw instanceof VPersonPreview && object instanceof DomPerson && vw.getObjectID().intValue() == object.getId()) {
                this.loadData(vw);
                return;
            }
            if (vw instanceof VBaptismPreview && object instanceof DomBaptism && vw.getObjectID().intValue() == object.getId()) {
                this.loadData(vw);
                return;
            }
            if (vw instanceof VConfirmationPreview && object instanceof DomConfirmation && vw.getObjectID().intValue() == object.getId()) {
                this.loadData(vw);
                return;
            }
            if (vw instanceof VWeddingPreview && object instanceof DomWedding && vw.getObjectID().intValue() == object.getId()) {
                this.loadData(vw);
                return;
            }
            if (vw instanceof VFuneralPreview && object instanceof DomFuneral && vw.getObjectID().intValue() == object.getId()) {
                this.loadData(vw);
                return;
            }
            if (!(vw instanceof VDonationPreview) || !(object instanceof DomDonation) || vw.getObjectID().intValue() != object.getId()) continue;
            this.loadData(vw);
            return;
        }
    }

    @Override
    public void businessObjectDeleted(BusinessObject object) {
        for (TabItem tbi : this.tbfPreview.getItems()) {
            VPreview vw = (VPreview)((ScrolledComposite)tbi.getControl()).getContent();
            if (vw instanceof VPersonPreview && object instanceof DomPerson && vw.getObjectID().intValue() == object.getId()) {
                tbi.dispose();
                return;
            }
            if (vw instanceof VBaptismPreview && object instanceof DomBaptism && vw.getObjectID().intValue() == object.getId()) {
                tbi.dispose();
                return;
            }
            if (vw instanceof VConfirmationPreview && object instanceof DomConfirmation && vw.getObjectID().intValue() == object.getId()) {
                tbi.dispose();
                return;
            }
            if (vw instanceof VWeddingPreview && object instanceof DomWedding && vw.getObjectID().intValue() == object.getId()) {
                tbi.dispose();
                return;
            }
            if (vw instanceof VFuneralPreview && object instanceof DomFuneral && vw.getObjectID().intValue() == object.getId()) {
                tbi.dispose();
                return;
            }
            if (!(vw instanceof VDonationPreview) || !(object instanceof DomDonation) || vw.getObjectID().intValue() != object.getId()) continue;
            tbi.dispose();
            return;
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        ScrolledComposite c = (ScrolledComposite)this.tbfPreview.getItem(this.tbfPreview.getSelectionIndex()).getControl();
        if (c == null) {
            return;
        }
        VPreview vw = (VPreview)c.getContent();
        if (vw instanceof VPersonPreview) {
            VPersonPreview vwp = (VPersonPreview)vw;
            if (e.getSource() == vwp.getTxtSpouse() && vwp.getSpouse() != null) {
                this.addPerson(vwp.getSpouse().getId());
            } else if (e.getSource() == vwp.getTxtFather() && vwp.getFather() != null) {
                this.addPerson(vwp.getFather().getId());
            } else if (e.getSource() == vwp.getTxtMother() && vwp.getMother() != null) {
                this.addPerson(vwp.getMother().getId());
            } else if (e.getSource() == vwp.getTblChildren() && vwp.getVwrChildren().getSelectedObject() != null) {
                this.addPerson(vwp.getVwrChildren().getSelectedObjectID());
            } else if (e.getSource() == vwp.getTblRelatives() && vwp.getVwrRelatives().getSelectedObject() != null) {
                this.addPerson(vwp.getVwrRelatives().getSelectedObjectID());
            } else if (e.getSource() == vwp.getTblEvents() && vwp.getVwrEvents().getSelectedObject() != null) {
                DomShortEvent event = (DomShortEvent)vwp.getVwrEvents().getSelectedObject();
                switch (event.getType()) {
                    case 0: {
                        this.addBaptism(event.getId());
                        break;
                    }
                    case 1: {
                        this.addConfirmation(event.getId());
                        break;
                    }
                    case 2: {
                        this.addFuneral(event.getId());
                        break;
                    }
                    case 3: {
                        this.addWedding(event.getId());
                    }
                }
            }
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    private void refreshActiveTab() {
        TabItem[] tabs = this.tbfPreview.getSelection();
        if (tabs == null || tabs.length == 0) {
            return;
        }
        final VPreview vw = (VPreview)((ScrolledComposite)tabs[0].getControl()).getContent();
        Operation.run(this.getShell(), true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    p.beginTask(Resources.getMsgString("Load.Loading"), -1);
                    vw.load(p);
                }
                catch (SQLException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("ObjectNotFound"), new Object[0]);
                }
            }
        });
        vw.refresh();
        tabs[0].setText(vw.getTitle());
    }
}

