/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.dao.MAttribute;
import eelk.koguja.gui.FillDtpc;
import eelk.koguja.gui.FuzzyDatePickerSearch;
import eelk.koguja.model.DomAttributeSearch;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomDonationType;
import eelk.koguja.model.DomGroup;
import eelk.koguja.search.PersonExpression;
import eelk.koguja.util.DateProvider;
import eelk.koguja.util.DateUtils;
import eelk.koguja.util.ImageFactory;
import eelk.koguja.util.Resources;
import eelk.koguja.util.ServerDateProvider;
import eelk.koguja.util.Util;
import eelk.koguja.view.VAdvancedSearch;
import eelk.koguja.view.VMain;
import eelk.koguja.viewer.DomComboViewer;
import eelk.koguja.viewer.DomLabelProvider;
import eelk.koguja.viewer.DomTableViewer;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class VPersonSearchAdvanced
extends VAdvancedSearch<PersonExpression>
implements SelectionListener {
    private final DateProvider dateProvider = new ServerDateProvider();
    private Text txtSurename;
    private Text txtGivenName;
    private Text txtIdNumber;
    private Combo cmbCongregation;
    private Button chkFullMemberLastYear;
    private Button chkFullMemberThisYear;
    private Text txtAgeBegin;
    private Text txtAgeEnd;
    private Button chkSexMale;
    private Button chkSexFemale;
    private Text txtDayOfBirthBegin;
    private Text txtDayOfBirthEnd;
    private Text txtMonthOfBirthBegin;
    private Text txtMonthOfBirthEnd;
    private Text txtPlace;
    private Text txtPostal;
    private Text txtNotes;
    private Combo cmbGroup;
    private Text txtDonationFrom;
    private Text txtDonationTo;
    private FuzzyDatePickerSearch dpcDonationDate;
    private FuzzyDatePickerSearch dpcDeathDate;
    private DomComboViewer<DomGroup> vwrGroup;
    private Combo cmbEventType;
    private FuzzyDatePickerSearch dpcEventDate;
    private Combo cmbDonationType;
    private DomComboViewer<DomDonationType> vwrDonationType;
    private DomTableViewer<DomAttributeSearch> vwrAttributes;

    public VPersonSearchAdvanced(Composite parent) {
        super(parent, 0);
    }

    public VPersonSearchAdvanced(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(2, false));
        Group grpPerson = new Group((Composite)this, 0);
        grpPerson.setText(Resources.getString("VPersonSearchAdvanced.grpPerson"));
        grpPerson.setLayout((Layout)new GridLayout(6, false));
        GridData gdata = new GridData(768);
        grpPerson.setLayoutData((Object)gdata);
        grpPerson.pack();
        Group grpAttributes = new Group((Composite)this, 0);
        grpAttributes.setText(Resources.getString("VPersonSearchAdvanced.grpAttributes"));
        grpAttributes.setLayout((Layout)new GridLayout(1, false));
        gdata = new GridData(272);
        gdata.heightHint = grpPerson.getSize().y;
        grpAttributes.setLayoutData((Object)gdata);
        int style = 68356;
        Table tblAttributes = new Table((Composite)grpAttributes, style);
        tblAttributes.setHeaderVisible(true);
        tblAttributes.setLinesVisible(true);
        gdata = new GridData(1808);
        tblAttributes.setLayoutData((Object)gdata);
        TableColumn colUsage = new TableColumn(tblAttributes, 0x1000000);
        colUsage.setText(Resources.getString("VPersonSearchAdvanced.colUsage"));
        colUsage.pack();
        TableColumn colAttributes = new TableColumn(tblAttributes, 16384);
        colAttributes.setText(Resources.getString("VPersonSearchAdvanced.colAttributes"));
        colAttributes.pack();
        DomLabelProvider<DomAttributeSearch> labelProvider = new DomLabelProvider<DomAttributeSearch>(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element == null) {
                    return "";
                }
                DomAttributeSearch m = (DomAttributeSearch)element;
                switch (columnIndex) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return m.getName();
                    }
                }
                return "";
            }

            @Override
            public Image getColumnImage(Object element, int columnIndex) {
                if (element == null) {
                    return null;
                }
                DomAttributeSearch m = (DomAttributeSearch)element;
                switch (columnIndex) {
                    case 0: {
                        return m.isUsedInSearch() ? (m.isYes() ? ImageFactory.getImage(ImageFactory.ImageCollection.CHECK) : ImageFactory.getImage(ImageFactory.ImageCollection.REDX)) : null;
                    }
                    case 1: {
                        return null;
                    }
                }
                return null;
            }
        };
        this.vwrAttributes = new DomTableViewer(tblAttributes, labelProvider);
        TableViewer v = (TableViewer)this.vwrAttributes.getViewer();
        v.setColumnProperties(new String[]{"used_in_search", "name"});
        v.setCellEditors(new CellEditor[]{new CheckboxCellEditor((Composite)tblAttributes), null});
        Label lblSurename = new Label((Composite)grpPerson, 0);
        lblSurename.setText(Resources.getString("VPersonSearchAdvanced.lblSurename"));
        lblSurename.setLayoutData((Object)new GridData(128));
        this.txtSurename = new Text((Composite)grpPerson, 2052);
        this.txtSurename.setLayoutData((Object)new GridData(768));
        Label lblGivenName = new Label((Composite)grpPerson, 0);
        lblGivenName.setText(Resources.getString("VPersonSearchAdvanced.lblGivenName"));
        lblGivenName.setLayoutData((Object)new GridData(128));
        this.txtGivenName = new Text((Composite)grpPerson, 2052);
        this.txtGivenName.setLayoutData((Object)new GridData(768));
        Label lblPlace = new Label((Composite)grpPerson, 0);
        lblPlace.setText(Resources.getString("VPersonSearchAdvanced.lblPlace"));
        lblPlace.setLayoutData((Object)new GridData(128));
        this.txtPlace = new Text((Composite)grpPerson, 2052);
        this.txtPlace.setLayoutData((Object)new GridData(768));
        Label lblGroup = new Label((Composite)grpPerson, 0);
        lblGroup.setText(Resources.getString("VPersonSearchAdvanced.lblGroup"));
        lblGroup.setLayoutData((Object)new GridData(128));
        this.cmbGroup = new Combo((Composite)grpPerson, Combo.LIMIT);
        this.cmbGroup.setLayoutData((Object)new GridData(768));
        this.vwrGroup = new DomComboViewer(this.cmbGroup);
        Label lblIdNumber = new Label((Composite)grpPerson, 0);
        lblIdNumber.setText(Resources.getString("VPersonSearchAdvanced.lblIdNumber"));
        lblIdNumber.setLayoutData((Object)new GridData(128));
        this.txtIdNumber = new Text((Composite)grpPerson, 2052);
        this.txtIdNumber.setLayoutData((Object)new GridData(768));
        Label lblPostal = new Label((Composite)grpPerson, 0);
        lblPostal.setText(Resources.getString("VPersonSearchAdvanced.lblPostal"));
        lblPostal.setLayoutData((Object)new GridData(128));
        this.txtPostal = new Text((Composite)grpPerson, 2052);
        this.txtPostal.setLayoutData((Object)new GridData(768));
        Label lblCongregation = new Label((Composite)grpPerson, 0);
        lblCongregation.setText(Resources.getString("VPersonSearchAdvanced.lblCongregation"));
        lblCongregation.setLayoutData((Object)new GridData(128));
        this.cmbCongregation = new Combo((Composite)grpPerson, Combo.LIMIT);
        this.cmbCongregation.setLayoutData((Object)new GridData(768));
        this.cmbCongregation.addSelectionListener((SelectionListener)this);
        this.vwrCongregation = new DomComboViewer(this.cmbCongregation);
        Composite cmp = new Composite((Composite)grpPerson, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        cmp.setLayoutData((Object)gridData);
        cmp.setLayout((Layout)new GridLayout(2, true));
        this.chkFullMemberLastYear = new Button(cmp, 32);
        this.chkFullMemberLastYear.setLayoutData((Object)new GridData(768));
        this.chkFullMemberLastYear.setEnabled(false);
        this.chkFullMemberThisYear = new Button(cmp, 32);
        this.chkFullMemberThisYear.setLayoutData((Object)new GridData(768));
        this.chkFullMemberThisYear.setEnabled(false);
        Label lblNotes = new Label((Composite)grpPerson, 0);
        lblNotes.setText(Resources.getString("VPersonSearchAdvanced.lblNotes"));
        lblNotes.setLayoutData((Object)new GridData(128));
        this.txtNotes = new Text((Composite)grpPerson, 2052);
        this.txtNotes.setLayoutData((Object)new GridData(768));
        Label lblBirthday = new Label((Composite)grpPerson, 0);
        lblBirthday.setText(Resources.getString("VPersonSearchAdvanced.lblBirthday"));
        GridData data1 = new GridData(130);
        lblBirthday.setLayoutData((Object)data1);
        Composite cmpBDayPane = new Composite((Composite)grpPerson, 0);
        GridLayout bDayLayout = new GridLayout(5, false);
        bDayLayout.marginWidth = 0;
        bDayLayout.marginHeight = 0;
        cmpBDayPane.setLayout((Layout)bDayLayout);
        data1 = new GridData(770);
        cmpBDayPane.setLayoutData((Object)data1);
        GridData dataB = new GridData(768);
        dataB.widthHint = 15;
        dataB.grabExcessHorizontalSpace = true;
        this.txtDayOfBirthBegin = new Text(cmpBDayPane, 2052);
        this.txtDayOfBirthBegin.setLayoutData((Object)dataB);
        this.txtMonthOfBirthBegin = new Text(cmpBDayPane, 2052);
        this.txtMonthOfBirthBegin.setLayoutData((Object)dataB);
        Label lblLine2 = new Label(cmpBDayPane, 0);
        lblLine2.setText("-");
        this.txtDayOfBirthEnd = new Text(cmpBDayPane, 2052);
        this.txtDayOfBirthEnd.setLayoutData((Object)dataB);
        this.txtMonthOfBirthEnd = new Text(cmpBDayPane, 2052);
        this.txtMonthOfBirthEnd.setLayoutData((Object)dataB);
        this.txtMonthOfBirthBegin.setTextLimit(2);
        this.txtMonthOfBirthEnd.setTextLimit(2);
        this.txtDayOfBirthBegin.setTextLimit(2);
        this.txtDayOfBirthEnd.setTextLimit(2);
        this.createSexComposite(grpPerson);
        Label lblDeathDate = new Label((Composite)grpPerson, 0);
        lblDeathDate.setText(Resources.getString("VPersonSearchAdvanced.lblDeathDate"));
        lblDeathDate.setLayoutData((Object)new GridData(128));
        this.dpcDeathDate = new FuzzyDatePickerSearch((Composite)grpPerson, 2048);
        GridLayout deathLayout = new GridLayout(3, false);
        deathLayout.marginWidth = 0;
        deathLayout.marginHeight = 0;
        GridData deathDateData = new GridData(768);
        deathDateData.grabExcessHorizontalSpace = true;
        this.dpcDeathDate.setLayout((Layout)deathLayout);
        this.dpcDeathDate.setLayoutData(deathDateData);
        Label lblDonation = new Label((Composite)grpPerson, 0);
        lblDonation.setText(Resources.getString("VPersonSearchAdvanced.lblDonation"));
        lblDonation.setLayoutData((Object)new GridData(128));
        Composite donation = new Composite((Composite)grpPerson, 0);
        GridLayout donLayout2 = new GridLayout(3, false);
        donLayout2.marginWidth = 0;
        donLayout2.marginHeight = 0;
        donation.setLayout((Layout)donLayout2);
        donation.setLayoutData((Object)new GridData(768));
        GridData donData = new GridData(768);
        donData.grabExcessHorizontalSpace = true;
        donData.widthHint = 5;
        this.txtDonationFrom = new Text(donation, 2052);
        this.txtDonationFrom.setTextLimit(12);
        this.txtDonationFrom.setLayoutData((Object)donData);
        Label lblLine3 = new Label(donation, 0);
        lblLine3.setText("-");
        this.txtDonationTo = new Text(donation, 2052);
        this.txtDonationTo.setTextLimit(12);
        this.txtDonationTo.setLayoutData((Object)donData);
        Label lblDonationDate = new Label((Composite)grpPerson, 0);
        lblDonationDate.setText(Resources.getString("VPersonSearchAdvanced.lblDonationDate"));
        lblDonationDate.setLayoutData((Object)new GridData(128));
        this.dpcDonationDate = new FuzzyDatePickerSearch((Composite)grpPerson, 2048);
        GridLayout donLayout = new GridLayout(3, false);
        donLayout.marginWidth = 0;
        donLayout.marginHeight = 0;
        this.dpcDonationDate.setLayout((Layout)donLayout);
        GridData donDateData = new GridData(768);
        donDateData.grabExcessVerticalSpace = false;
        this.dpcDonationDate.setLayoutData(donDateData);
        Label lblAge = new Label((Composite)grpPerson, 0);
        lblAge.setText(Resources.getString("VPersonSearchAdvanced.lblAge"));
        lblAge.setLayoutData((Object)new GridData(128));
        Composite age = new Composite((Composite)grpPerson, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        age.setLayout((Layout)layout);
        age.setLayoutData((Object)new GridData(768));
        GridData ageData = new GridData(768);
        ageData.widthHint = 5;
        ageData.grabExcessHorizontalSpace = true;
        this.txtAgeBegin = new Text(age, 2052);
        this.txtAgeBegin.setLayoutData((Object)ageData);
        Label lblLine1 = new Label(age, 0);
        lblLine1.setText("-");
        this.txtAgeEnd = new Text(age, 2052);
        this.txtAgeEnd.setLayoutData((Object)ageData);
        this.createDonationTypeFields(grpPerson);
        Label lblEventType = new Label((Composite)grpPerson, 0);
        lblEventType.setText(Resources.getString("VPersonSearchAdvanced.lblEventType"));
        lblEventType.setLayoutData((Object)new GridData(128));
        this.cmbEventType = new Combo((Composite)grpPerson, Combo.LIMIT);
        this.cmbEventType.setLayoutData((Object)new GridData(768));
        this.cmbEventType.addSelectionListener((SelectionListener)this);
        Label lblEventDate = new Label((Composite)grpPerson, 0);
        lblEventDate.setText(Resources.getString("VPersonSearchAdvanced.lblEventDate"));
        lblEventDate.setLayoutData((Object)new GridData(128));
        this.dpcEventDate = new FuzzyDatePickerSearch((Composite)grpPerson, 2048);
        GridLayout eventLayout = new GridLayout(3, false);
        eventLayout.marginWidth = 0;
        eventLayout.marginHeight = 0;
        GridData eventDateData = new GridData(768);
        eventDateData.grabExcessHorizontalSpace = true;
        this.dpcEventDate.setLayout((Layout)eventLayout);
        this.dpcEventDate.setLayoutData(eventDateData);
        Calendar defaultDate = Calendar.getInstance();
        defaultDate.setTime(new Date());
        defaultDate.set(2, 0);
        defaultDate.set(5, 1);
        new FillDtpc(this.dpcDonationDate, defaultDate.getTime());
        this.updateControls();
    }

    private void createSexComposite(Group parent) {
        Label lblSex = new Label((Composite)parent, 0);
        lblSex.setText(Resources.getString("VPersonSearchAdvanced.lblSex"));
        lblSex.setLayoutData((Object)new GridData(132));
        Composite sexComposite = new Composite((Composite)parent, 0);
        GridLayout sexLayout = new GridLayout(3, false);
        sexLayout.marginWidth = 0;
        sexLayout.marginHeight = 0;
        sexComposite.setLayout((Layout)sexLayout);
        sexComposite.setLayoutData((Object)new GridData(768));
        this.chkSexMale = new Button(sexComposite, 32);
        this.chkSexMale.setText(Resources.getString("VPersonSearchAdvanced.chkSexMale"));
        this.chkSexMale.setLayoutData((Object)new GridData(64));
        this.chkSexMale.addSelectionListener((SelectionListener)this);
        this.chkSexFemale = new Button(sexComposite, 32);
        this.chkSexFemale.setText(Resources.getString("VPersonSearchAdvanced.chkSexFemale"));
        this.chkSexFemale.setLayoutData((Object)new GridData(128));
        this.chkSexFemale.addSelectionListener((SelectionListener)this);
    }

    private void createDonationTypeFields(Group parent) {
        Label lblDonationType = new Label((Composite)parent, 0);
        lblDonationType.setText(Resources.getString("VPersonSearchAdvanced.lblDonationType"));
        lblDonationType.setLayoutData((Object)new GridData(132));
        this.cmbDonationType = new Combo((Composite)parent, Combo.LIMIT);
        this.cmbDonationType.setLayoutData((Object)new GridData(768));
        this.cmbDonationType.addSelectionListener((SelectionListener)this);
        this.vwrDonationType = new DomComboViewer(this.cmbDonationType);
    }

    @Override
    public void fillExp(PersonExpression e) {
        if (e == null) {
            return;
        }
        e.lastName.setValue(Util.c(this.txtSurename.getText()));
        e.firstName.setValue(Util.c(this.txtGivenName.getText()));
        e.code.setValue(Util.c(this.txtIdNumber.getText()));
        DomCongregation d = (DomCongregation)this.vwrCongregation.getSelectedObject();
        e.congregation.setValue(d == null || this.cmbCongregation.getSelectionIndex() <= 0 ? null : Integer.valueOf(d.getId()));
        e.fullMemberLastYear.setValue(this.chkFullMemberLastYear.getSelection());
        e.fullMemberThisYear.setValue(this.chkFullMemberThisYear.getSelection());
        e.ageFrom.setValue(Util.i(this.txtAgeBegin.getText()));
        e.ageTo.setValue(Util.i(this.txtAgeEnd.getText()));
        e.dayOfBirthFrom.setValue(Util.i(this.txtDayOfBirthBegin.getText()));
        e.dayOfBirthTo.setValue(Util.i(this.txtDayOfBirthEnd.getText()));
        e.monthOfBirthFrom.setValue(Util.i(this.txtMonthOfBirthBegin.getText()));
        e.monthOfBirthTo.setValue(Util.i(this.txtMonthOfBirthEnd.getText()));
        e.city.setValue(Util.c(this.txtPlace.getText()));
        e.postcode.setValue(Util.c(this.txtPostal.getText()));
        e.comment.setValue(Util.c(this.txtNotes.getText()));
        DomGroup g = (DomGroup)this.vwrGroup.getSelectedObject();
        e.group.setValue(g == null || this.cmbGroup.getSelectionIndex() <= 0 ? null : Integer.valueOf(g.getId()));
        e.donationFrom.setValue(Util.strToFloat(this.txtDonationFrom.getText()));
        e.donationTo.setValue(Util.strToFloat(this.txtDonationTo.getText()));
        e.donationDateFrom.setValue(this.dpcDonationDate.getSqlDate());
        e.donationDateTo.setValue(this.dpcDonationDate.getSqlFuzzyDate());
        DomDonationType donationType = (DomDonationType)this.vwrDonationType.getSelectedObject();
        e.donationType.setValue(donationType == null || this.cmbDonationType.getSelectionIndex() <= 0 ? null : Integer.valueOf(donationType.getId()));
        e.deathDateFrom.setValue(this.dpcDeathDate.getSqlDate());
        e.deathDateTo.setValue(this.dpcDeathDate.getSqlFuzzyDate());
        e.eventType.setValue(this.cmbEventType.getSelectionIndex() <= 0 ? null : Integer.valueOf(this.cmbEventType.getSelectionIndex()));
        e.eventDateFrom.setValue(this.dpcEventDate.getSqlDate());
        e.eventDateTo.setValue(this.dpcEventDate.getSqlFuzzyDate());
        if (this.chkSexMale.getSelection()) {
            e.sex.setValue(0);
        } else if (this.chkSexFemale.getSelection()) {
            e.sex.setValue(1);
        } else {
            e.sex.setValue(null);
        }
        List modified = this.vwrAttributes.getSource();
        StringBuilder positiveAttr = new StringBuilder();
        StringBuilder negativeAttr = new StringBuilder();
        for (DomAttributeSearch element : modified) {
            if (element.isUsedInSearch() && element.isYes()) {
                positiveAttr.append(element.getId()).append(";");
            }
            if (!element.isUsedInSearch() || element.isYes()) continue;
            negativeAttr.append(element.getId()).append(";");
        }
        e.positiveAttributes.setValue(Util.c(positiveAttr.toString()));
        e.negativeAttributes.setValue(Util.c(negativeAttr.toString()));
    }

    @Override
    public void loadExp(PersonExpression e) {
        int i;
        StringTokenizer st;
        if (e == null) {
            return;
        }
        this.txtSurename.setText(Util.d((String)e.lastName.getValue()));
        this.txtGivenName.setText(Util.d((String)e.firstName.getValue()));
        this.txtIdNumber.setText(Util.d((String)e.code.getValue()));
        this.vwrCongregation.setSelectedObject((Integer)e.congregation.getValue());
        if (e.congregation.getValue() == null) {
            this.chkFullMemberLastYear.setSelection(false);
            this.chkFullMemberThisYear.setSelection(false);
        } else {
            if (e.fullMemberLastYear.getValue() == null) {
                this.chkFullMemberLastYear.setSelection(false);
            } else {
                this.chkFullMemberLastYear.setSelection(((Boolean)e.fullMemberLastYear.getValue()).booleanValue());
            }
            if (e.fullMemberThisYear.getValue() == null) {
                this.chkFullMemberThisYear.setSelection(false);
            } else {
                this.chkFullMemberThisYear.setSelection(((Boolean)e.fullMemberThisYear.getValue()).booleanValue());
            }
        }
        this.txtAgeBegin.setText(Util.dInt((Integer)e.ageFrom.getValue()));
        this.txtAgeEnd.setText(Util.dInt((Integer)e.ageTo.getValue()));
        this.txtDayOfBirthBegin.setText(Util.dInt((Integer)e.dayOfBirthFrom.getValue()));
        this.txtMonthOfBirthBegin.setText(Util.dInt((Integer)e.monthOfBirthFrom.getValue()));
        this.txtDayOfBirthEnd.setText(Util.dInt((Integer)e.dayOfBirthTo.getValue()));
        this.txtMonthOfBirthEnd.setText(Util.dInt((Integer)e.monthOfBirthTo.getValue()));
        this.txtPlace.setText(Util.d((String)e.city.getValue()));
        this.txtPostal.setText(Util.d((String)e.postcode.getValue()));
        this.txtNotes.setText(Util.d((String)e.comment.getValue()));
        this.txtDonationFrom.setText(Util.floatToStr((Float)e.donationFrom.getValue()));
        this.txtDonationTo.setText(Util.floatToStr((Float)e.donationTo.getValue()));
        this.dpcDonationDate.setDate((Date)e.donationDateFrom.getValue());
        this.dpcDonationDate.setFuzzyDate((Date)e.donationDateTo.getValue());
        this.vwrDonationType.setSelectedObject((Integer)e.donationType.getValue());
        this.dpcDeathDate.setDate((Date)e.deathDateFrom.getValue());
        this.dpcDeathDate.setFuzzyDate((Date)e.deathDateTo.getValue());
        if (e.eventType.getValue() != null) {
            this.cmbEventType.select(((Integer)e.eventType.getValue()).intValue());
        } else {
            this.cmbEventType.select(-1);
        }
        this.dpcEventDate.setDate((Date)e.eventDateFrom.getValue());
        this.dpcEventDate.setFuzzyDate((Date)e.eventDateTo.getValue());
        if (e.sex.getValue() == null || (Integer)e.sex.getValue() != 0 && (Integer)e.sex.getValue() != 1) {
            this.chkSexMale.setSelection(false);
            this.chkSexFemale.setSelection(false);
        } else if ((Integer)e.sex.getValue() == 0) {
            this.chkSexMale.setSelection(true);
            this.chkSexFemale.setSelection(false);
        } else if ((Integer)e.sex.getValue() == 1) {
            this.chkSexFemale.setSelection(true);
            this.chkSexMale.setSelection(false);
        }
        if (this.vwrCongregation.getSelectedObject() == null || this.cmbCongregation.getSelectionIndex() <= 0) {
            this.chkFullMemberLastYear.setEnabled(false);
            this.chkFullMemberThisYear.setEnabled(false);
        }
        this.vwrGroup.setSelectedObject((Integer)e.group.getValue());
        List<DomAttributeSearch> atrList = MAttribute.instance().getCashedSearchAttributes();
        String attributes = (String)e.negativeAttributes.getValue();
        if (attributes != null) {
            st = new StringTokenizer(attributes, ";");
            while (st.hasMoreTokens()) {
                i = Integer.parseInt(st.nextToken());
                for (DomAttributeSearch attribute : atrList) {
                    if (attribute.getId() != i) continue;
                    attribute.setUsedInSearch(true);
                    attribute.setYes(false);
                }
            }
        }
        if ((attributes = (String)e.positiveAttributes.getValue()) != null) {
            st = new StringTokenizer(attributes, ";");
            while (st.hasMoreTokens()) {
                i = Integer.parseInt(st.nextToken());
                for (DomAttributeSearch attribute : atrList) {
                    if (attribute.getId() != i) continue;
                    attribute.setUsedInSearch(true);
                    attribute.setYes(true);
                }
            }
        }
        this.vwrAttributes.setSource(atrList);
        this.vwrAttributes.getViewer().refresh();
    }

    @Override
    public PersonExpression createExp() {
        return new PersonExpression();
    }

    public void setGroups(List<DomGroup> groups) {
        this.vwrGroup.setSource(groups);
    }

    public void setEventTypes(List<String> eventTypes) {
        eventTypes.add(0, "");
        String[] a = new String[eventTypes.size()];
        eventTypes.toArray(a);
        this.cmbEventType.setItems(a);
    }

    public void setAttributes(List<DomAttributeSearch> attributes) {
        this.vwrAttributes.setSource(attributes);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.cmbCongregation == e.getSource()) {
            boolean fullMemberEnabled = this.vwrCongregation.getSelectedObject() != null && this.cmbCongregation.getSelectionIndex() > 0;
            this.chkFullMemberLastYear.setEnabled(fullMemberEnabled);
            this.chkFullMemberThisYear.setEnabled(fullMemberEnabled);
        } else if (this.chkSexMale == e.getSource()) {
            this.chkSexFemale.setSelection(false);
        } else if (this.chkSexFemale == e.getSource()) {
            this.chkSexMale.setSelection(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    public VMain.SearchMode getMode() {
        return VMain.SearchMode.PERSON;
    }

    @Override
    public void updateControls() {
        Date date = this.dateProvider != null ? this.dateProvider.getDate() : null;
        date = date != null ? date : Calendar.getInstance().getTime();
        this.chkFullMemberLastYear.setText(DateUtils.getYear(date) - 1 + " " + Resources.getString("VPersonSearchAdvanced.chkFullMember"));
        this.chkFullMemberThisYear.setText(DateUtils.getYear(date) + " " + Resources.getString("VPersonSearchAdvanced.chkFullMember"));
    }

    @Override
    protected void fillStandardList() {
    }

    void setDonationTypes(List<DomDonationType> donationTypes) {
        this.vwrDonationType.setSource(donationTypes);
    }
}

