/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MDonation;
import eelk.koguja.dao.MGroupSwt;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.gui.DiffText;
import eelk.koguja.gui.TableEx;
import eelk.koguja.model.DomAddress;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomDonationWithTypeName;
import eelk.koguja.model.DomDonationsSum;
import eelk.koguja.model.DomEventState;
import eelk.koguja.model.DomGroupMember;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.DomPersonEventHistory;
import eelk.koguja.model.DomPersonHistory;
import eelk.koguja.model.DomPersonWithRelationType;
import eelk.koguja.model.DomShortEvent;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.Currencies;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.VPreview;
import eelk.koguja.viewer.AbstractSorter;
import eelk.koguja.viewer.DomLabelProvider;
import eelk.koguja.viewer.DomTableViewer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class VPersonPreview
extends VPreview {
    private DomPerson selectedPerson;
    private DomAddress address;
    private DomCongregation congregation;
    private List<DomGroupMember> groupMemberships;
    private DomTableViewer<DomGroupMember> vwrGroups;
    private List<DomShortEvent> events;
    private DomTableViewer<DomShortEvent> vwrEvents;
    private List<DomPersonEventHistory> history;
    private DomTableViewer<DomPersonEventHistory> vwrHistory;
    private List<DomPersonHistory> personHistory;
    private DomPerson spouse;
    private DomPerson father;
    private DomPerson mother;
    private List<DomPerson> children;
    private DomTableViewer<DomPerson> vwrChildren;
    private List<DomPersonWithRelationType> relatives;
    private DomTableViewer<DomPersonWithRelationType> vwrRelatives;
    private List<DomDonationsSum> donations;
    private DomTableViewer<DomDonationsSum> vwrDonations;
    private DiffText diffLastName;
    private DiffText diffFirstName;
    private DiffText diffCode;
    private DiffText diffBirthDate;
    private DiffText diffPhone;
    private DiffText diffEmail;
    private DiffText diffLink;
    private Text txtSurename;
    private Text txtGivenName;
    private Text txtIdNumber;
    private Text txtDateOfBirth;
    private Text txtCongregation;
    private Text txtAddress;
    private Text txtPhone;
    private Text txtEmail;
    private Text txtLink;
    private Text txtSpouse;
    private Text txtMother;
    private Text txtFather;
    private TableEx tblEvents;
    private TableEx tblChildren;
    private TableEx tblRelatives;

    public VPersonPreview(Composite parent) {
        super(parent, 0);
    }

    public VPersonPreview(Composite parent, int style) {
        super(parent, style);
    }

    protected AbstractSorter naturalOrderSorter() {
        return new AbstractSorter(){

            @Override
            public Comparable getSortValue(Object o, int column) {
                if (o == null) {
                    return null;
                }
                switch (column) {
                    case 0: {
                        if (o instanceof DomDonationWithTypeName) {
                            return ((DomDonationWithTypeName)o).getDonationDate();
                        }
                        if (o instanceof DomShortEvent) {
                            return DomShortEvent.nameOf(((DomShortEvent)o).getType());
                        }
                        if (o instanceof DomPersonEventHistory) {
                            return ((DomPersonEventHistory)o).getEventDate();
                        }
                        return null;
                    }
                    case 1: {
                        if (o instanceof DomDonationWithTypeName) {
                            return ((DomDonationWithTypeName)o).getAmount();
                        }
                        if (o instanceof DomShortEvent) {
                            return ((DomShortEvent)o).getEventDate();
                        }
                        if (o instanceof DomPersonEventHistory) {
                            return DomPersonEventHistory.nameOfEvent(((DomPersonEventHistory)o).getEventType());
                        }
                        return null;
                    }
                    case 2: {
                        if (o instanceof DomDonationWithTypeName) {
                            return ((DomDonationWithTypeName)o).getTypeName();
                        }
                        if (o instanceof DomShortEvent) {
                            return DomEventState.nameOf(((DomShortEvent)o).getType(), ((DomShortEvent)o).getState());
                        }
                        if (o instanceof DomPersonEventHistory) {
                            return DomPersonEventHistory.nameOfTime(((DomPersonEventHistory)o).getTimeType(), ((DomPersonEventHistory)o).getEventType(), ((DomPersonEventHistory)o).getTargetName());
                        }
                        return null;
                    }
                }
                return null;
            }
        };
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new FormLayout());
        Composite cmpLeft = new Composite((Composite)this, 0);
        cmpLeft.setLayout((Layout)new GridLayout(2, false));
        Composite cmpCenter = new Composite((Composite)this, 0);
        cmpCenter.setLayout((Layout)new GridLayout(4, false));
        Composite cmpRight = new Composite((Composite)this, 0);
        cmpRight.setLayout((Layout)new FormLayout());
        FormData fData = new FormData();
        fData.top = new FormAttachment(0, 0);
        fData.bottom = new FormAttachment(100, 0);
        fData.left = new FormAttachment(0, 0);
        fData.right = new FormAttachment(25, 0);
        cmpLeft.setLayoutData((Object)fData);
        fData = new FormData();
        fData.top = new FormAttachment(0, 0);
        fData.bottom = new FormAttachment(100, 0);
        fData.left = new FormAttachment(25, 2);
        fData.right = new FormAttachment(70, 0);
        cmpCenter.setLayoutData((Object)fData);
        fData = new FormData();
        fData.top = new FormAttachment(0, 0);
        fData.bottom = new FormAttachment(100, 0);
        fData.left = new FormAttachment(70, 2);
        fData.right = new FormAttachment(100, 0);
        cmpRight.setLayoutData((Object)fData);
        Label lblSurename = new Label(cmpLeft, 0);
        lblSurename.setText(Resources.getString("VPersonPreview.lblSurename"));
        lblSurename.setLayoutData((Object)new GridData(128));
        this.txtSurename = new Text(cmpLeft, 2052);
        this.txtSurename.setLayoutData((Object)new GridData(768));
        this.txtSurename.setEditable(false);
        Label lblGivenName = new Label(cmpLeft, 0);
        lblGivenName.setText(Resources.getString("VPersonPreview.lblGivenName"));
        lblGivenName.setLayoutData((Object)new GridData(128));
        this.txtGivenName = new Text(cmpLeft, 2052);
        this.txtGivenName.setLayoutData((Object)new GridData(768));
        this.txtGivenName.setEditable(false);
        Label lblIdNumber = new Label(cmpLeft, 0);
        lblIdNumber.setText(Resources.getString("VPersonPreview.lblIdNumber"));
        lblIdNumber.setLayoutData((Object)new GridData(128));
        this.txtIdNumber = new Text(cmpLeft, 2052);
        this.txtIdNumber.setLayoutData((Object)new GridData(768));
        this.txtIdNumber.setEditable(false);
        Label lblDateOfBirth = new Label(cmpLeft, 0);
        lblDateOfBirth.setText(Resources.getString("VPersonPreview.lblDateOfBirth"));
        lblDateOfBirth.setLayoutData((Object)new GridData(128));
        this.txtDateOfBirth = new Text(cmpLeft, 2052);
        this.txtDateOfBirth.setLayoutData((Object)new GridData(768));
        this.txtDateOfBirth.setEditable(false);
        Label lblCongregation = new Label(cmpLeft, 0);
        lblCongregation.setText(Resources.getString("VPersonPreview.lblCongregation"));
        lblCongregation.setLayoutData((Object)new GridData(128));
        this.txtCongregation = new Text(cmpLeft, 2052);
        this.txtCongregation.setLayoutData((Object)new GridData(768));
        this.txtCongregation.setEditable(false);
        Label lblAddress = new Label(cmpLeft, 0);
        lblAddress.setText(Resources.getString("VPersonPreview.lblAddress"));
        lblAddress.setLayoutData((Object)new GridData(130));
        this.txtAddress = new Text(cmpLeft, 2050);
        this.txtAddress.setLayoutData((Object)new GridData(768));
        this.txtAddress.setEditable(false);
        Label lblPhone = new Label(cmpLeft, 0);
        lblPhone.setText(Resources.getString("VPersonPreview.lblPhone"));
        lblPhone.setLayoutData((Object)new GridData(128));
        this.txtPhone = new Text(cmpLeft, 2048);
        this.txtPhone.setLayoutData((Object)new GridData(768));
        this.txtPhone.setEditable(false);
        MouseListener execute = new MouseListener(){

            public void mouseUp(MouseEvent m) {
            }

            public void mouseDown(MouseEvent m) {
            }

            public void mouseDoubleClick(MouseEvent m) {
                String run = m.getSource() == VPersonPreview.this.txtEmail ? "mailto:" + VPersonPreview.this.txtEmail.getText() : VPersonPreview.this.txtLink.getText();
                try {
                    Runtime.getRuntime().exec("cmd.exe /c start " + run);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        Label lblEmail = new Label(cmpLeft, 0);
        lblEmail.setText(Resources.getString("VPersonPreview.lblEmail"));
        lblEmail.setLayoutData((Object)new GridData(128));
        this.txtEmail = new Text(cmpLeft, 2048);
        this.txtEmail.setLayoutData((Object)new GridData(768));
        this.txtEmail.setEditable(false);
        this.txtEmail.addMouseListener(execute);
        Label lblLink = new Label(cmpLeft, 0);
        lblLink.setText(Resources.getString("VPersonPreview.lblLink"));
        lblLink.setLayoutData((Object)new GridData(128));
        this.txtLink = new Text(cmpLeft, 2048);
        this.txtLink.setLayoutData((Object)new GridData(768));
        this.txtLink.setEditable(false);
        this.txtLink.addMouseListener(execute);
        Label lblDonations = new Label(cmpLeft, 0);
        lblDonations.setText(Resources.getString("VPersonPreview.lblDonations"));
        lblDonations.setLayoutData((Object)new GridData(130));
        TableEx tblDonations = new TableEx(cmpLeft, 67584);
        tblDonations.setHeaderVisible(true);
        tblDonations.setLayoutData(new GridData(1808));
        tblDonations.setLinesVisible(true);
        TableColumn colDonationDate = new TableColumn(tblDonations.getTable(), 0);
        colDonationDate.setText(Resources.getString("VPersonPreview.colDonationDate"));
        colDonationDate.pack();
        TableColumn colDonationAmount = new TableColumn(tblDonations.getTable(), 0);
        colDonationAmount.setText(Resources.getString("VPersonPreview.colDonationAmount"));
        colDonationAmount.pack();
        TableColumn colDonationType = new TableColumn(tblDonations.getTable(), 0);
        colDonationType.setText(Resources.getString("VPersonPreview.colDonationType"));
        colDonationType.pack();
        tblDonations.setColMaxWidths(50, 50, 50);
        DomLabelProvider<DomDonationsSum> donationsLabelProvider = new DomLabelProvider<DomDonationsSum>(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element == null) {
                    return "";
                }
                DomDonationsSum m = (DomDonationsSum)element;
                switch (columnIndex) {
                    case 0: {
                        return m.getDate();
                    }
                    case 1: {
                        String amount;
                        Date date = Util.strToDate(m.getDate());
                        boolean isDonationInEuros = false;
                        if (m.getAmount() != null) {
                            if (date != null || Util.c(m.getDate()) == null) {
                                if (Currencies.isEuroDate(date)) {
                                    isDonationInEuros = true;
                                }
                            } else {
                                Integer year = Util.i(m.getDate());
                                if (year == null || Currencies.isEuroDate(new GregorianCalendar(year, 1, 1).getTime())) {
                                    isDonationInEuros = true;
                                }
                            }
                            if (isDonationInEuros) {
                                String amountInEur = String.valueOf(m.getAmount());
                                amount = String.format("%s %s", amountInEur, "\u20ac");
                            } else {
                                String amountInEek = String.valueOf(m.getAmount());
                                String amountInEur = String.valueOf(Currencies.getEekInEur(m.getAmount()));
                                amount = String.format("%s %s (%s%s)", amountInEek, "kr", amountInEur, "\u20ac");
                            }
                        } else {
                            amount = m.getDonationObject();
                        }
                        return amount;
                    }
                    case 2: {
                        return m.getTypeName();
                    }
                }
                return "";
            }
        };
        this.vwrDonations = new DomTableViewer(tblDonations.getTable(), donationsLabelProvider, this.naturalOrderSorter());
        Label lblEvents = new Label(cmpCenter, 0);
        lblEvents.setText(Resources.getString("VPersonPreview.lblEvents"));
        lblEvents.setLayoutData((Object)new GridData(130));
        this.tblEvents = new TableEx(cmpCenter, 67584);
        this.tblEvents.setHeaderVisible(true);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        this.tblEvents.setLayoutData(data);
        this.tblEvents.setLinesVisible(true);
        TableColumn colEventsEvent = new TableColumn(this.tblEvents.getTable(), 0);
        colEventsEvent.setText(Resources.getString("VPersonPreview.colEventsEvent"));
        colEventsEvent.pack();
        TableColumn colEventsDate = new TableColumn(this.tblEvents.getTable(), 0);
        colEventsDate.setText(Resources.getString("VPersonPreview.colEventsDate"));
        colEventsDate.pack();
        TableColumn colEventsState = new TableColumn(this.tblEvents.getTable(), 0);
        colEventsState.setText(Resources.getString("VPersonPreview.colEventsState"));
        colEventsState.pack();
        this.tblEvents.setColMaxWidths(40, 40, 40);
        DomLabelProvider<DomShortEvent> eventLabelProvider = new DomLabelProvider<DomShortEvent>(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element == null) {
                    return "";
                }
                DomShortEvent m = (DomShortEvent)element;
                switch (columnIndex) {
                    case 0: {
                        return DomShortEvent.nameOf(m.getType());
                    }
                    case 1: {
                        return Util.dateToStr(m.getEventDate()) + (m.getEventDateFuzzyEnd() != null ? " - " + Util.dateToStr(m.getEventDateFuzzyEnd()) : "");
                    }
                    case 2: {
                        return DomEventState.nameOf(m.getType(), m.getState());
                    }
                }
                return "";
            }
        };
        this.vwrEvents = new DomTableViewer(this.tblEvents.getTable(), eventLabelProvider, this.naturalOrderSorter());
        Label lblSpouse = new Label(cmpCenter, 0);
        lblSpouse.setText(Resources.getString("VPersonPreview.lblSpouse"));
        lblSpouse.setLayoutData((Object)new GridData(128));
        this.txtSpouse = new Text(cmpCenter, 2052);
        this.txtSpouse.setLayoutData((Object)new GridData(768));
        this.txtSpouse.setEditable(false);
        Label lblChildren = new Label(cmpCenter, 0);
        lblChildren.setText(Resources.getString("VPersonPreview.lblChildren"));
        data = new GridData(130);
        data.verticalSpan = 3;
        lblChildren.setLayoutData((Object)data);
        this.tblChildren = new TableEx(cmpCenter, 67584);
        this.tblChildren.setHeaderVisible(true);
        data = new GridData(1808);
        data.verticalSpan = 3;
        data.minimumHeight = 50;
        this.tblChildren.setLayoutData(data);
        this.tblChildren.setLinesVisible(true);
        TableColumn colChildrenName = new TableColumn(this.tblChildren.getTable(), 0);
        colChildrenName.setText(Resources.getString("VPersonPreview.colChildrenName"));
        colChildrenName.pack();
        this.tblChildren.setColMaxWidths(40);
        this.vwrChildren = new DomTableViewer(this.tblChildren.getTable());
        Label lblMother = new Label(cmpCenter, 0);
        lblMother.setText(Resources.getString("VPersonPreview.lblMother"));
        lblMother.setLayoutData((Object)new GridData(128));
        this.txtMother = new Text(cmpCenter, 2052);
        this.txtMother.setLayoutData((Object)new GridData(768));
        this.txtMother.setEditable(false);
        Label lblFather = new Label(cmpCenter, 0);
        lblFather.setText(Resources.getString("VPersonPreview.lblFather"));
        lblFather.setLayoutData((Object)new GridData(130));
        this.txtFather = new Text(cmpCenter, 2052);
        this.txtFather.setLayoutData((Object)new GridData(770));
        this.txtFather.setEditable(false);
        Label lblRelatives = new Label(cmpCenter, 0);
        lblRelatives.setText(Resources.getString("VPersonPreview.lblRelatives"));
        lblRelatives.setLayoutData((Object)new GridData(130));
        this.tblRelatives = new TableEx(cmpCenter, 67584);
        this.tblRelatives.setHeaderVisible(true);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        data.minimumHeight = 50;
        this.tblRelatives.setLayoutData(data);
        this.tblRelatives.setLinesVisible(true);
        TableColumn colRelativesName = new TableColumn(this.tblRelatives.getTable(), 0);
        colRelativesName.setText(Resources.getString("VPersonPreview.colRelativesName"));
        colRelativesName.pack();
        TableColumn colRelativesRelation = new TableColumn(this.tblRelatives.getTable(), 0);
        colRelativesRelation.setText(Resources.getString("VPersonPreview.colRelativesRelation"));
        colRelativesRelation.pack();
        this.tblRelatives.setColMaxWidths(40, 40);
        DomLabelProvider<DomPersonWithRelationType> relativeLabelProvider = new DomLabelProvider<DomPersonWithRelationType>(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element == null) {
                    return "";
                }
                DomPersonWithRelationType m = (DomPersonWithRelationType)element;
                switch (columnIndex) {
                    case 0: {
                        return m.getFirstName() + " " + m.getLastName();
                    }
                    case 1: {
                        return m.getRelationshipName();
                    }
                }
                return "";
            }
        };
        this.vwrRelatives = new DomTableViewer(this.tblRelatives.getTable(), relativeLabelProvider);
        Label lblGroups = new Label(cmpRight, 0);
        lblGroups.setText(Resources.getString("VPersonPreview.lblGroups"));
        TableEx tblGroups = new TableEx(cmpRight, 67584);
        tblGroups.setHeaderVisible(true);
        tblGroups.setLinesVisible(true);
        TableColumn colGroupsGroup = new TableColumn(tblGroups.getTable(), 0);
        colGroupsGroup.setText(Resources.getString("VPersonPreview.colGroupsGroup"));
        colGroupsGroup.pack();
        TableColumn colGroupsRole = new TableColumn(tblGroups.getTable(), 0);
        colGroupsRole.setText(Resources.getString("VPersonPreview.colGroupsRole"));
        colGroupsRole.pack();
        tblGroups.setColMaxWidths(40, 40);
        DomLabelProvider<DomGroupMember> groupLabelProvider = new DomLabelProvider<DomGroupMember>(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element == null) {
                    return "";
                }
                DomGroupMember m = (DomGroupMember)element;
                switch (columnIndex) {
                    case 0: {
                        return m.getGroupName();
                    }
                    case 1: {
                        return m.getRoleName();
                    }
                }
                return "";
            }
        };
        this.vwrGroups = new DomTableViewer(tblGroups.getTable(), groupLabelProvider);
        Label lblHistory = new Label(cmpRight, 0);
        lblHistory.setText(Resources.getString("VPersonPreview.lblHistory"));
        TableEx tblHistory = new TableEx(cmpRight, 67584);
        tblHistory.setHeaderVisible(true);
        fData = new FormData();
        fData.left = new FormAttachment(0, 0);
        fData.top = new FormAttachment(0, 5);
        lblGroups.setLayoutData((Object)fData);
        fData = new FormData();
        fData.left = new FormAttachment((Control)tblHistory, 0, 16384);
        fData.right = new FormAttachment(100, -5);
        fData.top = new FormAttachment(0, 5);
        fData.bottom = new FormAttachment(50, -5);
        tblGroups.setLayoutData(fData);
        fData = new FormData();
        fData.left = new FormAttachment(0, 0);
        fData.top = new FormAttachment((Control)tblGroups, 5);
        lblHistory.setLayoutData((Object)fData);
        fData = new FormData();
        fData.left = new FormAttachment((Control)lblHistory, 5);
        fData.right = new FormAttachment(100, -5);
        fData.top = new FormAttachment((Control)tblGroups, 5);
        fData.bottom = new FormAttachment(100, -5);
        tblHistory.setLayoutData(fData);
        tblHistory.setLinesVisible(true);
        TableColumn colHistoryDate = new TableColumn(tblHistory.getTable(), 0);
        colHistoryDate.setText(Resources.getString("VPersonPreview.colHistoryDate"));
        colHistoryDate.pack();
        TableColumn colHistoryType = new TableColumn(tblHistory.getTable(), 0);
        colHistoryType.setText(Resources.getString("VPersonPreview.colHistoryType"));
        colHistoryType.pack();
        TableColumn colHistoryDesc = new TableColumn(tblHistory.getTable(), 0);
        colHistoryDesc.setText(Resources.getString("VPersonPreview.colHistoryDesc"));
        colHistoryDesc.pack();
        tblHistory.setColMaxWidths(40, 40, 40);
        DomLabelProvider<DomPersonEventHistory> historyLabelProvider = new DomLabelProvider<DomPersonEventHistory>(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element == null) {
                    return "";
                }
                DomPersonEventHistory m = (DomPersonEventHistory)element;
                switch (columnIndex) {
                    case 0: {
                        return Util.dateToStr(m.getEventDate());
                    }
                    case 1: {
                        return DomPersonEventHistory.nameOfEvent(m.getEventType());
                    }
                    case 2: {
                        return DomPersonEventHistory.nameOfTime(m.getTimeType(), m.getEventType(), m.getTargetName());
                    }
                }
                return "";
            }
        };
        this.vwrHistory = new DomTableViewer(tblHistory.getTable(), historyLabelProvider, this.naturalOrderSorter());
        this.diffLastName = new DiffText(this.txtSurename);
        this.diffFirstName = new DiffText(this.txtGivenName);
        this.diffCode = new DiffText(this.txtIdNumber);
        this.diffBirthDate = new DiffText(this.txtDateOfBirth);
        this.diffPhone = new DiffText(this.txtPhone);
        this.diffEmail = new DiffText(this.txtEmail);
        this.diffLink = new DiffText(this.txtLink);
    }

    @Override
    public List<String> getHistory() {
        ArrayList<String> historyList = new ArrayList<String>();
        if (this.personHistory != null) {
            for (DomPersonHistory historyElement : this.personHistory) {
                String s = Util.dateToStr(historyElement.getModified_on()) + " " + historyElement.getModified_by();
                historyList.add(s);
            }
        }
        return historyList;
    }

    @Override
    public void loadHistory() {
        if (this.historyID == null) {
            return;
        }
        DomPersonHistory historicalPerson = this.personHistory.get(this.historyID);
        String maidenName = Util.c(historicalPerson.getMaidenName()) != null && !historicalPerson.getMaidenName().equals(historicalPerson.getLastName()) ? " " + Resources.getString("VPersonPreview.lblMaidenName") + " " + historicalPerson.getMaidenName() : "";
        String newLastName = historicalPerson.getLastName();
        String newFirstName = historicalPerson.getFirstName();
        String newCode = historicalPerson.getCode();
        String newDateOfBirth = Util.dateToStr(historicalPerson.getBirthDate()) + (historicalPerson.getBirthDateFuzzyEnd() != null ? " - " + Util.dateToStr(historicalPerson.getBirthDateFuzzyEnd()) : "");
        String newPhone = historicalPerson.getPhone();
        String newEmail = historicalPerson.getEmail();
        String newLink = historicalPerson.getLink();
        this.txtSurename.setText(newLastName + maidenName);
        this.txtGivenName.setText(Util.d(newFirstName));
        this.txtIdNumber.setText(Util.d(newCode));
        this.txtDateOfBirth.setText(Util.d(newDateOfBirth));
        this.txtPhone.setText(Util.d(newPhone));
        this.txtEmail.setText(Util.d(newEmail));
        this.txtLink.setText(Util.d(newLink));
    }

    private void refreshPersonalData() {
        DomPerson person = this.selectedPerson;
        if (person == null) {
            return;
        }
        String maidenName = Util.c(person.getMaidenName()) != null && !person.getMaidenName().equals(person.getLastName()) ? " " + Resources.getString("VPersonPreview.lblMaidenName") + " " + person.getMaidenName() : "";
        this.txtSurename.setText(person.getLastName() + maidenName);
        this.txtGivenName.setText(person.getFirstName());
        this.txtIdNumber.setText(Util.d(person.getCode()));
        this.txtDateOfBirth.setText(Util.dateToStr(person.getBirthDate()) + (person.getBirthDateFuzzyEnd() != null ? " - " + Util.dateToStr(person.getBirthDateFuzzyEnd()) : ""));
        this.setTitle(person.getLastName());
        if (this.congregation != null) {
            this.txtCongregation.setText(Util.d(this.congregation.getName()));
        } else {
            this.txtCongregation.setText("");
        }
        if (this.address != null) {
            this.txtAddress.setText(this.address.toString());
        } else {
            this.txtAddress.setText("");
        }
        this.txtPhone.setText(Util.d(person.getPhone()));
        this.txtEmail.setText(Util.d(person.getEmail()));
        this.txtLink.setText(Util.d(person.getLink()));
        this.diffLastName.setBaseText(person.getLastName() + maidenName);
        this.diffFirstName.setBaseText(person.getFirstName());
        this.diffCode.setBaseText(person.getCode());
        this.diffBirthDate.setBaseText(Util.dateToStr(person.getBirthDate()) + (person.getBirthDateFuzzyEnd() != null ? " - " + Util.dateToStr(person.getBirthDateFuzzyEnd()) : ""));
        this.diffPhone.setBaseText(person.getPhone());
        this.diffEmail.setBaseText(person.getEmail());
        this.diffLink.setBaseText(person.getLink());
    }

    @Override
    public void refresh() {
        this.refreshPersonalData();
        this.vwrGroups.setSource(this.groupMemberships);
        this.vwrEvents.setSource(this.events);
        this.vwrHistory.setSource(this.history);
        this.personHistory.add(0, new DomPersonHistory(this.selectedPerson));
        if (this.spouse != null) {
            this.txtSpouse.setText(this.spouse.getFirstName() + " " + this.spouse.getLastName());
        } else {
            this.txtSpouse.setText("");
        }
        if (this.father != null) {
            this.txtFather.setText(this.father.getFirstName() + " " + this.father.getLastName());
        } else {
            this.txtFather.setText("");
        }
        if (this.mother != null) {
            this.txtMother.setText(this.mother.getFirstName() + " " + this.mother.getLastName());
        } else {
            this.txtMother.setText("");
        }
        this.vwrChildren.setSource(this.children);
        this.vwrRelatives.setSource(this.relatives);
        this.vwrDonations.setSource(this.donations);
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        if (this.getObjectID() == null) {
            return;
        }
        int personId = this.getObjectID();
        this.selectedPerson = MPersonSwt.instance().get(personId);
        this.address = MPersonSwt.instance().getPersonsActiveAddress(personId);
        Integer congId = MPersonSwt.instance().getCongregation(personId);
        this.congregation = congId != null ? MCongregation.instance().get(congId) : null;
        this.groupMemberships = MGroupSwt.listGroupsRoles(personId, null);
        this.events = MPersonSwt.listEvents(personId);
        this.history = MPersonSwt.listEventHistory(personId);
        this.personHistory = MPersonSwt.getPersonHistory(personId);
        this.spouse = MPersonSwt.instance().getSpouse(personId);
        this.father = MPersonSwt.instance().getFather(personId);
        this.mother = MPersonSwt.instance().getMother(personId);
        this.children = MPersonSwt.instance().getChildren(personId);
        this.relatives = MPersonSwt.instance().getOtherRelatives(personId);
        this.donations = MDonation.listMyDonationsSumByYear(personId);
    }

    public Table getTblEvents() {
        return this.tblEvents.getTable();
    }

    public Table getTblChildren() {
        return this.tblChildren.getTable();
    }

    public Text getTxtFather() {
        return this.txtFather;
    }

    public Text getTxtMother() {
        return this.txtMother;
    }

    public Text getTxtSpouse() {
        return this.txtSpouse;
    }

    public DomPerson getFather() {
        return this.father;
    }

    public DomPerson getMother() {
        return this.mother;
    }

    public DomPerson getSpouse() {
        return this.spouse;
    }

    public DomTableViewer<DomShortEvent> getVwrEvents() {
        return this.vwrEvents;
    }

    public DomTableViewer<DomPerson> getVwrChildren() {
        return this.vwrChildren;
    }

    public Table getTblRelatives() {
        return this.tblRelatives.getTable();
    }

    public DomTableViewer<DomPersonWithRelationType> getVwrRelatives() {
        return this.vwrRelatives;
    }
}

