/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MGroupSwt;
import eelk.koguja.dao.MRole;
import eelk.koguja.gui.TableEx;
import eelk.koguja.model.DomGroupMember;
import eelk.koguja.model.DomRole;
import eelk.koguja.seq.SeqAddGroup;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.ImageFactory;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.util.Util;
import eelk.koguja.view.ILoad;
import eelk.koguja.view.ISave;
import eelk.koguja.view.View;
import eelk.koguja.viewer.DomComboCellEditor;
import eelk.koguja.viewer.DomLabelProvider;
import eelk.koguja.viewer.DomTableViewer;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;

public class VPersonGroup
extends View
implements ILoad,
ISave,
SelectionListener {
    private static final Logger logger = Logger.getLogger(VPersonGroup.class);
    private Button btnAddGroup;
    private DomTableViewer<DomGroupMember> vwrGroups;
    private DomComboCellEditor<DomRole> roleEditor;
    private Integer personId;
    private List<DomGroupMember> mbs;
    private List<DomGroupMember> modifiedMbs;
    private List<DomRole> roles;

    public VPersonGroup(Composite parent) {
        super(parent);
    }

    public VPersonGroup(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initControls() {
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        this.btnAddGroup = new Button((Composite)this, 0);
        this.btnAddGroup.setText(Resources.getString("VPersonGroup.btnAddGroup"));
        this.btnAddGroup.setLayoutData((Object)new GridData(128));
        int style = 68356;
        TableEx tblGroups = new TableEx(this, style);
        tblGroups.setLayoutData(new GridData(1808));
        tblGroups.setHeaderVisible(true);
        tblGroups.setLinesVisible(true);
        tblGroups.setLayoutData(new GridData(1808));
        TableColumn col1 = new TableColumn(tblGroups.getTable(), 0x1000000);
        col1.setText(Resources.getString("VPersonGroup.colName1"));
        col1.pack();
        TableColumn col2 = new TableColumn(tblGroups.getTable(), 0x1000000);
        col2.setText(Resources.getString("VPersonGroup.colName2"));
        col2.pack();
        TableColumn col3 = new TableColumn(tblGroups.getTable(), 0x1000000);
        col3.setText(Resources.getString("VPersonGroup.colName3"));
        col3.pack();
        tblGroups.setFixedSizeColumns(true, false, false);
        DomLabelProvider<DomGroupMember> labelProvider = new DomLabelProvider<DomGroupMember>(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element == null) {
                    return "";
                }
                DomGroupMember m = (DomGroupMember)element;
                switch (columnIndex) {
                    case 0: {
                        return "";
                    }
                    case 1: {
                        return Util.d(m.getGroupName());
                    }
                    case 2: {
                        return VPersonGroup.this.roleEditor.getViewer().getTextOf(m.getRoleId());
                    }
                }
                return "";
            }

            @Override
            public Image getColumnImage(Object element, int columnIndex) {
                if (element == null) {
                    return null;
                }
                DomGroupMember m = (DomGroupMember)element;
                switch (columnIndex) {
                    case 0: {
                        return m.isMember() ? ImageFactory.getImage(ImageFactory.ImageCollection.CHECK) : null;
                    }
                    case 1: {
                        return null;
                    }
                    case 2: {
                        return null;
                    }
                }
                return null;
            }
        };
        this.vwrGroups = new DomTableViewer(tblGroups.getTable(), labelProvider);
        String[] colNames = new String[]{"is_member", "group_id", "role_id"};
        this.roleEditor = new DomComboCellEditor((Composite)tblGroups.getTable());
        CellEditor[] cellEditors = new CellEditor[]{new CheckboxCellEditor((Composite)tblGroups.getTable()), null, this.roleEditor};
        TableViewer v = (TableViewer)this.vwrGroups.getViewer();
        v.setColumnProperties(colNames);
        v.setCellEditors(cellEditors);
        this.btnAddGroup.addSelectionListener((SelectionListener)this);
    }

    @Override
    public void refresh() {
        this.roleEditor.setSource(this.roles);
        this.vwrGroups.setSource(this.mbs);
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException {
        p.beginTask(Resources.getMsgString("Load.Loading"), 2);
        p.subTask(Resources.getMsgString("LoadingGroupMembership"));
        this.mbs = MGroupSwt.listMembership(this.getObjectID(), Session.congregation().getId());
        p.worked(1);
        p.subTask(Resources.getMsgString("LoadingRoles"));
        this.roles = MRole.listRoles();
        p.worked(1);
    }

    @Override
    public Integer getObjectID() {
        return this.personId;
    }

    @Override
    public void setObjectID(Integer personId) {
        this.personId = personId;
    }

    @Override
    public ISave.SaveMode getMode() {
        return ISave.SaveMode.SaveUpdate;
    }

    @Override
    public boolean collect() {
        this.modifiedMbs = this.vwrGroups.getCellModifier().getModifiedObjects();
        return true;
    }

    public List<DomGroupMember> getModifiedMbs() {
        return this.modifiedMbs;
    }

    @Override
    public boolean save(IProgressMonitor p) throws SQLException {
        if (this.modifiedMbs == null || this.modifiedMbs.isEmpty()) {
            return true;
        }
        p.beginTask(Resources.getMsgString("SavingGroupMembership"), this.modifiedMbs.size());
        MGroupSwt.setMemberShip(this.modifiedMbs, p);
        return true;
    }

    private void loadGroups() {
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                try {
                    VPersonGroup.this.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        SeqAddGroup seq;
        Sequence.SeqResult executionResult;
        if (this.btnAddGroup.equals(e.getSource()) && (executionResult = Sequence.execSequence(seq = new SeqAddGroup(this.getShell()))) == Sequence.SeqResult.SeqCompleted) {
            this.loadGroups();
        }
    }
}

