/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MAttribute;
import eelk.koguja.dao.MBaptism;
import eelk.koguja.dao.MCitizenship;
import eelk.koguja.dao.MConfirmation;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MFuneral;
import eelk.koguja.dao.MNationality;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.dao.MReligion;
import eelk.koguja.dao.MWedding;
import eelk.koguja.gui.DatePickerCombo;
import eelk.koguja.gui.FuzzyDatePickerCombo;
import eelk.koguja.gui.TableEx;
import eelk.koguja.model.DomAddress;
import eelk.koguja.model.DomAttribute;
import eelk.koguja.model.DomBaptism;
import eelk.koguja.model.DomCitizenship;
import eelk.koguja.model.DomConfirmation;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomFuneral;
import eelk.koguja.model.DomNationality;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.DomPersonAddress;
import eelk.koguja.model.DomReligion;
import eelk.koguja.model.DomWedding;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.seq.SeqPersonBaptismSearch;
import eelk.koguja.seq.SeqPersonConfSearch;
import eelk.koguja.seq.SeqPersonFuneralSearch;
import eelk.koguja.seq.SeqPersonWeddingSearch;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.ImageFactory;
import eelk.koguja.util.PersonCode;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.ISave;
import eelk.koguja.view.VAddressList;
import eelk.koguja.view.VEdit;
import eelk.koguja.viewer.DomComboViewer;
import eelk.koguja.viewer.DomLabelProvider;
import eelk.koguja.viewer.DomTableViewer;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class VPersonEdit
extends VEdit
implements ModifyListener,
SelectionListener,
FocusListener {
    private DomPerson person;
    private Integer citizenship_id;
    private Integer congregation_id;
    private List<DomAttribute> checkedAttributes;
    private DomPerson loadedPerson;
    private Integer loadedCitizenship_id;
    private Integer loadedCongregation_id;
    private List<DomPersonAddress> loadedAddresses;
    private List<DomAttribute> loadedCheckedAttributes;
    private SeqPersonBaptismSearch seqPersonBaptismSearch;
    private DomBaptism personBaptism = null;
    private boolean isNewBaptism = false;
    private SeqPersonConfSearch seqPersonConfSearch;
    private DomConfirmation personConf = null;
    private boolean isNewConf = false;
    private SeqPersonFuneralSearch seqPersonFuneralSearch;
    private DomFuneral personFuneral = null;
    private boolean isNewFuneral = false;
    private SeqPersonWeddingSearch seqPersonWeddingSearch;
    private DomWedding personWedding = null;
    private boolean isNewWedding = false;
    private List<DomNationality> lstNationalities;
    private List<DomCitizenship> lstCitizenships;
    private List<DomReligion> lstReligions;
    private List<DomCongregation> lstCongregations;
    private List<DomAttribute> lstAttributes;
    private DomComboViewer<DomNationality> vwrNationality;
    private DomComboViewer<DomCitizenship> vwrCitizenships;
    private DomComboViewer<DomReligion> vwrReligion;
    private DomComboViewer<DomCongregation> vwrCongregations;
    private DomTableViewer<DomAttribute> vwrAttributes;
    private Composite cmpLeftPanel;
    private Composite cmpRightPanel;
    private Text txtFirstName;
    private Text txtName;
    private Text txtPersonCode;
    private Button rdbMale;
    private Button rdbFemale;
    private Combo cmbMaritalStatus;
    private Text txtMaidenName;
    private FuzzyDatePickerCombo dpcDateOfBirth;
    private DateTime dtDateOfBirth;
    private FuzzyDatePickerCombo dpcDateOfDeath;
    private Text txtPlaceOfBirth;
    private DatePickerCombo dpcBaptismDate;
    private Button btnSearchBaptism;
    private DatePickerCombo dpcConfDate;
    private Button btnSearchConf;
    private DatePickerCombo dpcWedDate;
    private Button btnSearchWed;
    private DatePickerCombo dpcFuneralDate;
    private Button btnSearchFuneral;
    private Text txtPhone;
    private Text txtEmail;
    private Text txtLink;
    private VAddressList vwAddresses;
    private Text txtNotes;
    private Text txtProfession;
    private Combo cmbCongregation;
    private Text txtMemberCard;
    private Text txtBook;
    private Text txtPage;
    private TableEx tblAttributes;

    public VPersonEdit(Composite parent) {
        this(parent, 0);
    }

    public VPersonEdit(Composite parent, int style) {
        super(parent, style);
    }

    public DomPerson getPerson() {
        return this.person;
    }

    public List<DomAddress> getPersonAddresses() {
        ArrayList<DomAddress> result = new ArrayList<DomAddress>();
        for (int i = 0; i < this.vwAddresses.getAddressList().size(); ++i) {
            result.add(this.vwAddresses.getAddressList().get(i).getAddress());
        }
        return result;
    }

    public boolean hasPersonChanged() {
        return !this.person.hasEqualFields(this.loadedPerson);
    }

    public boolean hasChanged() {
        return !this.person.hasEqualFields(this.loadedPerson) || Util.compare(this.loadedCitizenship_id, this.citizenship_id) != 0 || Util.compare(this.loadedCongregation_id, this.congregation_id) != 0 || !this.loadedCheckedAttributes.equals(this.checkedAttributes) || !this.loadedAddresses.equals(this.vwAddresses.getAddressList());
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        p.beginTask(Resources.getMsgString("Load.Loading"), 10);
        if (this.getObjectID() != null) {
            this.setMode(ISave.SaveMode.SaveUpdate);
            this.person = MPersonSwt.instance().get(this.getObjectID());
            this.loadedPerson = new DomPerson(this.person);
            this.loadedCitizenship_id = this.citizenship_id = MPersonSwt.instance().getCitizenshipId(this.getObjectID());
            this.loadedCongregation_id = this.congregation_id = MPersonSwt.instance().getCongregation(this.getObjectID());
            this.vwAddresses.setObjectID(this.getObjectID());
            this.checkedAttributes = MPersonSwt.getAttributes(this.getObjectID());
            this.loadedCheckedAttributes = new ArrayList<DomAttribute>(this.checkedAttributes);
            this.personBaptism = MBaptism.getBaptismForPerson(this.getObjectID());
            this.personConf = MConfirmation.getConfirmationForPerson(this.getObjectID());
            this.personWedding = MWedding.getWeddingForPerson(this.getObjectID());
            this.personFuneral = MFuneral.getFuneralForPerson(this.getObjectID());
        } else {
            this.setMode(ISave.SaveMode.SaveAdd);
            this.checkedAttributes = new ArrayList<DomAttribute>();
        }
        p.worked(4);
        this.lstNationalities = MNationality.listNationalities();
        this.lstNationalities.add(0, new DomNationality());
        p.worked(1);
        this.lstCitizenships = MCitizenship.listCitizenships();
        this.lstCitizenships.add(0, new DomCitizenship());
        p.worked(1);
        this.lstReligions = MReligion.listNamesOfReligions();
        this.lstReligions.add(0, new DomReligion());
        p.worked(1);
        this.lstCongregations = MCongregation.listCongregations(null, Session.congregation().getId());
        this.lstCongregations.add(0, new DomCongregation());
        p.worked(1);
        this.vwAddresses.setObjectID(this.getObjectID());
        this.vwAddresses.load(p);
        p.worked(1);
        this.lstAttributes = MAttribute.listAttributes();
        p.worked(1);
        p.done();
    }

    @Override
    public void refresh() {
        this.vwrNationality.setSource(this.lstNationalities);
        this.vwrCitizenships.setSource(this.lstCitizenships);
        this.vwrReligion.setSource(this.lstReligions);
        this.vwrCongregations.setSource(this.lstCongregations);
        this.vwrAttributes.setSource(this.lstAttributes);
        this.vwrAttributes.sort(0);
        if (this.vwAddresses.getAddressList() == null) {
            this.vwAddresses.refresh();
            this.loadedAddresses = new ArrayList<DomPersonAddress>();
            for (DomPersonAddress address : this.vwAddresses.getAddressList()) {
                this.loadedAddresses.add(new DomPersonAddress(address));
            }
        } else {
            this.vwAddresses.refresh();
        }
        if (this.person != null) {
            this.txtFirstName.setText(Util.d(this.person.getFirstName()));
            this.txtName.setText(Util.d(this.person.getLastName()));
            this.txtMaidenName.setText(Util.d(this.person.getMaidenName()));
            this.txtPersonCode.setText(Util.d(this.person.getCode()));
            this.rdbMale.setSelection(this.person.getSex() == 0);
            this.rdbFemale.setSelection(this.person.getSex() == 1);
            this.cmbMaritalStatus.select(this.person.getMaritalStatus() == null ? 0 : this.person.getMaritalStatus() + 1);
            this.updateMaidenName();
            this.dpcDateOfBirth.setDate(this.person.getBirthDate());
            this.dpcDateOfBirth.setFuzzyDate(this.person.getBirthDateFuzzyEnd());
            this.dpcDateOfDeath.setDate(this.person.getDeathDate());
            this.dpcDateOfDeath.setFuzzyDate(this.person.getDeathDateFuzzyEnd());
            this.txtPlaceOfBirth.setText(Util.d(this.person.getBirthPlace()));
            if (this.person.getNationalityId() != null) {
                this.vwrNationality.setSelectedObject(this.person.getNationalityId());
            }
            if (this.citizenship_id != null) {
                this.vwrCitizenships.setSelectedObject(this.citizenship_id);
            }
            if (this.person.getReligionId() != null) {
                this.vwrReligion.setSelectedObject(this.person.getReligionId());
            }
            this.txtMemberCard.setText(Util.d(this.person.getMembercard()));
            this.txtProfession.setText(Util.d(this.person.getProfession()));
            this.txtEmail.setText(Util.d(this.person.getEmail()));
            this.txtLink.setText(Util.d(this.person.getLink()));
            this.txtPhone.setText(Util.d(this.person.getPhone()));
            this.txtNotes.setText(Util.d(this.person.getComment()));
            this.txtBook.setText(Util.d(this.person.getBook()));
            this.txtPage.setText(Util.d(this.person.getPage()));
            if (this.congregation_id != null) {
                this.vwrCongregations.setSelectedObject(this.congregation_id);
            }
            this.vwAddresses.setPrefillCong(this.congregation_id);
        } else {
            this.vwrNationality.setSelectedObject(this.lstNationalities.get(1).getId());
            this.vwrCitizenships.setSelectedObject(this.lstCitizenships.get(1).getId());
            this.vwrReligion.setSelectedObject(this.lstReligions.get(1).getId());
            this.vwrCongregations.setSelectedObject(Session.congregation().getId());
        }
        this.refreshSearchBaptism();
        this.refreshSearchConfirmation();
        this.refreshSearchWed();
        this.refreshSearchFuneral();
    }

    private void refreshSearchBaptism() {
        this.dpcBaptismDate.removeModifyListener(this);
        boolean enabled = this.dpcBaptismDate.getDate() != null;
        this.btnSearchBaptism.setEnabled(enabled &= this.personBaptism == null);
        this.dpcBaptismDate.setEnabled(this.personBaptism == null);
        if (this.personBaptism != null) {
            this.dpcBaptismDate.setDate(this.personBaptism.getEventDate());
        }
        this.dpcBaptismDate.addModifyListener(this);
    }

    private void refreshSearchConfirmation() {
        this.dpcConfDate.removeModifyListener(this);
        boolean enabled = this.dpcConfDate.getDate() != null;
        this.btnSearchConf.setEnabled(enabled &= this.personConf == null);
        this.dpcConfDate.setEnabled(this.personConf == null);
        if (this.personConf != null) {
            this.dpcConfDate.setDate(this.personConf.getEventDate());
        }
        this.dpcConfDate.addModifyListener(this);
    }

    private void refreshSearchFuneral() {
        this.dpcFuneralDate.removeModifyListener(this);
        boolean enabled = this.dpcDateOfDeath.getDate() != null;
        enabled &= this.dpcFuneralDate.getDate() != null;
        this.btnSearchFuneral.setEnabled(enabled &= this.personFuneral == null);
        this.dpcFuneralDate.setEnabled(this.personFuneral == null);
        if (this.personFuneral != null) {
            this.dpcFuneralDate.setDate(this.personFuneral.getEventDate());
        }
        this.dpcFuneralDate.addModifyListener(this);
    }

    private void refreshSearchWed() {
        this.dpcWedDate.removeModifyListener(this);
        boolean enabled = this.rdbMale.getSelection() || this.rdbFemale.getSelection();
        enabled &= this.dpcWedDate.getDate() != null;
        this.btnSearchWed.setEnabled(enabled &= this.personWedding == null);
        this.dpcWedDate.setEnabled(this.personWedding == null);
        if (this.personWedding != null) {
            this.dpcWedDate.setDate(this.personWedding.getEventDate());
        }
        this.dpcWedDate.addModifyListener(this);
    }

    @Override
    public boolean save(IProgressMonitor p) throws SQLException {
        p.beginTask(Resources.getMsgString("Save.Saving"), 9);
        if (this.getMode().equals((Object)ISave.SaveMode.SaveAdd)) {
            this.objectID = MPersonSwt.instance().create(this.person);
        } else if (!this.person.hasEqualFields(this.loadedPerson) || !this.loadedAddresses.equals(this.vwAddresses.getAddressList())) {
            MPersonSwt.instance().modify(this.person);
        }
        p.worked(1);
        MPersonSwt.instance().setCitizenship(this.objectID, this.citizenship_id);
        p.worked(1);
        MPersonSwt.instance().setCongregation(this.objectID, this.congregation_id);
        p.worked(1);
        MPersonSwt.setPersonAddresses(this.getObjectID(), this.vwAddresses.getAddressList());
        p.worked(1);
        MPersonSwt.setAttributes(this.getObjectID(), this.checkedAttributes);
        p.worked(1);
        if (this.personBaptism != null && this.seqPersonBaptismSearch != null) {
            this.personBaptism.setPersonId(this.getPerson().getId());
            if (this.isNewBaptism) {
                MBaptism.instance().create(this.personBaptism);
            } else {
                MBaptism.instance().modify(this.personBaptism);
            }
        }
        p.worked(1);
        if (this.personConf != null && this.seqPersonConfSearch != null) {
            this.personConf.setPersonId(this.getPerson().getId());
            if (this.isNewConf) {
                MConfirmation.instance().create(this.personConf);
            } else {
                MConfirmation.instance().modify(this.personConf);
            }
        }
        p.worked(1);
        if (this.personFuneral != null && this.seqPersonFuneralSearch != null) {
            this.personFuneral.setPersonId(this.getPerson().getId());
            if (this.isNewFuneral) {
                MFuneral.instance().create(this.personFuneral);
            } else {
                MFuneral.instance().modify(this.personFuneral);
            }
        }
        p.worked(1);
        if (this.personWedding != null && this.seqPersonWeddingSearch != null) {
            if (this.getPerson().getSex() == 0) {
                this.personWedding.setGroomId(this.getPerson().getId());
                this.personWedding.setGroomBirthdate(this.person.getBirthDate());
            } else {
                this.personWedding.setBrideId(this.getPerson().getId());
                this.personWedding.setBrideBirthdate(this.person.getBirthDate());
            }
            if (this.isNewWedding) {
                MWedding.createForPerson(this.personWedding);
            } else {
                MWedding.modifyForPerson(this.personWedding);
            }
        }
        p.worked(1);
        p.done();
        if (this.objectID >= 0) {
            this.setMode(ISave.SaveMode.SaveUpdate);
        }
        return this.objectID >= 0;
    }

    @Override
    public boolean collect() {
        Date deathDate;
        if (this.person == null) {
            this.person = new DomPerson();
        }
        if (Util.c(this.txtFirstName.getText()) == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VPersonEdit.FirstName", new Object[0]);
            this.txtFirstName.setFocus();
            return false;
        }
        this.person.setFirstName(this.txtFirstName.getText());
        if (Util.c(this.txtName.getText()) == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VPersonEdit.LastName", new Object[0]);
            this.txtName.setFocus();
            return false;
        }
        this.person.setLastName(this.txtName.getText());
        this.person.setMaidenName(Util.c(this.txtMaidenName.getText()));
        String code = Util.c(this.txtPersonCode.getText());
        if (code == null) {
            if (this.getMode().equals((Object)ISave.SaveMode.SaveAdd) && !GuiUtil.confirmationDialog(this.getShell(), "Err.VPersonEdit.Code.Missing")) {
                this.txtPersonCode.setFocus();
                return false;
            }
        } else if (!(PersonCode.isCorrect(code) || code.equals(this.person.getCode()) || GuiUtil.confirmationDialog(this.getShell(), "Err.VPersonEdit.Code.Incorrect"))) {
            this.txtPersonCode.setFocus();
            return false;
        }
        this.person.setCode(Util.c(this.txtPersonCode.getText()));
        if (!this.rdbMale.getSelection() && !this.rdbFemale.getSelection()) {
            GuiUtil.informationDialog(this.getShell(), "Err.VPersonEdit.Sex", new Object[0]);
            this.rdbMale.setFocus();
            this.rdbMale.setSelection(false);
            return false;
        }
        this.person.setSex(this.rdbMale.getSelection() ? 0 : 1);
        Date birthDate = this.dpcDateOfBirth.getSqlDate();
        if (birthDate == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VPersonEdit.BirthDate", new Object[0]);
            if (this.dpcDateOfBirth != null) {
                this.dpcDateOfBirth.setFocus();
            }
            return false;
        }
        if (!birthDate.before(Calendar.getInstance().getTime())) {
            GuiUtil.informationDialog(this.getShell(), "Err.VPersonEdit.BirthDate.Future", new Object[0]);
            if (this.dpcDateOfBirth != null) {
                this.dpcDateOfBirth.setFocus();
            }
            return false;
        }
        this.person.setBirthDate(birthDate);
        if (this.person.getBirthDate() != null) {
            this.person.setBirthDateFuzzyEnd(this.dpcDateOfBirth.getSqlFuzzyDate());
        }
        if ((deathDate = this.dpcDateOfDeath.getSqlDate()) != null && (deathDate.before(birthDate) || deathDate.after(Calendar.getInstance().getTime()))) {
            GuiUtil.informationDialog(this.getShell(), "Err.VPersonEdit.DeathDate.Future", new Object[0]);
            this.dpcDateOfDeath.setFocus();
            return false;
        }
        this.person.setDeathDate(deathDate);
        if (this.person.getDeathDate() != null) {
            this.person.setDeathDateFuzzyEnd(this.dpcDateOfDeath.getSqlFuzzyDate());
        }
        this.person.setBirthPlace(Util.c(this.txtPlaceOfBirth.getText()));
        this.person.setDeathDate(this.dpcDateOfDeath.getSqlDate());
        if (this.person.getDeathDate() == null && this.dpcDateOfDeath.getDate() != null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VPersonEdit.DeathDate", new Object[0]);
            this.dpcDateOfDeath.setFocus();
            return false;
        }
        this.person.setMembercard(Util.c(this.txtMemberCard.getText()));
        this.person.setMaritalStatus(this.cmbMaritalStatus.getSelectionIndex() == 0 ? null : Integer.valueOf(this.cmbMaritalStatus.getSelectionIndex() - 1));
        this.person.setProfession(Util.c(this.txtProfession.getText()));
        this.person.setEmail(Util.c(this.txtEmail.getText()));
        this.person.setLink(Util.c(this.txtLink.getText()));
        this.person.setPhone(Util.c(this.txtPhone.getText()));
        this.citizenship_id = this.vwrCitizenships.getSelectedObject() != null && this.vwrCitizenships.getSelectedObjectID() != -1 ? Integer.valueOf(this.vwrCitizenships.getSelectedObjectID()) : null;
        if (this.vwrNationality.getSelectedObject() != null && this.vwrNationality.getSelectedObjectID() != -1) {
            this.person.setNationalityId(this.vwrNationality.getSelectedObjectID());
        } else {
            this.person.setNationalityId(null);
        }
        if (this.vwrReligion.getSelectedObject() != null && this.vwrReligion.getSelectedObjectID() != -1) {
            this.person.setReligionId(this.vwrReligion.getSelectedObjectID());
        } else {
            this.person.setReligionId(null);
        }
        this.person.setComment(Util.c(this.txtNotes.getText()));
        this.person.setBook(Util.c(this.txtBook.getText()));
        this.person.setPage(Util.c(this.txtPage.getText()));
        this.congregation_id = this.vwrCongregations.getSelectedObject() != null && this.vwrCongregations.getSelectedObjectID() != -1 ? Integer.valueOf(this.vwrCongregations.getSelectedObjectID()) : null;
        return true;
    }

    public void focusGained(FocusEvent e) {
        if (this.txtMaidenName == e.getSource() && Util.c(this.txtMaidenName.getText()) == null) {
            this.txtMaidenName.setText(this.txtName.getText());
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public void modifyText(ModifyEvent e) {
        if (this.txtPersonCode == e.getSource()) {
            this.updateSex(PersonCode.getSex(this.txtPersonCode.getText()));
            this.updateBirthDate();
        } else if (this.txtFirstName == e.getSource() || this.txtName == e.getSource()) {
            this.updateCaption();
        } else if (this.dpcDateOfDeath == e.getSource()) {
            this.refreshSearchFuneral();
        } else if (this.dpcBaptismDate == e.getSource()) {
            this.refreshSearchBaptism();
        } else if (this.dpcConfDate == e.getSource()) {
            this.refreshSearchConfirmation();
        } else if (this.dpcWedDate == e.getSource()) {
            this.refreshSearchWed();
        } else if (this.dpcFuneralDate == e.getSource()) {
            this.refreshSearchFuneral();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.btnSearchBaptism == e.getSource()) {
            this.findBaptism();
        } else if (this.btnSearchConf == e.getSource()) {
            this.findConfirmation();
        } else if (this.btnSearchFuneral == e.getSource()) {
            this.findFuneral();
        } else if (this.btnSearchWed == e.getSource()) {
            this.findWedding();
        } else if (this.rdbMale == e.getSource() || this.rdbFemale == e.getSource()) {
            this.refreshSearchWed();
            this.updateMaidenName();
        } else if (this.cmbCongregation == e.getSource()) {
            this.vwAddresses.setPrefillCong(this.vwrCongregations.getSelectedObject() == null ? null : Integer.valueOf(this.vwrCongregations.getSelectedObjectID()));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private DomPerson getDataForEvents() {
        DomPerson result = new DomPerson();
        if (this.getPerson() != null) {
            result.setId(this.getPerson().getId());
        }
        result.setFirstName(Util.c(this.txtFirstName.getText()));
        result.setLastName(Util.c(this.txtName.getText()));
        result.setBirthDate(this.dpcDateOfBirth.getSqlDate());
        result.setCode(Util.c(this.txtPersonCode.getText()));
        result.setDeathDate(this.dpcDateOfDeath.getSqlDate());
        result.setSex(this.rdbMale.getSelection() ? 0 : 1);
        return result;
    }

    private void findBaptism() {
        Date eventDate = this.dpcBaptismDate.getSqlDate();
        if (eventDate == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VPersonEdit.BaptizedDate", new Object[0]);
            this.dpcBaptismDate.setFocus();
            return;
        }
        if (this.seqPersonBaptismSearch == null) {
            this.seqPersonBaptismSearch = new SeqPersonBaptismSearch(this.getShell());
        }
        this.seqPersonBaptismSearch.setPerson(this.getDataForEvents());
        this.seqPersonBaptismSearch.setEventDate(eventDate);
        Sequence.SeqResult seqResult = Sequence.execSequence(this.seqPersonBaptismSearch);
        if (seqResult == Sequence.SeqResult.SeqCompleted) {
            this.personBaptism = (DomBaptism)this.seqPersonBaptismSearch.getEvent();
            this.isNewBaptism = this.seqPersonBaptismSearch.isNewEvent();
            this.refreshSearchBaptism();
        } else if (seqResult == Sequence.SeqResult.SeqCancelled) {
            this.dpcBaptismDate.setText("");
        }
    }

    private void findConfirmation() {
        Date eventDate = this.dpcConfDate.getSqlDate();
        if (eventDate == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VPersonEdit.ConfirmationDate", new Object[0]);
            this.dpcConfDate.setFocus();
            return;
        }
        if (this.seqPersonConfSearch == null) {
            this.seqPersonConfSearch = new SeqPersonConfSearch(this.getShell());
        }
        this.seqPersonConfSearch.setPerson(this.getDataForEvents());
        this.seqPersonConfSearch.setEventDate(eventDate);
        Sequence.SeqResult seqResult = Sequence.execSequence(this.seqPersonConfSearch);
        if (seqResult == Sequence.SeqResult.SeqCompleted) {
            this.personConf = (DomConfirmation)this.seqPersonConfSearch.getEvent();
            this.isNewConf = this.seqPersonConfSearch.isNewEvent();
            this.refreshSearchConfirmation();
        } else if (seqResult == Sequence.SeqResult.SeqCancelled) {
            this.dpcConfDate.setText("");
        }
    }

    private void findFuneral() {
        Date eventDate = this.dpcFuneralDate.getSqlDate();
        if (eventDate == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VPersonEdit.FuneralDate", new Object[0]);
            this.dpcFuneralDate.setFocus();
            return;
        }
        if (eventDate.before(this.dpcDateOfDeath.getDate())) {
            GuiUtil.informationDialog(this.getShell(), "Err.VPersonEdit.FuneralBeforeDeath", new Object[0]);
            this.dpcFuneralDate.setFocus();
            return;
        }
        if (this.seqPersonFuneralSearch == null) {
            this.seqPersonFuneralSearch = new SeqPersonFuneralSearch(this.getShell());
        }
        this.seqPersonFuneralSearch.setPerson(this.getDataForEvents());
        this.seqPersonFuneralSearch.setEventDate(eventDate);
        Sequence.SeqResult seqResult = Sequence.execSequence(this.seqPersonFuneralSearch);
        if (seqResult == Sequence.SeqResult.SeqCompleted) {
            this.personFuneral = (DomFuneral)this.seqPersonFuneralSearch.getEvent();
            this.isNewFuneral = this.seqPersonFuneralSearch.isNewEvent();
            this.refreshSearchFuneral();
        } else if (seqResult == Sequence.SeqResult.SeqCancelled) {
            this.dpcFuneralDate.setText("");
        }
    }

    private void findWedding() {
        Date eventDate = this.dpcWedDate.getSqlDate();
        if (eventDate == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VPersonEdit.WeddingDate", new Object[0]);
            this.dpcWedDate.setFocus();
            return;
        }
        if (this.seqPersonWeddingSearch == null) {
            this.seqPersonWeddingSearch = new SeqPersonWeddingSearch(this.getShell());
        }
        this.seqPersonWeddingSearch.setPerson(this.getDataForEvents());
        this.seqPersonWeddingSearch.setEventDate(eventDate);
        Sequence.SeqResult seqResult = Sequence.execSequence(this.seqPersonWeddingSearch);
        if (seqResult == Sequence.SeqResult.SeqCompleted) {
            this.personWedding = (DomWedding)this.seqPersonWeddingSearch.getEvent();
            this.isNewWedding = this.seqPersonWeddingSearch.isNewEvent();
            this.refreshSearchWed();
        } else if (seqResult == Sequence.SeqResult.SeqCancelled) {
            this.dpcWedDate.setText("");
        }
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(2, true));
        this.cmpLeftPanel = new Composite((Composite)this, 0);
        this.cmpLeftPanel.setLayoutData((Object)new GridData(1808));
        this.cmpLeftPanel.setLayout((Layout)new GridLayout());
        this.cmpRightPanel = new Composite((Composite)this, 0);
        this.cmpRightPanel.setLayoutData((Object)new GridData(1808));
        this.cmpRightPanel.setLayout((Layout)new GridLayout());
        this.initPersonControls();
        this.initEventsControls();
        this.initContactControls();
        this.initOtherDataControls();
        this.initAttributesControls();
        this.initNotesControls();
        this.pack();
    }

    private void initPersonControls() {
        Group grpPerson = new Group(this.cmpLeftPanel, 0);
        grpPerson.setText(Resources.getString("VPersonEdit.grpPerson"));
        grpPerson.setLayoutData((Object)new GridData(768));
        grpPerson.setLayout((Layout)new GridLayout(2, false));
        Label lblFirstName = new Label((Composite)grpPerson, 0);
        lblFirstName.setText(Resources.getString("VPersonEdit.lblFirstName"));
        lblFirstName.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblFirstName);
        this.txtFirstName = new Text((Composite)grpPerson, 2048);
        this.txtFirstName.setLayoutData((Object)new GridData(768));
        this.txtFirstName.addModifyListener((ModifyListener)this);
        this.txtFirstName.setTextLimit(240);
        Label lblName = new Label((Composite)grpPerson, 0);
        lblName.setText(Resources.getString("VPersonEdit.lblName"));
        lblName.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblName);
        this.txtName = new Text((Composite)grpPerson, 2048);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.txtName.addModifyListener((ModifyListener)this);
        this.txtName.setTextLimit(240);
        Label lblMaidenName = new Label((Composite)grpPerson, 0);
        lblMaidenName.setText(Resources.getString("VPersonEdit.lblMaidenName"));
        lblMaidenName.setLayoutData((Object)new GridData(128));
        this.txtMaidenName = new Text((Composite)grpPerson, 2048);
        this.txtMaidenName.setLayoutData((Object)new GridData(768));
        this.txtMaidenName.addModifyListener((ModifyListener)this);
        this.txtMaidenName.setTextLimit(240);
        this.txtMaidenName.addFocusListener((FocusListener)this);
        Label lblPersonCode = new Label((Composite)grpPerson, 0);
        lblPersonCode.setText(Resources.getString("VPersonEdit.lblPersonCode"));
        lblPersonCode.setLayoutData((Object)new GridData(128));
        this.txtPersonCode = new Text((Composite)grpPerson, 2048);
        this.txtPersonCode.setLayoutData((Object)new GridData(768));
        this.txtPersonCode.addModifyListener((ModifyListener)this);
        this.txtPersonCode.setTextLimit(240);
        Label lblSex = new Label((Composite)grpPerson, 0);
        lblSex.setText(Resources.getString("VPersonEdit.lblSex"));
        lblSex.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblSex);
        Composite cmpSex = new Composite((Composite)grpPerson, 0);
        cmpSex.setLayoutData((Object)new GridData(768));
        cmpSex.setLayout((Layout)new RowLayout());
        this.rdbMale = new Button(cmpSex, 16);
        this.rdbMale.setText(Resources.getString("VPersonEdit.rdbMale"));
        this.rdbMale.addSelectionListener((SelectionListener)this);
        this.rdbFemale = new Button(cmpSex, 16);
        this.rdbFemale.setText(Resources.getString("VPersonEdit.rdbFemale"));
        this.rdbFemale.addSelectionListener((SelectionListener)this);
        Label lblDateOfBirth = new Label((Composite)grpPerson, 0);
        lblDateOfBirth.setText(Resources.getString("VPersonEdit.lblDateOfBirth"));
        lblDateOfBirth.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblDateOfBirth);
        this.dpcDateOfBirth = new FuzzyDatePickerCombo((Composite)grpPerson, 2048);
        this.dpcDateOfBirth.setLayoutData(new GridData(32));
        Label lblPlaceOfBirth = new Label((Composite)grpPerson, 0);
        lblPlaceOfBirth.setText(Resources.getString("VPersonEdit.lblPlaceOfBirth"));
        lblPlaceOfBirth.setLayoutData((Object)new GridData(128));
        this.txtPlaceOfBirth = new Text((Composite)grpPerson, 2048);
        this.txtPlaceOfBirth.setLayoutData((Object)new GridData(768));
        this.txtPlaceOfBirth.setTextLimit(240);
        Label lblDateOfDeath = new Label((Composite)grpPerson, 0);
        lblDateOfDeath.setText(Resources.getString("VPersonEdit.lblDateOfDeath"));
        lblDateOfDeath.setLayoutData((Object)new GridData(128));
        this.dpcDateOfDeath = new FuzzyDatePickerCombo((Composite)grpPerson, 2048);
        this.dpcDateOfDeath.setLayoutData(new GridData(32));
        this.dpcDateOfDeath.addModifyListener(this);
    }

    private void initOtherDataControls() {
        Group grpOtherData = new Group(this.cmpRightPanel, 0);
        grpOtherData.setText(Resources.getString("VPersonEdit.grpOtherData"));
        grpOtherData.setLayoutData((Object)new GridData(768));
        grpOtherData.setLayout((Layout)new GridLayout(2, false));
        Label lblMaritalStatus = new Label((Composite)grpOtherData, 0);
        lblMaritalStatus.setText(Resources.getString("VPersonEdit.lblMaritalStatus"));
        lblMaritalStatus.setLayoutData((Object)new GridData(128));
        this.cmbMaritalStatus = new Combo((Composite)grpOtherData, 2056);
        this.cmbMaritalStatus.setLayoutData((Object)new GridData(768));
        this.cmbMaritalStatus.add(Resources.getString("VPersonEdit.rdbUnset"), 0);
        this.cmbMaritalStatus.add(Resources.getString("VPersonEdit.rdbSingle"), 1);
        this.cmbMaritalStatus.add(Resources.getString("VPersonEdit.rdbMarried"), 2);
        this.cmbMaritalStatus.add(Resources.getString("VPersonEdit.rdbDivorced"), 3);
        this.cmbMaritalStatus.add(Resources.getString("VPersonEdit.rdbWidow"), 4);
        this.cmbMaritalStatus.add(Resources.getString("VPersonEdit.rdbCommonlaw"), 5);
        this.cmbMaritalStatus.select(0);
        Label lblProfession = new Label((Composite)grpOtherData, 0);
        lblProfession.setText(Resources.getString("VPersonEdit.lblProfession"));
        lblProfession.setLayoutData((Object)new GridData(128));
        this.txtProfession = new Text((Composite)grpOtherData, 2048);
        this.txtProfession.setLayoutData((Object)new GridData(768));
        this.txtProfession.setTextLimit(240);
        Label lblCitizenship = new Label((Composite)grpOtherData, 0);
        lblCitizenship.setText(Resources.getString("VPersonEdit.lblCitizenship"));
        lblCitizenship.setLayoutData((Object)new GridData(128));
        Combo cmbCitizenship = new Combo((Composite)grpOtherData, 2056);
        cmbCitizenship.setLayoutData((Object)new GridData(768));
        this.vwrCitizenships = new DomComboViewer(cmbCitizenship);
        Label lblNationality = new Label((Composite)grpOtherData, 0);
        lblNationality.setText(Resources.getString("VPersonEdit.lblNationality"));
        lblNationality.setLayoutData((Object)new GridData(128));
        Combo cmbNationality = new Combo((Composite)grpOtherData, 2056);
        cmbNationality.setLayoutData((Object)new GridData(768));
        this.vwrNationality = new DomComboViewer(cmbNationality);
        Label lblReligion = new Label((Composite)grpOtherData, 0);
        lblReligion.setText(Resources.getString("VPersonEdit.lblReligion"));
        lblReligion.setLayoutData((Object)new GridData(128));
        Combo cmbReligion = new Combo((Composite)grpOtherData, 2056);
        cmbReligion.setLayoutData((Object)new GridData(768));
        this.vwrReligion = new DomComboViewer(cmbReligion);
        Label lblCongregation = new Label((Composite)grpOtherData, 0);
        lblCongregation.setText(Resources.getString("VPersonEdit.lblCongregation"));
        lblCongregation.setLayoutData((Object)new GridData(128));
        this.cmbCongregation = new Combo((Composite)grpOtherData, 2056);
        this.cmbCongregation.setLayoutData((Object)new GridData(768));
        this.cmbCongregation.addSelectionListener((SelectionListener)this);
        this.vwrCongregations = new DomComboViewer(this.cmbCongregation);
        Label lblMemberCard = new Label((Composite)grpOtherData, 0);
        lblMemberCard.setText(Resources.getString("VPersonEdit.lblMemberCard"));
        lblMemberCard.setLayoutData((Object)new GridData(128));
        this.txtMemberCard = new Text((Composite)grpOtherData, 2048);
        this.txtMemberCard.setLayoutData((Object)new GridData(768));
        this.txtMemberCard.setTextLimit(240);
        Label lblPersonalBook = new Label((Composite)grpOtherData, 0);
        lblPersonalBook.setText(Resources.getString("VPersonEdit.lblPersonalBook"));
        lblPersonalBook.setLayoutData((Object)new GridData(128));
        Composite cmpBook = new Composite((Composite)grpOtherData, 0);
        cmpBook.setLayoutData((Object)new GridData(768));
        GridLayout grid = new GridLayout(4, false);
        grid.marginBottom = -5;
        grid.marginLeft = -5;
        grid.marginRight = -5;
        grid.marginTop = -5;
        cmpBook.setLayout((Layout)grid);
        Label lblBook = new Label(cmpBook, 0);
        lblBook.setText(Resources.getString("VPersonEdit.lblBook"));
        lblBook.setLayoutData((Object)new GridData(128));
        this.txtBook = new Text(cmpBook, 2048);
        this.txtBook.setLayoutData((Object)new GridData(768));
        this.txtBook.setTextLimit(240);
        Label lblPage = new Label(cmpBook, 0);
        lblPage.setText(Resources.getString("VPersonEdit.lblPage"));
        lblPage.setLayoutData((Object)new GridData(128));
        this.txtPage = new Text(cmpBook, 2048);
        this.txtPage.setLayoutData((Object)new GridData(768));
        this.txtPage.setTextLimit(240);
    }

    private void initEventsControls() {
        Group grpEvents = new Group(this.cmpRightPanel, 0);
        grpEvents.setText(Resources.getString("VPersonEdit.grpEvents"));
        grpEvents.setLayoutData((Object)new GridData(768));
        grpEvents.setLayout((Layout)new GridLayout(3, false));
        Label lblBaptismDate = new Label((Composite)grpEvents, 0);
        lblBaptismDate.setText(Resources.getString("VPersonEdit.lblBaptismDate"));
        lblBaptismDate.setLayoutData((Object)new GridData(128));
        this.dpcBaptismDate = new DatePickerCombo((Composite)grpEvents, 2048);
        this.dpcBaptismDate.setLayoutData(new GridData(768));
        this.dpcBaptismDate.addModifyListener(this);
        this.btnSearchBaptism = new Button((Composite)grpEvents, 0);
        this.btnSearchBaptism.setText(Resources.getString("VPersonEdit.btnSearchEvent"));
        this.btnSearchBaptism.setLayoutData((Object)new GridData(256));
        this.btnSearchBaptism.addSelectionListener((SelectionListener)this);
        this.btnSearchBaptism.setEnabled(false);
        Label lblConfDate = new Label((Composite)grpEvents, 0);
        lblConfDate.setText(Resources.getString("VPersonEdit.lblConfDate"));
        lblConfDate.setLayoutData((Object)new GridData(128));
        this.dpcConfDate = new DatePickerCombo((Composite)grpEvents, 2048);
        this.dpcConfDate.setLayoutData(new GridData(768));
        this.dpcConfDate.addModifyListener(this);
        this.btnSearchConf = new Button((Composite)grpEvents, 0);
        this.btnSearchConf.setText(Resources.getString("VPersonEdit.btnSearchEvent"));
        this.btnSearchConf.setLayoutData((Object)new GridData(256));
        this.btnSearchConf.addSelectionListener((SelectionListener)this);
        this.btnSearchConf.setEnabled(false);
        Label lblWedDate = new Label((Composite)grpEvents, 0);
        lblWedDate.setText(Resources.getString("VPersonEdit.lblWedDate"));
        lblWedDate.setLayoutData((Object)new GridData(128));
        this.dpcWedDate = new DatePickerCombo((Composite)grpEvents, 2048);
        this.dpcWedDate.setLayoutData(new GridData(768));
        this.dpcWedDate.addModifyListener(this);
        this.btnSearchWed = new Button((Composite)grpEvents, 0);
        this.btnSearchWed.setText(Resources.getString("VPersonEdit.btnSearchEvent"));
        this.btnSearchWed.setLayoutData((Object)new GridData(256));
        this.btnSearchWed.addSelectionListener((SelectionListener)this);
        this.btnSearchWed.setEnabled(false);
        Label lblFuneralDate = new Label((Composite)grpEvents, 0);
        lblFuneralDate.setText(Resources.getString("VPersonEdit.lblFuneralDate"));
        lblFuneralDate.setLayoutData((Object)new GridData(128));
        this.dpcFuneralDate = new DatePickerCombo((Composite)grpEvents, 2048);
        this.dpcFuneralDate.setLayoutData(new GridData(768));
        this.dpcFuneralDate.addModifyListener(this);
        this.btnSearchFuneral = new Button((Composite)grpEvents, 0);
        this.btnSearchFuneral.setText(Resources.getString("VPersonEdit.btnSearchEvent"));
        this.btnSearchFuneral.setLayoutData((Object)new GridData(256));
        this.btnSearchFuneral.addSelectionListener((SelectionListener)this);
        this.btnSearchFuneral.setEnabled(false);
    }

    private void initContactControls() {
        Group grpContact = new Group(this.cmpLeftPanel, 0);
        grpContact.setText(Resources.getString("VPersonEdit.grpContact"));
        grpContact.setLayoutData((Object)new GridData(1808));
        grpContact.setLayout((Layout)new GridLayout(1, false));
        Composite cmpPhoneEmail = new Composite((Composite)grpContact, 0);
        cmpPhoneEmail.setLayoutData((Object)new GridData(768));
        cmpPhoneEmail.setLayout((Layout)new GridLayout(2, false));
        Label lblPhone = new Label(cmpPhoneEmail, 0);
        lblPhone.setText(Resources.getString("VPersonEdit.lblPhone"));
        lblPhone.setLayoutData((Object)new GridData(128));
        this.txtPhone = new Text(cmpPhoneEmail, 2048);
        this.txtPhone.setLayoutData((Object)new GridData(768));
        this.txtPhone.setTextLimit(240);
        Label lblEmail = new Label(cmpPhoneEmail, 0);
        lblEmail.setText(Resources.getString("VPersonEdit.lblEmail"));
        lblEmail.setLayoutData((Object)new GridData(128));
        this.txtEmail = new Text(cmpPhoneEmail, 2048);
        this.txtEmail.setLayoutData((Object)new GridData(768));
        this.txtEmail.setTextLimit(240);
        Label lblLink = new Label(cmpPhoneEmail, 0);
        lblLink.setText(Resources.getString("VPersonEdit.lblLink"));
        lblLink.setLayoutData((Object)new GridData(128));
        this.txtLink = new Text(cmpPhoneEmail, 2048);
        this.txtLink.setLayoutData((Object)new GridData(768));
        this.txtLink.setTextLimit(240);
        this.vwAddresses = new VAddressList((Composite)grpContact);
        this.vwAddresses.setLayoutData(new GridData(1808));
    }

    private void initNotesControls() {
        Group grpNotes = new Group(this.cmpRightPanel, 0);
        grpNotes.setText(Resources.getString("VPersonEdit.grpNotes"));
        grpNotes.setLayoutData((Object)new GridData(1808));
        grpNotes.setLayout((Layout)new FillLayout());
        this.txtNotes = new Text((Composite)grpNotes, 2114);
    }

    private void initAttributesControls() {
        Group grpAttributes = new Group(this.cmpLeftPanel, 0);
        grpAttributes.setText(Resources.getString("VPersonEdit.grpAttributes"));
        grpAttributes.setLayoutData((Object)new GridData(1808));
        grpAttributes.setLayout((Layout)new GridLayout(1, false));
        this.tblAttributes = new TableEx((Composite)grpAttributes, 68356);
        this.tblAttributes.setLinesVisible(true);
        GridData gdata = new GridData(1808);
        gdata.heightHint = 90;
        this.tblAttributes.setLayoutData(gdata);
        TableColumn colApplies = new TableColumn(this.tblAttributes.getTable(), 0);
        colApplies.setText("   ");
        TableColumn colAttributes = new TableColumn(this.tblAttributes.getTable(), 0);
        this.tblAttributes.setColMaxWidths(40, 100);
        this.tblAttributes.setFixedSizeColumns(true, false);
        DomLabelProvider<DomAttribute> labelProvider = new DomLabelProvider<DomAttribute>(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element == null) {
                    return "";
                }
                return columnIndex == 1 ? ((DomAttribute)element).getName() : null;
            }

            @Override
            public Image getColumnImage(Object element, int columnIndex) {
                if (element == null || columnIndex != 0) {
                    return null;
                }
                return VPersonEdit.this.checkedAttributes.contains(element) ? ImageFactory.getImage(ImageFactory.ImageCollection.CHECK) : null;
            }
        };
        this.vwrAttributes = new DomTableViewer(this.tblAttributes.getTable(), labelProvider);
        CellEditor[] cellEditors = new CellEditor[]{new CheckboxCellEditor(this.tblAttributes){

            @Override
            protected Object doGetValue() {
                return VPersonEdit.this.checkedAttributes.contains(VPersonEdit.this.vwrAttributes.getSelectedObject());
            }

            @Override
            protected void doSetValue(Object value) {
                if (((Boolean)this.doGetValue()).booleanValue()) {
                    VPersonEdit.this.checkedAttributes.remove(VPersonEdit.this.vwrAttributes.getSelectedObject());
                } else {
                    VPersonEdit.this.checkedAttributes.add((DomAttribute)VPersonEdit.this.vwrAttributes.getSelectedObject());
                }
                VPersonEdit.this.tblAttributes.redraw();
            }
        }, null};
        TableViewer v = (TableViewer)this.vwrAttributes.getViewer();
        v.setColumnProperties(new String[]{"", ""});
        v.setCellEditors(cellEditors);
    }

    private void updateCaption() {
        String caption = this.txtFirstName.getText().trim();
        caption = caption.equals("") ? this.txtName.getText() : caption + " " + this.txtName.getText().trim();
        this.getShell().getShell().setText(caption);
    }

    private void updateSex(int sex) {
        if (sex == 0) {
            this.rdbMale.setSelection(true);
            this.rdbFemale.setSelection(false);
        } else if (sex == 1) {
            this.rdbMale.setSelection(false);
            this.rdbFemale.setSelection(true);
        }
    }

    private void updateMaidenName() {
        this.txtMaidenName.setEnabled(!this.rdbMale.getSelection());
        if (this.rdbMale.getSelection()) {
            this.txtMaidenName.setText("");
        }
    }

    private void updateBirthDate() {
        java.util.Date date = PersonCode.getDate(this.txtPersonCode.getText());
        if (date != null) {
            this.dpcDateOfBirth.setDate(date);
        }
    }
}

