/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.events.BusinessObjectManagedEvent;
import eelk.koguja.events.IBusinessObjectManagedListener;
import eelk.koguja.model.DomAddress;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.seq.SeqSelectPerson;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.PersonCode;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.util.Util;
import eelk.koguja.view.VEdit;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VPersonData
extends VEdit
implements SelectionListener,
ModifyListener {
    public static final int SELECT_CLEAR = 0;
    public static final int ADD_REMOVE = 1;
    private static final Logger logger = Logger.getLogger(VPersonData.class);
    private boolean isPersonSet = false;
    private DomPerson person;
    private DomCongregation congregation;
    private boolean isDeleted = false;
    private boolean collectSucceeded;
    private final List<IBusinessObjectManagedListener> lstBusinessObjectListeners = new ArrayList<IBusinessObjectManagedListener>();
    private SeqSelectPerson seqSelectPerson;
    private final boolean createCode;
    private final boolean createCong;
    private boolean createAddress;
    private boolean createMaritalStatus = true;
    private final int mode;
    private Text txtName;
    private Text txtFirstName;
    private Text txtPersonCode;
    private Text txtAddress;
    private Text txtCongregation;
    private Button chkCurrentCongOnly;
    private Button btnSelect;
    private Button btnClearPerson;
    private Button btnAdd;
    private Button btnRemove;
    private Combo cmbMaritalStatus;

    public VPersonData(Composite parent) {
        this(parent, 0);
    }

    public VPersonData(Composite parent, int style) {
        super(parent, style);
        this.createCode = true;
        this.createCong = true;
        this.createAddress = false;
        this.mode = 0;
        this.initControlsRep();
    }

    public VPersonData(Composite parent, boolean createCode, boolean createCong, int mode) {
        super(parent, 0);
        this.createCode = createCode;
        this.createCong = createCong;
        this.mode = mode;
        this.initControlsRep();
    }

    public VPersonData(Composite parent, boolean createCode, boolean createAddress, boolean createCong, int mode) {
        super(parent, 0);
        this.createCode = createCode;
        this.createAddress = createAddress;
        this.createCong = createCong;
        this.mode = mode;
        this.initControlsRep();
    }

    public VPersonData(Composite parent, boolean createCode, boolean createAddress, boolean createCong, boolean createMaritalStatus, int mode) {
        super(parent, 0);
        this.createCode = createCode;
        this.createAddress = createAddress;
        this.createCong = createCong;
        this.createMaritalStatus = createMaritalStatus;
        this.mode = mode;
        this.initControlsRep();
    }

    public DomPerson getPerson() {
        return this.person;
    }

    public void setPerson(DomPerson value) {
        this.person = new DomPerson(value);
        this.isDeleted = false;
        this.setObjectID(value == null ? null : Integer.valueOf(value.getId()));
        this.isPersonSet = true;
    }

    public void setPerson(Integer id, String firstName, String lastName, Date birthdate, String code) {
        this.setObjectID(id);
        this.person = new DomPerson();
        this.person.setId(id == null ? -1 : id);
        this.person.setFirstName(firstName);
        this.person.setLastName(lastName);
        this.person.setBirthDate(birthdate);
        this.person.setCode(code);
        this.isDeleted = false;
        this.isPersonSet = true;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    public void setObjectID(Integer objectID) {
        super.setObjectID(objectID);
        this.isPersonSet = false;
    }

    public void emptyPerson() {
        this.setObjectID(null);
        this.person = null;
        this.congregation = null;
        this.isDeleted = false;
        this.txtName.setText("");
        this.txtFirstName.setText("");
        if (this.createMaritalStatus) {
            this.cmbMaritalStatus.select(0);
        }
        if (this.createCong) {
            this.txtCongregation.setText("");
        }
        if (this.createAddress) {
            this.txtAddress.setText("");
        }
        if (this.createCode) {
            this.txtPersonCode.setText("");
        }
        this.chkCurrentCongOnly.setSelection(false);
        this.chechMandatory();
        this.notifyListeners(4);
    }

    public boolean isPersonOk() {
        if (this.getPerson() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.RelatedPersonMissing", new Object[0]);
            this.txtName.setFocus();
            return false;
        }
        boolean result = true;
        if (Util.compare(Util.d(this.getPerson().getFirstName()), Util.d(this.txtFirstName.getText())) != 0) {
            result = false;
        }
        if (Util.compare(Util.d(this.getPerson().getLastName()), Util.d(this.txtName.getText())) != 0) {
            result = false;
        }
        if (this.createCode && Util.compare(Util.d(Util.dateToStr(this.getPerson().getBirthDate())), Util.d(this.txtPersonCode.getText())) != 0) {
            result = false;
        }
        if (!result) {
            this.btnSelect.setCapture(true);
            GuiUtil.informationDialog(this.getShell(), "Err.RelatedPersonChanged", new Object[0]);
        }
        return result;
    }

    @Override
    public void refresh() {
        if (this.person == null) {
            this.txtName.setText("");
            this.txtFirstName.setText("");
            if (this.createMaritalStatus) {
                this.cmbMaritalStatus.select(0);
            }
            if (this.createCode) {
                this.txtPersonCode.setText("");
            }
            if (this.createAddress) {
                this.txtAddress.setText("");
            }
            if (this.createCong) {
                this.txtCongregation.setText("");
            }
            return;
        }
        if (this.mode == 0) {
            this.txtName.setText(Util.d(this.person.getLastName()));
            this.txtFirstName.setText(Util.d(this.person.getFirstName()));
            if (this.createMaritalStatus) {
                this.cmbMaritalStatus.select(this.person.getMaritalStatus() == null ? 0 : this.person.getMaritalStatus() + 1);
            }
            if (this.person.getBirthDate() != null && this.createCode) {
                this.txtPersonCode.setText(Util.dateToStr(this.person.getBirthDate()));
            } else if (this.person.getCode() != null && this.createCode) {
                this.txtPersonCode.setText(Util.d(this.person.getCode()));
            }
            if (this.createAddress) {
                try {
                    DomAddress tempAddress = MPersonSwt.instance().getPersonsActiveAddress(this.person.getId());
                    if (tempAddress != null) {
                        this.txtAddress.setText(Util.d(tempAddress.toString()));
                    }
                }
                catch (SQLException e) {
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
            if (this.createCong) {
                this.txtCongregation.setText(this.congregation == null ? "" : this.congregation.getName());
            }
        }
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        Integer congId;
        if (this.getObjectID() == null) {
            if (!this.isPersonSet) {
                this.person = null;
            }
            return;
        }
        if (!this.isPersonSet) {
            this.person = new DomPerson();
            this.person = MPersonSwt.instance().getFromAll(this.getObjectID());
            logger.debug(this.person.getMaritalStatus());
            this.isPersonSet = false;
        }
        this.congregation = (congId = MPersonSwt.instance().getCongregation(this.getObjectID())) == null ? null : MCongregation.instance().get(congId);
    }

    @Override
    public boolean save(IProgressMonitor p) throws SQLException {
        return false;
    }

    @Override
    public boolean collect() {
        if (this.getObjectID() == null) {
            return true;
        }
        if (this.createMaritalStatus) {
            this.person.setMaritalStatus(this.cmbMaritalStatus.getSelectionIndex() == 0 ? null : Integer.valueOf(this.cmbMaritalStatus.getSelectionIndex() - 1));
        }
        Operation.run(this.getShell(), true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    p.beginTask(Resources.getMsgString("Load.Loading"), -1);
                    VPersonData.this.collectSucceeded = MPersonSwt.instance().exists(VPersonData.this.getObjectID());
                    p.done();
                }
                catch (SQLException ex) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Save"), new Object[0]);
                    VPersonData.this.collectSucceeded = false;
                }
            }
        });
        if (!this.collectSucceeded) {
            return GuiUtil.confirmationDialog(GuiUtil.activeShell(), "Err.VPersonData.PersonDeleted", this.getPerson().toString());
        }
        return true;
    }

    public void addBusinessObjectListener(IBusinessObjectManagedListener<DomPerson> listener) {
        this.lstBusinessObjectListeners.add(listener);
    }

    public void removeBusinessObjectListener(IBusinessObjectManagedListener<DomPerson> listener) {
        this.lstBusinessObjectListeners.remove(listener);
    }

    protected void notifyListeners(int eventType) {
        BusinessObjectManagedEvent<DomPerson> e = new BusinessObjectManagedEvent<DomPerson>(this, this.person, eventType);
        for (IBusinessObjectManagedListener listener : this.lstBusinessObjectListeners) {
            listener.businessObjectManaged(e);
        }
    }

    public void modifyText(ModifyEvent e) {
        if (this.txtName == e.getSource()) {
            this.chechMandatory();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.btnSelect == e.getSource()) {
            if (this.selectPerson()) {
                this.notifyListeners(1);
            }
        } else if (this.btnClearPerson == e.getSource()) {
            this.emptyPerson();
        } else if (this.btnAdd == e.getSource()) {
            if (this.selectPerson()) {
                this.notifyListeners(1);
            }
        } else if (this.btnRemove == e.getSource()) {
            this.notifyListeners(2);
            this.emptyPerson();
        } else if (this.chkCurrentCongOnly == e.getSource()) {
            this.chechMandatory();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (this.txtName != null) {
            this.txtName.setEnabled(b);
        }
        if (this.txtFirstName != null) {
            this.txtFirstName.setEnabled(b);
        }
        if (this.txtPersonCode != null) {
            this.txtPersonCode.setEnabled(b);
        }
        if (this.cmbMaritalStatus != null) {
            this.cmbMaritalStatus.setEnabled(b);
        }
        if (this.chkCurrentCongOnly != null) {
            this.chkCurrentCongOnly.setEnabled(b);
        }
    }

    protected boolean selectPerson() {
        if (this.seqSelectPerson == null) {
            this.seqSelectPerson = new SeqSelectPerson(this.getShell());
        }
        String code = this.createCode ? this.txtPersonCode.getText() : null;
        this.seqSelectPerson.setSearchCond(this.txtFirstName.getText(), this.txtName.getText(), Util.strToSqlDate(code), PersonCode.isCorrect(code) ? code : null, !this.chkCurrentCongOnly.getSelection());
        if (!Sequence.execSequence(this.seqSelectPerson).equals((Object)Sequence.SeqResult.SeqCompleted)) {
            return false;
        }
        this.setObjectID(this.seqSelectPerson.getPersonId());
        Operation.run(this.getShell(), true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    p.beginTask(Resources.getMsgString("Load.Loading"), -1);
                    VPersonData.this.load(p);
                    p.done();
                }
                catch (SQLException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("ObjectNotFound"), new Object[0]);
                }
            }
        });
        this.refresh();
        return true;
    }

    @Override
    protected void initControls() {
    }

    protected void initControlsRep() {
        this.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        Composite cmpData = new Composite((Composite)this, 0);
        cmpData.setLayoutData((Object)formData);
        switch (this.mode) {
            case 0: {
                cmpData.setLayout((Layout)new GridLayout(2, false));
                break;
            }
            case 1: {
                cmpData.setLayout((Layout)new GridLayout(3, false));
            }
        }
        Label lblName = new Label(cmpData, 0);
        lblName.setText(Resources.getString("VPersonData.lblName"));
        lblName.setLayoutData((Object)new GridData(128));
        this.txtName = new Text(cmpData, 2048);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.txtName.addModifyListener((ModifyListener)this);
        this.txtName.setTextLimit(240);
        if (this.mode == 1) {
            this.btnAdd = new Button(cmpData, 8);
            this.btnAdd.setText(Resources.getGenString("AddF"));
            this.btnAdd.setLayoutData((Object)new GridData(256));
            this.btnAdd.addSelectionListener((SelectionListener)this);
        }
        Label lblFirstName = new Label(cmpData, 0);
        lblFirstName.setText(Resources.getString("VPersonData.lblFirstName"));
        lblFirstName.setLayoutData((Object)new GridData(128));
        this.txtFirstName = new Text(cmpData, 2048);
        this.txtFirstName.setLayoutData((Object)new GridData(768));
        this.txtFirstName.setTextLimit(240);
        if (this.mode == 1) {
            this.btnRemove = new Button(cmpData, 8);
            this.btnRemove.setText(Resources.getGenString("Remove"));
            this.btnRemove.setLayoutData((Object)new GridData(256));
            this.btnRemove.addSelectionListener((SelectionListener)this);
        }
        if (this.createCode) {
            Label lblPersonCode = new Label(cmpData, 0);
            lblPersonCode.setText(Resources.getString("VPersonData.lblPersonCode"));
            lblPersonCode.setLayoutData((Object)new GridData(128));
            this.txtPersonCode = new Text(cmpData, 2048);
            this.txtPersonCode.setLayoutData((Object)new GridData(768));
            this.txtPersonCode.setTextLimit(240);
            if (this.mode == 1) {
                new Label(cmpData, 0);
            }
        }
        if (this.mode == 0 && this.createMaritalStatus) {
            Label lblMaritalStatus = new Label(cmpData, 0);
            lblMaritalStatus.setText(Resources.getString("VPersonEdit.lblMaritalStatus"));
            lblMaritalStatus.setLayoutData((Object)new GridData(128));
            this.cmbMaritalStatus = new Combo(cmpData, 2056);
            this.cmbMaritalStatus.setLayoutData((Object)new GridData(768));
            this.cmbMaritalStatus.add(Resources.getString("VPersonEdit.rdbUnset"), 0);
            this.cmbMaritalStatus.add(Resources.getString("VPersonEdit.rdbSingle"), 1);
            this.cmbMaritalStatus.add(Resources.getString("VPersonEdit.rdbMarried"), 2);
            this.cmbMaritalStatus.add(Resources.getString("VPersonEdit.rdbDivorced"), 3);
            this.cmbMaritalStatus.add(Resources.getString("VPersonEdit.rdbWidow"), 4);
            this.cmbMaritalStatus.add(Resources.getString("VPersonEdit.rdbCommonlaw"), 5);
            this.cmbMaritalStatus.select(0);
        }
        if (this.createAddress) {
            Label lblAddress = new Label(cmpData, 0);
            lblAddress.setText(Resources.getString("VPersonData.lblAddress"));
            lblAddress.setLayoutData((Object)new GridData(128));
            this.txtAddress = new Text(cmpData, 2048);
            this.txtAddress.setLayoutData((Object)new GridData(768));
            this.txtAddress.setEnabled(false);
            this.txtAddress.setTextLimit(240);
            if (this.mode == 1) {
                new Label(cmpData, 0);
            }
        }
        if (this.createCong) {
            Label lblCongregation = new Label(cmpData, 0);
            lblCongregation.setText(Resources.getString("VPersonData.lblCongregation"));
            lblCongregation.setLayoutData((Object)new GridData(128));
            this.txtCongregation = new Text(cmpData, 2048);
            this.txtCongregation.setLayoutData((Object)new GridData(768));
            this.txtCongregation.setEnabled(false);
            this.txtCongregation.setTextLimit(240);
            if (this.mode == 1) {
                new Label(cmpData, 0);
            }
        }
        new Label(cmpData, 0);
        this.chkCurrentCongOnly = new Button(cmpData, 32);
        this.chkCurrentCongOnly.setText(Resources.getString("VPersonData.chkAllPersons"));
        this.chkCurrentCongOnly.setSelection(true);
        this.chkCurrentCongOnly.setLayoutData((Object)new GridData(32));
        this.chkCurrentCongOnly.addSelectionListener((SelectionListener)this);
        if (this.mode == 1) {
            this.btnClearPerson = new Button(cmpData, 0);
            this.btnClearPerson.setText(Resources.getGenString("Clear"));
            this.btnClearPerson.setLayoutData((Object)new GridData(256));
            this.btnClearPerson.addSelectionListener((SelectionListener)this);
        } else if (this.mode == 0) {
            Composite cmpPanelButtons = new Composite((Composite)this, 0);
            cmpPanelButtons.setLayout((Layout)new GridLayout(2, true));
            formData = new FormData();
            formData.top = new FormAttachment((Control)cmpData);
            formData.right = new FormAttachment(100, 0);
            cmpPanelButtons.setLayoutData((Object)formData);
            this.btnSelect = new Button(cmpPanelButtons, 0);
            this.btnSelect.setText(Resources.getGenString("SelectF"));
            this.btnSelect.setLayoutData((Object)new GridData(768));
            this.btnSelect.addSelectionListener((SelectionListener)this);
            this.btnClearPerson = new Button(cmpPanelButtons, 0);
            this.btnClearPerson.setText(Resources.getGenString("Clear"));
            this.btnClearPerson.setLayoutData((Object)new GridData());
            this.btnClearPerson.addSelectionListener((SelectionListener)this);
        }
        this.chechMandatory();
    }

    private void chechMandatory() {
        if (this.mode == 0) {
            this.btnSelect.setEnabled(Util.c(this.txtName.getText()) != null || this.chkCurrentCongOnly.getSelection());
        }
    }

    public void setMaritalStatusEnabled(boolean value) {
        this.cmbMaritalStatus.setEnabled(value);
    }

    public void setMaritalStatus(int value) {
        this.cmbMaritalStatus.select(value);
    }
}

