/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MAttribute;
import eelk.koguja.gui.TableEx;
import eelk.koguja.model.DomAttribute;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.util.Util;
import eelk.koguja.view.View;
import eelk.koguja.viewer.AbstractSorter;
import eelk.koguja.viewer.DomLabelProvider;
import eelk.koguja.viewer.DomTableViewer;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class VPersonAttributes
extends View
implements ISelectionChangedListener,
ModifyListener,
SelectionListener {
    private static final Logger logger = Logger.getLogger(VPersonAttributes.class);
    private List<DomAttribute> attributes;
    private DomTableViewer<DomAttribute> vwrAttributes;
    private Text txtRank;
    private Text txtName;
    private Button btnAdd;
    private Button btnModify;
    private Button btnDelete;

    public VPersonAttributes(Composite parent) {
        super(parent);
    }

    public VPersonAttributes(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(1, false));
        Composite cmpTable = new Composite((Composite)this, 0);
        cmpTable.setLayoutData((Object)new GridData(1808));
        cmpTable.setLayout((Layout)new GridLayout(1, true));
        TableEx tblAttributes = new TableEx(cmpTable, 67584);
        tblAttributes.setHeaderVisible(true);
        tblAttributes.setLayoutData(new GridData(1808));
        tblAttributes.setLinesVisible(true);
        TableColumn colRank = new TableColumn(tblAttributes.getTable(), 0x1000000);
        colRank.setText(Resources.getString("VPersonAttributes.colRank"));
        TableColumn colName = new TableColumn(tblAttributes.getTable(), 0x1000000);
        colName.setText(Resources.getString("VPersonAttributes.colName"));
        tblAttributes.setColMaxWidths(50, 50);
        tblAttributes.setFixedSizeColumns(true, false);
        this.vwrAttributes = new DomTableViewer(tblAttributes.getTable(), new DomLabelProvider<DomAttribute>(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element == null) {
                    throw new NullPointerException("element");
                }
                DomAttribute attribute = (DomAttribute)element;
                if (columnIndex == 0) {
                    return Util.dInt(attribute.getRank());
                }
                if (columnIndex == 1) {
                    return attribute.getName();
                }
                throw new IllegalArgumentException("columnindex");
            }
        }, new AbstractSorter(){

            @Override
            public Comparable getSortValue(Object element, int column) {
                if (element == null) {
                    throw new NullPointerException("element");
                }
                DomAttribute attribute = (DomAttribute)element;
                if (column == 0) {
                    return attribute.getRank();
                }
                if (column == 1) {
                    return attribute.getName();
                }
                throw new IllegalArgumentException("column");
            }
        });
        this.vwrAttributes.getViewer().addSelectionChangedListener(this);
        Composite cmpEditing = new Composite((Composite)this, 0);
        cmpEditing.setLayoutData((Object)new GridData(768));
        cmpEditing.setLayout((Layout)new GridLayout(2, false));
        Label lblRank = new Label(cmpEditing, 0);
        lblRank.setLayoutData((Object)new GridData(32));
        lblRank.setText(Resources.getString("VPersonAttributes.lblRank"));
        GuiUtil.displayAsMandatory((Control)lblRank);
        this.txtRank = new Text(cmpEditing, 2048);
        this.txtRank.setLayoutData((Object)new GridData(768));
        Label lblName = new Label(cmpEditing, 0);
        lblName.setLayoutData((Object)new GridData(32));
        lblName.setText(Resources.getString("VPersonAttributes.lblName"));
        GuiUtil.displayAsMandatory((Control)lblName);
        this.txtName = new Text(cmpEditing, 2048);
        this.txtName.setLayoutData((Object)new GridData(768));
        this.txtName.addModifyListener((ModifyListener)this);
        Composite cmpButtons = new Composite((Composite)this, 0);
        cmpButtons.setLayoutData((Object)new GridData(768));
        cmpButtons.setLayout((Layout)new GridLayout(3, true));
        this.btnAdd = new Button(cmpButtons, 0);
        this.btnAdd.setText(Resources.getGenString("Add"));
        this.btnAdd.setLayoutData((Object)new GridData(768));
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnModify = new Button(cmpButtons, 0);
        this.btnModify.setText(Resources.getGenString("Modify"));
        this.btnModify.setLayoutData((Object)new GridData(768));
        this.btnModify.addSelectionListener((SelectionListener)this);
        this.btnDelete = new Button(cmpButtons, 0);
        this.btnDelete.setText(Resources.getGenString("Delete"));
        this.btnDelete.setLayoutData((Object)new GridData(768));
        this.btnDelete.addSelectionListener((SelectionListener)this);
        this.updateButtons();
    }

    private boolean collectTo(DomAttribute attribute) {
        if (!this.txtRank.getText().trim().equals("")) {
            attribute.setRank(Util.i(this.txtRank.getText()));
            if (attribute.getRank() == null) {
                GuiUtil.informationDialog(this.getShell(), "Err.VPersonAttributes.Rank", new Object[0]);
                this.txtRank.setFocus();
                return false;
            }
        } else {
            attribute.setRank(1);
        }
        attribute.setName(this.txtName.getText());
        if (attribute.getName().trim().equals("")) {
            GuiUtil.informationDialog(this.getShell(), "Err.VPersonAttributes.Name", new Object[0]);
            this.txtRank.setFocus();
            return false;
        }
        return true;
    }

    private int createAttribute() {
        final DomAttribute attribute = new DomAttribute();
        if (!this.collectTo(attribute)) {
            return -1;
        }
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("CreatingObject"), -1);
                try {
                    MAttribute.instance().create(attribute);
                    Session.connection().commit();
                    VPersonAttributes.this.load(p);
                    MAttribute.instance().populateCashedSearchAttributes();
                    p.done();
                }
                catch (SQLException e) {
                    logger.error(e);
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Create"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        return 0;
    }

    private int modifyAttribute(DomAttribute domAttribute) {
        final DomAttribute attribute = domAttribute.clone();
        if (!this.collectTo(attribute)) {
            return -1;
        }
        if (!attribute.getName().equals(domAttribute.getName()) && !GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmAttributeMod", domAttribute.getName(), this.txtName.getText())) {
            return -1;
        }
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getGenString("Save.Saving"), -1);
                try {
                    MAttribute.instance().modify(attribute);
                    Session.connection().commit();
                    VPersonAttributes.this.load(p);
                    MAttribute.instance().populateCashedSearchAttributes();
                    p.done();
                }
                catch (SQLException e) {
                    logger.error(e);
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        return 0;
    }

    private int deleteAttribute(DomAttribute domAttribute) {
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmAttributeDel", domAttribute.getName())) {
            return -1;
        }
        final DomAttribute attribute = domAttribute;
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("DeletingObject"), -1);
                try {
                    MAttribute.instance().delete(attribute.getId());
                    Session.connection().commit();
                    VPersonAttributes.this.load(p);
                    MAttribute.instance().populateCashedSearchAttributes();
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound e) {
                    logger.error(e);
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Delete") + "." + Resources.getErrString("ObjectNotFound"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        return 0;
    }

    public void load(IProgressMonitor p) throws SQLException {
        this.attributes = MAttribute.listAttributes();
    }

    public void refresh() {
        this.vwrAttributes.setSource(this.attributes);
    }

    public void updateButtons() {
        this.btnAdd.setEnabled(this.canAdd());
        this.btnModify.setEnabled(this.canModify());
        this.btnDelete.setEnabled(this.canDelete());
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
        if (event.getSelection().isEmpty()) {
            this.txtRank.setText("");
            this.txtName.setText("");
        } else {
            this.txtRank.setText(Util.dInt(((DomAttribute)this.vwrAttributes.getSelectedObject()).getRank()));
            this.txtName.setText(((DomAttribute)this.vwrAttributes.getSelectedObject()).getName());
        }
    }

    public void modifyText(ModifyEvent arg0) {
        this.updateButtons();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.btnAdd)) {
            this.createAttribute();
        } else if (e.getSource().equals(this.btnModify)) {
            this.modifyAttribute((DomAttribute)this.vwrAttributes.getSelectedObject());
        } else if (e.getSource().equals(this.btnDelete)) {
            this.deleteAttribute((DomAttribute)this.vwrAttributes.getSelectedObject());
        }
    }

    private boolean canAdd() {
        return Util.c(this.txtName.getText()) != null;
    }

    private boolean canModify() {
        return this.canAdd() && this.canDelete();
    }

    private boolean canDelete() {
        return !this.vwrAttributes.getViewer().getSelection().isEmpty();
    }
}

