/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.gui.TableEx;
import eelk.koguja.model.DomCongregationPerson;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.ILoad;
import eelk.koguja.view.ISave;
import eelk.koguja.view.View;
import eelk.koguja.viewer.DomComboViewer;
import eelk.koguja.viewer.DomLabelProvider;
import eelk.koguja.viewer.DomTableViewer;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class VPersonAccess
extends View
implements ILoad,
ISave,
SelectionListener {
    private Integer selectedPersonId;
    private DomPerson selectedPerson;
    private List<DomCongregationPerson> congAccess;
    private List<DomCongregationPerson> modifiedCongAccess;
    private List<DomCongregationPerson> congNoAccess;
    private DomTableViewer<DomCongregationPerson> vwrCongAccess;
    private DomComboViewer<DomCongregationPerson> vwrCongNoAccess;
    private Text txtSurname;
    private Text txtFirstname;
    private Text txtBirthDate;
    private Text txtID;
    private Combo cmbCongNoAccess;
    private Button btnAdd;

    public VPersonAccess(Composite parent) {
        super(parent);
    }

    public VPersonAccess(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initControls() {
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        Group grpPerson = new Group((Composite)this, 0);
        grpPerson.setText(Resources.getString("VPersonAccess.grpPerson"));
        grpPerson.setLayoutData((Object)new GridData(768));
        grpPerson.setLayout((Layout)new GridLayout(2, false));
        Label lblSurname = new Label((Composite)grpPerson, 0);
        lblSurname.setText(Resources.getString("VPersonAccess.lblSurname"));
        lblSurname.setLayoutData((Object)new GridData(128));
        this.txtSurname = new Text((Composite)grpPerson, 2048);
        this.txtSurname.setLayoutData((Object)new GridData(768));
        this.txtSurname.setEditable(false);
        Label lblFirstname = new Label((Composite)grpPerson, 0);
        lblFirstname.setText(Resources.getString("VPersonAccess.lblFirstname"));
        lblFirstname.setLayoutData((Object)new GridData(128));
        this.txtFirstname = new Text((Composite)grpPerson, 2048);
        this.txtFirstname.setLayoutData((Object)new GridData(768));
        this.txtFirstname.setEditable(false);
        Label lblBirthDate = new Label((Composite)grpPerson, 0);
        lblBirthDate.setText(Resources.getString("VPersonAccess.lblBirthDate"));
        lblBirthDate.setLayoutData((Object)new GridData(128));
        this.txtBirthDate = new Text((Composite)grpPerson, 2048);
        this.txtBirthDate.setLayoutData((Object)new GridData(768));
        this.txtBirthDate.setEditable(false);
        Label lblID = new Label((Composite)grpPerson, 0);
        lblID.setText(Resources.getString("VPersonAccess.lblID"));
        lblID.setLayoutData((Object)new GridData(128));
        this.txtID = new Text((Composite)grpPerson, 2048);
        this.txtID.setLayoutData((Object)new GridData(768));
        this.txtID.setEditable(false);
        Group grpAccess = new Group((Composite)this, 0);
        grpAccess.setText(Resources.getString("VPersonAccess.grpAccess"));
        grpAccess.setLayoutData((Object)new GridData(1808));
        grpAccess.setLayout((Layout)new GridLayout(3, false));
        Label lblCongregation = new Label((Composite)grpAccess, 0);
        lblCongregation.setText(Resources.getString("VPersonAccess.lblCongregation"));
        lblCongregation.setLayoutData((Object)new GridData(1));
        this.cmbCongNoAccess = new Combo((Composite)grpAccess, Combo.LIMIT);
        this.cmbCongNoAccess.setLayoutData((Object)new GridData(768));
        this.cmbCongNoAccess.addSelectionListener((SelectionListener)this);
        this.vwrCongNoAccess = new DomComboViewer(this.cmbCongNoAccess);
        this.btnAdd = new Button((Composite)grpAccess, 8);
        this.btnAdd.setText(Resources.getGenString("Add"));
        this.btnAdd.setLayoutData((Object)new GridData(768));
        this.btnAdd.addSelectionListener((SelectionListener)this);
        this.btnAdd.setEnabled(false);
        int style = 101124;
        TableEx tblAccess = new TableEx((Composite)grpAccess, style);
        tblAccess.setHeaderVisible(true);
        tblAccess.setLinesVisible(true);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        tblAccess.setLayoutData(data);
        TableColumn colName1 = new TableColumn(tblAccess.getTable(), 0x1000000);
        colName1.setText(Resources.getString("VPersonAccess.colName1"));
        colName1.pack();
        TableColumn colName2 = new TableColumn(tblAccess.getTable(), 0x1000000);
        colName2.setText(Resources.getString("VPersonAccess.colName2"));
        colName2.pack();
        TableColumn colName3 = new TableColumn(tblAccess.getTable(), 0x1000000);
        colName3.setText(Resources.getString("VPersonAccess.colName3"));
        colName3.pack();
        TableColumn colName4 = new TableColumn(tblAccess.getTable(), 0x1000000);
        colName4.setText(Resources.getString("VPersonAccess.colName4"));
        colName4.pack();
        DomLabelProvider<DomCongregationPerson> labelProvider = new DomLabelProvider<DomCongregationPerson>(){

            @Override
            public String getColumnText(Object o, int column) {
                if (o == null) {
                    return "";
                }
                String res = "";
                DomCongregationPerson u = (DomCongregationPerson)o;
                switch (column) {
                    case 0: {
                        res = u.getCongregationName();
                        break;
                    }
                    case 1: {
                        res = Util.blnToStr(u.isReadAccess());
                        break;
                    }
                    case 2: {
                        res = Util.blnToStr(u.isWriteAccess());
                        break;
                    }
                    case 3: {
                        res = Util.blnToStr(u.isAdminAccess());
                    }
                }
                return res;
            }
        };
        this.vwrCongAccess = new DomTableViewer(tblAccess.getTable(), labelProvider);
        CellEditor[] cellEditors = new CellEditor[]{null, new CheckboxCellEditor(tblAccess), new CheckboxCellEditor(tblAccess), new CheckboxCellEditor(tblAccess)};
        String[] colNames = new String[]{"congregation_name", "read_access", "write_access", "admin_access"};
        TableViewer v = (TableViewer)this.vwrCongAccess.getViewer();
        v.setColumnProperties(colNames);
        v.setCellEditors(cellEditors);
    }

    @Override
    public Integer getObjectID() {
        return this.selectedPersonId;
    }

    @Override
    public void setObjectID(Integer personId) {
        this.selectedPersonId = personId;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.cmbCongNoAccess)) {
            this.btnAdd.setEnabled(true);
        } else if (e.getSource().equals(this.btnAdd)) {
            this.congAccess.add((DomCongregationPerson)this.vwrCongNoAccess.getSelectedObject());
            this.congNoAccess.remove(this.vwrCongNoAccess.getSelectedObject());
            this.refreshCongAccess();
            this.btnAdd.setEnabled(false);
        }
    }

    public void refreshCongAccess() {
        this.vwrCongAccess.setSource(this.congAccess);
        this.vwrCongNoAccess.setSource(this.congNoAccess);
    }

    @Override
    public void refresh() {
        this.refreshCongAccess();
        this.setUserData();
    }

    private void setUserData() {
        this.txtSurname.setText(this.selectedPerson.getLastName());
        this.txtFirstname.setText(this.selectedPerson.getFirstName());
        this.txtBirthDate.setText(Util.dateToStr(this.selectedPerson.getBirthDate()));
        this.txtID.setText(Util.d(this.selectedPerson.getCode()));
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        p.beginTask(Resources.getMsgString("Load.Loading"), 2);
        p.subTask(Resources.getMsgString("LoadingCongregationAccess"));
        this.congNoAccess = MPersonSwt.listCongregationPersons(this.getObjectID(), false);
        this.congAccess = MPersonSwt.listCongregationPersons(this.getObjectID(), true);
        p.worked(1);
        p.subTask(Resources.getMsgString("LoadingPersonData"));
        this.selectedPerson = MPersonSwt.instance().getFromAll(this.getObjectID());
        p.worked(1);
    }

    @Override
    public ISave.SaveMode getMode() {
        return ISave.SaveMode.SaveUpdate;
    }

    @Override
    public boolean save(IProgressMonitor p) throws SQLException {
        if (this.modifiedCongAccess == null || this.modifiedCongAccess.isEmpty()) {
            return true;
        }
        p.beginTask(Resources.getMsgString("SavingCongregationAccess"), this.modifiedCongAccess.size());
        MPersonSwt.setCongPersonAccess(this.modifiedCongAccess, p);
        return true;
    }

    @Override
    public boolean collect() {
        this.modifiedCongAccess = this.vwrCongAccess.getSource();
        return true;
    }
}

