/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MDeanery;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomDeanery;
import eelk.koguja.util.IDbUtil;
import eelk.koguja.util.Resources;
import eelk.koguja.view.ILoad;
import eelk.koguja.view.View;
import eelk.koguja.viewer.DomComboViewer;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VMembersByAgeReportSetup
extends View
implements DisposeListener,
ILoad {
    private String reportTitle;
    private int scope = 0;
    private int deaneryID = -1;
    private int congregationID = -1;
    private boolean fullyQualified;
    private Text txtTitle;
    private Button btnComplete;
    private Button btnDeanery;
    private Button btnCongregation;
    private Combo cmbDeanery;
    private DomComboViewer<DomDeanery> vwrDeanery;
    private Combo cmbCongregation;
    private DomComboViewer<DomCongregation> vwrCongregation;
    private Button btnFullyQualifiedMembers;
    private List<DomDeanery> deaneryList;
    private List<DomCongregation> congregationList;

    public VMembersByAgeReportSetup(Composite parent) {
        super(parent);
    }

    public VMembersByAgeReportSetup(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initControls() {
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        Group cmpTitle = new Group((Composite)this, 0);
        cmpTitle.setLayoutData((Object)new GridData(768));
        cmpTitle.setLayout((Layout)new GridLayout(2, false));
        Label lblTitle = new Label((Composite)cmpTitle, 0);
        lblTitle.setText(Resources.getString("VMembersByAgeReportSetup.lblTitle"));
        lblTitle.setLayoutData((Object)new GridData(128));
        this.txtTitle = new Text((Composite)cmpTitle, 2048);
        this.txtTitle.setLayoutData((Object)new GridData(768));
        this.txtTitle.addDisposeListener((DisposeListener)this);
        Group grpBusinessUnit = new Group((Composite)this, 0);
        grpBusinessUnit.setText(Resources.getString("VMembersByAgeReportSetup.grpBusinessUnit"));
        grpBusinessUnit.setLayoutData((Object)new GridData(1808));
        grpBusinessUnit.setLayout((Layout)new GridLayout(2, false));
        this.btnComplete = new Button((Composite)grpBusinessUnit, 16);
        this.btnComplete.addDisposeListener((DisposeListener)this);
        this.btnComplete.setText(Resources.getString("VMembersByAgeReportSetup.btnComplete"));
        GridData gData = new GridData();
        gData.horizontalSpan = 2;
        this.btnComplete.setLayoutData((Object)gData);
        this.btnDeanery = new Button((Composite)grpBusinessUnit, 16);
        this.btnDeanery.addDisposeListener((DisposeListener)this);
        this.btnDeanery.setText(Resources.getString("VMembersByAgeReportSetup.btnDeanery"));
        this.cmbDeanery = new Combo((Composite)grpBusinessUnit, 2048);
        this.cmbDeanery.addDisposeListener((DisposeListener)this);
        this.cmbDeanery.setLayoutData((Object)new GridData(768));
        this.vwrDeanery = new DomComboViewer(this.cmbDeanery);
        this.btnCongregation = new Button((Composite)grpBusinessUnit, 16);
        this.btnCongregation.addDisposeListener((DisposeListener)this);
        this.btnCongregation.setText(Resources.getString("VMembersByAgeReportSetup.btnCongregation"));
        this.cmbCongregation = new Combo((Composite)grpBusinessUnit, 2048);
        this.cmbCongregation.addDisposeListener((DisposeListener)this);
        this.cmbCongregation.setLayoutData((Object)new GridData(768));
        this.vwrCongregation = new DomComboViewer(this.cmbCongregation);
        Group cmpFullyQualified = new Group((Composite)this, 0);
        cmpFullyQualified.setLayoutData((Object)new GridData(768));
        cmpFullyQualified.setLayout((Layout)new GridLayout(1, false));
        this.btnFullyQualifiedMembers = new Button((Composite)cmpFullyQualified, 32);
        this.btnFullyQualifiedMembers.addDisposeListener((DisposeListener)this);
        this.btnFullyQualifiedMembers.setText(Resources.getString("VMembersByAgeReportSetup.btnFullyQualifiedMembers"));
        this.btnComplete.setSelection(true);
        this.addDisposeListener(this);
    }

    public void widgetDisposed(DisposeEvent e) {
        Object s = e.getSource();
        if (this.txtTitle == s) {
            this.reportTitle = this.txtTitle.getText();
        } else if (this.btnComplete == s && this.btnComplete.getSelection()) {
            this.scope = 1;
        } else if (this.btnDeanery == s && this.btnDeanery.getSelection()) {
            this.scope = 2;
        } else if (this.btnCongregation == s && this.btnCongregation.getSelection()) {
            this.scope = 3;
        } else if (this.cmbDeanery == s) {
            this.deaneryID = this.vwrDeanery.getSelectedObjectID();
        } else if (this.cmbCongregation == s) {
            this.congregationID = this.vwrCongregation.getSelectedObjectID();
        } else if (this.btnFullyQualifiedMembers == s) {
            this.fullyQualified = this.btnFullyQualifiedMembers.getSelection();
        }
    }

    public String getReportTitle() {
        return this.txtTitle.isDisposed() ? this.reportTitle : this.txtTitle.getText();
    }

    public void setReportTitle(String title) {
        this.txtTitle.setText(title);
    }

    public int getScope() {
        if (!this.btnComplete.isDisposed() && this.btnComplete.getSelection()) {
            return 1;
        }
        if (!this.btnDeanery.isDisposed() && this.btnDeanery.getSelection()) {
            return 2;
        }
        if (!this.btnCongregation.isDisposed() && this.btnCongregation.getSelection()) {
            return 3;
        }
        return this.scope;
    }

    public int getCongregationID() {
        if (this.getScope() == 3) {
            if (!this.cmbCongregation.isDisposed()) {
                return this.vwrCongregation.getSelectedObjectID();
            }
            return this.congregationID;
        }
        return -1;
    }

    public int getDeaneryID() {
        if (this.getScope() == 2) {
            if (!this.cmbDeanery.isDisposed()) {
                return this.vwrDeanery.getSelectedObjectID();
            }
            return this.deaneryID;
        }
        return -1;
    }

    public boolean isFullyQuelified() {
        return this.btnFullyQualifiedMembers.isDisposed() ? this.fullyQualified : this.btnFullyQualifiedMembers.getSelection();
    }

    @Override
    public Integer getObjectID() {
        return null;
    }

    @Override
    public void setObjectID(Integer i) {
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException {
        p.beginTask(Resources.getMsgString("Load.Loading"), 2);
        p.subTask(Resources.getMsgString("LoadingGroupMembership"));
        this.deaneryList = MDeanery.listDeaneries();
        p.worked(1);
        p.subTask(Resources.getMsgString("LoadingRoles"));
        this.congregationList = MCongregation.listMyCongregations(IDbUtil.Permission.Read);
        p.worked(1);
    }

    @Override
    public void refresh() {
        this.vwrDeanery.setSource(this.deaneryList);
        this.vwrCongregation.setSource(this.congregationList);
    }

    public Map<String, Object> getReportParameters() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("TITLE", this.getReportTitle());
        return m;
    }

    public Map<String, Object> getReportConstraints() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        int i = -1;
        switch (this.getScope()) {
            case 2: {
                i = this.getDeaneryID();
                m.put("deanery_id", i == -1 ? null : Integer.valueOf(i));
                break;
            }
            case 3: {
                i = this.getCongregationID();
                m.put("congregation_id", i == -1 ? null : Integer.valueOf(i));
            }
        }
        if (this.isFullyQuelified()) {
            m.put("is_fully_qualified", true);
        }
        return m;
    }
}

