/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.action.MainMenu;
import eelk.koguja.dao.MAttribute;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MDonationType;
import eelk.koguja.dao.MEventLocation;
import eelk.koguja.dao.MGroupSwt;
import eelk.koguja.model.DomAttributeSearch;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomDonationType;
import eelk.koguja.model.DomEventLocation;
import eelk.koguja.model.DomGroup;
import eelk.koguja.preference.IPreferenceStore;
import eelk.koguja.preference.Preferences;
import eelk.koguja.search.BaptismResult;
import eelk.koguja.search.ConfirmationResult;
import eelk.koguja.search.DonationResult;
import eelk.koguja.search.FuneralResult;
import eelk.koguja.search.PersonResult;
import eelk.koguja.search.Result;
import eelk.koguja.search.WeddingResult;
import eelk.koguja.util.Resources;
import eelk.koguja.view.ILoad;
import eelk.koguja.view.VNavi;
import eelk.koguja.view.VPreviewComposite;
import eelk.koguja.view.VResult;
import eelk.koguja.view.VResultComposite;
import eelk.koguja.view.VSearchComposite;
import eelk.koguja.view.View;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.Splitter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;

public class VMain
extends View
implements SelectionListener,
ControlListener,
ILoad,
MouseListener,
KeyListener {
    private static final String MAIN_WIDTH = "main.width";
    private static final String MAIN_HEIGHT = "main.height";
    private static final String MAIN_X = "main.x";
    private static final String MAIN_Y = "main.y";
    private static final String MAIN_MAXIMIZED = "main.maximized";
    private static final String MAIN_MODE = "main.mode";
    private static final String SEARCH_SMP_HEIGHT = "search.height";
    private static final String SEARCH_SHOW = "search.show";
    private static final String NAVI_WIDTH = "navi.width";
    private static final String NAVI_SHOW = "navi.show";
    private static final String RESULT_HEIGHT = "result.height";
    private static final String RESULT_SHOW = "result.show";
    private static final String PREVIEW_HEIGHT = "preview.height";
    private static final String PREVIEW_SHOW = "preview.show";
    private int naviWidth;
    private boolean skipResize;
    private Splitter shfContentPanels;
    private VNavi vwNavi;
    private Sash shNavi;
    private VSearchComposite vwSearchPanel;
    private VResultComposite vwResultPanel;
    private VPreviewComposite vwPreviewPanel;
    private List<DomCongregation> congregations;
    private List<DomGroup> groups;
    private List<DomEventLocation> eventLocations;
    private List<String> eventTypes;
    private List<DomAttributeSearch> attributes;
    private List<DomDonationType> donationTypes;

    public VMain(Composite parent) {
        this(parent, 0);
    }

    public VMain(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public Integer getObjectID() {
        return null;
    }

    @Override
    public void setObjectID(Integer id) {
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException {
        p.beginTask(Resources.getMsgString("Load.Loading"), 6);
        p.subTask(Resources.getMsgString("LoadingCongregations"));
        this.setCongregations(MCongregation.listCongregations(null));
        MCongregation.instance().populateCashedCongs();
        p.worked(1);
        p.subTask(Resources.getMsgString("LoadingGroups"));
        this.setGroups(MGroupSwt.listGroups(Session.current().getCongregation().getId()));
        MGroupSwt.instance().populateCashedCongs();
        p.worked(2);
        p.subTask(Resources.getMsgString("LoadingLocations"));
        this.setEventLocations(MEventLocation.listEventLocations(Session.current().getCongregation().getId()));
        MEventLocation.instance().populateCashedLocations(Session.current().getCongregation().getId());
        p.worked(3);
        p.subTask(Resources.getMsgString("LoadingAttributes"));
        this.attributes = MAttribute.listAttributesForSearch();
        MAttribute.instance().populateCashedSearchAttributes();
        p.worked(4);
        p.subTask(Resources.getMsgString("LoadingEventTypes"));
        this.eventTypes = new ArrayList<String>();
        this.eventTypes.add(Resources.getString("VPersonSearchAdvanced.cmbEventType.Baptism"));
        this.eventTypes.add(Resources.getString("VPersonSearchAdvanced.cmbEventType.Confirmation"));
        this.eventTypes.add(Resources.getString("VPersonSearchAdvanced.cmbEventType.Wedding"));
        this.eventTypes.add(Resources.getString("VPersonSearchAdvanced.cmbEventType.Funeral"));
        p.worked(5);
        p.subTask(Resources.getMsgString("LoadingDonationTypes"));
        this.setDonationTypes(MDonationType.listDonationTypes(true));
        p.worked(6);
    }

    @Override
    public void refresh() {
        VSearchComposite v = this.getSearchComposite();
        if (this.congregations != null) {
            v.vPersonSearchAdvanced.setCongregations(this.congregations);
            v.vBaptismSearchAdvanced.setCongregations(this.congregations);
            v.vConfirmationSearchAdvanced.setCongregations(this.congregations);
            v.vWeddingSearchAdvanced.setCongregations(this.congregations);
            v.vFuneralSearchAdvanced.setCongregations(this.congregations);
            v.vDonationSearchAdvanced.setCongregations(this.congregations);
        }
        if (this.eventLocations != null) {
            v.vBaptismSearchAdvanced.setEventLocations(this.eventLocations);
            v.vConfirmationSearchAdvanced.setEventLocations(this.eventLocations);
            v.vFuneralSearchAdvanced.setEventLocations(this.eventLocations);
            v.vWeddingSearchAdvanced.setEventLocations(this.eventLocations);
        }
        if (this.groups != null) {
            v.vDonationSearchAdvanced.setGroups(this.groups);
            v.vPersonSearchAdvanced.setGroups(this.groups);
            v.vPersonSearchSimple.setGroups(this.groups);
        }
        if (this.attributes != null) {
            v.vPersonSearchAdvanced.setAttributes(this.attributes);
        }
        if (this.donationTypes != null) {
            v.vPersonSearchAdvanced.setDonationTypes(this.donationTypes);
        }
        if (this.eventTypes != null) {
            v.vPersonSearchAdvanced.setEventTypes(this.eventTypes);
        }
        v.vDonationSearchAdvanced.setDefaults();
        v.loadSearchPrefs();
    }

    public SearchMode getMode() {
        return this.vwSearchPanel.getMode();
    }

    public void setMode(SearchMode mode) {
        if (this.getMode() == mode) {
            return;
        }
        this.vwSearchPanel.setMode(mode);
        this.vwResultPanel.setMode(mode);
        this.vwNavi.setMode(mode);
    }

    public boolean getSearchVisible() {
        return this.vwSearchPanel.getVisible();
    }

    public void setSearchVisible(boolean value) {
        if (this.getSearchVisible() == value) {
            return;
        }
        this.shfContentPanels.setVisible((Control)this.vwSearchPanel, value);
        MainMenu.getViewSearchPanel().setChecked(value);
        this.shfContentPanels.layout();
        this.vwSearchPanel.refreshSearchPane();
    }

    public boolean getNaviVisible() {
        return this.vwNavi.getVisible();
    }

    public void setNaviVisible(boolean value) {
        if (this.getNaviVisible() == value) {
            return;
        }
        this.vwNavi.setVisible(value);
        if (this.shNavi != null) {
            this.shNavi.setEnabled(value);
        }
        MainMenu.getViewNaviPanel().setChecked(value);
        FormData formData = (FormData)this.vwNavi.getLayoutData();
        if (value) {
            formData.width = this.naviWidth;
        } else {
            this.naviWidth = this.vwNavi.getSize().x;
            formData.width = 1;
        }
        this.layout();
    }

    public boolean getResultsVisible() {
        return this.vwResultPanel.getVisible();
    }

    public void setResultsVisible(boolean value) {
        if (this.getResultsVisible() == value) {
            return;
        }
        this.shfContentPanels.setVisible((Control)this.vwResultPanel, value);
        MainMenu.getViewResultsPanel().setChecked(value);
        this.shfContentPanels.layout();
        this.vwSearchPanel.refreshSearchPane();
    }

    public boolean getPreviewVisible() {
        return this.vwPreviewPanel.getVisible();
    }

    public void setPreviewVisible(boolean value) {
        if (this.getPreviewVisible() == value) {
            return;
        }
        this.shfContentPanels.setVisible((Control)this.vwPreviewPanel, value);
        MainMenu.getViewPreviewPanel().setChecked(value);
        this.shfContentPanels.layout();
        this.vwSearchPanel.refreshSearchPane();
    }

    public List<Result> getResults(SearchMode s) {
        return this.getResultComposite().getResult(s).getResults();
    }

    public List<Result> getCurrentResults() {
        return this.getResults(this.getMode());
    }

    public List<Result> getSelectedResults(SearchMode s) {
        return this.getResultComposite().getResult(s).getSelectedResults();
    }

    public List<Result> getCurrentSelectedResults() {
        return this.getSelectedResults(this.getMode());
    }

    public void controlMoved(ControlEvent e) {
    }

    public VSearchComposite getSearchComposite() {
        return this.vwSearchPanel;
    }

    public VResultComposite getResultComposite() {
        return this.vwResultPanel;
    }

    public VNavi getVNavi() {
        return this.vwNavi;
    }

    public VPreviewComposite getPreviewComposite() {
        return this.vwPreviewPanel;
    }

    public void controlResized(ControlEvent e) {
        if (this.vwSearchPanel == e.getSource()) {
            this.updateSearchHeight(e.data);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.shNavi.equals(e.getSource())) {
            this.updateNaviBarWidth(e.x);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetDefaultSelected(e);
    }

    @Override
    protected void initControls() {
        IPreferenceStore store = Preferences.getStore();
        this.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        if (store.contains(NAVI_WIDTH) && store.getInt(NAVI_WIDTH) >= 0) {
            formData.width = this.naviWidth = store.getInt(NAVI_WIDTH);
        }
        this.vwNavi = new VNavi(this);
        this.vwNavi.setLayoutData(formData);
        this.vwNavi.setMain(this);
        if (store.contains(NAVI_SHOW)) {
            this.setNaviVisible(store.getBoolean(NAVI_SHOW));
        }
        if (!this.getNaviVisible()) {
            this.naviWidth = store.contains(NAVI_WIDTH) && store.getInt(NAVI_WIDTH) >= 0 ? store.getInt(NAVI_WIDTH) : this.vwNavi.computeSize((int)-1, (int)-1).x;
        }
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.vwNavi);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.shNavi = new Sash((Composite)this, 512);
        this.shNavi.setLayoutData((Object)formData);
        this.shNavi.addSelectionListener((SelectionListener)this);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.shNavi);
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.shfContentPanels = new Splitter(this, 512);
        this.shfContentPanels.setLayoutData(formData);
        this.shfContentPanels.setLayout((Layout)new FormLayout());
        this.vwSearchPanel = new VSearchComposite((Composite)this.shfContentPanels, 2048);
        this.vwSearchPanel.addControlListener(this);
        this.vwResultPanel = new VResultComposite((Composite)this.shfContentPanels, 2048);
        this.vwPreviewPanel = new VPreviewComposite((Composite)this.shfContentPanels, 2048);
        int[] weights = new int[]{100, 100, 100};
        if (store.contains(SEARCH_SMP_HEIGHT) && store.getInt(SEARCH_SMP_HEIGHT) > 0) {
            weights[0] = store.getInt(SEARCH_SMP_HEIGHT);
        }
        if (store.contains(SEARCH_SHOW)) {
            this.setSearchVisible(store.getBoolean(SEARCH_SHOW));
        }
        if (store.contains(RESULT_HEIGHT) && store.getInt(RESULT_HEIGHT) > 0) {
            weights[1] = store.getInt(RESULT_HEIGHT);
        }
        if (store.contains(RESULT_SHOW)) {
            this.setResultsVisible(store.getBoolean(RESULT_SHOW));
        }
        if (store.contains(PREVIEW_HEIGHT) && store.getInt(PREVIEW_HEIGHT) > 0) {
            weights[2] = store.getInt(PREVIEW_HEIGHT);
        }
        if (store.contains(PREVIEW_SHOW)) {
            this.setPreviewVisible(store.getBoolean(PREVIEW_SHOW));
        }
        this.shfContentPanels.setWeights(weights);
        if (store.contains(MAIN_MODE) && store.getInt(MAIN_MODE) >= 0 && store.getInt(MAIN_MODE) < SearchMode.values().length) {
            this.setMode(SearchMode.values()[store.getInt(MAIN_MODE)]);
            this.vwNavi.setMode(SearchMode.values()[store.getInt(MAIN_MODE)]);
        } else {
            this.setMode(SearchMode.PERSON);
        }
        this.skipResize = true;
        this.pack();
        this.skipResize = false;
        if (store.contains(MAIN_WIDTH) && store.contains(MAIN_HEIGHT)) {
            this.getShell().setSize(store.getInt(MAIN_WIDTH), store.getInt(MAIN_HEIGHT));
        }
        if (store.contains(MAIN_X) && store.contains(MAIN_Y)) {
            this.getShell().setLocation(store.getInt(MAIN_X), store.getInt(MAIN_Y));
        }
        if (store.contains(MAIN_MAXIMIZED)) {
            this.getShell().setMaximized(store.getBoolean(MAIN_MAXIMIZED));
        }
        for (VResult vw : this.vwResultPanel.getLstResult()) {
            vw.getTblResult().addMouseListener((MouseListener)this);
        }
        this.vwSearchPanel.refreshSearchPane();
    }

    public void saveMainPreferences() {
        IPreferenceStore store = Preferences.getStore();
        store.setValue(MAIN_WIDTH, this.getShell().getSize().x);
        store.setValue(MAIN_HEIGHT, this.getShell().getSize().y);
        store.setValue(MAIN_X, this.getShell().getLocation().x);
        store.setValue(MAIN_Y, this.getShell().getLocation().y);
        store.setValue(MAIN_MAXIMIZED, this.getShell().getMaximized());
        store.setValue(MAIN_MODE, this.getMode().ordinal());
        store.setValue(NAVI_SHOW, this.getNaviVisible());
        store.setValue(NAVI_WIDTH, this.naviWidth);
        store.setValue(SEARCH_SHOW, this.getSearchVisible());
        store.setValue(RESULT_SHOW, this.getResultsVisible());
        store.setValue(PREVIEW_SHOW, this.getPreviewVisible());
        int[] weights = this.shfContentPanels.getWeights();
        store.setValue(SEARCH_SMP_HEIGHT, weights[0]);
        store.setValue(RESULT_HEIGHT, weights[1]);
        store.setValue(PREVIEW_HEIGHT, weights[2]);
    }

    private void updateNaviBarWidth(int width) {
        if (this.skipResize) {
            return;
        }
        if (this.getNaviVisible()) {
            this.naviWidth = width;
        }
        ((FormData)this.vwNavi.getLayoutData()).width = width;
        this.layout();
    }

    public void addObjectPreview(List<Result> results, int count) {
        int upperBound = Math.min(count, results.size());
        for (int i = 0; i < upperBound; ++i) {
            Result result = results.get(i);
            if (result instanceof PersonResult) {
                this.vwPreviewPanel.addPerson(result.getId());
                continue;
            }
            if (result instanceof BaptismResult) {
                this.vwPreviewPanel.addBaptism(result.getId());
                continue;
            }
            if (result instanceof ConfirmationResult) {
                this.vwPreviewPanel.addConfirmation(result.getId());
                continue;
            }
            if (result instanceof FuneralResult) {
                this.vwPreviewPanel.addFuneral(result.getId());
                continue;
            }
            if (result instanceof WeddingResult) {
                this.vwPreviewPanel.addWedding(result.getId());
                continue;
            }
            if (!(result instanceof DonationResult)) continue;
            this.vwPreviewPanel.addDonation(result.getId());
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (e.getSource().equals(this.vwResultPanel.getCurrent().getTblResult())) {
            this.addObjectPreview(this.vwResultPanel.getCurrent().getSelectedResults(), 1);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    private void updateSearchHeight(Object h) {
        if (h == null || !(h instanceof Integer)) {
            return;
        }
        int[] weights = this.shfContentPanels.getWeights();
        int hs = (Integer)h;
        int hr = this.vwResultPanel.getSize().y;
        int hp = this.vwPreviewPanel.getSize().y;
        if (hs <= 0 || hr < 0 || hp <= 0) {
            return;
        }
        if (this.vwResultPanel.getVisible()) {
            hr = this.vwSearchPanel.getSize().y + this.vwResultPanel.getSize().y + this.vwPreviewPanel.getSize().y - hs - hp;
            if (hr <= 0) {
                hp += hr - 31;
                hr = 30;
            }
            weights[0] = hs + 6;
            weights[1] = hr - 6;
            weights[2] = hp - 1;
        } else {
            weights[0] = hs + 6;
            weights[2] = this.shfContentPanels.getSize().y - hs;
        }
        this.shfContentPanels.setWeights(weights);
    }

    public void setGroups(List<DomGroup> groups) {
        this.groups = new ArrayList<DomGroup>();
        this.groups.addAll(groups);
        this.groups.add(0, new DomGroup());
    }

    private void setCongregations(List<DomCongregation> congregations) {
        this.congregations = new ArrayList<DomCongregation>();
        this.congregations.addAll(congregations);
        this.congregations.add(0, new DomCongregation());
    }

    private void setEventLocations(List<DomEventLocation> eventLocations) {
        this.eventLocations = new ArrayList<DomEventLocation>();
        this.eventLocations.addAll(eventLocations);
        this.eventLocations.add(0, new DomEventLocation());
    }

    private void setDonationTypes(List<DomDonationType> donationTypes) {
        this.donationTypes = new ArrayList<DomDonationType>(donationTypes.size());
        this.donationTypes.addAll(donationTypes);
        this.donationTypes.add(0, new DomDonationType());
    }

    public static enum SearchMode {
        BAPTISM(0, "baptism"),
        CONFIRMATION(1, "confirmation"),
        DONATION(2, "donation"),
        FUNERAL(3, "funeral"),
        PERSON(4, "person"),
        WEDDING(5, "wedding");

        private final int mode;
        private final String name;

        private SearchMode(int mode, String name) {
            this.mode = mode;
            this.name = name;
        }

        public int getMode() {
            return this.mode;
        }

        public String getName() {
            return this.name;
        }
    }
}

