/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.util.Resources;
import eelk.koguja.view.View;
import eelk.koguja.viewer.DomComboViewer;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VLogin
extends View
implements DisposeListener,
ModifyListener {
    private int selectedItemId;
    private String userName;
    private String password;
    private Button btnLogin = null;
    private Button btnDetails = null;
    private boolean askingUsername = true;
    private DomComboViewer<DomCongregation> vwrCongregation;
    private Text txtUser;
    private Text txtPass;
    private Combo cmbCongregation;

    public VLogin(Composite parent) {
        this(parent, 0);
    }

    public VLogin(Composite parent, int style) {
        super(parent, style);
        this.setMode();
    }

    public int getSelectedCongId() {
        if (this.isDisposed() || this.cmbCongregation.isDisposed()) {
            return this.selectedItemId;
        }
        return this.vwrCongregation.getSelectedObjectID();
    }

    public void setSelectedCong(int id) {
        this.vwrCongregation.setSelectedObject(id);
    }

    public String getUserName() {
        return this.isDisposed() || this.txtUser.isDisposed() ? this.userName : this.txtUser.getText();
    }

    public void setUserName(String value) {
        this.txtUser.setText(value);
    }

    public String getPassword() {
        return this.isDisposed() || this.txtPass.isDisposed() ? this.password : this.txtPass.getText();
    }

    public void setPassword(String value) {
        this.txtPass.setText(value);
    }

    public boolean isUserNameAsked() {
        return this.askingUsername;
    }

    public void askUserName() {
        this.askingUsername = true;
        this.setMode();
    }

    public void askCongregation() {
        this.askingUsername = false;
        this.setMode();
    }

    public boolean isCongregationAsked() {
        return !this.askingUsername;
    }

    public void setCongregations(List<DomCongregation> list) {
        this.vwrCongregation.setSource(list);
    }

    public void setLoginButton(Button value) {
        this.btnLogin = value;
        this.checkMandatory();
    }

    public Button getDetailsButton() {
        return this.btnDetails;
    }

    public void setDetailsButton(Button value) {
        this.btnDetails = value;
    }

    public void modifyText(ModifyEvent e) {
        if (this.txtUser == e.getSource() || this.txtPass == e.getSource() || this.cmbCongregation == e.getSource()) {
            this.checkMandatory();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.txtUser == e.getSource()) {
            this.userName = this.txtUser.getText();
        } else if (this.txtPass == e.getSource()) {
            this.password = this.txtPass.getText();
        } else if (this.cmbCongregation == e.getSource()) {
            this.selectedItemId = this.vwrCongregation.getSelectedObjectID();
        }
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(2, false));
        Label lblUser = new Label((Composite)this, 0);
        lblUser.setText(Resources.getString("VLogin.lblUser"));
        lblUser.setLayoutData((Object)new GridData(128));
        this.txtUser = new Text((Composite)this, 2048);
        this.txtUser.setLayoutData((Object)new GridData(768));
        this.txtUser.addDisposeListener((DisposeListener)this);
        this.txtUser.addModifyListener((ModifyListener)this);
        Label lblPass = new Label((Composite)this, 0);
        lblPass.setText(Resources.getString("VLogin.lblPass"));
        lblPass.setLayoutData((Object)new GridData(128));
        this.txtPass = new Text((Composite)this, 0x400800);
        this.txtPass.setLayoutData((Object)new GridData(768));
        this.txtPass.addDisposeListener((DisposeListener)this);
        this.txtPass.addModifyListener((ModifyListener)this);
        Label lblCongregation = new Label((Composite)this, 0);
        lblCongregation.setText(Resources.getString("VLogin.lblCongregation"));
        lblCongregation.setLayoutData((Object)new GridData(128));
        this.cmbCongregation = new Combo((Composite)this, 2056);
        this.cmbCongregation.setLayoutData((Object)new GridData(768));
        this.cmbCongregation.addModifyListener((ModifyListener)this);
        this.cmbCongregation.addDisposeListener((DisposeListener)this);
        this.vwrCongregation = new DomComboViewer(this.cmbCongregation);
    }

    protected void setMode() {
        this.txtUser.setEnabled(this.isUserNameAsked());
        this.txtPass.setEnabled(this.isUserNameAsked());
        this.cmbCongregation.setEnabled(this.isCongregationAsked());
        if (this.btnDetails != null) {
            this.btnDetails.setEnabled(Session.current() == null);
        }
    }

    protected void checkMandatory() {
        if (this.btnLogin == null) {
            return;
        }
        boolean enable = !this.txtUser.getText().equals("");
        enable &= !this.txtPass.getText().equals("");
        if (!this.askingUsername) {
            enable &= this.cmbCongregation.getSelectionIndex() >= 0;
        }
        this.btnLogin.setEnabled(enable);
    }
}

