/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MGroupName;
import eelk.koguja.model.DomGroupName;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VAttributes;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class VGroupNameAdmin
extends VAttributes<DomGroupName>
implements SelectionListener {
    private static final Logger logger = Logger.getLogger(VGroupNameAdmin.class);
    private List<DomGroupName> groupNames;

    public VGroupNameAdmin(Composite parent) {
        super(parent);
    }

    public VGroupNameAdmin(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initControls() {
    }

    @Override
    protected void initControlsHere() {
        super.initControlsHere();
        this.setTableHeaderText(Resources.getString("VGroupNameAdmin.colName"));
        this.setNameLabelText(Resources.getString("VGroupNameAdmin.lblName"));
        this.getVwrAttributes().packColumns();
        this.setTitle(Resources.getString("VGroupNameAdmin.Title"));
        this.getBtnAdd().addSelectionListener((SelectionListener)this);
        this.getBtnModify().addSelectionListener((SelectionListener)this);
        this.getBtnDelete().addSelectionListener((SelectionListener)this);
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.getBtnAdd())) {
            this.createGroupName();
        } else if (e.getSource().equals(this.getBtnModify())) {
            this.modifyGroupName((DomGroupName)this.getSelectedObject(), this.getAttributeText());
        } else if (e.getSource().equals(this.getBtnDelete())) {
            this.deleteGroupName((DomGroupName)this.getSelectedObject());
        }
    }

    private int createGroupName() {
        String newGroupNameName = this.getAttributeText();
        final DomGroupName domGroupName = new DomGroupName();
        domGroupName.setName(newGroupNameName);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("CreatingObject"), -1);
                try {
                    MGroupName.instance().create(domGroupName);
                    Session.connection().commit();
                    VGroupNameAdmin.this.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Create"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        return 0;
    }

    private int modifyGroupName(DomGroupName domGroupName, String newName) {
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmGroupNameMod", domGroupName.getName(), newName)) {
            return -1;
        }
        final DomGroupName groupName = domGroupName.clone();
        groupName.setName(newName);
        ArrayList<DomGroupName> initialGroupNames = new ArrayList<DomGroupName>();
        initialGroupNames.addAll(this.groupNames);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("Save.Saving"), -1);
                try {
                    MGroupName.instance().modify(groupName);
                    Session.connection().commit();
                    VGroupNameAdmin.this.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        return 0;
    }

    private int deleteGroupName(DomGroupName domGroupName) {
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmGroupNameDel", domGroupName.getName())) {
            return -1;
        }
        final DomGroupName groupName = domGroupName;
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("DeletingObject"), -1);
                try {
                    MGroupName.instance().delete(groupName.getId());
                    Session.connection().commit();
                    VGroupNameAdmin.this.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Delete") + "." + Resources.getErrString("ObjectNotFound"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        return 0;
    }

    public void load(IProgressMonitor p) throws SQLException {
        this.groupNames = MGroupName.listGroupNames();
    }

    public void refresh() {
        this.setSource(this.groupNames);
    }
}

