/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MGroupName;
import eelk.koguja.dao.MGroupSwt;
import eelk.koguja.dlg.DlgMain;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomGroup;
import eelk.koguja.model.DomGroupName;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.IDbUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.util.Util;
import eelk.koguja.view.VAttributes;
import eelk.koguja.view.View;
import eelk.koguja.viewer.DomComboViewer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VGroupAdmin
extends View
implements SelectionListener {
    private static final Logger logger = Logger.getLogger(VGroupAdmin.class);
    private List<DomCongregation> congregations;
    private List<DomGroup> groups;
    private List<DomGroupName> groupNames;
    private DomComboViewer<DomCongregation> vwrCongregation;
    private DomComboViewer<DomGroupName> vwrGroupNames;
    private Combo cmbCongregation;
    private VAttributes<DomGroup> vwGroups;
    private Group grpGroups;

    public VGroupAdmin(Composite parent) {
        super(parent);
    }

    public VGroupAdmin(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initControls() {
        Composite cmpCongregation = new Composite((Composite)this, 0);
        cmpCongregation.setLayout((Layout)new GridLayout(2, false));
        Label lblCongregation = new Label(cmpCongregation, 0);
        lblCongregation.setText(Resources.getString("VGroupAdmin.lblCongregation"));
        lblCongregation.setLayoutData((Object)new GridData(32));
        this.cmbCongregation = new Combo(cmpCongregation, 2056);
        this.cmbCongregation.setLayoutData((Object)new GridData(768));
        this.grpGroups = new Group((Composite)this, 0);
        this.grpGroups.setLayout((Layout)new FillLayout(256));
        this.grpGroups.setText(Resources.getString("VGroupAdmin.grpGroups"));
        this.vwGroups = new VAttributes<DomGroup>((Composite)this.grpGroups, VAttributes.NameMode.ComboBox){
            private Text txtLocalName;

            @Override
            public void initControlsHere() {
                super.initControlsHere();
                Label lblLocalName = new Label(this.getAttrPanel(), 0);
                this.txtLocalName = new Text(this.getAttrPanel(), 2048);
                lblLocalName.setText(Resources.getString("VGroupAdmin.vwGroups.colName"));
                GuiUtil.displayAsMandatory((Control)lblLocalName);
                FormData formData = new FormData();
                formData.top = new FormAttachment(this.getNameControl(), 5);
                formData.left = new FormAttachment((Control)this.getNameLabel(), 0, 16384);
                lblLocalName.setLayoutData((Object)formData);
                formData = new FormData();
                formData.top = new FormAttachment(this.getNameControl(), 5);
                formData.left = new FormAttachment(this.getNameControl(), 0, 16384);
                formData.right = new FormAttachment(100, 0);
                this.txtLocalName.setLayoutData((Object)formData);
                this.txtLocalName.addModifyListener((ModifyListener)this);
                Combo combo = (Combo)this.getNameControl();
                combo.addSelectionListener((SelectionListener)this);
            }

            public void setAttributeText(String name, Integer type) {
                this.txtLocalName.setText(Util.d(name));
                VGroupAdmin.this.vwrGroupNames.setSelectedObject(type);
            }

            @Override
            public void selectionChanged(SelectionChangedEvent e) {
                if (e.getSelection().isEmpty()) {
                    this.setAttributeText("", null);
                } else {
                    DomGroup group = (DomGroup)this.getVwrAttributes().getSelectedObject();
                    this.setAttributeText(group.getName(), group.getNameId());
                }
                this.checkButtons();
            }

            @Override
            public void checkButtons() {
                this.getBtnAdd().setEnabled(this.isAddEnabled() && Util.c(this.txtLocalName.getText()) != null);
                this.getBtnModify().setEnabled(this.isModEnabled() && Util.c(this.txtLocalName.getText()) != null);
                this.getBtnDelete().setEnabled(this.isDelEnabled());
            }

            public String toString() {
                return this.txtLocalName.getText();
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (e.getSource().equals(this.getNameControl())) {
                    this.txtLocalName.setText(((DomGroupName)VGroupAdmin.this.vwrGroupNames.getSelectedObject()).getName());
                }
            }
        };
        this.vwGroups.setTableHeaderText(Resources.getString("VGroupAdmin.vwGroups.colName"));
        this.vwGroups.setNameLabelText(Resources.getString("VGroupAdmin.vwGroups.lblName"));
        this.vwGroups.getVwrAttributes().packColumns();
        if (this.getLayout() == null) {
            this.setLayout((Layout)new FormLayout());
        }
        FormData formData = null;
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(50, 0);
        cmpCongregation.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)cmpCongregation, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100, -5);
        this.grpGroups.setLayoutData((Object)formData);
        this.cmbCongregation.addSelectionListener((SelectionListener)this);
        this.vwrCongregation = new DomComboViewer(this.cmbCongregation);
        this.vwrGroupNames = new DomComboViewer((Combo)this.vwGroups.getNameControl());
        this.vwGroups.getBtnAdd().addSelectionListener((SelectionListener)this);
        this.vwGroups.getBtnModify().addSelectionListener((SelectionListener)this);
        this.vwGroups.getBtnDelete().addSelectionListener((SelectionListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.cmbCongregation)) {
            this.loadGroups(this.vwrCongregation.getSelectedObjectID());
            this.vwGroups.checkButtons();
        } else if (e.getSource().equals(this.vwGroups.getBtnAdd())) {
            this.createGroup(this.vwrCongregation.getSelectedObjectID());
        } else if (e.getSource().equals(this.vwGroups.getBtnModify())) {
            this.modifyGroup((DomGroup)this.vwGroups.getSelectedObject(), this.vwGroups.toString(), this.vwrGroupNames.getSelectedObjectID());
        } else if (e.getSource().equals(this.vwGroups.getBtnDelete())) {
            this.deleteGroup((DomGroup)this.vwGroups.getSelectedObject());
        }
    }

    protected int createGroup(int congId) {
        String newGroupName = this.vwGroups.toString();
        final DomGroup domGroup = new DomGroup();
        domGroup.setName(newGroupName);
        domGroup.setNameId(this.vwrGroupNames.getSelectedObjectID());
        domGroup.setCongregationId(congId);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("CreatingObject"), -1);
                try {
                    MGroupSwt.instance().create(domGroup);
                    Session.connection().commit();
                    VGroupAdmin.this.groups = MGroupSwt.listGroups(domGroup.getCongregationId());
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Create"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refreshGroups();
        return 0;
    }

    private int modifyGroup(DomGroup domGroup, String newName, int newNameId) {
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmGroupMod", domGroup.getName())) {
            return -1;
        }
        final DomGroup group = domGroup.clone();
        group.setName(newName);
        group.setNameId(newNameId);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("Save.Saving"), -1);
                try {
                    MGroupSwt.instance().modify(group);
                    Session.connection().commit();
                    VGroupAdmin.this.groups = MGroupSwt.listGroups(group.getCongregationId());
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refreshGroups();
        return 0;
    }

    private int deleteGroup(DomGroup domGroup) {
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmGroupDel", domGroup.getName())) {
            return -1;
        }
        final DomGroup group = domGroup;
        group.setCongregationId(domGroup.getCongregationId());
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("DeletingObject"), -1);
                try {
                    MGroupSwt.instance().delete(group.getId());
                    Session.connection().commit();
                    VGroupAdmin.this.groups = MGroupSwt.listGroups(group.getCongregationId());
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Delete") + "." + Resources.getErrString("ObjectNotFound"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refreshGroups();
        return 0;
    }

    protected void loadGroups(int congId) {
        if (congId == -1) {
            this.groups = new ArrayList<DomGroup>();
        }
        final int id = congId;
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getString("Msg.LoadingGroups"), -1);
                try {
                    VGroupAdmin.this.groups = MGroupSwt.listGroups(id);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refreshGroups();
    }

    public void load(IProgressMonitor p) throws SQLException {
        this.congregations = MCongregation.listMyCongregations(IDbUtil.Permission.Admin);
        this.groupNames = MGroupName.listGroupNames();
    }

    public void refresh() {
        this.vwrCongregation.setSource(this.congregations);
        this.vwrGroupNames.setSource(this.groupNames);
        this.vwrCongregation.setSelectedObject(Session.congregation().getId());
        this.loadGroups(Session.congregation().getId());
        this.refreshGroups();
    }

    public void refreshGroups() {
        this.vwGroups.setSource(this.groups);
        DlgMain.instance().getVMain().setGroups(this.groups);
        DlgMain.instance().getVMain().refresh();
    }
}

